/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDoublesSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void empty() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(Double.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)Double.isNaN(sketch.getRank(0.0)));
        Assert.assertTrue((boolean)Double.isNaN(sketch.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(sketch.getMaxValue()));
        Assert.assertTrue((boolean)Double.isNaN(sketch.getQuantile(0.5)));
        Assert.assertNull((Object)sketch.getQuantiles(new double[]{0.0}));
        Assert.assertNull((Object)sketch.getPMF(new double[]{0.0}));
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneItem() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(1.0), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0), (double)1.0);
        Assert.assertEquals((double)sketch.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sketch.getMaxValue(), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)1.0);
    }

    @Test
    public void manyItemsEstimationMode() {
        int i;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((double)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new double[]{500000.0});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((double)sketch.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch.getQuantile(0.0), (double)0.0);
        Assert.assertEquals((double)sketch.getMaxValue(), (double)999999.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0), (double)999999.0);
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        double[] quantiles = sketch.getQuantiles(fractions);
        double[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        double previousQuantile = 0.0;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            double quantile = sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((double)quantile, (double)quantiles[i3]);
            Assert.assertEquals((double)quantile, (double)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        int n = 1000;
        double[] values = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i * 1.0);
            sketch2.update((double)(20000 - i - 1) * 1.0);
        }
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinValue(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxValue(), (double)19999.0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)(20000 - i - 1));
        }
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinValue(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxValue(), (double)19999.0);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        sketch2.update(1.0);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        sketch1.update(1.0);
        sketch2.update(2.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinValue(), (double)1.0);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((double)i);
        }
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxValue(), (double)1000000.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllDoublesSketch.newHeapInstance((int)7);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllDoublesSketch.newHeapInstance((int)65536);
    }

    @Test
    public void minK() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)8);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)65535);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmpty() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((boolean)Double.isNaN(sketch2.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void serializeDeserializeOneItem() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        sketch1.update(1.0);
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertFalse((boolean)Double.isNaN(sketch2.getMinValue()));
        Assert.assertFalse((boolean)Double.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)16);
    }

    @Test
    public void serializeDeserialize() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        byte[] bytes = sketch1.toByteArray();
        KllDoublesSketch sketch2 = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch2.getMinValue(), (double)sketch1.getMinValue());
        Assert.assertEquals((double)sketch2.getMaxValue(), (double)sketch1.getMaxValue());
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        sketch.getCDF(new double[]{1.0, 0.0});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        sketch.getCDF(new double[]{Double.NaN});
    }

    @Test
    public void getQuantiles() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        double[] quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0});
        double[] quantiles2 = sketch.getQuantiles(3);
        Assert.assertEquals((double[])quantiles1, (double[])quantiles2);
        Assert.assertEquals((double)quantiles1[0], (double)1.0);
        Assert.assertEquals((double)quantiles1[1], (double)2.0);
        Assert.assertEquals((double)quantiles1[2], (double)3.0);
    }

    @Test
    public void checkReset() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n1 = sk.getN();
        double min1 = sk.getMinValue();
        double max1 = sk.getMaxValue();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n2 = sk.getN();
        double min2 = sk.getMinValue();
        double max2 = sk.getMaxValue();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((double)min2, (double)min1);
        Assert.assertEquals((double)max2, (double)max1);
    }

    @Test
    public void coverInheritanceArtifacts() {
        float[] fltArr = new float[]{};
        float fltV = 1.0f;
        int idx = 1;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        try {
            sk.getFloatItemsArray();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMaxFloatValue();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinFloatValue();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setFloatItemsArray(fltArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setFloatItemsArrayAt(idx, fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMaxFloatValue(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMinFloatValue(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkReadOnlyUpdate() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)mem);
        try {
            sk2.update(1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNewDirectInstanceAndSize() {
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        KllDoublesSketch.newDirectInstance((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        try {
            KllDoublesSketch.newDirectInstance(null, (MemoryRequestServer)memReqSvr);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            KllFloatsSketch.newDirectInstance((WritableMemory)wmem, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int updateSize = KllDoublesSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (boolean)true);
        int compactSize = KllDoublesSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (boolean)false);
        Assert.assertTrue((compactSize < updateSize ? 1 : 0) != 0);
    }
}

