/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hash.MurmurHash3Adaptor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MurmurHash3AdaptorTest {
    @Test
    public void checkToBytesLong() {
        byte[] result = MurmurHash3Adaptor.hashToBytes((long)2L, (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
    }

    @Test
    public void checkToBytesLongArr() {
        long[] arr = new long[]{1L, 2L};
        byte[] result = MurmurHash3Adaptor.hashToBytes((long[])arr, (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToBytes((long[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
        arr = new long[]{};
        result = MurmurHash3Adaptor.hashToBytes((long[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
    }

    @Test
    public void checkToBytesIntArr() {
        int[] arr = new int[]{1, 2};
        byte[] result = MurmurHash3Adaptor.hashToBytes((int[])arr, (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToBytes((int[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
        arr = new int[]{};
        result = MurmurHash3Adaptor.hashToBytes((int[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
    }

    @Test
    public void checkToBytesCharArr() {
        char[] arr = new char[]{'\u0001', '\u0002'};
        byte[] result = MurmurHash3Adaptor.hashToBytes((char[])arr, (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToBytes((char[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
        arr = new char[]{};
        result = MurmurHash3Adaptor.hashToBytes((char[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
    }

    @Test
    public void checkToBytesByteArr() {
        byte[] arr = new byte[]{1, 2};
        byte[] result = MurmurHash3Adaptor.hashToBytes((byte[])arr, (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToBytes((byte[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
        arr = new byte[]{};
        result = MurmurHash3Adaptor.hashToBytes((byte[])arr, (long)0L);
        Assert.assertEquals((byte[])result, null);
    }

    @Test
    public void checkToBytesDouble() {
        byte[] result = MurmurHash3Adaptor.hashToBytes((double)1.0, (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        result = MurmurHash3Adaptor.hashToBytes((double)0.0, (long)0L);
        i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        result = MurmurHash3Adaptor.hashToBytes((double)-0.0, (long)0L);
        i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
    }

    @Test
    public void checkToBytesString() {
        byte[] result = MurmurHash3Adaptor.hashToBytes((String)"1", (long)0L);
        int i = 8;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        result = MurmurHash3Adaptor.hashToBytes((String)"", (long)0L);
        Assert.assertEquals((byte[])result, null);
        String s = null;
        result = MurmurHash3Adaptor.hashToBytes(s, (long)0L);
        Assert.assertEquals((byte[])result, null);
    }

    @Test
    public void checkToLongsLong() {
        long[] result = MurmurHash3Adaptor.hashToLongs((long)2L, (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
    }

    @Test
    public void checkToLongsLongArr() {
        long[] arr = new long[]{1L, 2L};
        long[] result = MurmurHash3Adaptor.hashToLongs((long[])arr, (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToLongs((long[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
        arr = new long[]{};
        result = MurmurHash3Adaptor.hashToLongs((long[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
    }

    @Test
    public void checkToLongsIntArr() {
        int[] arr = new int[]{1, 2};
        long[] result = MurmurHash3Adaptor.hashToLongs((int[])arr, (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToLongs((int[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
        arr = new int[]{};
        result = MurmurHash3Adaptor.hashToLongs((int[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
    }

    @Test
    public void checkToLongsCharArr() {
        char[] arr = new char[]{'\u0001', '\u0002'};
        long[] result = MurmurHash3Adaptor.hashToLongs((char[])arr, (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToLongs((char[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
        arr = new char[]{};
        result = MurmurHash3Adaptor.hashToLongs((char[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
    }

    @Test
    public void checkToLongsByteArr() {
        byte[] arr = new byte[]{1, 2};
        long[] result = MurmurHash3Adaptor.hashToLongs((byte[])arr, (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        arr = null;
        result = MurmurHash3Adaptor.hashToLongs((byte[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
        arr = new byte[]{};
        result = MurmurHash3Adaptor.hashToLongs((byte[])arr, (long)0L);
        Assert.assertEquals((long[])result, null);
    }

    @Test
    public void checkToLongsDouble() {
        long[] result = MurmurHash3Adaptor.hashToLongs((double)1.0, (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        result = MurmurHash3Adaptor.hashToLongs((double)0.0, (long)0L);
        i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        result = MurmurHash3Adaptor.hashToLongs((double)-0.0, (long)0L);
        i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
    }

    @Test
    public void checkToLongsString() {
        long[] result = MurmurHash3Adaptor.hashToLongs((String)"1", (long)0L);
        int i = 2;
        while (i-- > 0) {
            Assert.assertNotEquals((Object)result[i], (Object)0);
        }
        result = MurmurHash3Adaptor.hashToLongs((String)"", (long)0L);
        Assert.assertEquals((long[])result, null);
        String s = null;
        result = MurmurHash3Adaptor.hashToLongs(s, (long)0L);
        Assert.assertEquals((long[])result, null);
    }

    @Test
    public void checkModulo() {
        int div = 7;
        int i = 20;
        while (i-- > 0) {
            long[] out = MurmurHash3Adaptor.hashToLongs((long)i, (long)9001L);
            int mod = MurmurHash3Adaptor.modulo((long)out[0], (long)out[1], (int)div);
            Assert.assertTrue((mod < div && mod >= 0 ? 1 : 0) != 0);
            mod = MurmurHash3Adaptor.modulo((long[])out, (int)div);
            Assert.assertTrue((mod < div && mod >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAsDouble() {
        for (int i = 0; i < 10000; ++i) {
            double result = MurmurHash3Adaptor.asDouble((long[])MurmurHash3Adaptor.hashToLongs((long)i, (long)0L));
            Assert.assertTrue((result >= 0.0 && result < 1.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAsInt() {
        int lo = 0x30000000;
        int hi = 0x40000001;
        for (byte i = 0; i < 126; i = (byte)((byte)(i + 1))) {
            long[] longArr = new long[]{i, i + 1};
            int result = MurmurHash3Adaptor.asInt((long[])longArr, (int)lo);
            Assert.assertTrue((result >= 0 && result < lo ? 1 : 0) != 0);
            result = MurmurHash3Adaptor.asInt((long[])longArr, (int)hi);
            Assert.assertTrue((result >= 0 && result < hi ? 1 : 0) != 0);
            int[] intArr = new int[]{i, i + 1};
            result = MurmurHash3Adaptor.asInt((int[])intArr, (int)lo);
            Assert.assertTrue((result >= 0 && result < lo ? 1 : 0) != 0);
            result = MurmurHash3Adaptor.asInt((int[])intArr, (int)hi);
            Assert.assertTrue((result >= 0 && result < hi ? 1 : 0) != 0);
            byte[] byteArr = new byte[]{i, (byte)(i + 1)};
            result = MurmurHash3Adaptor.asInt((byte[])byteArr, (int)lo);
            Assert.assertTrue((result >= 0 && result < lo ? 1 : 0) != 0);
            result = MurmurHash3Adaptor.asInt((byte[])byteArr, (int)hi);
            Assert.assertTrue((result >= 0 && result < hi ? 1 : 0) != 0);
            long longV = i;
            result = MurmurHash3Adaptor.asInt((long)longV, (int)lo);
            Assert.assertTrue((result >= 0 && result < lo ? 1 : 0) != 0);
            result = MurmurHash3Adaptor.asInt((long)longV, (int)hi);
            Assert.assertTrue((result >= 0 && result < hi ? 1 : 0) != 0);
            double v = i;
            result = MurmurHash3Adaptor.asInt((double)v, (int)lo);
            Assert.assertTrue((result >= 0 && result < lo ? 1 : 0) != 0);
            result = MurmurHash3Adaptor.asInt((double)v, (int)hi);
            Assert.assertTrue((result >= 0 && result < hi ? 1 : 0) != 0);
            String s = Integer.toString(i);
            result = MurmurHash3Adaptor.asInt((String)s, (int)lo);
            Assert.assertTrue((result >= 0 && result < lo ? 1 : 0) != 0);
            result = MurmurHash3Adaptor.asInt((String)s, (int)hi);
            Assert.assertTrue((result >= 0 && result < hi ? 1 : 0) != 0);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseLongNull() {
        long[] arr = null;
        MurmurHash3Adaptor.asInt(arr, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseLongEmpty() {
        long[] arr = new long[]{};
        MurmurHash3Adaptor.asInt((long[])arr, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseIntNull() {
        int[] arr = null;
        MurmurHash3Adaptor.asInt(arr, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseIntEmpty() {
        int[] arr = new int[]{};
        MurmurHash3Adaptor.asInt((int[])arr, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseByteNull() {
        byte[] arr = null;
        MurmurHash3Adaptor.asInt(arr, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseByteEmpty() {
        byte[] arr = new byte[]{};
        MurmurHash3Adaptor.asInt((byte[])arr, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseStringNull() {
        String s = null;
        MurmurHash3Adaptor.asInt(s, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseStringEmpty() {
        String s = "";
        MurmurHash3Adaptor.asInt((String)s, (int)1000);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAsIntCornerCaseNTooSmall() {
        String s = "abc";
        MurmurHash3Adaptor.asInt((String)s, (int)1);
    }

    @Test
    public void printlnTest() {
        MurmurHash3AdaptorTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

