/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.cpc.IconEstimator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IconEstimatorTest {
    static final double iconInversionTolerance = 1.0E-15;

    static double qnj(double kf, double nf, int col) {
        double tmp1 = -1.0 / (kf * Math.pow(2.0, col));
        double tmp2 = Math.log1p(tmp1);
        return -1.0 * Math.expm1(nf * tmp2);
    }

    static double exactCofN(double kf, double nf) {
        double total = 0.0;
        for (int col = 128; col >= 1; --col) {
            total += IconEstimatorTest.qnj(kf, nf, col);
        }
        return kf * total;
    }

    static double exactIconEstimatorBinarySearch(double kf, double targetC, double nLoIn, double nHiIn) {
        int depth = 0;
        double nLo = nLoIn;
        double nHi = nHiIn;
        while (true) {
            if (depth > 100) {
                throw new SketchesStateException("Excessive recursion in binary search\n");
            }
            assert (nHi > nLo);
            double nMid = nLo + 0.5 * (nHi - nLo);
            assert (nMid > nLo && nMid < nHi);
            if ((nHi - nLo) / nMid < 1.0E-15) {
                return nMid;
            }
            double midC = IconEstimatorTest.exactCofN(kf, nMid);
            if (midC == targetC) {
                return nMid;
            }
            if (midC < targetC) {
                nLo = nMid;
                ++depth;
                continue;
            }
            if (!(midC > targetC)) break;
            nHi = nMid;
            ++depth;
        }
        throw new SketchesStateException("bad value in binary search\n");
    }

    static double exactIconEstimatorBracketHi(double kf, double targetC, double nLo) {
        int depth = 0;
        double curN = 2.0 * nLo;
        double curC = IconEstimatorTest.exactCofN(kf, curN);
        while (curC <= targetC) {
            if (depth > 100) {
                throw new SketchesStateException("Excessive looping in exactIconEstimatorBracketHi\n");
            }
            ++depth;
            curC = IconEstimatorTest.exactCofN(kf, curN *= 2.0);
        }
        assert (curC > targetC);
        return curN;
    }

    static double exactIconEstimator(int lgK, long c) {
        double targetC = c;
        if (c == 0L || c == 1L) {
            return targetC;
        }
        double kf = 1L << lgK;
        double nLo = targetC;
        assert (IconEstimatorTest.exactCofN(kf, nLo) < targetC);
        double nHi = IconEstimatorTest.exactIconEstimatorBracketHi(kf, targetC, nLo);
        return IconEstimatorTest.exactIconEstimatorBinarySearch(kf, targetC, nLo, nHi);
    }

    public static void testIconEstimator() {
        int lgK = 12;
        int k = 4096;
        long c = 1L;
        while (c < 262144L) {
            double exact = IconEstimatorTest.exactIconEstimator(12, c);
            double approx = IconEstimator.getIconEstimate((int)12, (long)c);
            double relDiff = (approx - exact) / exact;
            IconEstimatorTest.printf("%d\t%.19g\t%.19g\t%.19g\n", c, relDiff, exact, approx);
            long a = c + 1L;
            long b = 1001L * c / 1000L;
            c = a > b ? a : b;
        }
    }

    @Test
    public static void quickIconEstimatorTest() {
        for (int lgK = 4; lgK <= 26; ++lgK) {
            long k = 1L << lgK;
            long[] cArr = new long[]{2L, 5L * k, 6L * k, 60L * k};
            Assert.assertEquals((double)IconEstimator.getIconEstimate((int)lgK, (long)0L), (double)0.0, (double)0.0);
            Assert.assertEquals((double)IconEstimator.getIconEstimate((int)lgK, (long)1L), (double)1.0, (double)0.0);
            for (long c : cArr) {
                double exact = IconEstimatorTest.exactIconEstimator(lgK, c);
                double approx = IconEstimator.getIconEstimate((int)lgK, (long)c);
                double relDiff = Math.abs((approx - exact) / exact);
                IconEstimatorTest.printf("%d\t %d\t %.19g\t %.19g\t %.19g\n", lgK, c, relDiff, exact, approx);
                Assert.assertTrue((relDiff < Math.max(2.0E-6, 1.0 / (double)(80L * k)) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void printlnTest() {
        IconEstimatorTest.println("PRINTING: " + this.getClass().getName());
    }

    static void printf(String format, Object ... args) {
        String out = String.format(format, args);
        IconEstimatorTest.print(out);
    }

    static void println(String s) {
        IconEstimatorTest.print(s + "\n");
    }

    static void print(String s) {
    }
}

