/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.PrintStream;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.cpc.CpcConfidence;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.cpc.CpcUtil;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.Format;
import org.apache.datasketches.cpc.PairTable;
import org.apache.datasketches.cpc.TestUtil;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CpcSketchTest {
    static PrintStream ps = System.out;

    @Test
    public void checkUpdatesEstimate() {
        CpcSketch sk = new CpcSketch(10, 0L);
        CpcSketchTest.println(sk.toString(true));
        Assert.assertEquals((Object)sk.getFormat(), (Object)Format.EMPTY_HIP);
        sk.update(1L);
        sk.update(2.0);
        sk.update("3");
        sk.update(new byte[]{4});
        sk.update(new char[]{'\u0005'});
        sk.update(new int[]{6});
        sk.update(new long[]{7L});
        double est = sk.getEstimate();
        double lb = sk.getLowerBound(2);
        double ub = sk.getUpperBound(2);
        Assert.assertTrue((lb >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((lb <= est ? 1 : 0) != 0);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.SPARSE);
        Assert.assertEquals((Object)sk.getFormat(), (Object)Format.SPARSE_HYBRID_HIP);
        CpcSketchTest.println(sk.toString());
        CpcSketchTest.println(sk.toString(true));
    }

    @Test
    public void checkEstimatesWithMerge() {
        int lgK = 4;
        CpcSketch sk1 = new CpcSketch(4);
        CpcSketch sk2 = new CpcSketch(4);
        int n = 16;
        for (int i = 0; i < 16; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + 16));
        }
        CpcUnion union = new CpcUnion(4);
        union.update(sk1);
        union.update(sk2);
        CpcSketch result = union.getResult();
        double est = result.getEstimate();
        double lb = result.getLowerBound(2);
        double ub = result.getUpperBound(2);
        Assert.assertTrue((lb >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((lb <= est ? 1 : 0) != 0);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.validate());
        CpcSketchTest.println(result.toString(true));
    }

    @Test
    public void checkCornerCaseUpdates() {
        int lgK = 4;
        CpcSketch sk = new CpcSketch(4);
        sk.update(0.0);
        sk.update(-0.0);
        int est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        String s = null;
        sk.update(s);
        s = "";
        sk.update(s);
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        byte[] barr = null;
        sk.update(barr);
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        barr = new byte[]{};
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        char[] carr = null;
        sk.update(carr);
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        carr = new char[]{};
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        int[] iarr = null;
        sk.update(iarr);
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        iarr = new int[]{};
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        long[] larr = null;
        sk.update(larr);
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
        larr = new long[]{};
        est = (int)Math.round(sk.getEstimate());
        Assert.assertEquals((int)est, (int)1);
    }

    @Test
    public void checkCornerHashUpdates() {
        CpcSketch sk = new CpcSketch(26);
        long hash1 = 0L;
        long hash0 = -1L;
        sk.hashUpdate(-1L, 0L);
        PairTable table = sk.pairTable;
        CpcSketchTest.println(table.toString(true));
    }

    @Test
    public void checkCopyWithWindow() {
        int lgK = 4;
        CpcSketch sk = new CpcSketch(4);
        CpcSketch sk2 = sk.copy();
        for (int i = 0; i < 16; ++i) {
            sk.update((long)i);
        }
        sk2 = sk.copy();
        long[] bitMatrix = CpcUtil.bitMatrixOfSketch((CpcSketch)sk);
        CpcSketch.refreshKXP((CpcSketch)sk, (long[])bitMatrix);
    }

    @Test
    public void checkFamily() {
        Assert.assertEquals((Object)CpcSketch.getFamily(), (Object)Family.CPC);
    }

    @Test
    public void checkLgK() {
        CpcSketch sk = new CpcSketch(10);
        Assert.assertEquals((int)sk.getLgK(), (int)10);
        try {
            sk = new CpcSketch(3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIconHipUBLBLg15() {
        CpcConfidence.getIconConfidenceUB((int)15, (long)1L, (int)2);
        CpcConfidence.getIconConfidenceLB((int)15, (long)1L, (int)2);
        CpcConfidence.getHipConfidenceUB((int)15, (long)1L, (double)1.0, (int)2);
        CpcConfidence.getHipConfidenceLB((int)15, (long)1L, (double)1.0, (int)2);
    }

    @Test
    public void checkHeapify() {
        int lgK = 10;
        CpcSketch sk = new CpcSketch(lgK, 9001L);
        Assert.assertTrue((boolean)sk.isEmpty());
        byte[] byteArray = sk.toByteArray();
        CpcSketch sk2 = CpcSketch.heapify((byte[])byteArray, (long)9001L);
        Assert.assertTrue((boolean)TestUtil.specialEquals((CpcSketch)sk2, (CpcSketch)sk, (boolean)false, (boolean)false));
    }

    @Test
    public void checkHeapify2() {
        int lgK = 10;
        CpcSketch sk = new CpcSketch(lgK);
        Assert.assertTrue((boolean)sk.isEmpty());
        byte[] byteArray = sk.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        CpcSketch sk2 = CpcSketch.heapify((Memory)mem);
        Assert.assertTrue((boolean)TestUtil.specialEquals((CpcSketch)sk2, (CpcSketch)sk, (boolean)false, (boolean)false));
    }

    @Test
    public void checkRowColUpdate() {
        int lgK = 10;
        CpcSketch sk = new CpcSketch(lgK, 9001L);
        sk.rowColUpdate(0);
        Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.SPARSE);
    }

    @Test
    public void checkGetMaxSize() {
        int size4 = CpcSketch.getMaxSerializedBytes((int)4);
        int size26 = CpcSketch.getMaxSerializedBytes((int)26);
        Assert.assertEquals((int)size4, (int)64);
        Assert.assertEquals((int)size26, (int)40265358);
    }

    @Test
    void negative_int_equivalence() throws Exception {
        CpcSketch sketch = new CpcSketch();
        int v1 = -1;
        sketch.update((long)v1);
        int v2 = -1;
        sketch.update((long)v2);
        int v3 = -1;
        sketch.update((long)v3);
        long v4 = -1L;
        sketch.update(v4);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0, (double)0.01);
    }

    private static void println(String s) {
    }
}

