/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesSketchTest {
    @Test
    public void heapToDirect() {
        UpdateDoublesSketch heapSketch = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            heapSketch.update((double)i);
        }
        DoublesSketch directSketch = DoublesSketch.wrap((Memory)WritableMemory.writableWrap((byte[])heapSketch.toByteArray(false)));
        Assert.assertEquals((double)directSketch.getMinValue(), (double)0.0);
        Assert.assertEquals((double)directSketch.getMaxValue(), (double)999.0);
        Assert.assertEquals((double)directSketch.getQuantile(0.5), (double)500.0, (double)4.0);
    }

    @Test
    public void directToHeap() {
        int sizeBytes = 10000;
        UpdateDoublesSketch directSketch = DoublesSketch.builder().build(WritableMemory.writableWrap((byte[])new byte[sizeBytes]));
        for (int i = 0; i < 1000; ++i) {
            directSketch.update((double)i);
        }
        UpdateDoublesSketch heapSketch = (UpdateDoublesSketch)DoublesSketch.heapify((Memory)WritableMemory.writableWrap((byte[])directSketch.toByteArray()));
        for (int i = 0; i < 1000; ++i) {
            heapSketch.update((double)(i + 1000));
        }
        Assert.assertEquals((double)heapSketch.getMinValue(), (double)0.0);
        Assert.assertEquals((double)heapSketch.getMaxValue(), (double)1999.0);
        Assert.assertEquals((double)heapSketch.getQuantile(0.5), (double)1000.0, (double)10.0);
    }

    @Test
    public void checkToByteArray() {
        UpdateDoublesSketch ds = DoublesSketch.builder().build();
        ds.update(1.0);
        ds.update(2.0);
        byte[] arr = ds.toByteArray(false);
        Assert.assertEquals((int)arr.length, (int)ds.getUpdatableStorageBytes());
    }

    static void testSketchEquality(DoublesSketch sketch1, DoublesSketch sketch2) {
        Assert.assertEquals((int)sketch1.getK(), (int)sketch2.getK());
        Assert.assertEquals((long)sketch1.getN(), (long)sketch2.getN());
        Assert.assertEquals((long)sketch1.getBitPattern(), (long)sketch2.getBitPattern());
        Assert.assertEquals((double)sketch1.getMinValue(), (double)sketch2.getMinValue());
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)sketch2.getMaxValue());
        DoublesSketchAccessor accessor1 = DoublesSketchAccessor.wrap((DoublesSketch)sketch1);
        DoublesSketchAccessor accessor2 = DoublesSketchAccessor.wrap((DoublesSketch)sketch2);
        for (int i = 0; i < accessor1.numItems(); ++i) {
            Assert.assertEquals((double)accessor1.get(i), (double)accessor2.get(i));
        }
        int lvl = 0;
        for (long bitPattern = sketch1.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
            if ((bitPattern & 1L) > 0L) {
                accessor1.setLevel(lvl);
                accessor2.setLevel(lvl);
                for (int i = 0; i < accessor1.numItems(); ++i) {
                    Assert.assertEquals((double)accessor1.get(i), (double)accessor2.get(i));
                }
            }
            ++lvl;
        }
    }

    @Test
    public void checkIsSameResource() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[k * 16 + 24]);
        WritableMemory cmem = WritableMemory.writableWrap((byte[])new byte[8]);
        DirectUpdateDoublesSketch duds = (DirectUpdateDoublesSketch)DoublesSketch.builder().setK(k).build(mem);
        Assert.assertTrue((boolean)duds.isSameResource((Memory)mem));
        DirectCompactDoublesSketch dcds = (DirectCompactDoublesSketch)duds.compact(cmem);
        Assert.assertTrue((boolean)dcds.isSameResource((Memory)cmem));
        UpdateDoublesSketch uds = DoublesSketch.builder().setK(k).build();
        Assert.assertFalse((boolean)uds.isSameResource((Memory)mem));
    }

    @Test
    public void checkEmptyNullReturns() {
        int k = 16;
        UpdateDoublesSketch uds = DoublesSketch.builder().setK(k).build();
        Assert.assertNull((Object)uds.getQuantiles(5));
        Assert.assertNull((Object)uds.getPMF(new double[]{0.0, 0.5, 1.0}));
        Assert.assertNull((Object)uds.getCDF(new double[]{0.0, 0.5, 1.0}));
    }

    @Test
    public void directSketchShouldMoveOntoHeapEventually() {
        try (WritableHandle wdh = WritableMemory.allocateDirect((long)1000L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());){
            WritableMemory mem = wdh.getWritable();
            UpdateDoublesSketch sketch = DoublesSketch.builder().build(mem);
            Assert.assertTrue((boolean)sketch.isSameResource((Memory)mem));
            for (int i = 0; i < 1000; ++i) {
                sketch.update((double)i);
            }
            Assert.assertFalse((boolean)sketch.isSameResource((Memory)mem));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void directSketchShouldMoveOntoHeapEventually2() {
        try (WritableHandle wdh = WritableMemory.allocateDirect((long)50L, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)new DefaultMemoryRequestServer());){
            WritableMemory mem = wdh.getWritable();
            UpdateDoublesSketch sketch = DoublesSketch.builder().build(mem);
            Assert.assertTrue((boolean)sketch.isSameResource((Memory)mem));
            for (int i = 0; i < 1000 && sketch.isSameResource((Memory)mem); ++i) {
                sketch.update((double)i);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkEmptyDirect() {
        try (WritableHandle wdh = WritableMemory.allocateDirect((long)1000L);){
            WritableMemory mem = wdh.getWritable();
            UpdateDoublesSketch sketch = DoublesSketch.builder().build(mem);
            sketch.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void printlnTest() {
        DoublesSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

