/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import org.apache.datasketches.BinomialBoundsN;
import org.apache.datasketches.SketchesArgumentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BinomialBoundsNTest {
    private static final double TOL = 1.0E-15;
    private static final double[][] std = new double[][]{{70833.30682531043, 85303.73642825481, 32736.47725073409, 37340.24243699785, 57750.0}, {65394.15269641498, 89455.22372568645, 32223.0254649784, 39047.38469737429, 57750.0}, {60060.43493107306, 93181.05731423477, 31862.69956585285, 40964.6622192252, 57750.0}, {2275584.770163813, 2347586.549014998, 1020399.409477305, 1036729.927598294, 920982.0}, {2243569.126699713, 2374663.344107342, 1017017.233582122, 1042597.845553438, 920982.0}, {2210056.231903739, 2400441.267999687, 1014081.235946986, 1049480.769755676, 920982.0}, {4.688240115809608E7, 4.718067204619278E7, 2.148362024482338E7, 2.153118905212302E7, 1.2834414E7}, {4.674205938540214E7, 4.731333757486791E7, 2.146902141966406E7, 2.154916650733873E7, 1.2834414E7}, {4.659896614422579E7, 4.744404182094614E7, 2.145525391547799E7, 2.156815612325058E7, 1.2834414E7}};

    public static double[] runTestAux(long max_numSamplesI, int ci, double min_p) {
        long numSamplesI = 0L;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        long count = 0L;
        while (numSamplesI <= max_numSamplesI) {
            for (double p = 1.0; p >= min_p; p *= 0.99) {
                double lb = BinomialBoundsN.getLowerBound((long)numSamplesI, (double)p, (int)ci, (boolean)false);
                double ub = BinomialBoundsN.getUpperBound((long)numSamplesI, (double)p, (int)ci, (boolean)false);
                sum1 += Math.log(lb + 1.0);
                sum2 += Math.log(ub + 1.0);
                count += 2L;
                if (!(p < 1.0)) continue;
                lb = BinomialBoundsN.getLowerBound((long)numSamplesI, (double)(1.0 - p), (int)ci, (boolean)false);
                ub = BinomialBoundsN.getUpperBound((long)numSamplesI, (double)(1.0 - p), (int)ci, (boolean)false);
                sum3 += Math.log(lb + 1.0);
                sum4 += Math.log(ub + 1.0);
                count += 2L;
            }
            numSamplesI = Math.max(numSamplesI + 1L, 1001L * numSamplesI / 1000L);
        }
        BinomialBoundsNTest.println(String.format("{%.15e, %.15e, %.15e, %.15e, %d}", sum1, sum2, sum3, sum4, count));
        double[] arrOut = new double[]{sum1, sum2, sum3, sum4, count};
        return arrOut;
    }

    @Test
    public static void checkBounds() {
        int j;
        double[] arr;
        int i = 0;
        int ci = 1;
        while (ci <= 3) {
            arr = BinomialBoundsNTest.runTestAux(20L, ci, 0.001);
            for (j = 0; j < 5; ++j) {
                Assert.assertTrue((arr[j] / std[i][j] - 1.0 < 1.0E-15 ? 1 : 0) != 0);
            }
            ++ci;
            ++i;
        }
        ci = 1;
        while (ci <= 3) {
            arr = BinomialBoundsNTest.runTestAux(200L, ci, 1.0E-5);
            for (j = 0; j < 5; ++j) {
                Assert.assertTrue((arr[j] / std[i][j] - 1.0 < 1.0E-15 ? 1 : 0) != 0);
            }
            ++ci;
            ++i;
        }
    }

    @Test
    public static void checkCheckArgs() {
        try {
            BinomialBoundsN.checkArgs((long)-1L, (double)1.0, (int)1);
            BinomialBoundsN.checkArgs((long)10L, (double)0.0, (int)1);
            BinomialBoundsN.checkArgs((long)10L, (double)1.01, (int)1);
            BinomialBoundsN.checkArgs((long)10L, (double)1.0, (int)3);
            BinomialBoundsN.checkArgs((long)10L, (double)1.0, (int)0);
            BinomialBoundsN.checkArgs((long)10L, (double)1.0, (int)4);
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public static void checkComputeApproxBino_LB_UB() {
        long n = 100L;
        double theta = 0.999995;
        double result = BinomialBoundsN.getLowerBound((long)100L, (double)0.999995, (int)1, (boolean)false);
        Assert.assertEquals((double)result, (double)100.0, (double)0.0);
        result = BinomialBoundsN.getUpperBound((long)100L, (double)0.999995, (int)1, (boolean)false);
        Assert.assertEquals((double)result, (double)101.0, (double)0.0);
        result = BinomialBoundsN.getLowerBound((long)100L, (double)0.999995, (int)1, (boolean)true);
        Assert.assertEquals((double)result, (double)0.0, (double)0.0);
        result = BinomialBoundsN.getUpperBound((long)100L, (double)0.999995, (int)1, (boolean)true);
        Assert.assertEquals((double)result, (double)0.0, (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public static void checkThetaLimits1() {
        BinomialBoundsN.getUpperBound((long)100L, (double)1.1, (int)1, (boolean)false);
    }

    @Test
    public static void boundsExample() {
        BinomialBoundsNTest.println("BinomialBoundsN Example:");
        int k = 500;
        double theta = 0.001;
        int stdDev = 2;
        double ub = BinomialBoundsN.getUpperBound((long)500L, (double)0.001, (int)2, (boolean)false);
        double est = 500000.0;
        double lb = BinomialBoundsN.getLowerBound((long)500L, (double)0.001, (int)2, (boolean)false);
        BinomialBoundsNTest.println("K=500, Theta=0.001, SD=2");
        BinomialBoundsNTest.println("UB:  " + ub);
        BinomialBoundsNTest.println("Est: 500000.0");
        BinomialBoundsNTest.println("LB:  " + lb);
        BinomialBoundsNTest.println("");
    }

    @Test
    public void printlnTest() {
        BinomialBoundsNTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

