/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectQuantilesMemoryRequestTest {
    @Test
    public void checkLimitedMemoryScenarios() {
        int k = 128;
        int u = 5120;
        int initBytes = 2080;
        try (WritableHandle wdh = WritableMemory.allocateDirect((long)2080L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());){
            WritableMemory wmem = wdh.getWritable();
            DirectQuantilesMemoryRequestTest.println("Initial mem size: " + wmem.getCapacity());
            UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(128).build(wmem);
            Assert.assertTrue((boolean)usk1.isEmpty());
            for (int i = 0; i < 5120; ++i) {
                usk1.update((double)i);
            }
            double result = usk1.getQuantile(0.5);
            DirectQuantilesMemoryRequestTest.println("Result: " + result);
            Assert.assertEquals((double)result, (double)2560.0, (double)256.0);
            DirectQuantilesMemoryRequestTest.println("\nFinal mem size: " + wmem.getCapacity());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkGrowBaseBuf() {
        int k = 128;
        int u = 32;
        int initBytes = 160;
        try (WritableHandle memHandler = WritableMemory.allocateDirect((long)160L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());){
            WritableMemory mem1 = memHandler.getWritable();
            DirectQuantilesMemoryRequestTest.println("Initial mem size: " + mem1.getCapacity());
            UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(128).build(mem1);
            for (int i = 1; i <= 32; ++i) {
                usk1.update((double)i);
            }
            int currentSpace = usk1.getCombinedBufferItemCapacity();
            DirectQuantilesMemoryRequestTest.println("curCombBufItemCap: " + currentSpace);
            Assert.assertEquals((int)currentSpace, (int)256);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkGrowCombBuf() {
        int k = 128;
        int u = 255;
        int initBytes = 2080;
        try (WritableHandle memHandler = WritableMemory.allocateDirect((long)2080L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());){
            WritableMemory mem1 = memHandler.getWritable();
            DirectQuantilesMemoryRequestTest.println("Initial mem size: " + mem1.getCapacity());
            UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(128).build(mem1);
            for (int i = 1; i <= 255; ++i) {
                usk1.update((double)i);
            }
            int currentSpace = usk1.getCombinedBufferItemCapacity();
            DirectQuantilesMemoryRequestTest.println("curCombBufItemCap: " + currentSpace);
            double[] newCB = usk1.growCombinedBuffer(currentSpace, 384);
            int newSpace = usk1.getCombinedBufferItemCapacity();
            DirectQuantilesMemoryRequestTest.println("newCombBurItemCap: " + newSpace);
            Assert.assertEquals((int)newCB.length, (int)384);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkGrowFromWrappedEmptySketch() {
        int k = 16;
        boolean n = false;
        int initBytes = DoublesSketch.getUpdatableStorageBytes((int)16, (long)0L);
        UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(16).build();
        Memory origSketchMem = Memory.wrap((byte[])usk1.toByteArray());
        try (WritableHandle memHandle = WritableMemory.allocateDirect((long)initBytes, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());){
            WritableMemory mem = memHandle.getWritable();
            origSketchMem.copyTo(0L, mem, 0L, (long)initBytes);
            DirectUpdateDoublesSketch usk2 = DirectUpdateDoublesSketch.wrapInstance((WritableMemory)mem);
            Assert.assertTrue((boolean)mem.isSameResource((Object)usk2.getMemory()));
            Assert.assertEquals((long)mem.getCapacity(), (long)initBytes);
            Assert.assertTrue((boolean)mem.isDirect());
            Assert.assertTrue((boolean)usk2.isEmpty());
            for (int i = 1; i <= 5; ++i) {
                usk2.update((double)i);
            }
            Assert.assertEquals((long)usk2.getN(), (long)5L);
            WritableMemory mem2 = usk2.getMemory();
            Assert.assertFalse((boolean)mem.isSameResource((Object)mem2));
            Assert.assertFalse((boolean)mem2.isDirect());
            int expectedSize = 288;
            Assert.assertEquals((long)mem2.getCapacity(), (long)288L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void printlnTest() {
        DirectQuantilesMemoryRequestTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

