/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Random;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.KolmogorovSmirnov;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KolmogorovSmirnovTest {
    @Test
    public void checkKomologorovSmirnovStatistic1() {
        int k = 256;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(256).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(256).build();
        Random rand = new Random();
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 100.0);
            s2.update(x);
        }
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2), (double)1.0, (double)1.0E-6);
        KolmogorovSmirnovTest.println("D = " + KolmogorovSmirnov.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2));
    }

    @Test
    public void checkKomologorovSmirnovStatistic2() {
        int k = 256;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(256).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(256).build();
        Random rand = new Random();
        int n = 767;
        for (int i = 0; i < 767; ++i) {
            double x = rand.nextGaussian();
            s1.update(x);
            s2.update(x);
        }
        Assert.assertEquals((double)KolmogorovSmirnov.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2), (double)0.0, (double)0.01);
        KolmogorovSmirnovTest.println("D = " + KolmogorovSmirnov.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2));
    }

    @Test
    public void checkKomologorovSmirnovStatistic3() {
        int k = 2048;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(2048).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(2048).build();
        double tgtPvalue = 0.05;
        Random rand = new Random();
        int n = 6143;
        for (int i = 0; i < 6143; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 2048\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject);
        Assert.assertFalse((boolean)reject);
    }

    @Test
    public void checkKomologorovSmirnovStatistic4() {
        int k = 8192;
        UpdateDoublesSketch s1 = DoublesSketch.builder().setK(8192).build();
        UpdateDoublesSketch s2 = DoublesSketch.builder().setK(8192).build();
        double tgtPvalue = 0.05;
        Random rand = new Random();
        int n = 24575;
        for (int i = 0; i < 24575; ++i) {
            double x = rand.nextGaussian();
            s1.update(x + 0.05);
            s2.update(x);
        }
        double D = KolmogorovSmirnov.computeKSDelta((DoublesSketch)s1, (DoublesSketch)s2);
        double thresh = KolmogorovSmirnov.computeKSThreshold((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        boolean reject = KolmogorovSmirnov.kolmogorovSmirnovTest((DoublesSketch)s1, (DoublesSketch)s2, (double)0.05);
        KolmogorovSmirnovTest.println("pVal = 0.05\nK = 8192\nD = " + D + "\nTh = " + thresh + "\nNull Hypoth Rejected = " + reject);
        Assert.assertTrue((boolean)reject);
    }

    @Test
    public void printlnTest() {
        KolmogorovSmirnovTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

