/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesUnion;

public abstract class ArrayOfDoublesUnion {
    static final byte serialVersionUID = 1;
    static final int PREAMBLE_SIZE_BYTES = 16;
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SERIAL_VERSION_BYTE = 1;
    static final int FAMILY_ID_BYTE = 2;
    static final int SKETCH_TYPE_BYTE = 3;
    static final int FLAGS_BYTE = 4;
    static final int NUM_VALUES_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int THETA_LONG = 8;
    ArrayOfDoublesQuickSelectSketch sketch_;
    long theta_;

    ArrayOfDoublesUnion(ArrayOfDoublesQuickSelectSketch sketch) {
        this.sketch_ = sketch;
        this.theta_ = sketch.getThetaLong();
    }

    public static ArrayOfDoublesUnion heapify(Memory mem) {
        return ArrayOfDoublesUnion.heapify(mem, 9001L);
    }

    public static ArrayOfDoublesUnion heapify(Memory mem, long seed) {
        return HeapArrayOfDoublesUnion.heapifyUnion(mem, seed);
    }

    public static ArrayOfDoublesUnion wrap(Memory mem) {
        return ArrayOfDoublesUnion.wrap(mem, 9001L);
    }

    public static ArrayOfDoublesUnion wrap(Memory mem, long seed) {
        return DirectArrayOfDoublesUnion.wrapUnion((WritableMemory)mem, seed, false);
    }

    public static ArrayOfDoublesUnion wrap(WritableMemory mem) {
        return ArrayOfDoublesUnion.wrap(mem, 9001L);
    }

    public static ArrayOfDoublesUnion wrap(WritableMemory mem, long seed) {
        return DirectArrayOfDoublesUnion.wrapUnion(mem, seed, true);
    }

    @Deprecated
    public void update(ArrayOfDoublesSketch tupleSketch) {
        this.union(tupleSketch);
    }

    public void union(ArrayOfDoublesSketch tupleSketch) {
        if (tupleSketch == null) {
            return;
        }
        Util.checkSeedHashes(this.sketch_.getSeedHash(), tupleSketch.getSeedHash());
        if (this.sketch_.getNumValues() != tupleSketch.getNumValues()) {
            throw new SketchesArgumentException("Incompatible sketches: number of values mismatch " + this.sketch_.getNumValues() + " and " + tupleSketch.getNumValues());
        }
        if (tupleSketch.isEmpty()) {
            return;
        }
        if (tupleSketch.getThetaLong() < this.theta_) {
            this.setThetaLong(tupleSketch.getThetaLong());
        }
        ArrayOfDoublesSketchIterator it = tupleSketch.iterator();
        while (it.next()) {
            if (it.getKey() >= this.theta_) continue;
            this.sketch_.merge(it.getKey(), it.getValues());
        }
        if (this.sketch_.getThetaLong() < this.theta_) {
            this.setThetaLong(this.sketch_.getThetaLong());
        }
    }

    public ArrayOfDoublesCompactSketch getResult(WritableMemory dstMem) {
        long theta = this.theta_;
        if (this.sketch_.getRetainedEntries() > this.sketch_.getNominalEntries()) {
            theta = Math.min(theta, this.sketch_.getNewTheta());
        }
        if (dstMem == null) {
            return new HeapArrayOfDoublesCompactSketch(this.sketch_, theta);
        }
        return new DirectArrayOfDoublesCompactSketch(this.sketch_, theta, dstMem);
    }

    public ArrayOfDoublesCompactSketch getResult() {
        return this.getResult(null);
    }

    public void reset() {
        this.sketch_.reset();
        this.setThetaLong(this.sketch_.getThetaLong());
    }

    public byte[] toByteArray() {
        int sizeBytes = 16 + this.sketch_.getSerializedSizeBytes();
        byte[] byteArray = new byte[sizeBytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(0L, (byte)1);
        mem.putByte(1L, (byte)1);
        mem.putByte(2L, (byte)Family.TUPLE.getID());
        mem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesUnion.ordinal());
        mem.putLong(8L, this.theta_);
        this.sketch_.serializeInto(mem.writableRegion(16L, mem.getCapacity() - 16L));
        return byteArray;
    }

    public static int getMaxBytes(int nomEntries, int numValues) {
        return ArrayOfDoublesQuickSelectSketch.getMaxBytes(nomEntries, numValues) + 16;
    }

    void setThetaLong(long theta) {
        this.theta_ = theta;
    }
}

