/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IntegerSketchTest {
    @Test
    public void serDeTest() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk = new IntegerSketch(12, a1Mode);
        int m = 8192;
        for (int i = 0; i < 8192; ++i) {
            a1Sk.update((long)i, Integer.valueOf(1));
        }
        double est1 = a1Sk.getEstimate();
        Memory mem = Memory.wrap((byte[])a1Sk.toByteArray());
        IntegerSketch a1Sk2 = new IntegerSketch(mem, a1Mode);
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
    }

    @Test
    public void intersectTest() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk1 = new IntegerSketch(12, a1Mode);
        IntegerSketch a1Sk2 = new IntegerSketch(12, a1Mode);
        int m = 8192;
        for (int i = 0; i < 8192; ++i) {
            a1Sk1.update((long)i, Integer.valueOf(1));
            a1Sk2.update((long)(i + 4096), Integer.valueOf(1));
        }
        Intersection inter = new Intersection((SummarySetOperations)new IntegerSummarySetOperations(a1Mode, a1Mode));
        inter.intersect((Sketch)a1Sk1);
        inter.intersect((Sketch)a1Sk2);
        CompactSketch csk = inter.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)4096.0, (double)122.88);
    }

    @Test
    public void aNotBTest() {
        int lgK = 4;
        int u = 5;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk1 = new IntegerSketch(4, a1Mode);
        Sketch a1Sk2 = null;
        AnotB anotb = new AnotB();
        for (int i = 0; i < 5; ++i) {
            a1Sk1.update((long)i, Integer.valueOf(1));
        }
        anotb.update((Sketch)a1Sk1, a1Sk2);
        CompactSketch cSk = anotb.getResult();
        Assert.assertEquals((int)((int)cSk.getEstimate()), (int)5);
    }

    @Test
    public void checkMinMaxMode() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode minMode = IntegerSummary.Mode.Min;
        IntegerSummary.Mode maxMode = IntegerSummary.Mode.Max;
        IntegerSketch a1Sk1 = new IntegerSketch(12, minMode);
        IntegerSketch a1Sk2 = new IntegerSketch(12, maxMode);
        int m = 2048;
        for (int key = 0; key < 2048; ++key) {
            a1Sk1.update((long)key, Integer.valueOf(1));
            a1Sk1.update((long)key, Integer.valueOf(0));
            a1Sk1.update((long)key, Integer.valueOf(2));
            a1Sk2.update((long)(key + 1024), Integer.valueOf(1));
            a1Sk2.update((long)(key + 1024), Integer.valueOf(0));
            a1Sk2.update((long)(key + 1024), Integer.valueOf(2));
        }
        double est1 = a1Sk1.getEstimate();
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
    }

    @Test
    public void checkStringKey() {
        int lgK = 12;
        int K = 4096;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk1 = new IntegerSketch(12, a1Mode);
        int m = 2048;
        for (int key = 0; key < 2048; ++key) {
            a1Sk1.update(Integer.toHexString(key), Integer.valueOf(1));
        }
        Assert.assertEquals((double)a1Sk1.getEstimate(), (double)2048.0);
    }

    static void println(Object o) {
    }

    static void printf(String fmt, Object ... args) {
    }
}

