/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchTest {
    @Test
    public void checkGetMaxBytesWithEntries() {
        Assert.assertEquals((int)Sketch.getMaxCompactSketchBytes((int)10), (int)(80 + (Family.COMPACT.getMaxPreLongs() << 3)));
    }

    @Test
    public void checkGetCurrentBytes() {
        int i;
        int k = 64;
        int lowQSPreLongs = Family.QUICKSELECT.getMinPreLongs();
        int lowCompPreLongs = Family.COMPACT.getMinPreLongs();
        UpdateSketch sketch = UpdateSketch.builder().setNominalEntries(k).build();
        Assert.assertEquals((int)sketch.getCurrentPreambleLongs(), (int)lowQSPreLongs);
        Assert.assertEquals((int)sketch.getCompactPreambleLongs(), (int)1);
        Assert.assertEquals((int)sketch.getCurrentDataLongs(), (int)(k * 2));
        Assert.assertEquals((int)sketch.getCurrentBytes(), (int)(k * 2 * 8 + (lowQSPreLongs << 3)));
        Assert.assertEquals((int)sketch.getCompactBytes(), (int)(lowCompPreLongs << 3));
        CompactSketch compSk = sketch.compact(false, null);
        Assert.assertEquals((int)compSk.getCompactBytes(), (int)8);
        Assert.assertEquals((int)compSk.getCurrentBytes(), (int)8);
        Assert.assertEquals((int)compSk.getCurrentDataLongs(), (int)0);
        int compPreLongs = CompactOperations.computeCompactPreLongs((boolean)sketch.isEmpty(), (int)sketch.getRetainedEntries(true), (long)sketch.getThetaLong());
        Assert.assertEquals((int)compPreLongs, (int)1);
        for (i = 0; i < k; ++i) {
            sketch.update((long)i);
        }
        Assert.assertEquals((int)sketch.getCurrentPreambleLongs(), (int)lowQSPreLongs);
        Assert.assertEquals((int)sketch.getCompactPreambleLongs(), (int)2);
        Assert.assertEquals((int)sketch.getCurrentDataLongs(), (int)(k * 2));
        Assert.assertEquals((int)sketch.getCurrentBytes(), (int)(k * 2 * 8 + (lowQSPreLongs << 3)));
        Assert.assertEquals((int)sketch.getCompactBytes(), (int)(k * 8 + 16));
        compPreLongs = CompactOperations.computeCompactPreLongs((boolean)sketch.isEmpty(), (int)sketch.getRetainedEntries(true), (long)sketch.getThetaLong());
        Assert.assertEquals((int)compPreLongs, (int)2);
        for (i = k; i < 2 * k; ++i) {
            sketch.update((long)i);
        }
        int curCount = sketch.getRetainedEntries(true);
        Assert.assertEquals((int)sketch.getCurrentPreambleLongs(), (int)lowQSPreLongs);
        Assert.assertEquals((int)sketch.getCompactPreambleLongs(), (int)3);
        Assert.assertEquals((int)sketch.getCurrentDataLongs(), (int)(k * 2));
        Assert.assertEquals((int)sketch.getCurrentBytes(), (int)(k * 2 * 8 + (lowQSPreLongs << 3)));
        Assert.assertEquals((int)sketch.getCompactBytes(), (int)(curCount * 8 + 24));
        compPreLongs = CompactOperations.computeCompactPreLongs((boolean)sketch.isEmpty(), (int)sketch.getRetainedEntries(true), (long)sketch.getThetaLong());
        Assert.assertEquals((int)compPreLongs, (int)3);
        for (int i2 = 0; i2 < 3; ++i2) {
            int maxCompBytes = Sketch.getMaxCompactSketchBytes((int)i2);
            if (i2 == 0) {
                Assert.assertEquals((int)maxCompBytes, (int)8);
            }
            if (i2 == 1) {
                Assert.assertEquals((int)maxCompBytes, (int)16);
            }
            if (i2 <= 1) continue;
            Assert.assertEquals((int)maxCompBytes, (int)(24 + i2 * 8));
        }
    }

    @Test
    public void checkBuilder() {
        int k = 2048;
        int lgK = Integer.numberOfTrailingZeros(k);
        long seed = 1021L;
        float p = 0.5f;
        ResizeFactor rf = ResizeFactor.X4;
        Family fam = Family.ALPHA;
        UpdateSketch sk1 = UpdateSketch.builder().setSeed(seed).setP(p).setResizeFactor(rf).setFamily(fam).setNominalEntries(k).build();
        String nameS1 = sk1.getClass().getSimpleName();
        Assert.assertEquals((String)nameS1, (String)"HeapAlphaSketch");
        Assert.assertEquals((int)sk1.getLgNomLongs(), (int)lgK);
        Assert.assertEquals((long)sk1.getSeed(), (long)seed);
        Assert.assertEquals((float)sk1.getP(), (float)p);
        sk1 = UpdateSketch.builder().build();
        nameS1 = sk1.getClass().getSimpleName();
        Assert.assertEquals((String)nameS1, (String)"HeapQuickSelectSketch");
        Assert.assertEquals((int)sk1.getLgNomLongs(), (int)Integer.numberOfTrailingZeros(4096));
        Assert.assertEquals((long)sk1.getSeed(), (long)9001L);
        Assert.assertEquals((float)sk1.getP(), (float)1.0f);
        Assert.assertEquals((Object)sk1.getResizeFactor(), (Object)ResizeFactor.X8);
    }

    @Test
    public void checkBuilderNonPowerOf2() {
        int k = 1000;
        UpdateSketch sk = UpdateSketch.builder().setNominalEntries(k).build();
        Assert.assertEquals((int)sk.getLgNomLongs(), (int)10);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderIllegalP() {
        float p = 1.5f;
        UpdateSketch.builder().setP(p).build();
    }

    @Test
    public void checkBuilderResizeFactor() {
        ResizeFactor rf = ResizeFactor.X1;
        Assert.assertEquals((int)rf.getValue(), (int)1);
        Assert.assertEquals((int)rf.lg(), (int)0);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)0), (Object)ResizeFactor.X1);
        rf = ResizeFactor.X2;
        Assert.assertEquals((int)rf.getValue(), (int)2);
        Assert.assertEquals((int)rf.lg(), (int)1);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)1), (Object)ResizeFactor.X2);
        rf = ResizeFactor.X4;
        Assert.assertEquals((int)rf.getValue(), (int)4);
        Assert.assertEquals((int)rf.lg(), (int)2);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)2), (Object)ResizeFactor.X4);
        rf = ResizeFactor.X8;
        Assert.assertEquals((int)rf.getValue(), (int)8);
        Assert.assertEquals((int)rf.lg(), (int)3);
        Assert.assertEquals((Object)ResizeFactor.getRF((int)3), (Object)ResizeFactor.X8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapBadFamily() {
        UpdateSketch sketch = UpdateSketch.builder().setFamily(Family.ALPHA).setNominalEntries(1024).build();
        byte[] byteArr = sketch.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArr);
        Sketch.wrap((Memory)srcMem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        UpdateSketch.builder().setFamily(Family.INTERSECTION).setNominalEntries(1024).build();
    }

    @Test
    public void checkSerVer() {
        UpdateSketch sketch = UpdateSketch.builder().setNominalEntries(1024).build();
        byte[] sketchArray = sketch.toByteArray();
        Memory mem = Memory.wrap((byte[])sketchArray);
        int serVer = Sketch.getSerializationVersion((Memory)mem);
        Assert.assertEquals((int)serVer, (int)3);
        WritableMemory wmem = WritableMemory.wrap((byte[])sketchArray);
        UpdateSketch sk2 = UpdateSketch.wrap((WritableMemory)wmem);
        serVer = UpdateSketch.getSerializationVersion((Memory)wmem);
        Assert.assertEquals((int)serVer, (int)3);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyAlphaCompactExcep() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        byte[] byteArray = sketch1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.setBits(5L, (byte)8);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyQSCompactExcep() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        byte[] byteArray = sketch1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.setBits(5L, (byte)8);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyNotCompactExcep() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        int bytes = Sketch.getMaxCompactSketchBytes((int)0);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        sketch1.compact(false, mem);
        mem.clearBits(5L, (byte)8);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyFamilyExcep() {
        int k = 512;
        Union union = SetOperation.builder().setNominalEntries(k).buildUnion();
        byte[] byteArray = union.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapAlphaCompactExcep() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setFamily(Family.ALPHA).setNominalEntries(k).build();
        byte[] byteArray = sketch1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.setBits(5L, (byte)8);
        Sketch.wrap((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapQSCompactExcep() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        byte[] byteArray = sketch1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.setBits(5L, (byte)8);
        Sketch.wrap((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapNotCompactExcep() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        int bytes = Sketch.getMaxCompactSketchBytes((int)0);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        sketch1.compact(false, mem);
        mem.clearBits(5L, (byte)8);
        Sketch.wrap((Memory)mem);
    }

    @Test
    public void checkValidSketchID() {
        Assert.assertFalse((boolean)Sketch.isValidSketchID((int)0));
        Assert.assertTrue((boolean)Sketch.isValidSketchID((int)Family.ALPHA.getID()));
        Assert.assertTrue((boolean)Sketch.isValidSketchID((int)Family.QUICKSELECT.getID()));
        Assert.assertTrue((boolean)Sketch.isValidSketchID((int)Family.COMPACT.getID()));
    }

    @Test
    public void checkWrapToHeapifyConversion1() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            sketch1.update((long)i);
        }
        double uest1 = sketch1.getEstimate();
        CompactSketch csk = sketch1.compact();
        Memory v1mem = BackwardConversions.convertSerVer3toSerVer1(csk);
        Sketch csk2 = Sketch.wrap((Memory)v1mem);
        Assert.assertFalse((boolean)csk2.isDirect());
        Assert.assertFalse((boolean)csk2.hasMemory());
        Assert.assertEquals((double)uest1, (double)csk2.getEstimate(), (double)0.0);
        Memory v2mem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        csk2 = Sketch.wrap((Memory)v2mem);
        Assert.assertFalse((boolean)csk2.isDirect());
        Assert.assertFalse((boolean)csk2.hasMemory());
        Assert.assertEquals((double)uest1, (double)csk2.getEstimate(), (double)0.0);
    }

    @Test
    public void checkIsSameResource() {
        int k = 16;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        WritableMemory cmem = WritableMemory.wrap((byte[])new byte[32]);
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(k).build(mem);
        sketch.update(1L);
        sketch.update(2L);
        Assert.assertTrue((boolean)sketch.isSameResource((Memory)mem));
        DirectCompactSketch dcos = (DirectCompactSketch)sketch.compact(true, cmem);
        Assert.assertTrue((boolean)dcos.isSameResource((Memory)cmem));
        Assert.assertTrue((boolean)dcos.isOrdered());
        DirectCompactSketch dcs = (DirectCompactSketch)sketch.compact(false, cmem);
        Assert.assertTrue((boolean)dcs.isSameResource((Memory)cmem));
        Assert.assertFalse((boolean)dcs.isOrdered());
        UpdateSketch sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        Assert.assertFalse((boolean)sk.isSameResource((Memory)mem));
    }

    @Test
    public void checkCountLessThanTheta() {
        int k = 512;
        UpdateSketch sketch1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < 2 * k; ++i) {
            sketch1.update((long)i);
        }
        double theta = sketch1.rebuild().getTheta();
        int count = sketch1.getCountLessThanTheta(theta);
        Assert.assertEquals((int)count, (int)k);
    }

    private static WritableMemory createCompactSketchMemory(int k, int u) {
        UpdateSketch usk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = Sketch.getMaxCompactSketchBytes((int)usk.getRetainedEntries(true));
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        usk.compact(true, wmem);
        return wmem;
    }

    @Test
    public void checkCompactFlagsOnWrap() {
        WritableMemory wmem = SketchTest.createCompactSketchMemory(16, 32);
        Sketch sk = Sketch.wrap((Memory)wmem);
        Assert.assertTrue((boolean)(sk instanceof CompactSketch));
        int flags = PreambleUtil.extractFlags((Memory)wmem);
        int flagsNoCompact = flags & 0xFFFFFFF7;
        PreambleUtil.insertFlags((WritableMemory)wmem, (int)flagsNoCompact);
        try {
            sk = Sketch.wrap((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        int flagsNoReadOnly = flags & 0xFFFFFFFD;
        PreambleUtil.insertFlags((WritableMemory)wmem, (int)flagsNoReadOnly);
        try {
            sk = Sketch.wrap((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertFlags((WritableMemory)wmem, (int)flags);
        PreambleUtil.insertSerVer((WritableMemory)wmem, (int)5);
        try {
            sk = Sketch.wrap((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCompactSizeAndFlagsOnHeapify() {
        WritableMemory wmem = SketchTest.createCompactSketchMemory(16, 32);
        Sketch sk = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(sk instanceof CompactSketch));
        int flags = PreambleUtil.extractFlags((Memory)wmem);
        int flagsNoCompact = flags & 0xFFFFFFFD;
        PreambleUtil.insertFlags((WritableMemory)wmem, (int)flagsNoCompact);
        try {
            sk = Sketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        wmem = WritableMemory.allocate((int)7);
        PreambleUtil.insertSerVer((WritableMemory)wmem, (int)3);
        try {
            sk = Sketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void check2Methods() {
        int k = 16;
        UpdateSketch sk = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        int bytes1 = sk.getCurrentBytes(true);
        int bytes2 = sk.getCurrentBytes(false);
        Assert.assertEquals((int)bytes1, (int)8);
        Assert.assertEquals((int)bytes2, (int)280);
        int retEnt = sk.getRetainedEntries();
        Assert.assertEquals((int)retEnt, (int)0);
    }

    @Test
    public void printlnTest() {
        SketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

