/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapQuickSelectSketchTest {
    private Family fam_ = Family.QUICKSELECT;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k;
        int u = k = 512;
        long seed = 9001L;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
        byte[] byteArray = usk.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(1L, (byte)0);
        Sketch.heapify((Memory)mem, (long)seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSketchID_UpdateSketch() {
        int k;
        int u = k = 512;
        long seed = 9001L;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
        byte[] byteArray = usk.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(2L, (byte)0);
        Sketch.heapify((Memory)mem, (long)seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int k = 512;
        long seed1 = 1021L;
        long seed2 = 9001L;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setSeed(seed1).setNominalEntries(k).build();
        byte[] byteArray = usk.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArray);
        Sketch.heapify((Memory)srcMem, (long)seed2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyCorruptLgNomLongs() {
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(16).build();
        WritableMemory srcMem = WritableMemory.wrap((byte[])usk.toByteArray());
        srcMem.putByte(3L, (byte)2);
        Sketch.heapify((Memory)srcMem, (long)9001L);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k;
        int u = k = 512;
        long seed = 9001L;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCurrentBytes();
        byte[] byteArray = usk.toByteArray();
        Assert.assertEquals((int)bytes, (int)byteArray.length);
        Memory srcMem = Memory.wrap((byte[])byteArray);
        UpdateSketch usk2 = Sketches.heapifyUpdateSketch((Memory)srcMem, (long)seed);
        Assert.assertEquals((double)usk2.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((double)usk2.getLowerBound(2), (double)u, (double)0.0);
        Assert.assertEquals((double)usk2.getUpperBound(2), (double)u, (double)0.0);
        Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)usk.getClass().getSimpleName());
        Assert.assertEquals((Object)usk2.getResizeFactor(), (Object)usk.getResizeFactor());
        usk2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int k = 4096;
        int u = 2 * k;
        long seed = 9001L;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)true);
        byte[] byteArray = usk.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArray);
        UpdateSketch usk2 = UpdateSketch.heapify((Memory)srcMem, (long)seed);
        Assert.assertEquals((double)usk2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)usk2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)usk2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)usk.getClass().getSimpleName());
        Assert.assertEquals((Object)usk2.getResizeFactor(), (Object)usk.getResizeFactor());
    }

    @Test
    public void checkHeapifyMemoryEstimating() {
        int k = 512;
        int u = 2 * k;
        long seed = 9001L;
        boolean estimating = u > k;
        UpdateSketch sk1 = UpdateSketch.builder().setFamily(this.fam_).setSeed(seed).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        double sk1est = sk1.getEstimate();
        double sk1lb = sk1.getLowerBound(2);
        double sk1ub = sk1.getUpperBound(2);
        Assert.assertEquals((boolean)sk1.isEstimationMode(), (boolean)estimating);
        byte[] byteArray = sk1.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        UpdateSketch sk2 = UpdateSketch.heapify((Memory)mem, (long)9001L);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sk1est);
        Assert.assertEquals((double)sk2.getLowerBound(2), (double)sk1lb);
        Assert.assertEquals((double)sk2.getUpperBound(2), (double)sk1ub);
        Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)sk2.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)sk2.getClass().getSimpleName(), (String)sk1.getClass().getSimpleName());
    }

    @Test
    public void checkHQStoCompactForms() {
        int k = 512;
        int u = 4 * k;
        boolean estimating = u > k;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        Assert.assertFalse((boolean)usk.isDirect());
        Assert.assertFalse((boolean)usk.hasMemory());
        Assert.assertFalse((boolean)usk.isCompact());
        Assert.assertFalse((boolean)usk.isOrdered());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        sk1.rebuild();
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        int uskBytes = usk.getCurrentBytes();
        int uskCompBytes = usk.getCompactBytes();
        Assert.assertEquals((int)uskBytes, (int)maxBytes);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)estimating);
        CompactSketch comp1 = usk.compact(false, null);
        Assert.assertEquals((double)comp1.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp1.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp1.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp1.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp1.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp1.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp1.getClass().getSimpleName(), (String)"HeapCompactSketch");
        CompactSketch comp2 = usk.compact(true, null);
        Assert.assertEquals((double)comp2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp2.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp2.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp2.getClass().getSimpleName(), (String)"HeapCompactSketch");
        byte[] memArr2 = new byte[uskCompBytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
        CompactSketch comp3 = usk.compact(false, mem2);
        Assert.assertEquals((double)comp3.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp3.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp3.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp3.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp3.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp3.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp3.getClass().getSimpleName(), (String)"DirectCompactSketch");
        mem2.clear();
        CompactSketch comp4 = usk.compact(true, mem2);
        Assert.assertEquals((double)comp4.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp4.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp4.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp4.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp4.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp4.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp4.getClass().getSimpleName(), (String)"DirectCompactSketch");
        comp4.toString(false, true, 0, false);
    }

    @Test
    public void checkHQStoCompactEmptyForms() {
        int k = 512;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X2).setNominalEntries(k).build();
        HeapQuickSelectSketchTest.println("lgArr: " + usk.getLgArrLongs());
        HeapQuickSelectSketchTest.println(usk.toString(false, true, 0, false));
        boolean estimating = false;
        Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        int currentUSBytes = usk.getCurrentBytes();
        Assert.assertEquals((int)currentUSBytes, (int)280);
        int compBytes = usk.getCompactBytes();
        Assert.assertEquals((int)compBytes, (int)8);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)estimating);
        byte[] arr2 = new byte[compBytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])arr2);
        CompactSketch csk2 = usk.compact(false, mem2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)csk2.getClass().getSimpleName(), (String)"DirectCompactSketch");
        CompactSketch csk3 = usk.compact(true, mem2);
        HeapQuickSelectSketchTest.println(csk3.toString(false, true, 0, false));
        HeapQuickSelectSketchTest.println(csk3.toString());
        Assert.assertEquals((double)csk3.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)csk3.getClass().getSimpleName(), (String)"DirectCompactSketch");
    }

    @Test
    public void checkExactMode() {
        int k = 4096;
        int u = 4096;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertEquals((double)usk.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)u);
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        int u = 2 * k;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X4).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
    }

    @Test
    public void checkSamplingMode() {
        int k;
        int u = k = 4096;
        float p = 0.5f;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setP(p).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        double p2 = sk1.getP();
        double theta = sk1.getTheta();
        Assert.assertTrue((theta <= p2 ? 1 : 0) != 0);
        double est = usk.getEstimate();
        double kdbl = k;
        Assert.assertEquals((double)kdbl, (double)est, (double)(kdbl * 0.05));
        double ub = usk.getUpperBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        double lb = usk.getLowerBound(1);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int k = 512;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X1).setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk.update((long)i);
        }
        double est = usk.getEstimate();
        double lb = usk.getLowerBound(2);
        double ub = usk.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 10 * k;
        for (int i = k; i < u; ++i) {
            usk.update((long)i);
            usk.update((long)i);
        }
        est = usk.getEstimate();
        lb = usk.getLowerBound(2);
        ub = usk.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkEmptyAndP() {
        int k = 1024;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        usk.update(1L);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)1);
        Assert.assertFalse((boolean)usk.isEmpty());
        UpdateSketch usk2 = UpdateSketch.builder().setFamily(this.fam_).setP(0.001f).setNominalEntries(k).build();
        sk1 = (HeapQuickSelectSketch)usk2;
        Assert.assertTrue((boolean)usk2.isEmpty());
        usk2.update(1L);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)0);
        Assert.assertFalse((boolean)usk2.isEmpty());
        double est = usk2.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        double ub = usk2.getUpperBound(2);
        Assert.assertTrue((ub > 0.0 ? 1 : 0) != 0);
        double lb = usk2.getLowerBound(2);
        Assert.assertTrue((lb <= est ? 1 : 0) != 0);
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int k = 512;
        int u = 2 * k;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X2).setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        double est = usk.getEstimate();
        double ub = usk.getUpperBound(1);
        double lb = usk.getLowerBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int k = 16;
        int u = 4 * k;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertTrue((usk.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((sk1.getRetainedEntries(false) > k ? 1 : 0) != 0);
        sk1.rebuild();
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)k);
        sk1.rebuild();
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)k);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int k = 1024;
        int u = 4 * k;
        UpdateSketch usk = UpdateSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X8).setNominalEntries(k).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        Assert.assertEquals((int)(1 << sk1.getLgArrLongs()), (int)(2 * k));
        sk1.reset();
        ResizeFactor rf = sk1.getResizeFactor();
        int subMul = Util.startingSubMultiple((int)11, (int)rf.lg(), (int)5);
        Assert.assertEquals((int)sk1.getLgArrLongs(), (int)subMul);
        UpdateSketch usk2 = UpdateSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X1).setNominalEntries(k).build();
        sk1 = (HeapQuickSelectSketch)usk2;
        for (int i = 0; i < u; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((int)(1 << sk1.getLgArrLongs()), (int)(2 * k));
        sk1.reset();
        rf = sk1.getResizeFactor();
        subMul = Util.startingSubMultiple((int)11, (int)rf.lg(), (int)5);
        Assert.assertEquals((int)sk1.getLgArrLongs(), (int)subMul);
        Assert.assertNull((Object)sk1.getMemory());
        Assert.assertFalse((boolean)sk1.isOrdered());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int k = 512;
        UpdateSketch qs = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        qs.hashUpdate(-1L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMinReqBytes() {
        int k = 16;
        UpdateSketch s1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < 4 * k; ++i) {
            s1.update((long)i);
        }
        byte[] byteArray = s1.toByteArray();
        byte[] badBytes = Arrays.copyOfRange(byteArray, 0, 24);
        Memory mem = Memory.wrap((byte[])badBytes);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkThetaAndLgArrLongs() {
        int k = 16;
        UpdateSketch s1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            s1.update((long)i);
        }
        byte[] badArray = s1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])badArray);
        PreambleUtil.insertLgArrLongs((WritableMemory)mem, (int)4);
        PreambleUtil.insertThetaLong((WritableMemory)mem, (long)0x3FFFFFFFFFFFFFFFL);
        Sketch.heapify((Memory)mem);
    }

    @Test
    public void checkFamily() {
        UpdateSketch sketch = Sketches.updateSketchBuilder().build();
        Assert.assertEquals((Object)sketch.getFamily(), (Object)Family.QUICKSELECT);
    }

    @Test
    public void checkMemSerDeExceptions() {
        int k = 1024;
        UpdateSketch sk1 = UpdateSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        sk1.update(1L);
        byte[] bytearray1 = sk1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])bytearray1);
        long pre0 = mem.getLong(0L);
        HeapQuickSelectSketchTest.tryBadMem(mem, 0, 2);
        mem.putLong(0L, pre0);
        HeapQuickSelectSketchTest.tryBadMem(mem, 1, 2);
        mem.putLong(0L, pre0);
        HeapQuickSelectSketchTest.tryBadMem(mem, 2, 1);
        mem.putLong(0L, pre0);
        HeapQuickSelectSketchTest.tryBadMem(mem, 5, 2);
        mem.putLong(0L, pre0);
        HeapQuickSelectSketchTest.tryBadMem(mem, 2, 4);
        mem.putLong(0L, pre0);
        long origThetaLong = mem.getLong(16L);
        try {
            mem.putLong(16L, 0x3FFFFFFFFFFFFFFFL);
            HeapQuickSelectSketch.heapifyInstance((Memory)mem, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        mem.putLong(16L, origThetaLong);
        byte[] byteArray2 = new byte[bytearray1.length - 1];
        WritableMemory mem2 = WritableMemory.wrap((byte[])byteArray2);
        mem.copyTo(0L, mem2, 0L, mem2.getCapacity());
        try {
            HeapQuickSelectSketch.heapifyInstance((Memory)mem2, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertLgResizeFactor((WritableMemory)mem, (int)ResizeFactor.X1.lg());
        HeapQuickSelectSketch hqss = HeapQuickSelectSketch.heapifyInstance((Memory)mem, (long)9001L);
        Assert.assertEquals((Object)hqss.getResizeFactor(), (Object)ResizeFactor.X2);
    }

    private static void tryBadMem(WritableMemory mem, int byteOffset, int byteValue) {
        try {
            mem.putByte((long)byteOffset, (byte)byteValue);
            HeapQuickSelectSketch.heapifyInstance((Memory)mem, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        HeapQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

