/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.ConcurrentDirectQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketchTest;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConcurrentDirectQuickSelectSketchTest {
    private static final long SEED = 9001L;

    @Test
    public void checkDirectCompactConversion() {
        int lgK = 9;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        Assert.assertTrue((boolean)(sl.shared instanceof ConcurrentDirectQuickSelectSketch));
        Assert.assertTrue((boolean)sl.shared.compact().isCompact());
    }

    @Test
    public void checkHeapifyMemoryEstimating() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 2 * k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertEquals((String)shared.getClass().getSimpleName(), (String)"ConcurrentDirectQuickSelectSketch");
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        UpdateSketch sharedHeap = Sketches.heapifyUpdateSketch((Memory)sl.wmem);
        Assert.assertEquals((String)sharedHeap.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        ConcurrentDirectQuickSelectSketchTest.checkMemoryDirectProxyMethods((Sketch)local, (Sketch)shared);
        ConcurrentDirectQuickSelectSketchTest.checkOtherProxyMethods((Sketch)local, (Sketch)shared);
        ConcurrentDirectQuickSelectSketchTest.checkOtherProxyMethods((Sketch)local, (Sketch)sharedHeap);
        int curCount1 = shared.getRetainedEntries(true);
        int curCount2 = sharedHeap.getRetainedEntries(true);
        Assert.assertEquals((int)curCount1, (int)curCount2);
        long[] cache = sharedHeap.getCache();
        long thetaLong = sharedHeap.getThetaLong();
        int cacheCount = HashOperations.count((long[])cache, (long)thetaLong);
        Assert.assertEquals((int)curCount1, (int)cacheCount);
        Assert.assertEquals((int)local.getCurrentPreambleLongs(), (int)3);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int lgK = 9;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < k; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        byte[] serArr = shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        Sketch recoveredShared = Sketch.heapify((Memory)srcMem);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        shared = sl.bldr.buildSharedFromSketch((UpdateSketch)recoveredShared, wmem);
        UpdateSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)k, (double)0.0);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)k, (double)0.0);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)k, (double)0.0);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)recoveredShared.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        local2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int lgK = 12;
        int k = 1 << lgK;
        int u = 2 * k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double uskEst = local.getEstimate();
        double uskLB = local.getLowerBound(2);
        double uskUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)true);
        byte[] serArr = shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        Sketch recoveredShared = Sketch.heapify((Memory)srcMem);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        shared = sl.bldr.buildSharedFromSketch((UpdateSketch)recoveredShared, wmem);
        UpdateSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((String)recoveredShared.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
    }

    @Test
    public void checkWrapMemoryEst() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 2 * k;
        boolean estimating = u > k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double sk1est = local.getEstimate();
        double sk1lb = local.getLowerBound(2);
        double sk1ub = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        Sketch local2 = Sketch.wrap((Memory)sl.wmem);
        Assert.assertEquals((double)local2.getEstimate(), (double)sk1est);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)sk1lb);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)sk1ub);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)estimating);
    }

    @Test
    public void checkDQStoCompactForms() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 4 * k;
        boolean estimating = u > k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        Assert.assertFalse((boolean)local.isDirect());
        Assert.assertTrue((boolean)local.hasMemory());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        shared.rebuild();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        CompactSketch csk = shared.compact(false, null);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactSketch");
        csk = shared.compact(true, null);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactSketch");
        int bytes = shared.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)(k * 8 + (Family.COMPACT.getMaxPreLongs() << 3)));
        byte[] memArr2 = new byte[bytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
        csk = shared.compact(false, mem2);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactSketch");
        mem2.clear();
        csk = shared.compact(true, mem2);
        Assert.assertEquals((double)csk.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk.getUpperBound(2), (double)localUB);
        Assert.assertFalse((boolean)csk.isEmpty());
        Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactSketch");
        csk.toString(false, true, 0, false);
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        int lgK = 9;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        local.toString(false, true, 0, false);
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertFalse((boolean)local.isEstimationMode());
        int bytes = local.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)8);
        byte[] memArr2 = new byte[bytes];
        WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
        CompactSketch csk2 = shared.compact(false, mem2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)localUB);
        Assert.assertTrue((boolean)csk2.isEmpty());
        Assert.assertFalse((boolean)csk2.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactSketch csk3 = shared.compact(true, mem2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)localUB);
        Assert.assertTrue((boolean)csk3.isEmpty());
        Assert.assertFalse((boolean)csk3.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
    }

    @Test
    public void checkEstMode() {
        int lgK = 12;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertTrue((shared.getRetainedEntries(false) > k ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int lgK = 9;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < k; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        double lb = local.getLowerBound(2);
        double ub = local.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 100 * k;
        for (int i = k; i < u; ++i) {
            local.update((long)i);
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        est = local.getEstimate();
        lb = local.getLowerBound(2);
        ub = local.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 2 * k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        double ub = local.getUpperBound(1);
        double lb = local.getLowerBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 4 * k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)k);
        local.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)k);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int lgK = 9;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 4 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
        Assert.assertTrue((local.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
        shared.reset();
        local.reset();
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)0);
        Assert.assertEquals((double)local.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((long)local.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkExactModeMemoryArr() {
        int k;
        int lgK = 12;
        int u = k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)u);
    }

    @Test
    public void checkEstModeMemoryArr() {
        int lgK = 12;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        Assert.assertTrue((est < (double)u * 1.05 && est > (double)u * 0.95 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
    }

    @Test
    public void checkEstModeNativeMemory() {
        int lgK = 12;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est = local.getEstimate();
        Assert.assertTrue((est < (double)u * 1.05 && est > (double)u * 0.95 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
    }

    @Test
    public void checkConstructReconstructFromMemory() {
        int lgK = 12;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double est1 = local.getEstimate();
        int count1 = shared.getRetainedEntries(false);
        Assert.assertTrue((est1 < (double)u * 1.05 && est1 > (double)u * 0.95 ? 1 : 0) != 0);
        Assert.assertTrue((count1 >= k ? 1 : 0) != 0);
        byte[] serArr = shared.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = Sketches.wrapUpdateSketch((WritableMemory)mem);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = sl.bldr.buildLocal(shared);
        double est2 = local2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
    }

    @Test
    public void checkNullMemory() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        UpdateSketch sk = bldr.build();
        for (int i = 0; i < 1000; ++i) {
            sk.update((long)i);
        }
        UpdateSketch shared = bldr.buildSharedFromSketch(sk, null);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)1000);
        Assert.assertFalse((boolean)shared.hasMemory());
    }

    @Test
    public void checkResizeInBigMem() {
        int lgK = 14;
        int u = 0x100000;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, 9001L, useMem, true, 8);
        UpdateSketch local = sl.local;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorKtooSmall() {
        int lgK = 3;
        boolean useMem = true;
        new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorMemTooSmall() {
        int lgK = 4;
        int k = 1 << lgK;
        WritableMemory wmem = WritableMemory.allocate((int)(k / 2));
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        bldr.setLogNominalEntries(lgK);
        bldr.buildShared(wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyIllegalFamilyID_heapify() {
        int lgK = 9;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        sl.wmem.putByte(2L, (byte)0);
        Sketch.heapify((Memory)sl.wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadLgNomLongs() {
        int lgK = 4;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        sl.wmem.putByte(3L, (byte)3);
        DirectQuickSelectSketch.writableWrap((WritableMemory)sl.wmem, (long)9001L);
    }

    @Test
    public void checkBackgroundPropagation() {
        int i;
        int lgK = 4;
        int k = 1 << lgK;
        int u = 10 * k;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        ConcurrentHeapThetaBuffer sk1 = (ConcurrentHeapThetaBuffer)local;
        for (i = 0; i < k; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        long theta1 = ((ConcurrentSharedThetaSketch)shared).getVolatileTheta();
        while (i < u) {
            local.update((long)i);
            ++i;
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        long theta2 = ((ConcurrentSharedThetaSketch)shared).getVolatileTheta();
        int entries = shared.getRetainedEntries(false);
        Assert.assertTrue((entries > k || theta2 < theta1 ? 1 : 0) != 0, (String)("entries=" + entries + " k=" + k + " theta1=" + theta1 + " theta2=" + theta2));
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)k);
        sk1.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)k);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int lgK = 9;
        int k = 1 << lgK;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < k; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)k, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        sl.wmem.putByte(1L, (byte)0);
        Sketch.wrap((Memory)sl.wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_wrap() {
        int lgK = 9;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        sl.wmem.putByte(2L, (byte)0);
        Sketch.wrap((Memory)sl.wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_direct() {
        int lgK = 9;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        sl.wmem.putByte(2L, (byte)0);
        DirectQuickSelectSketch.writableWrap((WritableMemory)sl.wmem, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int lgK = 9;
        long seed1 = 1021L;
        long seed2 = 9001L;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, seed1, useMem, true, 1);
        UpdateSketch shared = sl.shared;
        Memory srcMem = Memory.wrap((byte[])shared.toByteArray());
        Sketch.heapify((Memory)srcMem, (long)seed2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptLgNomLongs() {
        int lgK = 4;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        sl.wmem.putByte(3L, (byte)2);
        Sketch.heapify((Memory)sl.wmem, (long)9001L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkIllegalHashUpdate() {
        int lgK = 4;
        boolean useMem = true;
        ConcurrentHeapQuickSelectSketchTest.SharedLocal sl = new ConcurrentHeapQuickSelectSketchTest.SharedLocal(lgK, lgK, useMem);
        UpdateSketch shared = sl.shared;
        shared.hashUpdate(1L);
    }

    @Test
    public void printlnTest() {
        ConcurrentDirectQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static void checkMemoryDirectProxyMethods(Sketch local, Sketch shared) {
        Assert.assertEquals((boolean)local.hasMemory(), (boolean)shared.hasMemory());
        Assert.assertEquals((boolean)local.isDirect(), (boolean)shared.isDirect());
    }

    private static void checkOtherProxyMethods(Sketch local, Sketch shared) {
        Assert.assertEquals((int)local.getCompactBytes(), (int)shared.getCompactBytes());
        Assert.assertEquals((int)local.getCurrentBytes(), (int)shared.getCurrentBytes());
        Assert.assertEquals((double)local.getEstimate(), (double)shared.getEstimate());
        Assert.assertEquals((double)local.getLowerBound(2), (double)shared.getLowerBound(2));
        Assert.assertEquals((double)local.getUpperBound(2), (double)shared.getUpperBound(2));
        Assert.assertEquals((boolean)local.isEmpty(), (boolean)shared.isEmpty());
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)shared.isEstimationMode());
    }
}

