/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfLongsSerDe;
import org.apache.datasketches.ArrayOfNumbersSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.datasketches.sampling.ReservoirSize;
import org.apache.datasketches.sampling.SampleSubsetSummary;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirItemsSketchTest {
    private static final double EPS = 1.0E-8;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidK() {
        ReservoirItemsSketch.newInstance((int)0);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        WritableMemory mem = ReservoirItemsSketchTest.getBasicSerializedLongsRIS();
        mem.putByte(1L, (byte)0);
        ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        WritableMemory mem = ReservoirItemsSketchTest.getBasicSerializedLongsRIS();
        mem.putByte(2L, (byte)Family.ALPHA.getID());
        try {
            PreambleUtil.preambleToString((Memory)mem);
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Inspecting preamble with Sampling family"));
        }
        ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreLongs() {
        WritableMemory mem = ReservoirItemsSketchTest.getBasicSerializedLongsRIS();
        mem.putByte(0L, (byte)0);
        ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadMemory() {
        byte[] bytes = new byte[4];
        Memory mem = Memory.wrap((byte[])bytes);
        try {
            PreambleUtil.getAndCheckPreLongs((Memory)mem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        bytes = new byte[8];
        bytes[0] = 2;
        mem = Memory.wrap((byte[])bytes);
        PreambleUtil.getAndCheckPreLongs((Memory)mem);
    }

    @Test
    public void checkEmptySketch() {
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)5);
        Assert.assertTrue((ris.getSamples() == null ? 1 : 0) != 0);
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Memory mem = Memory.wrap((byte[])sketchBytes);
        Assert.assertEquals((int)sketchBytes.length, (int)(Family.RESERVOIR.getMinPreLongs() << 3));
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        ReservoirItemsSketch loadedRis = ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)loadedRis.getNumSamples(), (int)0);
        ReservoirItemsSketchTest.println("Empty sketch:");
        ReservoirItemsSketchTest.println("  Preamble:");
        ReservoirItemsSketchTest.println(PreambleUtil.preambleToString((Memory)mem));
        ReservoirItemsSketchTest.println("  Sketch:");
        ReservoirItemsSketchTest.println(ris.toString());
    }

    @Test
    public void checkUnderFullReservoir() {
        int k = 128;
        int n = 64;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)128);
        int expectedLength = 0;
        for (int i = 0; i < 64; ++i) {
            String intStr = Integer.toString(i);
            expectedLength += intStr.length() + 4;
            ris.update((Object)intStr);
        }
        Assert.assertEquals((int)ris.getNumSamples(), (int)64);
        String[] data = (String[])ris.getSamples();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)ris.getNumSamples(), (long)ris.getN());
        Assert.assertEquals((int)data.length, (int)64);
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((String)data[i], (String)Integer.toString(i));
        }
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)sketchBytes.length, (int)(expectedLength += Family.RESERVOIR.getMaxPreLongs() << 3));
        Memory mem = Memory.wrap((byte[])sketchBytes);
        ReservoirItemsSketch loadedRis = ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)serDe);
        ReservoirItemsSketchTest.validateReservoirEquality(ris, loadedRis);
        ReservoirItemsSketchTest.println("Under-full reservoir:");
        ReservoirItemsSketchTest.println("  Preamble:");
        ReservoirItemsSketchTest.println(PreambleUtil.preambleToString((Memory)mem));
        ReservoirItemsSketchTest.println("  Sketch:");
        ReservoirItemsSketchTest.println(ris.toString());
    }

    @Test
    public void checkFullReservoir() {
        int k = 1000;
        int n = 2000;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)1000, (ResizeFactor)ResizeFactor.X2);
        for (int i = 0; i < 2000; ++i) {
            ris.update((Object)i);
        }
        Assert.assertEquals((int)ris.getNumSamples(), (int)ris.getK());
        ReservoirItemsSketchTest.validateSerializeAndDeserialize((ReservoirItemsSketch<Long>)ris);
        ReservoirItemsSketchTest.println("Full reservoir:");
        ReservoirItemsSketchTest.println("  Preamble:");
        byte[] byteArr = ris.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        ReservoirItemsSketchTest.println(ReservoirItemsSketch.toString((byte[])byteArr));
        ReservoirItemsSketch.toString((Memory)Memory.wrap((byte[])byteArr));
        ReservoirItemsSketchTest.println("  Sketch:");
        ReservoirItemsSketchTest.println(ris.toString());
    }

    @Test
    public void checkPolymorphicType() {
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)6);
        Assert.assertNull((Object)ris.getSamples());
        Assert.assertNull((Object)ris.getSamples(Number.class));
        ris.update((Object)1);
        ris.update((Object)2L);
        ris.update((Object)3.0);
        ris.update((Object)-21513);
        ris.update((Object)68);
        ris.update((Object)Float.valueOf(4.0f));
        Number[] data = (Number[])ris.getSamples(Number.class);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((int)data.length, (int)6);
        try {
            ris.getSamples();
            Assert.fail();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        ArrayOfNumbersSerDe serDe = new ArrayOfNumbersSerDe();
        try {
            ris.toByteArray((ArrayOfItemsSerDe)serDe);
            Assert.fail();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)serDe, Number.class);
        Assert.assertEquals((int)sketchBytes.length, (int)49);
        Memory mem = Memory.wrap((byte[])sketchBytes);
        ReservoirItemsSketch loadedRis = ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)ris.getNumSamples(), (int)loadedRis.getNumSamples());
        Number[] samples1 = (Number[])ris.getSamples(Number.class);
        Number[] samples2 = (Number[])loadedRis.getSamples(Number.class);
        Assert.assertNotNull((Object)samples1);
        Assert.assertNotNull((Object)samples2);
        Assert.assertEquals((int)samples1.length, (int)samples2.length);
        for (int i = 0; i < samples1.length; ++i) {
            Assert.assertEquals((Object)samples1[i], (Object)samples2[i]);
        }
    }

    @Test
    public void checkArrayOfNumbersSerDeErrors() {
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)6);
        Assert.assertNull((Object)ris.getSamples());
        Assert.assertNull((Object)ris.getSamples(Number.class));
        ris.update((Object)1);
        ris.update((Object)new BigDecimal(2));
        Number[] data = (Number[])ris.getSamples(Number.class);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((int)data.length, (int)2);
        ArrayOfNumbersSerDe serDe = new ArrayOfNumbersSerDe();
        try {
            ris.toByteArray((ArrayOfItemsSerDe)serDe, Number.class);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        data[1] = 3.0;
        byte[] bytes = serDe.serializeToByteArray(data);
        bytes[0] = 113;
        try {
            serDe.deserializeFromMemory(Memory.wrap((byte[])bytes), 2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkBadConstructorArgs() {
        ArrayList<String> data = new ArrayList<String>(128);
        for (int i = 0; i < 128; ++i) {
            data.add(Integer.toString(i));
        }
        ResizeFactor rf = ResizeFactor.X8;
        try {
            ReservoirItemsSketch.newInstance(null, (long)128L, (ResizeFactor)rf, (int)128);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("null reservoir"));
        }
        try {
            ReservoirItemsSketch.newInstance(data, (long)128L, (ResizeFactor)rf, (int)1);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("size less than 2"));
        }
        try {
            ReservoirItemsSketch.newInstance(data, (long)128L, (ResizeFactor)rf, (int)64);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("max size less than array length"));
        }
        try {
            ReservoirItemsSketch.newInstance(data, (long)512L, (ResizeFactor)rf, (int)256);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("too few samples"));
        }
        try {
            ReservoirItemsSketch.newInstance(data, (long)256L, (ResizeFactor)rf, (int)256);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("too few samples"));
        }
    }

    @Test
    public void checkRawSamples() {
        int k = 32;
        long n = 12L;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)32, (ResizeFactor)ResizeFactor.X2);
        for (long i = 0L; i < 12L; ++i) {
            ris.update((Object)i);
        }
        Long[] samples = (Long[])ris.getSamples();
        Assert.assertNotNull((Object)samples);
        Assert.assertEquals((long)samples.length, (long)12L);
        ArrayList rawSamples = ris.getRawSamplesAsList();
        Assert.assertEquals((long)rawSamples.size(), (long)12L);
        Assert.assertEquals((long)((Long)rawSamples.get(0)), (long)0L);
        rawSamples.set(0, -1L);
        samples = (Long[])ris.getSamples();
        Assert.assertEquals((long)samples[0], (long)-1L);
        Assert.assertEquals((long)samples.length, (long)12L);
    }

    @Test
    public void checkSketchCapacity() {
        ArrayList<Long> data = new ArrayList<Long>(64);
        for (long i = 0L; i < 64L; ++i) {
            data.add(i);
        }
        long itemsSeen = 0xFFFFFFFFFFFEL;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance(data, (long)0xFFFFFFFFFFFEL, (ResizeFactor)ResizeFactor.X8, (int)64);
        ris.update((Object)0L);
        try {
            ris.update((Object)0L);
            Assert.fail();
        }
        catch (SketchesStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Sketch has exceeded capacity for total items seen"));
        }
        ris.reset();
        Assert.assertEquals((long)ris.getN(), (long)0L);
        ris.update((Object)1L);
        Assert.assertEquals((long)ris.getN(), (long)1L);
    }

    @Test
    public void checkSampleWeight() {
        int i;
        int k = 32;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)32);
        for (i = 0; i < 16; ++i) {
            ris.update((Object)i);
        }
        Assert.assertEquals((double)ris.getImplicitSampleWeight(), (double)1.0);
        for (i = 0; i < 32; ++i) {
            ris.update((Object)i);
        }
        Assert.assertTrue((ris.getImplicitSampleWeight() - 1.5 < 1.0E-8 ? 1 : 0) != 0);
    }

    @Test
    public void checkVersionConversion() {
        int k = 32768;
        short encK = ReservoirSize.computeSize((int)32768);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)32768);
        byte[] sketchBytesOrig = ris.toByteArray((ArrayOfItemsSerDe)serDe);
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)serDe);
        WritableMemory sketchMem = WritableMemory.wrap((byte[])sketchBytes);
        sketchMem.putByte(1L, (byte)1);
        sketchMem.putInt(4L, 0);
        sketchMem.putShort(4L, encK);
        ReservoirItemsSketchTest.println(PreambleUtil.preambleToString((Memory)sketchMem));
        ReservoirItemsSketch rebuilt = ReservoirItemsSketch.heapify((Memory)sketchMem, (ArrayOfItemsSerDe)serDe);
        byte[] rebuiltBytes = rebuilt.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)sketchBytesOrig.length, (int)rebuiltBytes.length);
        for (int i = 0; i < sketchBytesOrig.length; ++i) {
            Assert.assertEquals((byte)sketchBytesOrig[i], (byte)rebuiltBytes[i]);
        }
    }

    @Test
    public void checkSetAndGetValue() {
        int k = 20;
        int tgtIdx = 5;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)20);
        ris.update(null);
        Assert.assertEquals((long)ris.getN(), (long)0L);
        for (short i = 0; i < 20; i = (short)(i + 1)) {
            ris.update((Object)i);
        }
        Assert.assertEquals((short)((Short)ris.getValueAtPosition(5)), (short)5);
        ris.insertValueAtPosition((Object)-1, 5);
        Assert.assertEquals((short)((Short)ris.getValueAtPosition(5)), (short)-1);
    }

    @Test
    public void checkBadSetAndGetValue() {
        int k = 20;
        int tgtIdx = 5;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)20);
        try {
            ris.getValueAtPosition(0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        for (int i = 0; i < 20; ++i) {
            ris.update((Object)i);
        }
        Assert.assertEquals((int)((Integer)ris.getValueAtPosition(5)), (int)5);
        try {
            ris.insertValueAtPosition((Object)-1, -1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            ris.insertValueAtPosition((Object)-1, 21);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            ris.getValueAtPosition(-1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            ris.getValueAtPosition(21);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkForceIncrement() {
        int k = 100;
        ReservoirItemsSketch rls = ReservoirItemsSketch.newInstance((int)100);
        for (long i = 0L; i < 200L; ++i) {
            rls.update((Object)i);
        }
        Assert.assertEquals((long)rls.getN(), (long)200L);
        rls.forceIncrementItemsSeen(100L);
        Assert.assertEquals((long)rls.getN(), (long)300L);
        try {
            rls.forceIncrementItemsSeen(0xFFFFFFFFFFFEL);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkEstimateSubsetSum() {
        long i;
        int k = 10;
        ReservoirItemsSketch sketch = ReservoirItemsSketch.newInstance((int)10);
        SampleSubsetSummary ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)0.0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)0.0);
        double itemCount = 0.0;
        for (i = 1L; i <= 9L; ++i) {
            sketch.update((Object)i);
            itemCount += 1.0;
        }
        ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)itemCount);
        Assert.assertEquals((double)ss.getLowerBound(), (double)itemCount);
        Assert.assertEquals((double)ss.getUpperBound(), (double)itemCount);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
        for (i = 10L; i <= 11L; ++i) {
            sketch.update((Object)i);
            itemCount += 1.0;
        }
        ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)itemCount);
        Assert.assertEquals((double)ss.getUpperBound(), (double)itemCount);
        Assert.assertTrue((ss.getLowerBound() < itemCount ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
        ss = sketch.estimateSubsetSum(item -> false);
        Assert.assertEquals((double)ss.getEstimate(), (double)0.0);
        Assert.assertEquals((double)ss.getLowerBound(), (double)0.0);
        Assert.assertTrue((ss.getUpperBound() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
        for (i = 1L; i <= 11L; ++i) {
            sketch.update((Object)(-i));
            itemCount += 1.0;
        }
        ss = sketch.estimateSubsetSum(item -> item < 0L);
        Assert.assertTrue((ss.getEstimate() >= ss.getLowerBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getEstimate() <= ss.getUpperBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getLowerBound() < itemCount / 1.4 ? 1 : 0) != 0);
        Assert.assertTrue((ss.getUpperBound() > itemCount / 2.6 ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
    }

    private static WritableMemory getBasicSerializedLongsRIS() {
        int k = 10;
        int n = 20;
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)10);
        Assert.assertEquals((int)ris.getNumSamples(), (int)0);
        for (int i = 0; i < 20; ++i) {
            ris.update((Object)i);
        }
        Assert.assertEquals((int)ris.getNumSamples(), (int)Math.min(20, 10));
        Assert.assertEquals((long)ris.getN(), (long)20L);
        Assert.assertEquals((int)ris.getK(), (int)10);
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        return WritableMemory.wrap((byte[])sketchBytes);
    }

    private static void validateSerializeAndDeserialize(ReservoirItemsSketch<Long> ris) {
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertEquals((int)sketchBytes.length, (int)(Family.RESERVOIR.getMaxPreLongs() + ris.getNumSamples() << 3));
        Memory mem = Memory.wrap((byte[])sketchBytes);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        ReservoirItemsSketch loadedRis = ReservoirItemsSketch.heapify((Memory)mem, (ArrayOfItemsSerDe)serDe);
        ReservoirItemsSketchTest.validateReservoirEquality(ris, loadedRis);
    }

    static <T> void validateReservoirEquality(ReservoirItemsSketch<T> ris1, ReservoirItemsSketch<T> ris2) {
        Assert.assertEquals((int)ris1.getNumSamples(), (int)ris2.getNumSamples());
        if (ris1.getNumSamples() == 0) {
            return;
        }
        Object[] samples1 = ris1.getSamples();
        Object[] samples2 = ris2.getSamples();
        Assert.assertNotNull((Object)samples1);
        Assert.assertNotNull((Object)samples2);
        Assert.assertEquals((int)samples1.length, (int)samples2.length);
        for (int i = 0; i < samples1.length; ++i) {
            Assert.assertEquals((Object)samples1[i], (Object)samples2[i]);
        }
    }

    private static void println(String msg) {
    }
}

