/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.datasketches.ArrayOfDoublesSerDe;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfLongsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ItemsSketchTest {
    @BeforeMethod
    public void setUp() {
        ItemsSketch.rand.setSeed(32749L);
    }

    @Test
    public void empty() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)128, Comparator.naturalOrder());
        Assert.assertNotNull((Object)sketch);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getRetainedItems(), (int)0);
        Assert.assertNull((Object)sketch.getMinValue());
        Assert.assertNull((Object)sketch.getMaxValue());
        Assert.assertNull((Object)sketch.getQuantile(0.5));
        Assert.assertNull((Object)sketch.getQuantiles(2));
        Assert.assertNull((Object)sketch.getQuantiles(new double[]{0.0, 1.0}));
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)byteArr.length, (int)8);
        Assert.assertNull((Object)sketch.getPMF((Object[])new String[0]));
        Assert.assertNull((Object)sketch.getCDF((Object[])new String[0]));
        Assert.assertTrue((boolean)Double.isNaN(sketch.getRank((Object)"a")));
    }

    @Test
    public void oneItem() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)128, Comparator.naturalOrder());
        sketch.update((Object)"a");
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getRetainedItems(), (int)1);
        Assert.assertEquals((String)((String)sketch.getMinValue()), (String)"a");
        Assert.assertEquals((String)((String)sketch.getMaxValue()), (String)"a");
        Assert.assertEquals((String)((String)sketch.getQuantile(0.5)), (String)"a");
        Assert.assertEquals((double)sketch.getRank((Object)"a"), (double)0.0);
        double[] pmf = sketch.getPMF((Object[])new String[0]);
        Assert.assertEquals((int)pmf.length, (int)1);
        Assert.assertEquals((double)pmf[0], (double)1.0);
        pmf = sketch.getPMF((Object[])new String[]{"a"});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.0);
        Assert.assertEquals((double)pmf[1], (double)1.0);
        double[] cdf = sketch.getCDF((Object[])new String[0]);
        Assert.assertEquals((int)cdf.length, (int)1);
        Assert.assertEquals((double)cdf[0], (double)1.0);
        cdf = sketch.getCDF((Object[])new String[]{"a"});
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.0);
        Assert.assertEquals((double)cdf[1], (double)1.0);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getRetainedItems(), (int)0);
        Assert.assertNull((Object)sketch.getMinValue());
        Assert.assertNull((Object)sketch.getMaxValue());
        Assert.assertNull((Object)sketch.getQuantile(0.5));
    }

    @Test
    public void estimation() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 1000; ++i) {
            sketch.update((Object)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000L);
        Assert.assertTrue((sketch.getRetainedItems() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sketch.getMinValue(), (Object)1);
        Assert.assertEquals((Object)sketch.getMaxValue(), (Object)1000);
        Assert.assertEquals((float)((Integer)sketch.getQuantile(0.5)).intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        Assert.assertEquals((Object)sketch.getQuantile(0.0), (Object)1);
        Assert.assertEquals((Object)sketch.getQuantile(1.0), (Object)1000);
        double[] fracRanks = new double[]{0.0, 0.5, 1.0};
        Integer[] quantiles = (Integer[])sketch.getQuantiles(fracRanks);
        Assert.assertEquals((Object)quantiles[0], (Object)1);
        Assert.assertEquals((float)quantiles[1].intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        Assert.assertEquals((Object)quantiles[2], (Object)1000);
        double[] fracRanks2 = new double[]{0.25, 0.5, 0.75};
        Integer[] quantiles2 = (Integer[])sketch.getQuantiles(fracRanks2);
        Assert.assertEquals((float)quantiles2[0].intValue(), (float)Integer.valueOf(250).intValue(), (float)17.0f);
        Assert.assertEquals((float)quantiles2[1].intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        Assert.assertEquals((float)quantiles2[2].intValue(), (float)Integer.valueOf(750).intValue(), (float)17.0f);
        quantiles = (Integer[])sketch.getQuantiles(2);
        Assert.assertEquals((Object)quantiles[0], (Object)1);
        quantiles = (Integer[])sketch.getQuantiles(3);
        Assert.assertEquals((Object)quantiles[0], (Object)1);
        Assert.assertEquals((float)quantiles[1].intValue(), (float)Integer.valueOf(500).intValue(), (float)17.0f);
        Assert.assertEquals((Object)quantiles[2], (Object)1000);
        double normErr = sketch.getNormalizedRankError(true);
        Assert.assertEquals((double)normErr, (double)0.0172, (double)0.001);
        ItemsSketchTest.println("" + normErr);
        double[] pmf = sketch.getPMF((Object[])new Integer[0]);
        Assert.assertEquals((int)pmf.length, (int)1);
        Assert.assertEquals((double)pmf[0], (double)1.0);
        pmf = sketch.getPMF((Object[])new Integer[]{500});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.05);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.05);
        Object[] intArr = new Integer[50];
        for (int i = 0; i < 50; ++i) {
            intArr[i] = 20 * i + 10;
        }
        double[] pmf2 = sketch.getPMF(intArr);
        Assert.assertEquals((int)pmf2.length, (int)51);
        double[] cdf = sketch.getCDF((Object[])new Integer[0]);
        Assert.assertEquals((int)cdf.length, (int)1);
        Assert.assertEquals((double)cdf[0], (double)1.0);
        cdf = sketch.getCDF((Object[])new Integer[]{500});
        Assert.assertEquals((int)cdf.length, (int)2);
        Assert.assertEquals((double)cdf[0], (double)0.5, (double)0.05);
        Assert.assertEquals((double)cdf[1], (double)1.0, (double)0.05);
        Assert.assertEquals((double)sketch.getRank((Object)500), (double)0.5, (double)0.01);
    }

    @Test
    public void serializeDeserializeLong() {
        ItemsSketch sketch1 = ItemsSketch.getInstance((int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getRetainedItems() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sketch2.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)sketch2.getMaxValue(), (Object)1000L);
        Assert.assertEquals((float)((Long)sketch2.getQuantile(0.5)).longValue(), (float)Long.valueOf(500L).longValue(), (float)17.0f);
    }

    @Test
    public void serializeDeserializeDouble() {
        ItemsSketch sketch1 = ItemsSketch.getInstance((int)128, Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getRetainedItems() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((Object)sketch2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)sketch2.getMaxValue(), (Object)1000.0);
        Assert.assertEquals((double)((Double)sketch2.getQuantile(0.5)), (double)500.0, (double)17.0);
    }

    @Test
    public void serializeDeserializeString() {
        Comparator<String> numericOrder = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Integer i1 = Integer.parseInt(s1, 2);
                Integer i2 = Integer.parseInt(s2, 2);
                return i1.compareTo(i2);
            }
        };
        ItemsSketch sketch1 = ItemsSketch.getInstance((int)128, (Comparator)numericOrder);
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)Integer.toBinaryString(i << 10));
        }
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes), (Comparator)numericOrder, (ArrayOfItemsSerDe)serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)Integer.toBinaryString(i << 10));
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getRetainedItems() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)sketch2.getMinValue()), (String)Integer.toBinaryString(1024));
        Assert.assertEquals((String)((String)sketch2.getMaxValue()), (String)Integer.toBinaryString(1024000));
        Assert.assertEquals((float)(Integer.parseInt((String)sketch2.getQuantile(0.5), 2) >> 10), (float)Integer.valueOf(500).intValue(), (float)17.0f);
    }

    @Test
    public void toStringCrudeCheck() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        String brief = sketch.toString();
        String full = sketch.toString(true, true);
        String part = sketch.toString(false, true);
        sketch.update((Object)"a");
        brief = sketch.toString();
        full = sketch.toString(true, true);
        part = sketch.toString(false, true);
        Assert.assertTrue((brief.length() < full.length() ? 1 : 0) != 0);
        Assert.assertTrue((part.length() < full.length() ? 1 : 0) != 0);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        ItemsSketch.toString((byte[])bytes);
        ItemsSketch.toString((Memory)Memory.wrap((byte[])bytes));
    }

    @Test
    public void toStringBiggerCheck() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        String bigger = sketch.toString();
        String full = sketch.toString(true, true);
        Assert.assertTrue((bigger.length() < full.length() ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkDownsampleException() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        sketch.downSample(32);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void zeroEvenlySpacedMustThrow() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        sketch.update((Object)"a");
        sketch.getQuantiles(0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void negativeQuantileMustThrow() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        sketch.update(null);
        sketch.getQuantile(-0.1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceExcep1() {
        Memory mem = Memory.wrap((byte[])new byte[4]);
        ItemsSketch.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceExcep2() {
        Memory mem = Memory.wrap((byte[])new byte[8]);
        ItemsSketch.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkGoodSerDeId() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Memory mem = Memory.wrap((byte[])byteArr);
        ItemsSketch.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkDownsample() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        ItemsSketch out = sketch.downSample(8);
        Assert.assertEquals((int)out.getK(), (int)8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void unorderedSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{2, 1});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nonUniqueSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{1, 1});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nullInSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        sketch.update((Object)1);
        sketch.getPMF((Object[])new Integer[]{1, null});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void compactNotSupported() {
        ArrayOfDoublesSerDe serDe = new ArrayOfDoublesSerDe();
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        WritableMemory mem = WritableMemory.wrap((byte[])byteArr);
        mem.clearBits(3L, (byte)8);
        ItemsSketchTest.println(PreambleUtil.toString((Memory)mem, (boolean)false));
        ItemsSketch.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
    }

    @Test
    public void checkPutMemory() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        byte[] byteArr = new byte[200];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArr);
        sketch.putMemory(mem, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPutMemoryException() {
        ItemsSketch sketch = ItemsSketch.getInstance((int)16, Comparator.naturalOrder());
        for (int i = 0; i < 40; ++i) {
            sketch.update((Object)Integer.toString(i));
        }
        byte[] byteArr = new byte[100];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArr);
        sketch.putMemory(mem, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkPMFonEmpty() {
        ItemsSketch<String> iss = ItemsSketchTest.buildStringIS(32, 32);
        double[] ranks = new double[]{};
        String[] qOut = (String[])iss.getQuantiles(ranks);
        ItemsSketchTest.println("qOut: " + qOut.length);
        Assert.assertEquals((int)qOut.length, (int)0);
        double[] cdfOut = iss.getCDF((Object[])new String[0]);
        ItemsSketchTest.println("cdfOut: " + cdfOut.length);
        Assert.assertEquals((double)cdfOut[0], (double)1.0, (double)0.0);
    }

    @Test
    public void checkToFromByteArray() {
        ItemsSketchTest.checkToFromByteArray2(128, 1300);
        ItemsSketchTest.checkToFromByteArray2(4, 7);
        ItemsSketchTest.checkToFromByteArray2(4, 8);
        ItemsSketchTest.checkToFromByteArray2(4, 9);
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        int n = 1000000;
        Object[] values = new Integer[1000000];
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((Object)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void getRankAndGetCdfConsistencyReverseComparator() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder().reversed());
        int n = 1000000;
        Object[] values = new Integer[1000000];
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((Object)i);
            values[i] = i;
        }
        Arrays.sort(values, sketch.getComparator());
        double[] ranks = sketch.getCDF(values);
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void checkBounds() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        for (int i = 0; i < 1000; ++i) {
            sketch.update((Object)i);
        }
        double eps = sketch.getNormalizedRankError(false);
        double est = (Double)sketch.getQuantile(0.5);
        double ub = (Double)sketch.getQuantileUpperBound(0.5);
        double lb = (Double)sketch.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)((Double)sketch.getQuantile(0.5 + eps)));
        Assert.assertEquals((double)lb, (double)((Double)sketch.getQuantile(0.5 - eps)));
        ItemsSketchTest.println("Ext     : " + est);
        ItemsSketchTest.println("UB      : " + ub);
        ItemsSketchTest.println("LB      : " + lb);
    }

    @Test
    public void checkGetKFromEqs() {
        ItemsSketch sketch = ItemsSketch.getInstance(Comparator.naturalOrder());
        int k = sketch.getK();
        double eps = ItemsSketch.getNormalizedRankError((int)k, (boolean)false);
        double epsPmf = ItemsSketch.getNormalizedRankError((int)k, (boolean)true);
        int kEps = ItemsSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = ItemsSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)k);
        Assert.assertEquals((int)kEpsPmf, (int)k);
    }

    private static void checkToFromByteArray2(int k, int n) {
        double f;
        ItemsSketch<String> is = ItemsSketchTest.buildStringIS(k, n);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] byteArr = is.toByteArray(true, (ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])byteArr);
        ItemsSketch is2 = ItemsSketch.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((String)((String)is.getQuantile(f)), (String)((String)is2.getQuantile(f)));
        }
        byteArr = is.toByteArray(false, (ArrayOfItemsSerDe)serDe);
        mem = Memory.wrap((byte[])byteArr);
        is2 = ItemsSketch.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((String)((String)is.getQuantile(f)), (String)((String)is2.getQuantile(f)));
        }
    }

    static ItemsSketch<String> buildStringIS(int k, int n) {
        return ItemsSketchTest.buildStringIS(k, n, 0);
    }

    static ItemsSketch<String> buildStringIS(int k, int n, int start) {
        ItemsSketch sketch = ItemsSketch.getInstance((int)k, Comparator.naturalOrder());
        for (int i = 0; i < n; ++i) {
            sketch.update((Object)Integer.toString(i + start));
        }
        return sketch;
    }

    @Test
    public void testOrdering() {
        Comparator<String> natural = Comparator.naturalOrder();
        Comparator reverse = natural.reversed();
        Comparator<String> numeric = natural.thenComparing(new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return Integer.valueOf(s);
            }
        });
        for (Comparator c : Arrays.asList(natural, reverse, numeric)) {
            ItemsSketch sketch = ItemsSketch.getInstance((int)16, (Comparator)c);
            for (int i = 0; i < 10000; ++i) {
                sketch.update((Object)String.valueOf(ItemsSketch.rand.nextInt(1000000)));
            }
            Object[] quantiles = (String[])sketch.getQuantiles(100);
            Object[] sorted = Arrays.copyOf(quantiles, quantiles.length);
            Arrays.sort(sorted, c);
            Assert.assertEquals((Object[])quantiles, (Object[])sorted, (String)c.toString());
        }
    }

    @Test
    public void printlnTest() {
        ItemsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

