/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.DoublesUnionBuilder;
import org.apache.datasketches.quantiles.DoublesUnionImpl;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesUnionImplTest {
    @Test
    public void checkUnion1() {
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build();
        UpdateDoublesSketch qs0 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 500);
        union.update((DoublesSketch)qs0);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)500L);
        Assert.assertEquals((int)result.getK(), (int)256);
        union.reset();
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000);
        union.update((DoublesSketch)qs1);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)1000L);
        Assert.assertEquals((int)result.getK(), (int)256);
        UpdateDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000, 1000);
        union.update((DoublesSketch)qs2);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)2000L);
        Assert.assertEquals((int)result.getK(), (int)256);
    }

    @Test
    public void checkUnion1Direct() {
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build();
        UpdateDoublesSketch qs0 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 500);
        union.update((DoublesSketch)qs0);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)500L);
        Assert.assertEquals((int)result.getK(), (int)256);
        union.reset();
        UpdateDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        union.update((DoublesSketch)qs1);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)1000L);
        Assert.assertEquals((int)result.getK(), (int)256);
        CompactDoublesSketch qs2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000L, 1000).compact();
        union.update((DoublesSketch)qs2);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)2000L);
        Assert.assertEquals((int)result.getK(), (int)256);
    }

    @Test
    public void checkUnion2() {
        CompactDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000).compact();
        UpdateDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build();
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        union.update((DoublesSketch)qs1);
        UpdateDoublesSketch res1 = union.getResult();
        Assert.assertEquals((long)res1.getN(), (long)1000L);
        Assert.assertEquals((int)res1.getK(), (int)256);
        union.update((DoublesSketch)qs2);
        UpdateDoublesSketch res2 = union.getResult();
        Assert.assertEquals((long)res2.getN(), (long)2000L);
        Assert.assertEquals((int)res2.getK(), (int)128);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        DoublesUnionImplTest.println(union.toString());
    }

    @Test
    public void checkUnion2Direct() {
        UpdateDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        UpdateDoublesSketch qs2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 1000);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build();
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        union.update((DoublesSketch)qs1);
        UpdateDoublesSketch res1 = union.getResult();
        Assert.assertEquals((long)res1.getN(), (long)1000L);
        Assert.assertEquals((int)res1.getK(), (int)256);
        union.update((DoublesSketch)qs2);
        UpdateDoublesSketch res2 = union.getResult();
        Assert.assertEquals((long)res2.getN(), (long)2000L);
        Assert.assertEquals((int)res2.getK(), (int)128);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        DoublesUnionImplTest.println(union.toString());
    }

    @Test
    public void checkUnion3() {
        int k1 = 128;
        int n1 = 256;
        int k2 = 256;
        int n2 = 2000;
        UpdateDoublesSketch sketchIn1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 256);
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)2000L);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build(mem);
        union.update((DoublesSketch)sketchIn1);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)256.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkUnion3Direct() {
        int k1 = 128;
        int n1 = 256;
        int k2 = 256;
        int n2 = 2000;
        UpdateDoublesSketch sketchIn1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 256);
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)2000L);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build(mem);
        union.update((DoublesSketch)sketchIn1);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)256.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkUnion4() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 4;
        int n2 = 8;
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        WritableMemory skMem = WritableMemory.wrap((byte[])new byte[bytes]);
        UpdateDoublesSketch sketchIn1 = DoublesSketch.builder().setK(8).build(skMem);
        for (int i = 0; i < 16; ++i) {
            sketchIn1.update((double)(i + 1));
        }
        WritableMemory uMem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build(uMem);
        union.update((DoublesSketch)sketchIn1);
        Assert.assertEquals((long)union.getResult().getN(), (long)16L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)8);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)16L);
        Assert.assertEquals((double)result.getMaxValue(), (double)16.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)8);
        UpdateDoublesSketch sketchIn2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(4, 8, 17);
        union.reset();
        union.update((DoublesSketch)sketchIn2);
        result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)25.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)18.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion4Direct() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 4;
        int n2 = 8;
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        WritableMemory skMem = WritableMemory.wrap((byte[])new byte[bytes]);
        UpdateDoublesSketch sketchIn1 = DoublesSketch.builder().setK(8).build(skMem);
        for (int i = 0; i < 16; ++i) {
            sketchIn1.update((double)(i + 1));
        }
        WritableMemory uMem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build(uMem);
        union.update((DoublesSketch)sketchIn1);
        Assert.assertEquals((long)union.getResult().getN(), (long)16L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)8);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)16L);
        Assert.assertEquals((double)result.getMaxValue(), (double)16.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)8);
        UpdateDoublesSketch sketchIn2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(4, 8L, 17);
        union.reset();
        union.update((DoublesSketch)sketchIn2);
        result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)25.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)18.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion4DirectCompact() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 4;
        int n2 = 20;
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        WritableMemory skMem = WritableMemory.wrap((byte[])new byte[bytes]);
        UpdateDoublesSketch sketchIn0 = DoublesSketch.builder().setK(8).build(skMem);
        for (int i = 0; i < 16; ++i) {
            sketchIn0.update((double)(i + 1));
        }
        CompactDoublesSketch sketchIn1 = sketchIn0.compact();
        WritableMemory uMem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build(uMem);
        union.update((DoublesSketch)sketchIn1);
        Assert.assertEquals((long)union.getResult().getN(), (long)16L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)8);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)16L);
        Assert.assertEquals((double)result.getMaxValue(), (double)16.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)result.getK(), (int)8);
        CompactDoublesSketch sketchIn2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(4, 20L, 17).compact();
        union.reset();
        union.update((DoublesSketch)sketchIn2);
        result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)37.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)18.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion5() {
        int k2 = 4;
        int n2 = 8;
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        WritableMemory skMem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesSketch.builder().setK(256).build(skMem);
        DoublesUnionImpl union = DoublesUnionImpl.heapifyInstance((Memory)skMem);
        Assert.assertEquals((long)union.getResult().getN(), (long)0L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)256);
        UpdateDoublesSketch sketchIn2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(4, 8, 17);
        union.update((DoublesSketch)sketchIn2);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
        Assert.assertEquals((long)union.getResult().getN(), (long)8L);
    }

    @Test
    public void checkUnion5Direct() {
        int k2 = 4;
        int n2 = 8;
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)256, (long)50L);
        WritableMemory skMem = WritableMemory.wrap((byte[])new byte[bytes]);
        DoublesSketch.builder().setK(256).build(skMem);
        DoublesUnionImpl union = DoublesUnionImpl.heapifyInstance((Memory)skMem);
        Assert.assertEquals((long)union.getResult().getN(), (long)0L);
        Assert.assertEquals((int)union.getMaxK(), (int)256);
        Assert.assertEquals((int)union.getEffectiveK(), (int)256);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)256);
        UpdateDoublesSketch sketchIn2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(4, 8L, 17);
        union.update((DoublesSketch)sketchIn2);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
        Assert.assertEquals((long)union.getResult().getN(), (long)8L);
    }

    @Test
    public void checkUnion6() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 16;
        int n2 = 32;
        UpdateDoublesSketch sk1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(8, 16, 0);
        UpdateDoublesSketch sk2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(16, 32, 16);
        DoublesUnionImpl union = DoublesUnionImpl.heapifyInstance((DoublesSketch)sk1);
        union.update((DoublesSketch)sk2);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)48.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion6Direct() {
        int k1 = 8;
        int n1 = 16;
        int k2 = 16;
        int n2 = 32;
        UpdateDoublesSketch sk1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(8, 16L, 0);
        UpdateDoublesSketch sk2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(16, 32L, 16);
        DoublesUnionImpl union = DoublesUnionImpl.heapifyInstance((DoublesSketch)sk1);
        union.update((DoublesSketch)sk2);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)48.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        DoublesUnionImplTest.println("\nFinal" + union.getResult().toString(true, true));
    }

    @Test
    public void checkUnion7() {
        DoublesUnionImpl union = DoublesUnionImpl.heapInstance((int)16);
        UpdateDoublesSketch skEst = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 64);
        union.update((DoublesSketch)skEst);
        DoublesUnionImplTest.println(skEst.toString(true, true));
        DoublesUnionImplTest.println(union.toString(true, true));
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)64.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkUnionQuantiles() {
        int k = 128;
        int n1 = 1664;
        int n2 = 1088;
        int n = 2752;
        double errorTolerance = 48.160000000000004;
        UpdateDoublesSketch sketch1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1664);
        CompactDoublesSketch sketch2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1088, 1664).compact();
        DoublesUnion union = DoublesUnion.builder().setMaxK(256).build();
        union.update((DoublesSketch)sketch2);
        union.update((DoublesSketch)sketch1);
        Memory mem = Memory.wrap((byte[])union.getResult().toByteArray(true));
        DoublesSketch result = DoublesSketch.wrap((Memory)mem);
        Assert.assertEquals((long)result.getN(), (long)2752L);
        Assert.assertEquals((int)result.getK(), (int)128);
        for (double fraction = 0.05; fraction < 1.0; fraction += 0.05) {
            Assert.assertEquals((double)result.getQuantile(fraction), (double)(fraction * 2752.0), (double)48.160000000000004);
        }
    }

    @Test
    public void checkUnion7Direct() {
        DoublesUnionImpl union = DoublesUnionImpl.heapInstance((int)16);
        UpdateDoublesSketch skEst = DirectUpdateDoublesSketchTest.buildAndLoadDQS(32, 64);
        union.update((DoublesSketch)skEst);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)64.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkUpdateMemory() {
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000);
        int bytes = qs1.getCompactStorageBytes();
        WritableMemory dstMem = WritableMemory.wrap((byte[])new byte[bytes]);
        qs1.putMemory(dstMem);
        WritableMemory srcMem = dstMem;
        DoublesUnion union = DoublesUnion.builder().build();
        union.update((Memory)srcMem);
        for (int i = 1000; i < 2000; ++i) {
            union.update((double)i);
        }
        UpdateDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((double)qs2.getMaxValue(), (double)1999.0, (double)0.0);
        String s = union.toString();
        DoublesUnionImplTest.println(s);
        union.reset();
    }

    @Test
    public void checkUpdateMemoryDirect() {
        UpdateDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        int bytes = qs1.getCompactStorageBytes();
        WritableMemory dstMem = WritableMemory.wrap((byte[])new byte[bytes]);
        qs1.putMemory(dstMem);
        WritableMemory srcMem = dstMem;
        DoublesUnion union = DoublesUnion.builder().build();
        union.update((Memory)srcMem);
        for (int i = 1000; i < 2000; ++i) {
            union.update((double)i);
        }
        UpdateDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((double)qs2.getMaxValue(), (double)1999.0, (double)0.0);
        String s = union.toString();
        DoublesUnionImplTest.println(s);
        union.reset();
    }

    @Test
    public void checkUnionUpdateLogic() {
        DoublesSketch qs1 = null;
        HeapUpdateDoublesSketch qs2 = (HeapUpdateDoublesSketch)HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 0);
        DoublesUnionImpl.updateLogic((int)256, qs1, (DoublesSketch)qs2);
        DoublesUnionImpl.updateLogic((int)256, (UpdateDoublesSketch)qs2, qs1);
        qs2.update(1.0);
        UpdateDoublesSketch result = DoublesUnionImpl.updateLogic((int)256, (UpdateDoublesSketch)qs2, qs1);
        Assert.assertEquals((double)result.getMaxValue(), (double)result.getMinValue(), (double)0.0);
    }

    @Test
    public void checkUnionUpdateLogicDirect() {
        DoublesSketch qs1 = null;
        DirectUpdateDoublesSketch qs2 = (DirectUpdateDoublesSketch)DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 0);
        DoublesUnionImpl.updateLogic((int)256, qs1, (DoublesSketch)qs2);
        DoublesUnionImpl.updateLogic((int)256, (UpdateDoublesSketch)qs2, qs1);
        qs2.update(1.0);
        UpdateDoublesSketch result = DoublesUnionImpl.updateLogic((int)256, (UpdateDoublesSketch)qs2, qs1);
        Assert.assertEquals((double)result.getMaxValue(), (double)result.getMinValue(), (double)0.0);
    }

    @Test
    public void checkUnionUpdateLogicDirectDownsampled() {
        DirectUpdateDoublesSketch qs1 = (DirectUpdateDoublesSketch)DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 1000);
        DirectUpdateDoublesSketch qs2 = (DirectUpdateDoublesSketch)DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 2000);
        UpdateDoublesSketch result = DoublesUnionImpl.updateLogic((int)128, (UpdateDoublesSketch)qs1, (DoublesSketch)qs2);
        Assert.assertEquals((double)result.getMaxValue(), (double)2000.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((long)result.getN(), (long)3000L);
        Assert.assertEquals((int)result.getK(), (int)128);
    }

    @Test
    public void checkUnionUpdateLogic2() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().build();
        DoublesUnion union = DoublesUnion.builder().build();
        union.update((DoublesSketch)qs1);
        union.update((DoublesSketch)qs2);
        qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1000);
        union.update((DoublesSketch)qs1);
        union.update((DoublesSketch)qs2);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)1000.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkUnionUpdateLogic2Direct() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().build();
        DoublesUnion union = DoublesUnion.builder().build();
        union.update((DoublesSketch)qs1);
        union.update((DoublesSketch)qs2);
        qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 1000);
        union.update((DoublesSketch)qs1);
        union.update((DoublesSketch)qs2);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((double)result.getMaxValue(), (double)1000.0, (double)0.0);
        Assert.assertEquals((double)result.getMinValue(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkResultAndReset() {
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 0);
        DoublesUnion union = DoublesUnion.heapify((DoublesSketch)qs1);
        UpdateDoublesSketch qs2 = union.getResultAndReset();
        Assert.assertEquals((int)qs2.getK(), (int)256);
    }

    @Test
    public void checkResultAndResetDirect() {
        UpdateDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 0);
        DoublesUnion union = DoublesUnion.heapify((DoublesSketch)qs1);
        UpdateDoublesSketch qs2 = union.getResultAndReset();
        Assert.assertEquals((int)qs2.getK(), (int)256);
    }

    @Test
    public void checkResultViaMemory() {
        DoublesUnion union = DoublesUnion.builder().build();
        WritableMemory mem = WritableMemory.allocate((int)1);
        try {
            union.getResult(mem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        mem = WritableMemory.allocate((int)8);
        UpdateDoublesSketch result = union.getResult(mem);
        Assert.assertTrue((boolean)result.isEmpty());
        int k = 128;
        int n = 1392;
        mem = WritableMemory.allocate((int)DoublesSketch.getUpdatableStorageBytes((int)128, (long)1392L));
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 1392);
        union.update((DoublesSketch)qs);
        result = union.getResult(mem);
        DoublesSketchTest.testSketchEquality((DoublesSketch)result, (DoublesSketch)qs);
    }

    @Test
    public void updateWithDoubleValueOnly() {
        DoublesUnion union = DoublesUnion.builder().build();
        union.update(123.456);
        UpdateDoublesSketch qs = union.getResultAndReset();
        Assert.assertEquals((long)qs.getN(), (long)1L);
    }

    @Test
    public void checkEmptyUnion() {
        DoublesUnionImpl union = DoublesUnionImpl.heapInstance((int)128);
        UpdateDoublesSketch sk = union.getResult();
        Assert.assertNotNull((Object)sk);
        byte[] bytes = union.toByteArray();
        Assert.assertEquals((int)bytes.length, (int)8);
        String s = union.toString();
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void checkUnionNulls() {
        DoublesUnionImpl union = DoublesUnionImpl.heapInstance((int)128);
        UpdateDoublesSketch sk1 = union.getResultAndReset();
        UpdateDoublesSketch sk2 = union.getResultAndReset();
        Assert.assertNull((Object)sk1);
        Assert.assertNull((Object)sk2);
        union.update((DoublesSketch)sk2);
        UpdateDoublesSketch sk3 = union.getResultAndReset();
        Assert.assertNull((Object)sk3);
    }

    @Test
    public void differentLargerK() {
        DoublesUnion union = DoublesUnion.builder().setMaxK(128).build();
        UpdateDoublesSketch sketch1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 0);
        union.update((DoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.update((DoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentLargerKDirect() {
        DoublesUnion union = DoublesUnion.builder().setMaxK(128).build();
        UpdateDoublesSketch sketch1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(256, 0);
        union.update((DoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.update((DoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentEmptySmallerK() {
        int k128 = 128;
        int k64 = 64;
        DoublesUnion union = DoublesUnion.builder().setMaxK(128).build();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.isDirect());
        UpdateDoublesSketch sketch1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(64, 0);
        union.update((DoublesSketch)sketch1);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.isDirect());
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.update((DoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentEmptySmallerKDirect() {
        int k128 = 128;
        int k64 = 64;
        DoublesUnion union = DoublesUnion.builder().setMaxK(128).build();
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.isDirect());
        UpdateDoublesSketch sketch1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(64, 0);
        union.update((DoublesSketch)sketch1);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.isDirect());
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update(1.0);
        union.update((DoublesSketch)sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void checkDirectInstance() {
        int k = 128;
        int n = 1000;
        DoublesUnionBuilder bldr = DoublesUnion.builder();
        bldr.setMaxK(128);
        Assert.assertEquals((int)bldr.getMaxK(), (int)128);
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)128, (long)1000L);
        byte[] byteArr = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArr);
        DoublesUnion union = bldr.build(mem);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertTrue((boolean)union.isDirect());
        for (int i = 1; i <= 1000; ++i) {
            union.update((double)i);
        }
        Assert.assertFalse((boolean)union.isEmpty());
        UpdateDoublesSketch res = union.getResult();
        double median = res.getQuantile(0.5);
        Assert.assertEquals((double)median, (double)500.0, (double)10.0);
        DoublesUnionImplTest.println(union.toString());
    }

    @Test
    public void checkWrapInstance() {
        int k = 128;
        int n = 1000;
        UpdateDoublesSketch sketch = DoublesSketch.builder().setK(128).build();
        for (int i = 1; i <= 1000; ++i) {
            sketch.update((double)i);
        }
        double skMedian = sketch.getQuantile(0.5);
        Assert.assertEquals((double)skMedian, (double)500.0, (double)10.0);
        byte[] byteArr = sketch.toByteArray(false);
        WritableMemory mem = WritableMemory.wrap((byte[])byteArr);
        DoublesUnion union = DoublesUnion.wrap((WritableMemory)mem);
        Assert.assertFalse((boolean)union.isEmpty());
        Assert.assertTrue((boolean)union.isDirect());
        UpdateDoublesSketch sketch2 = union.getResult();
        double uMedian = sketch2.getQuantile(0.5);
        Assert.assertEquals((double)skMedian, (double)uMedian, (double)0.0);
        byte[] bytesOut = union.toByteArray();
        Assert.assertEquals((int)bytesOut.length, (int)byteArr.length);
        Assert.assertEquals((byte[])bytesOut, (byte[])byteArr);
    }

    @Test
    public void isSameResourceHeap() {
        DoublesUnion union = DoublesUnion.builder().build();
        Assert.assertFalse((boolean)union.isSameResource(null));
    }

    @Test
    public void isSameResourceDirect() {
        WritableMemory mem1 = WritableMemory.wrap((byte[])new byte[1000000]);
        DoublesUnion union = DoublesUnion.builder().build(mem1);
        Assert.assertTrue((boolean)union.isSameResource((Memory)mem1));
        WritableMemory mem2 = WritableMemory.wrap((byte[])new byte[1000000]);
        Assert.assertFalse((boolean)union.isSameResource((Memory)mem2));
    }

    @Test
    public void emptyUnionSerDeIssue195() {
        DoublesUnion union = DoublesUnion.builder().build();
        byte[] byteArr = union.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        DoublesUnion union2 = DoublesUnion.heapify((Memory)mem);
        Assert.assertEquals((long)mem.getCapacity(), (long)8L);
        Assert.assertTrue((boolean)union2.isEmpty());
    }

    @Test
    public void printlnTest() {
        DoublesUnionImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

