/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllFloatsSketchIteratorTest {
    @Test
    public void emptySketch() {
        KllFloatsSketch sketch = new KllFloatsSketch();
        KllFloatsSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllFloatsSketch sketch = new KllFloatsSketch();
        sketch.update(0.0f);
        KllFloatsSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((float)it.getValue(), (float)0.0f);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllFloatsSketch sketch = new KllFloatsSketch();
            for (int i = 0; i < n; ++i) {
                sketch.update((float)i);
            }
            KllFloatsSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight = (int)((long)weight + it.getWeight());
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

