/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllFloatsSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DeprecatedAndMiscTest {
    @Test
    public void checkDeprecatedRankError() {
        KllFloatsSketch sketch = new KllFloatsSketch();
        int k = 200;
        double eps1 = sketch.getNormalizedRankError();
        double eps2 = KllFloatsSketch.getNormalizedRankError((int)200);
        double expectEps = KllFloatsSketch.getNormalizedRankError((int)200, (boolean)true);
        Assert.assertEquals((double)eps1, (double)expectEps);
        Assert.assertEquals((double)eps2, (double)expectEps);
    }

    @Test
    public void checkGetKFromEps() {
        int k = 200;
        double eps = KllFloatsSketch.getNormalizedRankError((int)200, (boolean)false);
        double epsPmf = KllFloatsSketch.getNormalizedRankError((int)200, (boolean)true);
        int kEps = KllFloatsSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = KllFloatsSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)200);
        Assert.assertEquals((int)kEpsPmf, (int)200);
    }

    @Test
    public void checkBounds() {
        KllFloatsSketch kll = new KllFloatsSketch();
        for (int i = 0; i < 1000; ++i) {
            kll.update((float)i);
        }
        double eps = kll.getNormalizedRankError(false);
        float est = kll.getQuantile(0.5);
        float ub = kll.getQuantileUpperBound(0.5);
        float lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((float)ub, (float)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((float)lb, (float)kll.getQuantile(0.5 - eps));
        DeprecatedAndMiscTest.println("Ext     : " + est);
        DeprecatedAndMiscTest.println("UB      : " + ub);
        DeprecatedAndMiscTest.println("LB      : " + lb);
    }

    public void checkNumRetainedAboveLevelZero() {
        KllFloatsSketch sketch = new KllFloatsSketch(20);
        for (int i = 0; i < 10; ++i) {
            sketch.update((float)(i + 1));
        }
        String s1 = sketch.toString(true, true);
        DeprecatedAndMiscTest.println(s1);
        KllFloatsSketch sketch2 = new KllFloatsSketch(20);
        for (int i = 0; i < 400; ++i) {
            sketch2.update((float)(i + 1));
        }
        sketch2.merge(sketch);
        String s2 = sketch2.toString(true, true);
        DeprecatedAndMiscTest.println(s2);
    }

    @Test
    public void printlnTest() {
        DeprecatedAndMiscTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

