/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.nio.file.Files;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.memory.MapHandle;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMapHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpecialCBinariesTest {
    static PrintStream ps = System.out;
    static final String LS = System.getProperty("line.separator");

    @Test
    public void checkCpc10mBin() {
        String fileName = "cpc-10m.sk";
        File file = Util.getResourceFile((String)fileName);
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            try {
                CpcSketch cpcSketch = CpcSketch.heapify((Memory)mem);
            }
            catch (SketchesArgumentException sketchesArgumentException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkFranksString() {
        String hex = "06011006001ACC938E000000010000000100000009000000C0284BC1E001763B471D75617B0770CC9488E8DEE445D88A9347E97778C4A83E010600000D010000";
        int len = hex.length();
        byte[] byteArr = new byte[len / 2];
        for (int i = 0; i < len / 2; ++i) {
            String subStr = hex.substring(2 * i, 2 * i + 2);
            byteArr[i] = (byte)(Integer.parseInt(subStr, 16) & 0xFF);
        }
        SpecialCBinariesTest.println(CpcSketch.toString((byte[])byteArr, (boolean)true));
        CpcSketch sk = CpcSketch.heapify((byte[])byteArr);
        Assert.assertTrue((boolean)sk.validate());
        SpecialCBinariesTest.println(sk.toString(true));
        SpecialCBinariesTest.println("Est: " + sk.getEstimate());
    }

    static void byteArrToFile(byte[] byteArr, String fileName) throws Exception {
        String userDir = System.getProperty("user.dir");
        String fullPathName = userDir + "/src/test/resources/" + fileName;
        File file = new File(fullPathName);
        if (file.exists()) {
            Files.delete(file.toPath());
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        try (WritableMapHandle wmh = WritableMemory.map((File)file, (long)0L, (long)byteArr.length, (ByteOrder)ByteOrder.nativeOrder());){
            WritableMemory wmem = wmh.get();
            wmem.putByteArray(0L, byteArr, 0, byteArr.length);
            wmh.force();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void printlnTest() {
        SpecialCBinariesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void printf(String format, Object ... args) {
    }

    static void println(String s) {
    }
}

