/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.datasketches.Util;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.Flavor;
import org.apache.datasketches.cpc.PreambleUtil;
import org.apache.datasketches.memory.MapHandle;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CpcCBinariesTest {
    static PrintStream ps = System.out;
    static final String LS = System.getProperty("line.separator");

    @Test
    public void checkEmptyBin() {
        String fileName = "cpc-empty.sk";
        File file = Util.getResourceFile((String)"cpc-empty.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory wmem = mh.get();
            CpcCBinariesTest.println(PreambleUtil.toString((Memory)wmem, (boolean)true));
            CpcSketch sk = CpcSketch.heapify((Memory)wmem);
            Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.EMPTY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkSparseBin() {
        String fileName = "cpc-sparse.sk";
        File file = Util.getResourceFile((String)"cpc-sparse.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            CpcCBinariesTest.println("CPP GENERATED SKETCH FROM BINARY FILE LgK=11, U0 to U99");
            CpcCBinariesTest.println("PreambleUtil.toString(mem, true)" + LS);
            CpcCBinariesTest.println(PreambleUtil.toString((Memory)mem, (boolean)true));
            CpcCBinariesTest.println(LS + LS + "################");
            CpcCBinariesTest.println("CpcSketch sk = CpcSketch.heapify(mem);");
            CpcCBinariesTest.println("sk.toString(true)" + LS);
            CpcSketch sk = CpcSketch.heapify((Memory)mem);
            CpcCBinariesTest.println(sk.toString(true));
            Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.SPARSE);
            double est1 = sk.getEstimate();
            Assert.assertEquals((double)est1, (double)100.0, (double)2.0);
            for (int i = 0; i < 100; ++i) {
                sk.update((long)i);
            }
            double est2 = sk.getEstimate();
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkHybridBin() {
        String fileName = "cpc-hybrid.sk";
        File file = Util.getResourceFile((String)"cpc-hybrid.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            CpcCBinariesTest.println("CPP GENERATED SKETCH FROM BINARY FILE LgK=11, U0 to U199");
            CpcCBinariesTest.println("PreambleUtil.toString(mem, true)" + LS);
            CpcCBinariesTest.println(PreambleUtil.toString((Memory)mem, (boolean)true));
            CpcCBinariesTest.println(LS + LS + "################");
            CpcCBinariesTest.println("CpcSketch sk = CpcSketch.heapify(mem);");
            CpcCBinariesTest.println("sk.toString(true)" + LS);
            CpcSketch sk = CpcSketch.heapify((Memory)mem);
            CpcCBinariesTest.println(sk.toString(true));
            Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.HYBRID);
            double est1 = sk.getEstimate();
            Assert.assertEquals((double)est1, (double)200.0, (double)4.0);
            for (long i = 0L; i < 200L; ++i) {
                sk.update(i);
            }
            double est2 = sk.getEstimate();
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkPinnedBin() {
        String fileName = "cpc-pinned.sk";
        File file = Util.getResourceFile((String)"cpc-pinned.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            CpcCBinariesTest.println("CPP GENERATED SKETCH FROM BINARY FILE LgK=11, U0 to U1999");
            CpcCBinariesTest.println("PreambleUtil.toString(mem, true)" + LS);
            CpcCBinariesTest.println(PreambleUtil.toString((Memory)mem, (boolean)true));
            CpcCBinariesTest.println(LS + LS + "################");
            CpcCBinariesTest.println("CpcSketch sk = CpcSketch.heapify(mem);");
            CpcCBinariesTest.println("sk.toString(true)" + LS);
            CpcSketch sk = CpcSketch.heapify((Memory)mem);
            CpcCBinariesTest.println(sk.toString(true));
            Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.PINNED);
            double est1 = sk.getEstimate();
            Assert.assertEquals((double)est1, (double)2000.0, (double)40.0);
            for (long i = 0L; i < 2000L; ++i) {
                sk.update(i);
            }
            double est2 = sk.getEstimate();
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkSlidingBin() {
        String fileName = "cpc-sliding.sk";
        File file = Util.getResourceFile((String)"cpc-sliding.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            CpcCBinariesTest.println("CPP GENERATED SKETCH FROM BINARY FILE LgK=11, U0 to U19999");
            CpcCBinariesTest.println("PreambleUtil.toString(mem, true)" + LS);
            CpcCBinariesTest.println(PreambleUtil.toString((Memory)mem, (boolean)true));
            CpcCBinariesTest.println(LS + LS + "################");
            CpcCBinariesTest.println("CpcSketch sk = CpcSketch.heapify(mem);");
            CpcCBinariesTest.println("sk.toString(true)" + LS);
            CpcSketch sk = CpcSketch.heapify((Memory)mem);
            CpcCBinariesTest.println(sk.toString(true));
            Assert.assertEquals((Object)sk.getFlavor(), (Object)Flavor.SLIDING);
            double est1 = sk.getEstimate();
            Assert.assertEquals((double)est1, (double)20000.0, (double)400.0);
            for (long i = 0L; i < 20000L; ++i) {
                sk.update(i);
            }
            double est2 = sk.getEstimate();
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkEmptyImages() {
        String fileName = "cpc-empty.sk";
        File file = Util.getResourceFile((String)"cpc-empty.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            int cap = (int)mem.getCapacity();
            byte[] memByteArr = new byte[cap];
            mem.getByteArray(0L, memByteArr, 0, cap);
            CpcSketch sk = new CpcSketch(11);
            byte[] mem2ByteArr = sk.toByteArray();
            Memory mem2 = Memory.wrap((byte[])mem2ByteArr);
            Assert.assertEquals((long)mem.getCapacity(), (long)mem2.getCapacity());
            Assert.assertEquals((byte[])memByteArr, (byte[])mem2ByteArr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkSparseImages() {
        String fileName = "cpc-sparse.sk";
        File file = Util.getResourceFile((String)"cpc-sparse.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            int cap = (int)mem.getCapacity();
            byte[] memByteArr = new byte[cap];
            mem.getByteArray(0L, memByteArr, 0, cap);
            CpcSketch sk = new CpcSketch(11);
            for (int i = 0; i < 100; ++i) {
                sk.update((long)i);
            }
            byte[] mem2ByteArr = sk.toByteArray();
            Memory mem2 = Memory.wrap((byte[])mem2ByteArr);
            Assert.assertEquals((long)mem.getCapacity(), (long)mem2.getCapacity());
            Assert.assertEquals((byte[])memByteArr, (byte[])mem2ByteArr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkHybridImages() {
        String fileName = "cpc-hybrid.sk";
        File file = Util.getResourceFile((String)"cpc-hybrid.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            int cap = (int)mem.getCapacity();
            byte[] memByteArr = new byte[cap];
            mem.getByteArray(0L, memByteArr, 0, cap);
            CpcSketch sk = new CpcSketch(11);
            for (int i = 0; i < 200; ++i) {
                sk.update((long)i);
            }
            byte[] mem2ByteArr = sk.toByteArray();
            Memory mem2 = Memory.wrap((byte[])mem2ByteArr);
            Assert.assertEquals((long)mem.getCapacity(), (long)mem2.getCapacity());
            Assert.assertEquals((byte[])memByteArr, (byte[])mem2ByteArr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkPinnedImages() {
        String fileName = "cpc-pinned.sk";
        File file = Util.getResourceFile((String)"cpc-pinned.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            int cap = (int)mem.getCapacity();
            byte[] cppMemByteArr = new byte[cap];
            mem.getByteArray(0L, cppMemByteArr, 0, cap);
            CpcSketch sk = new CpcSketch(11);
            for (int i = 0; i < 2000; ++i) {
                sk.update((long)i);
            }
            byte[] javaMemByteArr = sk.toByteArray();
            Memory mem2 = Memory.wrap((byte[])javaMemByteArr);
            Assert.assertEquals((long)mem.getCapacity(), (long)mem2.getCapacity());
            Assert.assertEquals((byte[])cppMemByteArr, (byte[])javaMemByteArr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void checkSlidingImages() {
        String fileName = "cpc-sliding.sk";
        File file = Util.getResourceFile((String)"cpc-sliding.sk");
        try (MapHandle mh = Memory.map((File)file);){
            Memory mem = mh.get();
            int cap = (int)mem.getCapacity();
            byte[] memByteArr = new byte[cap];
            mem.getByteArray(0L, memByteArr, 0, cap);
            CpcSketch sk = new CpcSketch(11);
            for (int i = 0; i < 20000; ++i) {
                sk.update((long)i);
            }
            byte[] mem2ByteArr = sk.toByteArray();
            Memory mem2 = Memory.wrap((byte[])mem2ByteArr);
            Assert.assertEquals((long)mem.getCapacity(), (long)mem2.getCapacity());
            Assert.assertEquals((byte[])memByteArr, (byte[])mem2ByteArr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void genSparseSketch() {
        CpcSketch sk = new CpcSketch(11);
        for (int i = 0; i < 100; ++i) {
            sk.update((long)i);
        }
        CpcCBinariesTest.println("JAVA GENERATED SKETCH LgK=11, U0 to U99");
        CpcCBinariesTest.println("sketch.toString(true);" + LS);
        CpcCBinariesTest.println(sk.toString(true));
        CpcCBinariesTest.println(LS + LS + "################");
        byte[] byteArray = sk.toByteArray();
        CpcCBinariesTest.println("sketch.toByteArray();");
        CpcCBinariesTest.println("PreambleUtil.toString(byteArray, true);" + LS);
        CpcCBinariesTest.println(PreambleUtil.toString((byte[])byteArray, (boolean)true));
        CpcCBinariesTest.println(LS + LS + "################");
        CpcCBinariesTest.println("CpcSketch sk2 = CpcSketch.heapify(byteArray);");
        CpcCBinariesTest.println("sk2.toString(true);" + LS);
        CpcSketch sk2 = CpcSketch.heapify((byte[])byteArray);
        CpcCBinariesTest.println(sk2.toString(true));
    }

    @Test
    public void printlnTest() {
        CpcCBinariesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void printf(String format, Object ... args) {
    }

    static void println(String s) {
    }
}

