/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IntegerSketchTest {
    @Test
    public void serDeTest() {
        int lgK = 12;
        int K = 1 << lgK;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk = new IntegerSketch(lgK, a1Mode);
        int m = 2 * K;
        for (int key = 0; key < m; ++key) {
            a1Sk.update((long)key, Integer.valueOf(1));
        }
        double est1 = a1Sk.getEstimate();
        Memory mem = Memory.wrap((byte[])a1Sk.toByteArray());
        IntegerSketch a1Sk2 = new IntegerSketch(mem, a1Mode);
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((Object)est1, (Object)est2);
    }

    @Test
    public void intersectTest() {
        int lgK = 12;
        int K = 1 << lgK;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk1 = new IntegerSketch(lgK, a1Mode);
        IntegerSketch a1Sk2 = new IntegerSketch(lgK, a1Mode);
        int m = 2 * K;
        for (int key = 0; key < m; ++key) {
            a1Sk1.update((long)key, Integer.valueOf(1));
            a1Sk2.update((long)(key + m / 2), Integer.valueOf(1));
        }
        Intersection inter = new Intersection((SummarySetOperations)new IntegerSummarySetOperations(a1Mode, a1Mode));
        inter.update((Sketch)a1Sk1);
        inter.update((Sketch)a1Sk2);
        CompactSketch csk = inter.getResult();
        Assert.assertEquals((double)csk.getEstimate(), (double)((double)K * 1.0), (double)((double)K * 0.03));
    }

    @Test
    public void checkMinMaxMode() {
        int lgK = 12;
        int K = 1 << lgK;
        IntegerSummary.Mode minMode = IntegerSummary.Mode.Min;
        IntegerSummary.Mode maxMode = IntegerSummary.Mode.Max;
        IntegerSketch a1Sk1 = new IntegerSketch(lgK, minMode);
        IntegerSketch a1Sk2 = new IntegerSketch(lgK, maxMode);
        int m = K / 2;
        for (int key = 0; key < m; ++key) {
            a1Sk1.update((long)key, Integer.valueOf(1));
            a1Sk1.update((long)key, Integer.valueOf(0));
            a1Sk1.update((long)key, Integer.valueOf(2));
            a1Sk2.update((long)(key + m / 2), Integer.valueOf(1));
            a1Sk2.update((long)(key + m / 2), Integer.valueOf(0));
            a1Sk2.update((long)(key + m / 2), Integer.valueOf(2));
        }
        double est1 = a1Sk1.getEstimate();
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((Object)est1, (Object)est2);
    }

    @Test
    public void checkStringKey() {
        int lgK = 12;
        int K = 1 << lgK;
        IntegerSummary.Mode a1Mode = IntegerSummary.Mode.AlwaysOne;
        IntegerSketch a1Sk1 = new IntegerSketch(lgK, a1Mode);
        int m = K / 2;
        for (int key = 0; key < m; ++key) {
            a1Sk1.update(Integer.toHexString(key), Integer.valueOf(1));
        }
        Assert.assertEquals((Object)a1Sk1.getEstimate(), (Object)((double)K / 2.0));
    }

    static void println(Object o) {
    }

    static void printf(String fmt, Object ... args) {
    }
}

