/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapArrayOfDoublesQuickSelectSketchTest {
    @Test
    public void isEmpty() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.fail((String)"empty sketch expected");
        }
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test
    public void isEmptyWithSampling() {
        float samplingProbability = 0.1f;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(samplingProbability).build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((Object)((double)sketch.getThetaLong() / 9.223372036854776E18), (Object)samplingProbability);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)samplingProbability);
    }

    @Test
    public void sampling() {
        float samplingProbability = 0.001f;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(samplingProbability).build();
        sketch.update("a", new double[]{1.0});
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertTrue((sketch.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((Object)((double)sketch.getThetaLong() / 9.223372036854776E18), (Object)samplingProbability);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)samplingProbability);
    }

    @Test
    public void exactMode() {
        int i;
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        for (int i2 = 1; i2 <= 4096; ++i2) {
            sketch.update((long)i2, new double[]{1.0});
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)4096.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)4096.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)4096.0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        double[][] values = sketch.getValues();
        Assert.assertEquals((int)values.length, (int)4096);
        int count = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
        for (i = 0; i < 4096; ++i) {
            Assert.assertEquals((Object)values[i][0], (Object)1.0);
        }
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.fail((String)"empty sketch expected");
        }
    }

    @Test
    public void estimationMode() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        for (int i = 1; i <= 8192; ++i) {
            sketch.update((long)i, new double[]{1.0});
        }
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)8192.0, (double)81.92);
        Assert.assertTrue((sketch.getEstimate() >= sketch.getLowerBound(1) ? 1 : 0) != 0);
        Assert.assertTrue((sketch.getEstimate() < sketch.getUpperBound(1) ? 1 : 0) != 0);
        Assert.assertTrue((sketch.getRetainedEntries() > 4096 ? 1 : 0) != 0);
        sketch.trim();
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)4096);
        double[][] values = sketch.getValues();
        int count = 0;
        for (double[] array : values) {
            if (array == null) continue;
            ++count;
            Assert.assertEquals((int)array.length, (int)1);
            Assert.assertEquals((Object)array[0], (Object)1.0);
        }
        Assert.assertEquals((int)count, (int)values.length);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)0.0);
        Assert.assertEquals((Object)sketch.getUpperBound(1), (Object)0.0);
        Assert.assertEquals((Object)sketch.getLowerBound(1), (Object)0.0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)sketch.getTheta(), (Object)1.0);
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.fail((String)"empty sketch expected");
        }
    }

    @Test
    public void updatesOfAllKeyTypes() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2.0, new double[]{1.0});
        sketch.update(new byte[]{3}, new double[]{1.0});
        sketch.update(new int[]{4}, new double[]{1.0});
        sketch.update(new long[]{5L}, new double[]{1.0});
        sketch.update("a", new double[]{1.0});
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)6.0);
    }

    @Test
    public void doubleSum() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        Assert.assertEquals((Object)sketch.getValues()[0][0], (Object)1.0);
        sketch.update(1L, new double[]{0.7});
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        Assert.assertEquals((Object)sketch.getValues()[0][0], (Object)1.7);
        sketch.update(1L, new double[]{0.8});
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        Assert.assertEquals((Object)sketch.getValues()[0][0], (Object)2.5);
    }

    @Test
    public void serializeDeserializeExact() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = ArrayOfDoublesUpdatableSketch.heapify((Memory)WritableMemory.wrap((byte[])sketch1.toByteArray()));
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)1);
        Assert.assertEquals((Object)values[0][0], (Object)1.0);
        sketch2.update(1L, new double[]{1.0});
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)1.0);
        sketch2.update(2L, new double[]{1.0});
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)2.0);
    }

    @Test
    public void serializeDeserializeEstimationNoResize() throws Exception {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setResizeFactor(ResizeFactor.X1).build();
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 8192; ++i) {
                sketch1.update((long)i, new double[]{1.0});
            }
        }
        byte[] byteArray = sketch1.toByteArray();
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketch.heapify((Memory)Memory.wrap((byte[])byteArray));
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)8192.0, (double)8110.08);
        Assert.assertEquals((Object)sketch1.getTheta(), (Object)sketch2.getTheta());
        double[][] values = sketch2.getValues();
        Assert.assertTrue((values.length >= 4096 ? 1 : 0) != 0);
        for (double[] array : values) {
            Assert.assertEquals((Object)array[0], (Object)10.0);
        }
    }

    @Test
    public void serializeDeserializeSampling() {
        int sketchSize;
        int numberOfUniques = sketchSize = 16384;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(sketchSize).setSamplingProbability(0.5f).build();
        for (int i = 0; i < numberOfUniques; ++i) {
            sketch1.update((long)i, new double[]{1.0});
        }
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketch.heapify((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)(sketch2.getEstimate() / (double)numberOfUniques), (double)1.0, (double)0.01);
        Assert.assertEquals((double)((double)sketch2.getRetainedEntries() / (double)numberOfUniques), (double)0.5, (double)0.01);
        Assert.assertEquals((Object)sketch1.getTheta(), (Object)sketch2.getTheta());
    }
}

