/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.datasketches.tuple.DirectArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.HeapArrayOfDoublesCompactSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesCompactSketchTest {
    @Test
    public void heapToDirectExactTwoDoubles() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        DirectArrayOfDoublesCompactSketch sketch2 = new DirectArrayOfDoublesCompactSketch(Memory.wrap((byte[])sketch1.compact().toByteArray()));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)4.0);
        Assert.assertEquals((Object)sketch2.getUpperBound(1), (Object)4.0);
        Assert.assertEquals((Object)sketch2.getLowerBound(1), (Object)4.0);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)sketch2.getTheta(), (Object)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)4);
        for (double[] array : values) {
            Assert.assertEquals((int)array.length, (int)2);
            Assert.assertEquals((Object)array[0], (Object)2.0);
            Assert.assertEquals((Object)array[1], (Object)4.0);
        }
    }

    @Test
    public void directToHeapExactTwoDoubles() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build(WritableMemory.wrap((byte[])new byte[1000000]));
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        sketch1.update("a", new double[]{1.0, 2.0});
        sketch1.update("b", new double[]{1.0, 2.0});
        sketch1.update("c", new double[]{1.0, 2.0});
        sketch1.update("d", new double[]{1.0, 2.0});
        HeapArrayOfDoublesCompactSketch sketch2 = new HeapArrayOfDoublesCompactSketch(Memory.wrap((byte[])sketch1.compact(WritableMemory.wrap((byte[])new byte[1000000])).toByteArray()));
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((Object)sketch2.getEstimate(), (Object)4.0);
        Assert.assertEquals((Object)sketch2.getUpperBound(1), (Object)4.0);
        Assert.assertEquals((Object)sketch2.getLowerBound(1), (Object)4.0);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((Object)sketch2.getTheta(), (Object)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)4);
        for (double[] array : values) {
            Assert.assertEquals((int)array.length, (int)2);
            Assert.assertEquals((Object)array[0], (Object)2.0);
            Assert.assertEquals((Object)array[1], (Object)4.0);
        }
    }
}

