/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UpdateSketchTest {
    @Test
    public void checkOtherUpdates() {
        int k = 512;
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        sk1.update(1L);
        sk1.update(1.5);
        sk1.update(0.0);
        sk1.update(-0.0);
        String s = null;
        sk1.update(s);
        s = "";
        sk1.update(s);
        s = "String";
        sk1.update(s);
        byte[] byteArr = null;
        sk1.update(byteArr);
        byteArr = new byte[]{};
        sk1.update(byteArr);
        byteArr = "Byte Array".getBytes(StandardCharsets.UTF_8);
        sk1.update(byteArr);
        char[] charArr = null;
        sk1.update(charArr);
        charArr = new char[]{};
        sk1.update(charArr);
        charArr = "String".toCharArray();
        sk1.update(charArr);
        int[] intArr = null;
        sk1.update(intArr);
        intArr = new int[]{};
        sk1.update(intArr);
        int[] intArr2 = new int[]{1, 2, 3, 4, 5};
        sk1.update(intArr2);
        long[] longArr = null;
        sk1.update(longArr);
        longArr = new long[]{};
        sk1.update(longArr);
        long[] longArr2 = new long[]{6L, 7L, 8L, 9L};
        sk1.update(longArr2);
        double est = sk1.getEstimate();
        Assert.assertEquals((double)est, (double)8.0, (double)0.0);
    }

    @Test
    public void checkStartingSubMultiple() {
        int lgSubMul = Util.startingSubMultiple((int)10, (ResizeFactor)ResizeFactor.X1, (int)5);
        Assert.assertEquals((int)lgSubMul, (int)10);
        lgSubMul = Util.startingSubMultiple((int)10, (ResizeFactor)ResizeFactor.X2, (int)5);
        Assert.assertEquals((int)lgSubMul, (int)5);
        lgSubMul = Util.startingSubMultiple((int)10, (ResizeFactor)ResizeFactor.X4, (int)5);
        Assert.assertEquals((int)lgSubMul, (int)6);
        lgSubMul = Util.startingSubMultiple((int)10, (ResizeFactor)ResizeFactor.X8, (int)5);
        Assert.assertEquals((int)lgSubMul, (int)7);
        lgSubMul = Util.startingSubMultiple((int)4, (ResizeFactor)ResizeFactor.X1, (int)5);
        Assert.assertEquals((int)lgSubMul, (int)5);
    }

    @Test
    public void checkBuilder() {
        UpdateSketchBuilder bldr = UpdateSketch.builder();
        long seed = 12345L;
        bldr.setSeed(seed);
        Assert.assertEquals((long)bldr.getSeed(), (long)seed);
        float p = 0.5f;
        bldr.setP(p);
        Assert.assertEquals((Object)Float.valueOf(bldr.getP()), (Object)Float.valueOf(p));
        ResizeFactor rf = ResizeFactor.X4;
        bldr.setResizeFactor(rf);
        Assert.assertEquals((Object)bldr.getResizeFactor(), (Object)rf);
        Family fam = Family.ALPHA;
        bldr.setFamily(fam);
        Assert.assertEquals((Object)bldr.getFamily(), (Object)fam);
        int lgK = 10;
        int k = 1 << lgK;
        bldr.setNominalEntries(k);
        Assert.assertEquals((int)bldr.getLgNominalEntries(), (int)lgK);
        DefaultMemoryRequestServer mrs = new DefaultMemoryRequestServer();
        bldr.setMemoryRequestServer((MemoryRequestServer)mrs);
        Assert.assertEquals((Object)bldr.getMemoryRequestServer(), (Object)mrs);
        UpdateSketchTest.println(bldr.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderNomEntries() {
        UpdateSketchBuilder bldr = UpdateSketch.builder();
        int k = 0x8000000;
        bldr.setNominalEntries(k);
    }

    @Test
    public void checkCompact() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        CompactSketch csk = sk.compact();
        Assert.assertEquals((int)csk.getCurrentBytes(true), (int)8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIncompatibleFamily() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        WritableMemory wmem = WritableMemory.wrap((byte[])sk.compact().toByteArray());
        UpdateSketch.wrap((WritableMemory)wmem, (long)9001L);
    }

    @Test
    public void checkCorruption() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        WritableMemory wmem = WritableMemory.wrap((byte[])sk.toByteArray());
        try {
            wmem.putByte(1L, (byte)2);
            UpdateSketch.wrap((WritableMemory)wmem, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            wmem.putByte(1L, (byte)3);
            wmem.putByte(0L, (byte)2);
            UpdateSketch.wrap((WritableMemory)wmem, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        UpdateSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

