/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    @Test
    public void checkToString() {
        int k = 4096;
        int u = 2 * k;
        int bytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        UpdateSketch quick1 = UpdateSketch.builder().setNominalEntries(k).build(mem);
        PreambleUtilTest.println(Sketch.toString((byte[])byteArray));
        Assert.assertTrue((boolean)quick1.isEmpty());
        for (int i = 0; i < u; ++i) {
            quick1.update((long)i);
        }
        PreambleUtilTest.println("U: " + quick1.getEstimate());
        Assert.assertEquals((double)quick1.getEstimate(), (double)u, (double)(0.05 * (double)u));
        Assert.assertTrue((quick1.getRetainedEntries(false) > k ? 1 : 0) != 0);
        PreambleUtilTest.println(quick1.toString());
        PreambleUtilTest.println(PreambleUtil.preambleToString((Memory)mem));
        WritableMemory uMem = WritableMemory.wrap((byte[])new byte[SetOperation.getMaxUnionBytes((int)k)]);
        Union union = SetOperation.builder().setNominalEntries(k).buildUnion(uMem);
        union.update((Sketch)quick1);
        PreambleUtilTest.println(PreambleUtil.preambleToString((Memory)uMem));
    }

    @Test
    public void checkToStringWithPrelongsOf2() {
        int k;
        int u = k = 16;
        UpdateSketch quick1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            quick1.update((long)i);
        }
        byte[] bytes = quick1.compact().toByteArray();
        PreambleUtilTest.println(Sketch.toString((byte[])bytes));
    }

    @Test
    public void checkPreambleToStringExceptions() {
        byte[] byteArr = new byte[7];
        try {
            Sketch.toString((byte[])byteArr);
            Assert.fail((String)"Did not throw SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        byteArr = new byte[8];
        byteArr[0] = 2;
        try {
            Sketch.toString((Memory)Memory.wrap((byte[])byteArr));
            Assert.fail((String)"Did not throw SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSeedHashFromSeed() {
        Util.computeSeedHash((long)50541L);
    }

    @Test
    public void checkPreLongs() {
        UpdateSketch sketch = UpdateSketch.builder().setNominalEntries(16).build();
        CompactSketch comp = sketch.compact(false, null);
        byte[] byteArr = comp.toByteArray();
        PreambleUtilTest.println(Sketch.toString((byte[])byteArr));
        sketch.update(1L);
        comp = sketch.compact(false, null);
        byteArr = comp.toByteArray();
        PreambleUtilTest.println(Sketch.toString((byte[])byteArr));
        for (int i = 2; i <= 32; ++i) {
            sketch.update((long)i);
        }
        comp = sketch.compact(false, null);
        byteArr = comp.toByteArray();
        PreambleUtilTest.println(Sketch.toString((Memory)Memory.wrap((byte[])byteArr)));
    }

    @Test
    public void checkInsertsAndExtracts() {
        byte[] arr = new byte[32];
        WritableMemory mem = WritableMemory.wrap((byte[])arr);
        int v = 0;
        PreambleUtil.insertPreLongs((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((Memory)mem), (int)v);
        PreambleUtil.insertLgResizeFactor((WritableMemory)mem, (int)3);
        Assert.assertEquals((int)PreambleUtil.extractLgResizeFactor((Memory)mem), (int)3);
        PreambleUtil.insertSerVer((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractSerVer((Memory)mem), (int)v);
        PreambleUtil.insertFamilyID((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractFamilyID((Memory)mem), (int)v);
        PreambleUtil.insertLgNomLongs((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractLgNomLongs((Memory)mem), (int)v);
        PreambleUtil.insertLgArrLongs((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractLgArrLongs((Memory)mem), (int)v);
        PreambleUtil.insertFlags((WritableMemory)mem, (int)3);
        Assert.assertEquals((int)PreambleUtil.extractFlags((Memory)mem), (int)3);
        Assert.assertEquals((int)PreambleUtil.extractLgResizeRatioV1((Memory)mem), (int)3);
        PreambleUtil.insertSeedHash((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractSeedHash((Memory)mem), (int)v);
        Assert.assertEquals((int)PreambleUtil.extractFlagsV1((Memory)mem), (int)v);
        PreambleUtil.insertCurCount((WritableMemory)mem, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractCurCount((Memory)mem), (int)v);
        PreambleUtil.insertP((WritableMemory)mem, (float)1.0f);
        Assert.assertEquals((Object)Float.valueOf(PreambleUtil.extractP((Memory)mem)), (Object)Float.valueOf(1.0f));
        PreambleUtil.insertThetaLong((WritableMemory)mem, (long)(++v));
        Assert.assertEquals((long)PreambleUtil.extractThetaLong((Memory)mem), (long)v);
        PreambleUtil.insertUnionThetaLong((WritableMemory)mem, (long)(++v));
        Assert.assertEquals((long)PreambleUtil.extractUnionThetaLong((Memory)mem), (long)v);
        PreambleUtil.setEmpty((WritableMemory)mem);
        Assert.assertTrue((boolean)PreambleUtil.isEmpty((Memory)mem));
        PreambleUtil.clearEmpty((WritableMemory)mem);
        Assert.assertFalse((boolean)PreambleUtil.isEmpty((Memory)mem));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

