/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.theta.JaccardSimilarity;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JaccardSimilarityTest {
    @Test
    public void checkNullsEmpties() {
        int minK = 4096;
        double threshold = 0.95;
        JaccardSimilarityTest.println("Check nulls & empties, minK: " + minK + "\t Th: " + threshold);
        double[] jResults = JaccardSimilarity.jaccard(null, null);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println("null \t null:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual(null, null);
        Assert.assertFalse((boolean)state);
        UpdateSketch measured = UpdateSketch.builder().setNominalEntries(minK).build();
        UpdateSketch expected = UpdateSketch.builder().setNominalEntries(minK).build();
        jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println("empty\tempty:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)expected);
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)measured);
        Assert.assertTrue((boolean)state);
        expected.update(1L);
        jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println("empty\t    1:\t" + state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)expected);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkExactMode() {
        int k;
        int u = k = 4096;
        double threshold = 0.9999;
        JaccardSimilarityTest.println("Exact Mode, minK: " + k + "\t Th: " + threshold);
        UpdateSketch measured = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch expected = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u - 1; ++i) {
            measured.update((long)i);
            expected.update((long)i);
        }
        double[] jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)expected);
        Assert.assertTrue((boolean)state);
        measured.update((long)(u - 1));
        expected.update((long)u);
        jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)expected);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        int u = 0x100000;
        double threshold = 0.9999;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + k + "\t Th: " + threshold);
        UpdateSketch measured = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch expected = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            measured.update((long)i);
            expected.update((long)i);
        }
        double[] jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        boolean state = jResults[1] > threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)expected);
        Assert.assertTrue((boolean)state);
        for (int i = u; i < u + 50; ++i) {
            measured.update((long)i);
        }
        jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        state = jResults[1] >= threshold;
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertFalse((boolean)state);
        state = JaccardSimilarity.exactlyEqual((Sketch)measured, (Sketch)expected);
        Assert.assertFalse((boolean)state);
        JaccardSimilarityTest.println("");
    }

    @Test
    public void checkSimilarity() {
        int i;
        int minK = 4096;
        int u1 = 0x100000;
        int u2 = (int)((double)u1 * 0.95);
        double threshold = 0.943;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + minK + "\t Th: " + threshold);
        UpdateSketch expected = UpdateSketch.builder().setNominalEntries(minK).build();
        UpdateSketch measured = UpdateSketch.builder().setNominalEntries(minK).build();
        for (i = 0; i < u1; ++i) {
            expected.update((long)i);
        }
        for (i = 0; i < u2; ++i) {
            measured.update((long)i);
        }
        double[] jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        boolean state = JaccardSimilarity.similarityTest((Sketch)measured, (Sketch)expected, (double)threshold);
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
        Assert.assertTrue((boolean)state);
        state = JaccardSimilarity.similarityTest((Sketch)measured, (Sketch)measured, (double)threshold);
        Assert.assertTrue((boolean)state);
    }

    @Test
    public void checkDissimilarity() {
        int i;
        int minK = 4096;
        int u1 = 0x100000;
        int u2 = (int)((double)u1 * 0.05);
        double threshold = 0.061;
        JaccardSimilarityTest.println("Estimation Mode, minK: " + minK + "\t Th: " + threshold);
        UpdateSketch expected = UpdateSketch.builder().setNominalEntries(minK).build();
        UpdateSketch measured = UpdateSketch.builder().setNominalEntries(minK).build();
        for (i = 0; i < u1; ++i) {
            expected.update((long)i);
        }
        for (i = 0; i < u2; ++i) {
            measured.update((long)i);
        }
        double[] jResults = JaccardSimilarity.jaccard((Sketch)measured, (Sketch)expected);
        boolean state = JaccardSimilarity.dissimilarityTest((Sketch)measured, (Sketch)expected, (double)threshold);
        JaccardSimilarityTest.println(state + "\t" + JaccardSimilarityTest.jaccardString(jResults));
    }

    private static String jaccardString(double[] jResults) {
        double lb = jResults[0];
        double est = jResults[1];
        double ub = jResults[2];
        return lb + "\t" + est + "\t" + ub + "\t" + (lb / est - 1.0) + "\t" + (ub / est - 1.0);
    }

    @Test
    public void checkMinK() {
        UpdateSketch skA = UpdateSketch.builder().build();
        UpdateSketch skB = UpdateSketch.builder().build();
        skA.update(1L);
        skB.update(1L);
        double[] result = JaccardSimilarity.jaccard((Sketch)skA, (Sketch)skB);
        JaccardSimilarityTest.println(result[0] + ", " + result[1] + ", " + result[2]);
        for (int i = 1; i < 4096; ++i) {
            skA.update((long)i);
            skB.update((long)i);
        }
        result = JaccardSimilarity.jaccard((Sketch)skA, (Sketch)skB);
        JaccardSimilarityTest.println(result[0] + ", " + result[1] + ", " + result[2]);
    }

    @Test
    public void printlnTest() {
        JaccardSimilarityTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

