/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.IntersectionImpl;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapIntersectionTest {
    @Test
    public void checkExactIntersectionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < k / 2; ++i) {
            usk1.update((long)i);
        }
        for (i = k / 2; i < k; ++i) {
            usk2.update((long)i);
        }
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)usk1);
        inter.update((Sketch)usk2);
        boolean ordered = true;
        Assert.assertTrue((boolean)inter.hasResult());
        CompactSketch rsk1 = inter.getResult(!ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        rsk1 = inter.getResult(ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        boolean compact = true;
        int bytes = rsk1.getCurrentBytes(compact);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        rsk1 = inter.getResult(!ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        rsk1 = inter.getResult(ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)0.0);
        Assert.assertFalse((boolean)inter.isSameResource((Memory)mem));
    }

    @Test
    public void checkExactIntersectionFullOverlap() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < k; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < k; ++i) {
            usk2.update((long)i);
        }
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)usk1);
        inter.update((Sketch)usk2);
        boolean ordered = true;
        CompactSketch rsk1 = inter.getResult(!ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
        rsk1 = inter.getResult(ordered, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
        boolean compact = true;
        int bytes = rsk1.getCurrentBytes(compact);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        rsk1 = inter.getResult(!ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
        rsk1 = inter.getResult(ordered, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)k);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int i;
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < u; ++i) {
            usk1.update((long)i);
        }
        for (i = u / 2; i < u + u / 2; ++i) {
            usk2.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)csk1);
        inter.update((Sketch)csk2);
        CompactSketch rsk1 = inter.getResult(true, null);
        double result = rsk1.getEstimate();
        double sd2err = 4096.0 / Math.sqrt(k);
        Assert.assertEquals((double)result, (double)2048.0, (double)sd2err);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkNoCall() {
        Intersection inter = SetOperation.builder().buildIntersection();
        Assert.assertFalse((boolean)inter.hasResult());
        inter.getResult(false, null);
    }

    @Test
    public void check1stCall() {
        int lgK = 9;
        int k = 1 << lgK;
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update(null);
        CompactSketch rsk1 = inter.getResult(false, null);
        double est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        UpdateSketch sk = UpdateSketch.builder().setNominalEntries(k).build();
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk = UpdateSketch.builder().setNominalEntries(k).build();
        sk.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterNull() {
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update(null);
        inter.update(null);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        inter = SetOperation.builder().buildIntersection();
        inter.update(null);
        UpdateSketch sk = UpdateSketch.builder().build();
        inter.update((Sketch)sk);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        inter = SetOperation.builder().buildIntersection();
        inter.update(null);
        sk = UpdateSketch.builder().build();
        sk.update(1L);
        inter.update((Sketch)sk);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterEmpty() {
        UpdateSketch sk1 = UpdateSketch.builder().build();
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        inter.update(null);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterValid() {
        UpdateSketch sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        inter.update(null);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(2L);
        inter.update((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkEstimatingIntersect() {
        int i;
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < 2 * k; ++i) {
            sk1.update((long)i);
        }
        HeapIntersectionTest.println("sk1: " + sk1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < 2 * k; ++i) {
            sk2.update((long)i);
        }
        HeapIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.update((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > (double)k ? 1 : 0) != 0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkHeapifyAndWrap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < 2 * k; ++i) {
            sk1.update((long)i);
        }
        CompactSketch cSk1 = sk1.compact(true, null);
        double cSk1Est = cSk1.getEstimate();
        HeapIntersectionTest.println("cSk1Est: " + cSk1Est);
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.update((Sketch)cSk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < 2 * k; ++i) {
            sk2.update((long)i);
        }
        CompactSketch cSk2 = sk2.compact(true, null);
        double cSk2Est = cSk2.getEstimate();
        HeapIntersectionTest.println("cSk2Est: " + cSk2Est);
        Assert.assertEquals((double)cSk2Est, (double)cSk1Est, (double)0.0);
        inter.update((Sketch)cSk2);
        CompactSketch interResultCSk1 = inter.getResult(false, null);
        double inter1est = interResultCSk1.getEstimate();
        Assert.assertEquals((double)inter1est, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("Inter1Est: " + inter1est);
        byte[] byteArray = inter.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)mem);
        CompactSketch heapifiedSk = inter2.getResult(false, null);
        double heapifiedEst = heapifiedSk.getEstimate();
        Assert.assertEquals((double)heapifiedEst, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("HeapifiedEst: " + heapifiedEst);
        Intersection inter3 = Sketches.wrapIntersection((WritableMemory)mem);
        CompactSketch wrappedSk = inter3.getResult(false, null);
        double wrappedEst = wrappedSk.getEstimate();
        Assert.assertEquals((double)wrappedEst, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("WrappedEst: " + wrappedEst);
        inter.reset();
        inter2.reset();
        inter3.reset();
    }

    @Test
    public void checkHeapifyNullEmpty() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArray);
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)srcMem);
        inter1.update(null);
        byteArray = inter1.toByteArray();
        srcMem = Memory.wrap((byte[])byteArray);
        inter2 = (Intersection)SetOperation.heapify((Memory)srcMem);
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertTrue((boolean)comp.isEmpty());
    }

    @Test
    public void checkHeapifyNullEmpty2() {
        int lgK = 5;
        int k = 1 << lgK;
        Intersection inter1 = SetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArray);
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)srcMem);
        UpdateSketch sk1 = UpdateSketch.builder().setP(0.005f).setFamily(Family.QUICKSELECT).setNominalEntries(k).build();
        sk1.update(1L);
        inter1.update((Sketch)sk1);
        byteArray = inter1.toByteArray();
        srcMem = Memory.wrap((byte[])byteArray);
        inter2 = (Intersection)SetOperation.heapify((Memory)srcMem);
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(0L, (byte)2);
        SetOperation.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(1L, (byte)2);
        SetOperation.heapify((Memory)mem);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkFamilyID() {
        int k = 32;
        Union union = SetOperation.builder().setNominalEntries(k).buildUnion();
        byte[] byteArray = union.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        Intersection inter1 = (Intersection)SetOperation.heapify((Memory)mem);
        HeapIntersectionTest.println(inter1.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadEmptyState() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        inter1.update((Sketch)sk);
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putInt(8L, 1);
        SetOperation.heapify((Memory)mem);
    }

    @Test
    public void checkEmpty() {
        UpdateSketch usk = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.update((Sketch)usk);
        Assert.assertTrue((boolean)inter.isEmpty());
        Assert.assertEquals((int)inter.getRetainedEntries(true), (int)0);
        Assert.assertTrue((inter.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)inter.getThetaLong(), (long)Long.MAX_VALUE);
        long[] longArr = inter.getCache();
        Assert.assertEquals((int)longArr.length, (int)0);
    }

    @Test
    public void checkOne() {
        UpdateSketch usk = Sketches.updateSketchBuilder().build();
        usk.update(1L);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.update((Sketch)usk);
        Assert.assertFalse((boolean)inter.isEmpty());
        Assert.assertEquals((int)inter.getRetainedEntries(true), (int)1);
        Assert.assertTrue((inter.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)inter.getThetaLong(), (long)Long.MAX_VALUE);
        long[] longArr = inter.getCache();
        Assert.assertEquals((int)longArr.length, (int)32);
    }

    @Test
    public void checkGetResult() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.update((Sketch)sk);
        CompactSketch csk = inter.getResult();
        Assert.assertEquals((int)csk.getCurrentBytes(true), (int)8);
    }

    @Test
    public void checkFamily() {
        IntersectionImpl impl = IntersectionImpl.initNewHeapInstance((long)9001L);
        Assert.assertEquals((Object)impl.getFamily(), (Object)Family.INTERSECTION);
    }

    @Test
    public void checkPairIntersectSimple() {
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skB = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        CompactSketch csk = inter.intersect((Sketch)skA, (Sketch)skB);
        Assert.assertEquals((int)csk.getCurrentBytes(true), (int)8);
    }

    @Test
    public void printlnTest() {
        HeapIntersectionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

