/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HeapAnotB;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapAnotBTest {
    @Test
    public void checkExactAnotB_AvalidNoOverlap() {
        int i;
        int k = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (i = 0; i < k / 2; ++i) {
            usk1.update((long)i);
        }
        for (i = k / 2; i < k; ++i) {
            usk2.update((long)i);
        }
        AnotB aNb = SetOperation.builder().buildANotB();
        Assert.assertTrue((boolean)aNb.isEmpty());
        Assert.assertNull((Object)aNb.getCache());
        Assert.assertEquals((long)aNb.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((short)aNb.getSeedHash(), (short)Util.computeSeedHash((long)9001L));
        aNb.update((Sketch)usk1, (Sketch)usk2);
        Assert.assertEquals((int)aNb.getRetainedEntries(true), (int)256);
        CompactSketch rsk1 = aNb.getResult(false, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)((double)k / 2.0));
        aNb.update((Sketch)usk1, (Sketch)usk2);
        rsk1 = aNb.getResult(true, null);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)((double)k / 2.0));
        int bytes = rsk1.getCurrentBytes(true);
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        aNb.update((Sketch)usk1, (Sketch)usk2);
        rsk1 = aNb.getResult(false, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)((double)k / 2.0));
        aNb.update((Sketch)usk1, (Sketch)usk2);
        rsk1 = aNb.getResult(true, mem);
        Assert.assertEquals((Object)rsk1.getEstimate(), (Object)((double)k / 2.0));
    }

    @Test
    public void checkCombinations() {
        int k = 512;
        Sketch aNull = null;
        Sketch bNull = null;
        UpdateSketch aEmpty = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch bEmpty = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch aHT = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            aHT.update((long)i);
        }
        CompactSketch aC = aHT.compact(false, null);
        CompactSketch aO = aHT.compact(true, null);
        UpdateSketch bHT = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = k / 2; i < k + k / 2; ++i) {
            bHT.update((long)i);
        }
        CompactSketch bC = bHT.compact(false, null);
        CompactSketch bO = bHT.compact(true, null);
        boolean ordered = true;
        AnotB aNb = SetOperation.builder().buildANotB();
        aNb.update(aNull, bNull);
        CompactSketch res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update(aNull, (Sketch)bEmpty);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update(aNull, (Sketch)bC);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update(aNull, (Sketch)bO);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update(aNull, (Sketch)bHT);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aEmpty, bNull);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aEmpty, (Sketch)bEmpty);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aEmpty, (Sketch)bC);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aEmpty, (Sketch)bO);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aEmpty, (Sketch)bHT);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)0.0);
        Assert.assertTrue((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aC, bNull);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)k);
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aC, (Sketch)bEmpty);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)k);
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aC, (Sketch)bC);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aC, (Sketch)bO);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aC, (Sketch)bHT);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aO, bNull);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)k);
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aO, (Sketch)bEmpty);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)k);
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aO, (Sketch)bC);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aO, (Sketch)bO);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aO, (Sketch)bHT);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aHT, bNull);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)k);
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aHT, (Sketch)bEmpty);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)k);
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aHT, (Sketch)bC);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aHT, (Sketch)bO);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
        aNb.update((Sketch)aHT, (Sketch)bHT);
        res = aNb.getResult(!ordered, null);
        Assert.assertEquals((Object)res.getEstimate(), (Object)((double)k / 2.0));
        Assert.assertFalse((boolean)res.isEmpty());
        Assert.assertEquals((long)res.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkAnotBnotC() {
        int k = 1024;
        boolean ordered = true;
        UpdateSketch aU = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            aU.update((long)i);
        }
        UpdateSketch bU = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k / 2; ++i) {
            bU.update((long)i);
        }
        UpdateSketch cU = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = k / 2; i < 3 * k / 4; ++i) {
            cU.update((long)i);
        }
        int memBytes = Sketch.getMaxUpdateSketchBytes((int)k);
        byte[] memArr1 = new byte[memBytes];
        byte[] memArr2 = new byte[memBytes];
        WritableMemory mem1 = WritableMemory.wrap((byte[])memArr1);
        WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
        AnotB aNb = SetOperation.builder().buildANotB();
        aNb.update((Sketch)aU, (Sketch)bU);
        CompactSketch r1 = aNb.getResult(ordered, mem1);
        aNb.update((Sketch)r1, (Sketch)cU);
        CompactSketch r2 = aNb.getResult(ordered, mem2);
        double est = r2.getEstimate();
        HeapAnotBTest.println("est: " + est);
        Assert.assertEquals((double)est, (double)((double)k / 4.0), (double)0.0);
    }

    @Test
    public void checkAnotBnotC_sameMemory() {
        int k = 1024;
        boolean ordered = true;
        UpdateSketch a = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            a.update((long)i);
        }
        UpdateSketch b = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k / 2; ++i) {
            b.update((long)i);
        }
        UpdateSketch c = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = k / 2; i < 3 * k / 4; ++i) {
            c.update((long)i);
        }
        int memBytes = Sketch.getMaxCompactSketchBytes((int)a.getCurrentBytes(true));
        byte[] memArr = new byte[memBytes];
        WritableMemory mem = WritableMemory.wrap((byte[])memArr);
        AnotB aNb = SetOperation.builder().buildANotB();
        aNb.update((Sketch)a, (Sketch)b);
        CompactSketch r = aNb.getResult(ordered, mem);
        aNb.update((Sketch)r, (Sketch)c);
        r = aNb.getResult(ordered, mem);
        double est = r.getEstimate();
        HeapAnotBTest.println("est: " + est);
        Assert.assertEquals((double)est, (double)((double)k / 4.0), (double)0.0);
    }

    @Test
    public void checkAnotBsimple() {
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skB = Sketches.updateSketchBuilder().build();
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch csk = aNotB.aNotB((Sketch)skA, (Sketch)skB);
        Assert.assertEquals((int)csk.getCurrentBytes(true), (int)8);
    }

    @Test
    public void checkGetResult() {
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skB = Sketches.updateSketchBuilder().build();
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        aNotB.update((Sketch)skA, (Sketch)skB);
        CompactSketch csk = aNotB.getResult();
        Assert.assertEquals((int)csk.getCurrentBytes(true), (int)8);
    }

    @Test
    public void checkGetFamily() {
        HeapAnotB anotb = new HeapAnotB(9001L);
        Assert.assertEquals((Object)anotb.getFamily(), (Object)Family.A_NOT_B);
    }

    @Test
    public void printlnTest() {
        HeapAnotBTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

