/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactOrderedSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ForwardCompatibilityTest {
    @Test
    public void checkSerVer1_Empty() {
        EmptyCompactSketch csk = EmptyCompactSketch.getInstance();
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer1((CompactSketch)csk);
        Sketch sketch = Sketch.heapify((Memory)srcMem);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof EmptyCompactSketch));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSerVer1_badPrelongs() {
        EmptyCompactSketch csk = EmptyCompactSketch.getInstance();
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer1((CompactSketch)csk);
        WritableMemory srcMemW = (WritableMemory)srcMem;
        srcMemW.putByte(0L, (byte)1);
        Sketch.heapify((Memory)srcMemW);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSerVer1_tooSmall() {
        UpdateSketch usk = Sketches.updateSketchBuilder().build();
        usk.update(1L);
        usk.update(2L);
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        Memory srcMem2 = srcMem.region(0L, srcMem.getCapacity() - 8L);
        Sketch.heapify((Memory)srcMem2);
    }

    @Test
    public void checkSerVer1_1Value() {
        UpdateSketch usk = Sketches.updateSketchBuilder().build();
        usk.update(1L);
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        Sketch sketch = Sketch.heapify((Memory)srcMem);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertEquals((Object)sketch.getEstimate(), (Object)1.0);
        Assert.assertTrue((boolean)(sketch instanceof SingleItemSketch));
    }

    @Test
    public void checkSerVer2_1PreLong_Empty() {
        EmptyCompactSketch csk = EmptyCompactSketch.getInstance();
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer2((CompactSketch)csk, 9001L);
        Sketch sketch = Sketch.heapify((Memory)srcMem);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof EmptyCompactSketch));
    }

    @Test
    public void checkSerVer2_2PreLongs_Empty() {
        UpdateSketch usk = Sketches.updateSketchBuilder().setLogNominalEntries(4).build();
        for (int i = 0; i < 2; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        WritableMemory srcMemW = WritableMemory.allocate((int)16);
        srcMem.copyTo(0L, srcMemW, 0L, 16L);
        PreambleUtil.setEmpty((WritableMemory)srcMemW);
        Assert.assertTrue((boolean)PreambleUtil.isEmpty((Memory)srcMemW));
        srcMemW.putInt(8L, 0);
        Sketch sketch = Sketch.heapify((Memory)srcMemW);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof EmptyCompactSketch));
    }

    @Test
    public void checkSerVer2_3PreLongs_Empty() {
        UpdateSketch usk = Sketches.updateSketchBuilder().setLogNominalEntries(4).build();
        for (int i = 0; i < 32; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        WritableMemory srcMemW = WritableMemory.allocate((int)24);
        srcMem.copyTo(0L, srcMemW, 0L, 24L);
        PreambleUtil.setEmpty((WritableMemory)srcMemW);
        Assert.assertTrue((boolean)PreambleUtil.isEmpty((Memory)srcMemW));
        srcMemW.putInt(8L, 0);
        srcMemW.putLong(16L, Long.MAX_VALUE);
        Sketch sketch = Sketch.heapify((Memory)srcMemW);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof EmptyCompactSketch));
    }

    @Test
    public void checkSerVer2_2PreLongs_1Value() {
        UpdateSketch usk = Sketches.updateSketchBuilder().setLogNominalEntries(4).build();
        usk.update(1L);
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        Sketch sketch = Sketch.heapify((Memory)srcMem);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof SingleItemSketch));
    }

    @Test
    public void checkSerVer2_3PreLongs_1Value() {
        UpdateSketch usk = Sketches.updateSketchBuilder().setLogNominalEntries(4).build();
        for (int i = 0; i < 32; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        WritableMemory srcMemW = WritableMemory.allocate((int)32);
        srcMem.copyTo(0L, srcMemW, 0L, 32L);
        srcMemW.putInt(8L, 1);
        srcMemW.putLong(16L, Long.MAX_VALUE);
        long[] cache = csk.getCache();
        srcMemW.putLong(24L, cache[0]);
        Sketch sketch = Sketch.heapify((Memory)srcMemW);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof SingleItemSketch));
    }

    @Test
    public void checkSerVer2_3PreLongs_1Value_ThLessthan1() {
        UpdateSketch usk = Sketches.updateSketchBuilder().setLogNominalEntries(4).build();
        for (int i = 0; i < 32; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact(true, null);
        Memory srcMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        WritableMemory srcMemW = WritableMemory.allocate((int)32);
        srcMem.copyTo(0L, srcMemW, 0L, 32L);
        srcMemW.putInt(8L, 1);
        long[] cache = csk.getCache();
        srcMemW.putLong(24L, cache[0]);
        Sketch sketch = Sketch.heapify((Memory)srcMemW);
        Assert.assertEquals((boolean)sketch.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isEstimationMode(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isDirect(), (boolean)false);
        Assert.assertEquals((boolean)sketch.hasMemory(), (boolean)false);
        Assert.assertEquals((boolean)sketch.isCompact(), (boolean)true);
        Assert.assertEquals((boolean)sketch.isOrdered(), (boolean)true);
        Assert.assertTrue((boolean)(sketch instanceof HeapCompactOrderedSketch));
    }

    @Test
    public void printlnTest() {
        ForwardCompatibilityTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

