/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableDirectHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.ConcurrentDirectQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConcurrentDirectQuickSelectSketchTest {
    private int lgK;
    private volatile UpdateSketch shared;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            for (int i = 0; i < k; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            Assert.assertFalse((boolean)local.isEmpty());
            Assert.assertEquals((double)local.getEstimate(), (double)k, (double)0.0);
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
            mem.putByte(1L, (byte)0);
            Sketch.wrap((Memory)mem);
        }
    }

    @Test
    public void checkDirectCompactConversion() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            this.buildSharedReturnLocalSketch(mem);
            Assert.assertTrue((boolean)(this.shared instanceof ConcurrentDirectQuickSelectSketch));
            Assert.assertTrue((boolean)this.shared.compact().isCompact());
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorKtooSmall() {
        this.lgK = 3;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            this.buildSharedReturnLocalSketch(mem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorMemTooSmall() {
        this.lgK = 4;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k / 2);){
            WritableMemory mem = h.get();
            this.buildSharedReturnLocalSketch(mem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyIllegalFamilyID_heapify() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int bytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[bytes]);
        this.buildSharedReturnLocalSketch(mem);
        mem.putByte(2L, (byte)0);
        Sketch.heapify((Memory)mem);
    }

    @Test
    public void checkHeapifyMemoryEstimating() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int u = 2 * k;
        boolean estimating = u > k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double sk1est = local.getEstimate();
            double sk1lb = local.getLowerBound(2);
            double sk1ub = local.getUpperBound(2);
            Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
            int curCount1 = this.shared.getRetainedEntries(true);
            Assert.assertTrue((boolean)local.isDirect());
            Assert.assertTrue((boolean)local.hasMemory());
            Assert.assertEquals((int)local.getCurrentPreambleLongs(false), (int)3);
            UpdateSketch sharedHeap = Sketches.heapifyUpdateSketch((Memory)mem);
            Assert.assertEquals((Object)sharedHeap.getEstimate(), (Object)sk1est);
            Assert.assertEquals((Object)sharedHeap.getLowerBound(2), (Object)sk1lb);
            Assert.assertEquals((Object)sharedHeap.getUpperBound(2), (Object)sk1ub);
            Assert.assertFalse((boolean)sharedHeap.isEmpty());
            Assert.assertEquals((boolean)sharedHeap.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)sharedHeap.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
            int curCount2 = sharedHeap.getRetainedEntries(true);
            long[] cache = sharedHeap.getCache();
            Assert.assertEquals((int)curCount1, (int)curCount2);
            long thetaLong = sharedHeap.getThetaLong();
            int cacheCount = HashOperations.count((long[])cache, (long)thetaLong);
            Assert.assertEquals((int)curCount1, (int)cacheCount);
            Assert.assertFalse((boolean)sharedHeap.isDirect());
            Assert.assertFalse((boolean)sharedHeap.hasMemory());
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_wrap() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[maxBytes]);
        this.buildSharedReturnLocalSketch(mem);
        mem.putByte(2L, (byte)0);
        Sketch.wrap((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWrapIllegalFamilyID_direct() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[maxBytes]);
        this.buildSharedReturnLocalSketch(mem);
        mem.putByte(2L, (byte)0);
        DirectQuickSelectSketch.writableWrap((WritableMemory)mem, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        long seed1 = 1021L;
        long seed2 = 9001L;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder().setSeed(seed1);
            this.shared = bldr.buildShared(mem);
            byte[] serArr = this.shared.toByteArray();
            Memory srcMem = Memory.wrap((byte[])serArr);
            Sketch.heapify((Memory)srcMem, (long)seed2);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkCorruptLgNomLongs() {
        this.lgK = 4;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            this.buildSharedReturnLocalSketch(mem);
            mem.putByte(3L, (byte)2);
            Sketch.heapify((Memory)mem, (long)9001L);
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkIllegalHashUpdate() {
        this.lgK = 4;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            this.buildSharedReturnLocalSketch(h.get());
            this.shared.hashUpdate(1L);
        }
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            UpdateSketch local = this.buildSharedReturnLocalSketch(mem);
            for (int i = 0; i < k; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            byte[] serArr = this.shared.toByteArray();
            Memory srcMem = Memory.wrap((byte[])serArr);
            Sketch recoveredShared = Sketch.heapify((Memory)srcMem);
            int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
            WritableMemory wmem = WritableMemory.allocate((int)bytes);
            this.shared = bldr.buildSharedFromSketch((UpdateSketch)recoveredShared, wmem);
            UpdateSketch local2 = bldr.buildLocal(this.shared);
            Assert.assertEquals((double)local2.getEstimate(), (double)k, (double)0.0);
            Assert.assertEquals((double)local2.getLowerBound(2), (double)k, (double)0.0);
            Assert.assertEquals((double)local2.getUpperBound(2), (double)k, (double)0.0);
            Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)false);
            Assert.assertEquals((String)recoveredShared.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
            local2.toString(true, true, 8, true);
        }
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        this.lgK = 12;
        int k = 1 << this.lgK;
        int u = 2 * k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            UpdateSketch local = this.buildSharedReturnLocalSketch(mem);
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double uskEst = local.getEstimate();
            double uskLB = local.getLowerBound(2);
            double uskUB = local.getUpperBound(2);
            Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)true);
            byte[] serArr = this.shared.toByteArray();
            Memory srcMem = Memory.wrap((byte[])serArr);
            Sketch recoveredShared = Sketch.heapify((Memory)srcMem);
            int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
            WritableMemory wmem = WritableMemory.allocate((int)bytes);
            this.shared = bldr.buildSharedFromSketch((UpdateSketch)recoveredShared, wmem);
            UpdateSketch local2 = bldr.buildLocal(this.shared);
            Assert.assertEquals((Object)local2.getEstimate(), (Object)uskEst);
            Assert.assertEquals((Object)local2.getLowerBound(2), (Object)uskLB);
            Assert.assertEquals((Object)local2.getUpperBound(2), (Object)uskUB);
            Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)true);
            Assert.assertEquals((String)recoveredShared.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        }
    }

    @Test
    public void checkWrapMemoryEst() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int u = 2 * k;
        boolean estimating = u > k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch local = this.buildSharedReturnLocalSketch(mem);
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double sk1est = local.getEstimate();
            double sk1lb = local.getLowerBound(2);
            double sk1ub = local.getUpperBound(2);
            Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
            Sketch local2 = Sketch.wrap((Memory)mem);
            Assert.assertEquals((Object)local2.getEstimate(), (Object)sk1est);
            Assert.assertEquals((Object)local2.getLowerBound(2), (Object)sk1lb);
            Assert.assertEquals((Object)local2.getUpperBound(2), (Object)sk1ub);
            Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
            Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)estimating);
        }
    }

    @Test
    public void checkDQStoCompactForms() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int u = 4 * k;
        boolean estimating = u > k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
            Assert.assertTrue((boolean)local.isDirect());
            Assert.assertTrue((boolean)local.hasMemory());
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            this.shared.rebuild();
            double localEst = local.getEstimate();
            double localLB = local.getLowerBound(2);
            double localUB = local.getUpperBound(2);
            Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
            CompactSketch csk = this.shared.compact(false, null);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)localEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)localLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)localUB);
            Assert.assertFalse((boolean)csk.isEmpty());
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactUnorderedSketch");
            csk = this.shared.compact(true, null);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)localEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)localLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)localUB);
            Assert.assertFalse((boolean)csk.isEmpty());
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"HeapCompactOrderedSketch");
            int bytes = local.getCurrentBytes(true);
            Assert.assertEquals((int)bytes, (int)(k * 8 + (Family.COMPACT.getMaxPreLongs() << 3)));
            byte[] memArr2 = new byte[bytes];
            WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
            csk = this.shared.compact(false, mem2);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)localEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)localLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)localUB);
            Assert.assertFalse((boolean)csk.isEmpty());
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactUnorderedSketch");
            mem2.clear();
            csk = this.shared.compact(true, mem2);
            Assert.assertEquals((Object)csk.getEstimate(), (Object)localEst);
            Assert.assertEquals((Object)csk.getLowerBound(2), (Object)localLB);
            Assert.assertEquals((Object)csk.getUpperBound(2), (Object)localUB);
            Assert.assertFalse((boolean)csk.isEmpty());
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)estimating);
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)"DirectCompactOrderedSketch");
            csk.toString(false, true, 0, false);
        }
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            local.toString(false, true, 0, false);
            Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
            double localEst = local.getEstimate();
            double localLB = local.getLowerBound(2);
            double localUB = local.getUpperBound(2);
            Assert.assertFalse((boolean)local.isEstimationMode());
            int bytes = local.getCurrentBytes(true);
            Assert.assertEquals((int)bytes, (int)8);
            byte[] memArr2 = new byte[bytes];
            WritableMemory mem2 = WritableMemory.wrap((byte[])memArr2);
            CompactSketch csk2 = this.shared.compact(false, mem2);
            Assert.assertEquals((Object)csk2.getEstimate(), (Object)localEst);
            Assert.assertEquals((Object)csk2.getLowerBound(2), (Object)localLB);
            Assert.assertEquals((Object)csk2.getUpperBound(2), (Object)localUB);
            Assert.assertTrue((boolean)csk2.isEmpty());
            Assert.assertFalse((boolean)csk2.isEstimationMode());
            Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
            CompactSketch csk3 = this.shared.compact(true, mem2);
            csk3.toString(false, true, 0, false);
            csk3.toString();
            Assert.assertEquals((Object)csk3.getEstimate(), (Object)localEst);
            Assert.assertEquals((Object)csk3.getLowerBound(2), (Object)localLB);
            Assert.assertEquals((Object)csk3.getUpperBound(2), (Object)localUB);
            Assert.assertTrue((boolean)csk3.isEmpty());
            Assert.assertFalse((boolean)csk3.isEstimationMode());
            Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
        }
    }

    @Test
    public void checkEstMode() {
        this.lgK = 12;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            int u = 3 * k;
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            Assert.assertTrue((this.shared.getRetainedEntries(false) > k ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkErrorBounds() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch local = this.buildSharedReturnLocalSketch(mem);
            for (int i = 0; i < k; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double est = local.getEstimate();
            double lb = local.getLowerBound(2);
            double ub = local.getUpperBound(2);
            Assert.assertEquals((double)est, (double)ub, (double)0.0);
            Assert.assertEquals((double)est, (double)lb, (double)0.0);
            int u = 100 * k;
            for (int i = k; i < u; ++i) {
                local.update((long)i);
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            est = local.getEstimate();
            lb = local.getLowerBound(2);
            ub = local.getUpperBound(2);
            Assert.assertTrue((est <= ub ? 1 : 0) != 0);
            Assert.assertTrue((est >= lb ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkUpperAndLowerBounds() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int u = 2 * k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketch local = this.buildSharedReturnLocalSketch(mem);
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double est = local.getEstimate();
            double ub = local.getUpperBound(1);
            double lb = local.getLowerBound(1);
            Assert.assertTrue((ub > est ? 1 : 0) != 0);
            Assert.assertTrue((lb < est ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkRebuild() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        int u = 4 * k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            Assert.assertFalse((boolean)local.isEmpty());
            Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((this.shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
            this.shared.rebuild();
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
            Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
            local.rebuild();
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
            Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
        }
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        this.lgK = 9;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            int u = 4 * k;
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            Assert.assertFalse((boolean)local.isEmpty());
            Assert.assertTrue((this.shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
            Assert.assertTrue((local.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
            this.shared.reset();
            local.reset();
            Assert.assertTrue((boolean)local.isEmpty());
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)0);
            Assert.assertEquals((double)local.getEstimate(), (double)0.0, (double)0.0);
            Assert.assertEquals((long)local.getThetaLong(), (long)Long.MAX_VALUE);
        }
    }

    @Test
    public void checkExactModeMemoryArr() {
        int k;
        this.lgK = 12;
        int u = k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)u);
        }
    }

    @Test
    public void checkEstModeMemoryArr() {
        this.lgK = 12;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            int u = 3 * k;
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double est = local.getEstimate();
            Assert.assertTrue((est < (double)u * 1.05 && est > (double)u * 0.95 ? 1 : 0) != 0);
            Assert.assertTrue((this.shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkEstModeNativeMemory() {
        this.lgK = 12;
        int k = 1 << this.lgK;
        int memCapacity = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        try (WritableDirectHandle memHandler = WritableMemory.allocateDirect((long)memCapacity);){
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(memHandler.get());
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            int u = 3 * k;
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double est = local.getEstimate();
            Assert.assertTrue((est < (double)u * 1.05 && est > (double)u * 0.95 ? 1 : 0) != 0);
            Assert.assertTrue((this.shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkConstructReconstructFromMemory() {
        this.lgK = 12;
        int k = 1 << this.lgK;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(h.get());
            UpdateSketch local = bldr.buildLocal(this.shared);
            Assert.assertTrue((boolean)local.isEmpty());
            int u = 3 * k;
            for (int i = 0; i < u; ++i) {
                local.update((long)i);
            }
            this.waitForBgPropagationToComplete();
            double est1 = local.getEstimate();
            int count1 = this.shared.getRetainedEntries(false);
            Assert.assertTrue((est1 < (double)u * 1.05 && est1 > (double)u * 0.95 ? 1 : 0) != 0);
            Assert.assertTrue((count1 >= k ? 1 : 0) != 0);
            byte[] serArr = this.shared.toByteArray();
            WritableMemory mem = WritableMemory.wrap((byte[])serArr);
            UpdateSketch recoveredShared = Sketches.wrapUpdateSketch((WritableMemory)mem);
            int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
            WritableMemory wmem = WritableMemory.allocate((int)bytes);
            this.shared = bldr.buildSharedFromSketch(recoveredShared, wmem);
            UpdateSketch local2 = bldr.buildLocal(this.shared);
            double est2 = local2.getEstimate();
            Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        }
    }

    @Test
    public void checkNullMemory() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        UpdateSketch sk = bldr.build();
        for (int i = 0; i < 1000; ++i) {
            sk.update((long)i);
        }
        UpdateSketch shared = bldr.buildSharedFromSketch(sk, null);
        Assert.assertEquals((int)shared.getRetainedEntries(), (int)1000);
        Assert.assertFalse((boolean)shared.hasMemory());
    }

    @Test
    public void checkResizeInBigMem() {
        this.lgK = 14;
        int k = 1 << this.lgK;
        int u = 0x100000;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[8 * k * 16 + 24]);
        UpdateSketch local = this.buildSharedReturnLocalSketch(mem);
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadLgNomLongs() {
        int k = 16;
        this.lgK = 4;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[k * 16 + 24]);
        this.buildSharedReturnLocalSketch(mem);
        mem.putByte(3L, (byte)3);
        DirectQuickSelectSketch.writableWrap((WritableMemory)mem, (long)9001L);
    }

    @Test
    public void checkBackgroundPropagation() {
        this.lgK = 4;
        int k = 1 << this.lgK;
        int u = 10 * k;
        try (WritableDirectHandle h = ConcurrentDirectQuickSelectSketchTest.makeNativeMemory(k);){
            int i;
            WritableMemory mem = h.get();
            UpdateSketchBuilder bldr = this.configureBuilder();
            this.shared = bldr.buildShared(mem);
            UpdateSketch local = bldr.buildLocal(this.shared);
            ConcurrentHeapThetaBuffer sk1 = (ConcurrentHeapThetaBuffer)local;
            Assert.assertTrue((boolean)local.isEmpty());
            for (i = 0; i < k; ++i) {
                local.update((long)i);
            }
            Assert.assertFalse((boolean)local.isEmpty());
            Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
            long theta1 = ((ConcurrentSharedThetaSketch)this.shared).getVolatileTheta();
            while (i < u) {
                local.update((long)i);
                ++i;
            }
            this.waitForBgPropagationToComplete();
            long theta2 = ((ConcurrentSharedThetaSketch)this.shared).getVolatileTheta();
            int entries = this.shared.getRetainedEntries(false);
            Assert.assertTrue((entries > k || theta2 < theta1 ? 1 : 0) != 0, (String)("entries=" + entries + " k=" + k + " theta1=" + theta1 + " theta2=" + theta2));
            this.shared.rebuild();
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
            Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
            sk1.rebuild();
            Assert.assertEquals((int)this.shared.getRetainedEntries(false), (int)k);
            Assert.assertEquals((int)this.shared.getRetainedEntries(true), (int)k);
        }
    }

    @Test
    public void printlnTest() {
        ConcurrentDirectQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static final int getMaxBytes(int k) {
        return (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
    }

    private static WritableDirectHandle makeNativeMemory(int k) {
        return WritableMemory.allocateDirect((long)ConcurrentDirectQuickSelectSketchTest.getMaxBytes(k));
    }

    private UpdateSketch buildSharedReturnLocalSketch(WritableMemory mem) {
        UpdateSketchBuilder bldr = this.configureBuilder();
        this.shared = bldr.buildShared(mem);
        return bldr.buildLocal(this.shared);
    }

    private UpdateSketchBuilder configureBuilder() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        bldr.setLogNominalEntries(this.lgK);
        bldr.setLocalLogNominalEntries(this.lgK);
        bldr.setSeed(9001L);
        return bldr;
    }

    private void waitForBgPropagationToComplete() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((ConcurrentSharedThetaSketch)this.shared).awaitBgPropagationTermination();
        ConcurrentPropagationService.resetExecutorService((long)Thread.currentThread().getId());
        ((ConcurrentSharedThetaSketch)this.shared).initBgPropagationService();
    }
}

