/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableDirectHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactOrderedSketch;
import org.apache.datasketches.theta.DirectCompactUnorderedSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactOrderedSketch;
import org.apache.datasketches.theta.HeapCompactUnorderedSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompactSketchTest {
    @Test
    public void checkHeapifyWrap() {
        int k = 4096;
        boolean ordered = true;
        this.checkHeapifyWrap(k, 0, true);
        this.checkHeapifyWrap(k, 1, true);
        this.checkHeapifyWrap(k, 1, false);
        this.checkHeapifyWrap(k, k, true);
        this.checkHeapifyWrap(k, k, false);
        this.checkHeapifyWrap(k, 4 * k, true);
        this.checkHeapifyWrap(k, 4 * k, false);
    }

    public void checkHeapifyWrap(int k, int u, boolean ordered) {
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        CompactSketch refSk = usk.compact(ordered, null);
        byte[] barr = refSk.toByteArray();
        Memory srcMem = Memory.wrap((byte[])barr);
        CompactSketch testSk = (CompactSketch)Sketch.heapify((Memory)srcMem);
        CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
        byte[] byteArray = refSk.toByteArray();
        Memory heapROMem = Memory.wrap((byte[])byteArray);
        testSk = (CompactSketch)Sketch.heapify((Memory)heapROMem);
        CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
        int bytes = usk.getCurrentBytes(true);
        try (WritableDirectHandle wdh = WritableMemory.allocateDirect((long)bytes);){
            WritableMemory directMem = wdh.get();
            refSk = usk.compact(ordered, directMem);
            testSk = (CompactSketch)Sketch.wrap((Memory)directMem);
            CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
            testSk = (CompactSketch)Sketch.wrap((Memory)directMem);
            CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
        }
    }

    private static void checkByRange(Sketch refSk, Sketch testSk, int u, boolean ordered) {
        if (u == 0) {
            CompactSketchTest.checkEmptySketch(testSk);
        } else if (u == 1) {
            CompactSketchTest.checkSingleItemSketch(testSk, refSk);
        } else {
            CompactSketchTest.checkOtherCompactSketch(testSk, refSk, ordered);
        }
    }

    private static void checkEmptySketch(Sketch testSk) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertTrue((boolean)(testSk instanceof EmptyCompactSketch));
        Assert.assertTrue((boolean)testSk.isEmpty());
        Assert.assertTrue((boolean)testSk.isOrdered());
        Assert.assertNull((Object)testSk.getMemory());
        Assert.assertFalse((boolean)testSk.isDirect());
        Assert.assertFalse((boolean)testSk.hasMemory());
        Assert.assertEquals((int)testSk.getSeedHash(), (int)0);
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((double)testSk.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(true), (int)8);
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)8);
        Assert.assertEquals((int)testSk.getCache().length, (int)0);
        Assert.assertEquals((int)testSk.getCurrentPreambleLongs(true), (int)1);
    }

    private static void checkSingleItemSketch(Sketch testSk, Sketch refSk) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertTrue((boolean)(testSk instanceof SingleItemSketch));
        Assert.assertFalse((boolean)testSk.isEmpty());
        Assert.assertTrue((boolean)testSk.isOrdered());
        Assert.assertNull((Object)testSk.getMemory());
        Assert.assertFalse((boolean)testSk.isDirect());
        Assert.assertFalse((boolean)testSk.hasMemory());
        Assert.assertEquals((short)testSk.getSeedHash(), (short)refSk.getSeedHash());
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)1);
        Assert.assertEquals((double)testSk.getEstimate(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(true), (int)16);
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)16);
        Assert.assertEquals((int)testSk.getCache().length, (int)1);
        Assert.assertEquals((int)testSk.getCurrentPreambleLongs(true), (int)1);
    }

    private static void checkOtherCompactSketch(Sketch testSk, Sketch refSk, boolean ordered) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertFalse((boolean)testSk.isEmpty());
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((boolean)testSk.isOrdered(), (boolean)ordered);
        if (refSk.hasMemory()) {
            Assert.assertTrue((boolean)testSk.hasMemory());
            Assert.assertNotNull((Object)testSk.getMemory());
            if (ordered) {
                Assert.assertTrue((boolean)(testSk instanceof DirectCompactOrderedSketch));
            } else {
                Assert.assertTrue((boolean)(testSk instanceof DirectCompactUnorderedSketch));
            }
            if (refSk.isDirect()) {
                Assert.assertTrue((boolean)testSk.isDirect());
            } else {
                Assert.assertFalse((boolean)testSk.isDirect());
            }
        } else {
            Assert.assertFalse((boolean)testSk.hasMemory());
            if (ordered) {
                Assert.assertTrue((boolean)(testSk instanceof HeapCompactOrderedSketch));
            } else {
                Assert.assertTrue((boolean)(testSk instanceof HeapCompactUnorderedSketch));
            }
        }
        Assert.assertEquals((short)testSk.getSeedHash(), (short)refSk.getSeedHash());
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)refSk.getRetainedEntries());
        Assert.assertEquals((double)testSk.getEstimate(), (double)refSk.getEstimate(), (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(true), (int)refSk.getCurrentBytes(true));
        Assert.assertEquals((int)testSk.toByteArray().length, (int)refSk.toByteArray().length);
        Assert.assertEquals((int)testSk.getCache().length, (int)refSk.getCache().length);
        Assert.assertEquals((int)testSk.getCurrentPreambleLongs(true), (int)refSk.getCurrentPreambleLongs(true));
    }

    @Test
    public void checkDirectSingleItemSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        int bytes = sk.getCurrentBytes(true);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        sk.compact(true, wmem);
        Sketch csk2 = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(csk2 instanceof SingleItemSketch));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmall() {
        int k;
        int u = k = 512;
        boolean compact = true;
        boolean ordered = false;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCurrentBytes(compact);
        byte[] byteArray = new byte[bytes - 8];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        usk.compact(ordered, mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmallOrdered() {
        int k;
        int u = k = 512;
        boolean compact = true;
        boolean ordered = true;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCurrentBytes(compact);
        byte[] byteArray = new byte[bytes - 8];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        usk.compact(ordered, mem);
    }

    @Test
    public void checkCompactCachePart() {
        long[] result = CompactSketch.compactCachePart(null, (int)4, (int)0, (long)0L, (boolean)false);
        Assert.assertEquals((int)result.length, (int)0);
    }

    @Test
    public void checkDirectCompactSingleItemSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        CompactSketch csk = sk.compact(true, WritableMemory.allocate((int)16));
        int bytes = csk.getCurrentBytes(true);
        Assert.assertEquals((int)bytes, (int)8);
        sk.update(1L);
        csk = sk.compact(true, WritableMemory.allocate((int)16));
        bytes = csk.getCurrentBytes(true);
        Assert.assertEquals((int)bytes, (int)16);
        Assert.assertTrue((csk == csk.compact() ? 1 : 0) != 0);
        Assert.assertTrue((csk == csk.compact(true, null) ? 1 : 0) != 0);
    }

    @Test
    public void checkHeapifySingleItemSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        int bytes = Sketches.getMaxCompactSketchBytes((int)2);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        sk.compact(false, wmem);
        Sketch csk = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void checkHeapifyEmptySketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        WritableMemory wmem = WritableMemory.allocate((int)16);
        sk.compact(false, wmem);
        PreambleUtil.clearEmpty((WritableMemory)wmem);
        Sketch csk = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(csk instanceof EmptyCompactSketch));
    }

    @Test
    public void checkGetCache() {
        UpdateSketch sk = Sketches.updateSketchBuilder().setP(0.5f).build();
        sk.update(7L);
        int bytes = sk.getCurrentBytes(true);
        CompactSketch csk = sk.compact(true, WritableMemory.allocate((int)bytes));
        long[] cache = csk.getCache();
        Assert.assertTrue((cache.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void printlnTest() {
        CompactSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

