/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesReadOnlyException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReadOnlyMemoryTest {
    @Test
    public void wrapAndTryUpdatingSparseSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        byte[] bytes = s1.toByteArray(false);
        Assert.assertEquals((int)bytes.length, (int)64);
        Memory mem = Memory.wrap((byte[])bytes);
        UpdateDoublesSketch s2 = (UpdateDoublesSketch)DoublesSketch.wrap((Memory)mem);
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)2.0);
        try {
            s2.update(3.0);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void wrapCompactSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.compact().toByteArray());
        DoublesSketch s2 = DoublesSketch.wrap((Memory)mem);
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)2.0);
        Assert.assertEquals((long)s2.getN(), (long)2L);
    }

    @Test
    public void heapifySparseSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(false));
        DoublesSketch s2 = DoublesSketch.heapify((Memory)mem);
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)2.0);
    }

    @Test
    public void heapifyAndUpdateSparseSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(false));
        UpdateDoublesSketch s2 = (UpdateDoublesSketch)DoublesSketch.heapify((Memory)mem);
        s2.update(3.0);
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)3.0);
    }

    @Test
    public void heapifyCompactSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(true));
        DoublesSketch s2 = DoublesSketch.heapify((Memory)mem);
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)2.0);
    }

    @Test
    public void heapifyEmptyUpdateSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        Memory mem = Memory.wrap((byte[])s1.toByteArray());
        DoublesSketch s2 = DoublesSketch.heapify((Memory)mem);
        Assert.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void heapifyEmptyCompactSketch() {
        CompactDoublesSketch s1 = DoublesSketch.builder().build().compact();
        Memory mem = Memory.wrap((byte[])s1.toByteArray());
        DoublesSketch s2 = DoublesSketch.heapify((Memory)mem);
        Assert.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void wrapEmptyUpdateSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        Memory mem = Memory.wrap((byte[])s1.toByteArray());
        UpdateDoublesSketch s2 = (UpdateDoublesSketch)DoublesSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)s2.isEmpty());
        try {
            s2.putMinValue(-1.0);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putMaxValue(1.0);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putN(1L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putBitPattern(1L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.reset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putBaseBufferCount(5);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            s2.putCombinedBuffer(new double[16]);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            int currCap = s2.getCombinedBufferItemCapacity();
            s2.growCombinedBuffer(currCap, 2 * currCap);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void wrapEmptyCompactSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        Memory mem = Memory.wrap((byte[])s1.compact().toByteArray());
        DoublesSketch s2 = DoublesSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void heapifyUnionFromSparse() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(false));
        DoublesUnion u = DoublesUnion.heapify((Memory)mem);
        u.update(3.0);
        UpdateDoublesSketch s2 = u.getResult();
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)3.0);
    }

    @Test
    public void heapifyUnionFromCompact() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(true));
        DoublesUnion u = DoublesUnion.heapify((Memory)mem);
        u.update(3.0);
        UpdateDoublesSketch s2 = u.getResult();
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)3.0);
    }

    @Test
    public void wrapUnionFromSparse() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(false));
        DoublesUnion u = DoublesUnion.wrap((Memory)mem);
        UpdateDoublesSketch s2 = u.getResult();
        Assert.assertEquals((Object)s2.getMinValue(), (Object)1.0);
        Assert.assertEquals((Object)s2.getMaxValue(), (Object)2.0);
        try {
            u.update(3.0);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            u.update((DoublesSketch)s2);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            u.update(mem);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            u.reset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            u.getResultAndReset();
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrapUnionFromCompact() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        s1.update(1.0);
        s1.update(2.0);
        Memory mem = Memory.wrap((byte[])s1.toByteArray(true));
        DoublesUnion.wrap((Memory)mem);
        Assert.fail();
    }
}

