/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchR;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DirectUpdateDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        DoublesSketch.rand.setSeed(32749L);
    }

    @Test
    public void checkBigMinMax() {
        int k = 32;
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(k).build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().setK(k).build();
        UpdateDoublesSketch qs3 = DoublesSketch.builder().setK(k).build();
        Assert.assertFalse((boolean)qs1.isEstimationMode());
        for (int i = 999; i >= 1; --i) {
            qs1.update((double)i);
            qs2.update((double)(1000 + i));
            qs3.update((double)i);
        }
        Assert.assertTrue((boolean)qs1.isEstimationMode());
        Assert.assertTrue((qs1.getQuantile(0.0) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((qs1.getQuantile(1.0) == 999.0 ? 1 : 0) != 0);
        Assert.assertTrue((qs2.getQuantile(0.0) == 1001.0 ? 1 : 0) != 0);
        Assert.assertTrue((qs2.getQuantile(1.0) == 1999.0 ? 1 : 0) != 0);
        Assert.assertTrue((qs3.getQuantile(0.0) == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((qs3.getQuantile(1.0) == 999.0 ? 1 : 0) != 0);
        double[] queries = new double[]{0.0, 1.0};
        double[] resultsA = qs1.getQuantiles(queries);
        Assert.assertTrue((resultsA[0] == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((resultsA[1] == 999.0 ? 1 : 0) != 0);
        DoublesUnion union1 = DoublesUnion.heapify((DoublesSketch)qs1);
        union1.update((DoublesSketch)qs2);
        UpdateDoublesSketch result1 = union1.getResult();
        DoublesUnion union2 = DoublesUnion.heapify((DoublesSketch)qs2);
        union2.update((DoublesSketch)qs3);
        UpdateDoublesSketch result2 = union2.getResult();
        double[] resultsB = result1.getQuantiles(queries);
        Assert.assertTrue((resultsB[0] == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((resultsB[1] == 1999.0 ? 1 : 0) != 0);
        double[] resultsC = result2.getQuantiles(queries);
        Assert.assertTrue((resultsC[0] == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((resultsC[1] == 1999.0 ? 1 : 0) != 0);
    }

    @Test
    public void checkSmallMinMax() {
        int k = 32;
        int n = 8;
        UpdateDoublesSketch qs1 = DirectUpdateDoublesSketchTest.buildDQS(k, n);
        UpdateDoublesSketch qs2 = DirectUpdateDoublesSketchTest.buildDQS(k, n);
        UpdateDoublesSketch qs3 = DirectUpdateDoublesSketchTest.buildDQS(k, n);
        for (int i = n; i >= 1; --i) {
            qs1.update((double)i);
            qs2.update((double)(10 + i));
            qs3.update((double)i);
        }
        assert (qs1.getQuantile(0.0) == 1.0);
        assert (qs1.getQuantile(0.5) == 5.0);
        assert (qs1.getQuantile(1.0) == 8.0);
        assert (qs2.getQuantile(0.0) == 11.0);
        assert (qs2.getQuantile(0.5) == 15.0);
        assert (qs2.getQuantile(1.0) == 18.0);
        assert (qs3.getQuantile(0.0) == 1.0);
        assert (qs3.getQuantile(0.5) == 5.0);
        assert (qs3.getQuantile(1.0) == 8.0);
        double[] queries = new double[]{0.0, 0.5, 1.0};
        double[] resultsA = qs1.getQuantiles(queries);
        assert (resultsA[0] == 1.0);
        assert (resultsA[1] == 5.0);
        assert (resultsA[2] == 8.0);
        DoublesUnion union1 = DoublesUnion.heapify((DoublesSketch)qs1);
        union1.update((DoublesSketch)qs2);
        UpdateDoublesSketch result1 = union1.getResult();
        DoublesUnion union2 = DoublesUnion.heapify((DoublesSketch)qs2);
        union2.update((DoublesSketch)qs3);
        UpdateDoublesSketch result2 = union2.getResult();
        double[] resultsB = result1.getQuantiles(queries);
        DirectUpdateDoublesSketchTest.printResults(resultsB);
        assert (resultsB[0] == 1.0);
        assert (resultsB[1] == 11.0);
        assert (resultsB[2] == 18.0);
        double[] resultsC = result2.getQuantiles(queries);
        assert (resultsC[0] == 1.0);
        assert (resultsC[1] == 11.0);
        assert (resultsC[2] == 18.0);
    }

    static void printResults(double[] results) {
        DirectUpdateDoublesSketchTest.println(results[0] + ", " + results[1] + ", " + results[2]);
    }

    @Test
    public void wrapEmptyUpdateSketch() {
        UpdateDoublesSketch s1 = DoublesSketch.builder().build();
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)ByteBuffer.wrap(s1.toByteArray()).order(ByteOrder.nativeOrder()));
        DirectUpdateDoublesSketch s2 = DirectUpdateDoublesSketch.wrapInstance((WritableMemory)mem);
        Assert.assertTrue((boolean)s2.isEmpty());
        Assert.assertEquals((long)s2.getN(), (long)0L);
        Assert.assertTrue((boolean)Double.isNaN(s2.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(s2.getMaxValue()));
        s2.reset();
        Assert.assertEquals((long)s2.getN(), (long)0L);
    }

    @Test
    public void checkPutCombinedBuffer() {
        int k = 128;
        int cap = 2080;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[2080]);
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(128).build(mem);
        mem = qs.getMemory();
        Assert.assertEquals((long)mem.getCapacity(), (long)2080L);
        Assert.assertTrue((boolean)qs.isEmpty());
        int n = 16;
        double[] data = new double[16];
        for (int i = 0; i < 16; ++i) {
            data[i] = i + 1;
        }
        qs.putBaseBufferCount(16);
        qs.putN(16L);
        qs.putCombinedBuffer(data);
        double[] combBuf = qs.getCombinedBuffer();
        Assert.assertEquals((double[])combBuf, (double[])data);
        Assert.assertTrue((boolean)Double.isNaN(qs.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(qs.getMaxValue()));
    }

    @Test
    public void checkMisc() {
        int k = 128;
        int n = 48;
        int cap = 32 + (2 * k << 3);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[cap]);
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build(mem);
        mem = qs.getMemory();
        Assert.assertEquals((long)mem.getCapacity(), (long)cap);
        double[] combBuf = qs.getCombinedBuffer();
        Assert.assertEquals((int)combBuf.length, (int)(2 * k));
        qs = DirectUpdateDoublesSketchTest.buildAndLoadDQS(k, n);
        qs.update(Double.NaN);
        int n2 = (int)qs.getN();
        Assert.assertEquals((int)n2, (int)n);
        combBuf = qs.getCombinedBuffer();
        Assert.assertEquals((int)combBuf.length, (int)Util.ceilingPowerOf2((int)n));
        DirectUpdateDoublesSketchTest.println(qs.toString(true, true));
        qs.reset();
        Assert.assertEquals((long)qs.getN(), (long)0L);
        qs.putBaseBufferCount(0);
    }

    @Test
    public void variousExceptions() {
        int flags2;
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[8]);
        try {
            flags2 = 8;
            DirectUpdateDoublesSketchR.checkCompact((int)2, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException flags2) {
            // empty catch block
        }
        try {
            flags2 = 8;
            DirectUpdateDoublesSketchR.checkCompact((int)3, (int)flags2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketchR.checkPreLongs((int)3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketchR.checkPreLongs((int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketchR.checkDirectFlags((int)8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DirectUpdateDoublesSketchR.checkEmptyAndN((boolean)true, (long)1L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCheckDirectMemCapacity() {
        int k = 128;
        DirectUpdateDoublesSketchR.checkDirectMemCapacity((int)128, (long)255L, (long)2080L);
        DirectUpdateDoublesSketchR.checkDirectMemCapacity((int)128, (long)257L, (long)3104L);
        DirectUpdateDoublesSketchR.checkDirectMemCapacity((int)128, (long)0L, (long)8L);
        try {
            DirectUpdateDoublesSketchR.checkDirectMemCapacity((int)128, (long)10000L, (long)64L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void serializeDeserialize() {
        int sizeBytes = DoublesSketch.getUpdatableStorageBytes((int)128, (long)2000L);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[sizeBytes]);
        UpdateDoublesSketch sketch1 = DoublesSketch.builder().build(mem);
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        UpdateDoublesSketch sketch2 = UpdateDoublesSketch.wrap((WritableMemory)mem);
        for (int i = 0; i < 1000; ++i) {
            sketch2.update((double)(i + 1000));
        }
        Assert.assertEquals((Object)sketch2.getMinValue(), (Object)0.0);
        Assert.assertEquals((Object)sketch2.getMaxValue(), (Object)1999.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)1000.0, (double)10.0);
        byte[] arr2 = sketch2.toByteArray(false);
        Assert.assertEquals((int)arr2.length, (int)sketch2.getStorageBytes());
        DoublesSketch sketch3 = DoublesSketch.wrap((Memory)WritableMemory.wrap((byte[])arr2));
        Assert.assertEquals((Object)sketch3.getMinValue(), (Object)0.0);
        Assert.assertEquals((Object)sketch3.getMaxValue(), (Object)1999.0);
        Assert.assertEquals((double)sketch3.getQuantile(0.5), (double)1000.0, (double)10.0);
    }

    @Test
    public void mergeTest() {
        UpdateDoublesSketch dqs1 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 256);
        UpdateDoublesSketch dqs2 = DirectUpdateDoublesSketchTest.buildAndLoadDQS(128, 256L, 256);
        DoublesUnion union = DoublesUnion.builder().setMaxK(128).build();
        union.update((DoublesSketch)dqs1);
        union.update((DoublesSketch)dqs2);
        UpdateDoublesSketch result = union.getResult();
        double median = result.getQuantile(0.5);
        DirectUpdateDoublesSketchTest.println("Median: " + median);
        Assert.assertEquals((double)median, (double)258.0, (double)12.9);
    }

    @Test
    public void checkSimplePropagateCarryDirect() {
        int k = 16;
        int n = 32;
        int memBytes = DoublesSketch.getUpdatableStorageBytes((int)16, (long)32L);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[memBytes]);
        DoublesSketchBuilder bldr = DoublesSketch.builder();
        UpdateDoublesSketch ds = bldr.setK(16).build(mem);
        for (int i = 1; i <= 32; ++i) {
            ds.update((double)i);
        }
        double last = 0.0;
        for (int i = 0; i < 16; ++i) {
            double d = mem.getDouble((long)(36 + i << 3));
            Assert.assertTrue((d > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((d > last ? 1 : 0) != 0);
            last = d;
        }
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        int k = 128;
        int n = 1000000;
        int memBytes = DoublesSketch.getUpdatableStorageBytes((int)128, (long)1000000L);
        WritableMemory mem = WritableMemory.wrap((byte[])new byte[memBytes]);
        UpdateDoublesSketch sketch = DoublesSketch.builder().build(mem);
        double[] values = new double[1000000];
        for (int i = 0; i < 1000000; ++i) {
            sketch.update((double)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertEquals((Object)ranks[i], (Object)sketch.getRank(values[i]));
        }
    }

    static UpdateDoublesSketch buildAndLoadDQS(int k, int n) {
        return DirectUpdateDoublesSketchTest.buildAndLoadDQS(k, n, 0);
    }

    static UpdateDoublesSketch buildAndLoadDQS(int k, long n, int startV) {
        UpdateDoublesSketch qs = DirectUpdateDoublesSketchTest.buildDQS(k, n);
        int i = 1;
        while ((long)i <= n) {
            qs.update((double)(startV + i));
            ++i;
        }
        return qs;
    }

    static UpdateDoublesSketch buildDQS(int k, long n) {
        int cap = DoublesSketch.getUpdatableStorageBytes((int)k, (long)n);
        if (cap < 2 * k) {
            cap = 2 * k;
        }
        DoublesSketchBuilder bldr = new DoublesSketchBuilder();
        bldr.setK(k);
        UpdateDoublesSketch dqs = bldr.build(WritableMemory.wrap((byte[])new byte[cap]));
        return dqs;
    }

    @Test
    public void printlnTest() {
        DirectUpdateDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DirectUpdateDoublesSketchTest.print(s + org.apache.datasketches.quantiles.Util.LS);
    }

    static void print(String s) {
    }
}

