/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.util.Random;
import org.testng.Assert;

public class LzTzSpeedTest {
    static final byte[] byteTrailingZerosTable = new byte[256];
    static final byte[] byteLeadingZerosTable = new byte[256];

    private static void fillByteTrailingZerosTable() {
        LzTzSpeedTest.byteTrailingZerosTable[0] = 8;
        for (int i = 1; i < 256; ++i) {
            LzTzSpeedTest.byteTrailingZerosTable[i] = (byte)Integer.numberOfTrailingZeros(i);
        }
    }

    private static void fillByteLeadingZerosTable() {
        LzTzSpeedTest.byteLeadingZerosTable[0] = 8;
        for (int i = 1; i < 256; ++i) {
            LzTzSpeedTest.byteLeadingZerosTable[i] = (byte)Integer.numberOfLeadingZeros(i << 24);
        }
    }

    static int countLeadingZerosByByte(long theInput) {
        long tmp = theInput >>> 56;
        if (tmp > 0L) {
            return 0 + byteLeadingZerosTable[(int)tmp];
        }
        tmp = theInput >>> 48;
        if (tmp > 0L) {
            return 8 + byteLeadingZerosTable[(int)tmp];
        }
        tmp = theInput >>> 40;
        if (tmp > 0L) {
            return 16 + byteLeadingZerosTable[(int)tmp];
        }
        tmp = theInput >>> 32;
        if (tmp > 0L) {
            return 24 + byteLeadingZerosTable[(int)tmp];
        }
        tmp = theInput >>> 24;
        if (tmp > 0L) {
            return 32 + byteLeadingZerosTable[(int)tmp];
        }
        tmp = theInput >>> 16;
        if (tmp > 0L) {
            return 40 + byteLeadingZerosTable[(int)tmp];
        }
        tmp = theInput >>> 8;
        if (tmp > 0L) {
            return 48 + byteLeadingZerosTable[(int)tmp];
        }
        return 56 + byteLeadingZerosTable[(int)(theInput & 0xFFL)];
    }

    static int countTrailingZerosByByte(long theInput) {
        long tmp = theInput;
        for (int j = 0; j < 8; ++j) {
            int aByte = (int)(tmp & 0xFFL);
            if (aByte != 0) {
                return (j << 3) + byteTrailingZerosTable[aByte];
            }
            tmp >>>= 8;
        }
        return 64;
    }

    public void checkLeadingTrailingZerosByByte() {
        for (int i = 0; i < 64; ++i) {
            long in = 1L << i;
            Assert.assertEquals((int)LzTzSpeedTest.countTrailingZerosByByte(in), (int)Long.numberOfTrailingZeros(in));
            Assert.assertEquals((int)LzTzSpeedTest.countLeadingZerosByByte(in), (int)Long.numberOfLeadingZeros(in));
        }
    }

    public void checkLeadingZerosByByteRandom() {
        Random rand = new Random();
        int n = 1024;
        long signBit = Long.MIN_VALUE;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < n; ++j) {
                long in = (rand.nextLong() | signBit) >>> i;
                Assert.assertEquals((int)LzTzSpeedTest.countLeadingZerosByByte(in), (int)Long.numberOfLeadingZeros(in));
            }
        }
    }

    public void checkLeadingZerosSpeed() {
        long signBit = Long.MIN_VALUE;
        int n = 0x10000000;
        for (int shift = 0; shift < 64; ++shift) {
            long sum1 = 0L;
            long tmp = 0L;
            long t0 = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                long in = ((tmp += -7046029254386353133L) | signBit) >>> shift;
                sum1 += (long)LzTzSpeedTest.countLeadingZerosByByte(in);
            }
            long t1 = System.nanoTime();
            double byteTime = (double)(t1 - t0) / (double)n;
            long sum2 = 0L;
            tmp = 0L;
            long t2 = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                long in = ((tmp += -7046029254386353133L) | signBit) >>> shift;
                sum2 += (long)Long.numberOfLeadingZeros(in);
            }
            long t3 = System.nanoTime();
            double longTime = (double)(t3 - t2) / (double)n;
            assert (sum1 == sum2);
            LzTzSpeedTest.println("shift: " + shift + ", byte: " + byteTime + ", long: " + longTime);
        }
    }

    public void checkTrailingZerosSpeed() {
        long oneBit = 1L;
        int n = 0x10000000;
        for (int shift = 0; shift < 64; ++shift) {
            long sum1 = 0L;
            long tmp = 0L;
            long t0 = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                long in = ((tmp += -7046029254386353133L) | oneBit) << shift;
                sum1 += (long)LzTzSpeedTest.countTrailingZerosByByte(in);
            }
            long t1 = System.nanoTime();
            double byteTime = (double)(t1 - t0) / (double)n;
            long sum2 = 0L;
            tmp = 0L;
            long t2 = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                long in = ((tmp += -7046029254386353133L) | oneBit) << shift;
                sum2 += (long)Long.numberOfTrailingZeros(in);
            }
            long t3 = System.nanoTime();
            double longTime = (double)(t3 - t2) / (double)n;
            assert (sum1 == sum2);
            LzTzSpeedTest.println("shift: " + shift + ", byte: " + byteTime + ", long: " + longTime);
        }
    }

    public void printlnTest() {
        LzTzSpeedTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        System.out.println(s);
    }

    static {
        LzTzSpeedTest.fillByteTrailingZerosTable();
        LzTzSpeedTest.fillByteLeadingZerosTable();
    }
}

