/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Misc$nonGlyphToVisibleGlyphsRemapper$;
import passera.unsigned.UByte;
import passera.unsigned.UByte$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;
import scala.xml.include.sax.EncodingHeuristics$;

public final class Misc$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Misc$.class.getDeclaredField("byteToCharTable$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Misc$.class.getDeclaredField("classPath$lzy1"));
    private volatile Object classPath$lzy1;
    private static final char[] hexLookup;
    public static final Misc$nonGlyphToVisibleGlyphsRemapper$ nonGlyphToVisibleGlyphsRemapper;
    private volatile Object byteToCharTable$lzy1;
    public static final Misc$ MODULE$;

    private Misc$() {
    }

    static {
        MODULE$ = new Misc$();
        hexLookup = (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString("0123456789ABCDEF"), ClassTag$.MODULE$.apply(Character.TYPE));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Misc$.class);
    }

    public <T> Option<T> boolToOpt(boolean test, Function0<T> thing) {
        if (test) {
            return Some$.MODULE$.apply(thing.apply());
        }
        return None$.MODULE$;
    }

    public String getNameFromClass(Object obj) {
        return this.getNameGivenAClassObject(obj.getClass());
    }

    public String getNameGivenAClassObject(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        String nonPackageClassName = (String)Predef$.MODULE$.wrapRefArray((Object[])clazz.getName().split("\\.")).toList().reverse().head();
        List nonDollarsParts = Predef$.MODULE$.wrapRefArray((Object[])nonPackageClassName.split("\\$")).toList().reverse();
        List nonNumericParts = nonDollarsParts.filterNot((Function1 & Serializable)_$9 -> _$9.matches("\\d*"));
        String nameToken = (String)nonNumericParts.head();
        return nameToken;
    }

    public String stripSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public String stripQuotes(String s) {
        String stripFirst = s.startsWith("\"") ? s.substring(1) : s;
        String stripLast = stripFirst.endsWith("\"") ? stripFirst.substring(0, stripFirst.length() - 1) : stripFirst;
        return stripLast;
    }

    public boolean isNullOrBlank(String s) {
        boolean b = Option$.MODULE$.apply((Object)s).isEmpty() || s.trim().isEmpty();
        return b;
    }

    public boolean isFileURI(URI uri) {
        if (uri.isAbsolute()) {
            String protocol;
            String string = protocol = uri.toURL().getProtocol();
            String string2 = "file";
            boolean result = !(string != null ? !string.equals(string2) : string2 != null);
            return result;
        }
        return false;
    }

    public Tuple2<Option<URI>, String> getResourceOption(String resourcePathRaw) {
        String resourcePath = resourcePathRaw.replaceAll("\\s", "%20");
        Object resPath = resourcePath.startsWith("/") ? resourcePath : "/" + resourcePath;
        Option res = Option$.MODULE$.apply((Object)this.getClass().getResource((String)resPath));
        return Tuple2$.MODULE$.apply((Object)res.map((Function1 & Serializable)_$10 -> _$10.toURI()), resPath);
    }

    private Option<URI> getResourceAbsoluteOrRelativeOption(String rawResName, Option<URI> optContextURI) {
        String resName = rawResName.replaceAll("\\s", "%20");
        Tuple2<Option<URI>, String> tuple2 = this.getResourceOption(resName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option maybeRes = (Option)tuple2._1();
        Option maybeRes2 = maybeRes;
        if (maybeRes2.isDefined()) {
            return maybeRes2;
        }
        return optContextURI.flatMap((Function1 & Serializable)contextURI -> MODULE$.getResourceRelativeOnlyOption(resName, (URI)contextURI));
    }

    public Option<URI> getResourceRelativeOnlyOption(String relPath, URI contextURI) {
        if (relPath == null) {
            throw Assert$.MODULE$.usageError("relPath.ne(null)");
        }
        if (contextURI == null) {
            throw Assert$.MODULE$.usageError("contextURI.ne(null)");
        }
        String string = contextURI.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case -341064690: {
                if (!"resource".equals(string)) break;
                return this.optRelativeResourceURI(contextURI, relPath);
            }
            case 104987: {
                if (!"jar".equals(string)) break;
                return this.optRelativeJarFileURI(contextURI, relPath);
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                return this.optRelativeFileURI(contextURI, relPath);
            }
        }
        throw new IllegalArgumentException("Unrecognized URI scheme: " + contextURI);
    }

    public Tuple2<String, String> splitJarUri(URI uri) {
        String string = uri.getScheme();
        String string2 = "jar";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Assert$.MODULE$.abort("Invariant broken: uri.getScheme().==(\"jar\")");
        }
        String uriStr = uri.toString();
        int exclamIdx = uriStr.lastIndexOf("!");
        String jarPart = uriStr.substring(0, exclamIdx);
        String pathPart = uriStr.substring(exclamIdx + 1);
        return Tuple2$.MODULE$.apply((Object)jarPart, (Object)pathPart);
    }

    public Option<URI> optRelativeJarFileURI(URI contextURI, String relPath) {
        None$ none$;
        Tuple2<String, String> tuple2 = this.splitJarUri(contextURI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String jarPart = (String)tuple2._1();
        String pathPart = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)jarPart, (Object)pathPart);
        String jarPart2 = (String)tuple22._1();
        String pathPart2 = (String)tuple22._2();
        if (!pathPart2.startsWith("/")) {
            throw Assert$.MODULE$.abort("Invariant broken: pathPart.startsWith(\"/\")");
        }
        URI contextURIPathOnly = URI.create(pathPart2);
        URI resolvedURIPathOnly = contextURIPathOnly.resolve(relPath);
        URI newJarPathURI = URI.create(jarPart2 + "!" + resolvedURIPathOnly.toString());
        try {
            newJarPathURI.toURL().openStream().close();
            none$ = Some$.MODULE$.apply((Object)newJarPathURI);
        }
        catch (IOException io) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<URI> optRelativeFileURI(URI contextURI, String relPath) {
        URI resourceURI = contextURI.resolve(relPath);
        if (Paths.get(resourceURI).toFile().exists()) {
            return Some$.MODULE$.apply((Object)resourceURI);
        }
        return None$.MODULE$;
    }

    public Option<URI> optRelativeResourceURI(URI contextURI, String relPath) {
        URI resolvedURI = contextURI.resolve(relPath);
        if (this.getClass().getResource(resolvedURI.getPath()) != null) {
            return Some$.MODULE$.apply((Object)resolvedURI);
        }
        return None$.MODULE$;
    }

    public Option<URI> searchResourceOption(String resName, Option<URI> relativeTo) {
        URI resAsURI = new URI(resName);
        Path resPath = resAsURI.getScheme() != null ? Paths.get(resAsURI) : Paths.get(resName, new String[0]);
        Some resolvedURI = Files.exists(resPath, new LinkOption[0]) ? Some$.MODULE$.apply((Object)resPath.toFile().toURI()) : this.getResourceAbsoluteOrRelativeOption(resName, relativeTo);
        Option res = resolvedURI.orElse(() -> Misc$.$anonfun$2(resName, relativeTo));
        return res;
    }

    public Seq<URL> classPath() {
        Object object = this.classPath$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.classPath$lzyINIT1();
    }

    private Object classPath$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.classPath$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        Seq urls;
                        Seq seq2;
                        ClassLoader cl;
                        ClassLoader classLoader = cl = this.getClass().getClassLoader();
                        if (classLoader instanceof URLClassLoader) {
                            URLClassLoader url = (URLClassLoader)classLoader;
                            Object object3 = Predef$.MODULE$.refArrayOps((Object[])url.getURLs());
                            seq2 = ArrayOps$.MODULE$.toSeq$extension(object3);
                        } else {
                            seq2 = (Seq)package$.MODULE$.Seq().empty();
                        }
                        seq = urls = seq2;
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.classPath$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.classPath$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public URI getRequiredResource(String resourcePath) {
        Tuple2<Option<URI>, String> tuple2 = this.getResourceOption(resourcePath);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            if (None$.MODULE$.equals(option)) {
                String resPath = (String)tuple2._2();
                String msg = "Required resource " + resPath + " was not found.\nClasspath is " + (String)(this.classPath().length() == 0 ? "unknown." : ": " + this.classPath().mkString("\n"));
                throw new FileNotFoundException(msg);
            }
            if (option instanceof Some) {
                URI res = (URI)((Some)option).value();
                return res;
            }
        }
        throw new MatchError(tuple2);
    }

    public String initialUpperCase(String s) {
        char c = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))));
        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(s.substring(1)), c);
    }

    public String initialLowerCase(String s) {
        char c = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))));
        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(s.substring(1)), c);
    }

    public String toInitialLowerCaseUnlessAllUpperCase(String s) {
        if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)))) {
            return s;
        }
        if (this.isAllUpper(s, 1)) {
            return s;
        }
        char c = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)));
        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(s.substring(1)), c);
    }

    public boolean isAllUpper(String s, int start) {
        int l = s.length();
        for (int i = start; i < l; ++i) {
            if (!RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i)))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllWhitespace(StringBuilder sb) {
        if (sb.isEmpty()) {
            return false;
        }
        int sbLen = sb.length();
        for (int in = 0; in < sbLen; ++in) {
            if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(sb.charAt(in)))) continue;
            return false;
        }
        return true;
    }

    public String getDaffodilVersion() {
        URI uri = this.getRequiredResource("org/apache/daffodil/lib/VERSION");
        String version = Source$.MODULE$.fromInputStream(uri.toURL().openStream(), "UTF-8").mkString();
        return version;
    }

    public byte[] hex2Bytes(String hex) {
        int len = hex.length();
        if (len % 2 != 0) {
            throw new NumberFormatException("Hex string must have an even number of characters, but was " + len + " for " + hex);
        }
        int numBytes = len / 2;
        byte[] arr = new byte[numBytes];
        int arrIdx = 0;
        int hexIdx = 0;
        while (arrIdx < numBytes) {
            int l = this.hexCharToValue$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(hex), hexIdx));
            int r = this.hexCharToValue$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(hex), hexIdx + 1));
            arr[arrIdx] = (byte)(l << 4 | r);
            ++arrIdx;
            hexIdx += 2;
        }
        return arr;
    }

    public String hex2Bits(String hex) {
        IndexedSeq nums = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(hex), (Function1 & Serializable)ch -> Misc$.$anonfun$3(BoxesRunTime.unboxToChar((Object)ch)));
        IndexedSeq bits = (IndexedSeq)nums.map((Function1 & Serializable)_$11 -> Misc$.$anonfun$4(BoxesRunTime.unboxToInt((Object)_$11)));
        IndexedSeq paddedBits = (IndexedSeq)bits.map((Function1 & Serializable)_$12 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%4s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{_$12})).replaceAll(" ", "0"));
        String res = paddedBits.mkString();
        return res;
    }

    public String bytes2Hex(byte[] bytes) {
        if (bytes.length > 0x3FFFFFFF) {
            throw Assert$.MODULE$.abort("Invariant broken: bytes.length.<=(scala.Int.MaxValue./(2))");
        }
        char[] hexArr = new char[bytes.length * 2];
        int bytIdx = 0;
        int hexIdx = 0;
        while (bytIdx < bytes.length) {
            int b = bytes[bytIdx] & 0xFF;
            hexArr[hexIdx] = hexLookup[b >>> 4];
            hexArr[hexIdx + 1] = hexLookup[b & 0xF];
            ++bytIdx;
            hexIdx += 2;
        }
        return new String(hexArr);
    }

    public byte[] bits2Bytes(String bits) {
        if (bits.isEmpty()) {
            return (byte[])package$.MODULE$.Nil().toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        return this.bits2Bytes((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)bits, (List)Nil$.MODULE$))));
    }

    public byte[] bits2Bytes(Seq<String> bits) {
        String allBitsOnly = ((IterableOnceOps)bits.flatMap((Function1 & Serializable)_$13 -> Predef$.MODULE$.wrapRefArray((Object[])_$13.split("[^01]")))).mkString();
        Iterator byteSizedBits = StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(allBitsOnly), 8, 8);
        return (byte[])byteSizedBits.map((Function1 & Serializable)_$14 -> (byte)Integer.parseInt(_$14, 2)).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public String bytes2Bits(byte[] bytes) {
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)b -> StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToByte((Object)b) & 0xFF))))), 8, '0'))), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    public ReadableByteChannel stringToReadableByteChannel(String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return this.byteArrayToReadableByteChannel(bytes);
    }

    public WritableByteChannel stringToWritableByteChannel(String s) {
        int size = s.length();
        return this.byteArrayToWritableByteChannel(size);
    }

    public ReadableByteChannel byteArrayToReadableByteChannel(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ReadableByteChannel rbc = Channels.newChannel(inputStream);
        return rbc;
    }

    public WritableByteChannel byteArrayToWritableByteChannel(int size) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(size);
        WritableByteChannel wbc = Channels.newChannel(outputStream);
        return wbc;
    }

    public ReadableByteChannel fileToReadableByteChannel(File file) {
        FileInputStream inputStream = new FileInputStream(file);
        ReadableByteChannel rbc = Channels.newChannel(inputStream);
        return rbc;
    }

    public String remapStringToVisibleGlyphs(String s) {
        return Misc$nonGlyphToVisibleGlyphsRemapper$.MODULE$.remap(s);
    }

    public char remapControlOrLineEndingToVisibleGlyphs(char c, boolean replaceControlPictures) {
        int n;
        int URC = 9254;
        char c2 = c;
        char n2 = c2;
        if (n2 <= '\u001f') {
            n = n2 + 9216;
        } else if (' ' == c2) {
            n = 9251;
        } else if ('\u007f' == c2) {
            n = 9249;
        } else {
            char n3 = c2;
            if (n3 >= '\u0080' && n3 <= '\u009f') {
                n = n3 + 256;
            } else {
                switch (c2) {
                    case '\u00a0': {
                        n = 9250;
                        break;
                    }
                    case '\u00ad': {
                        n = 45;
                        break;
                    }
                    case '\u200b': {
                        n = URC;
                        break;
                    }
                    case '\u2028': {
                        n = URC;
                        break;
                    }
                    case '\u2029': {
                        n = URC;
                        break;
                    }
                    case '\u200c': {
                        n = URC;
                        break;
                    }
                    case '\u200d': {
                        n = URC;
                        break;
                    }
                    case '\u2060': {
                        n = URC;
                        break;
                    }
                    case '\u200e': 
                    case '\u200f': {
                        n = URC;
                        break;
                    }
                    default: {
                        char b = c2;
                        if (b >= '\u202a' && b <= '\u202e') {
                            n = URC;
                            break;
                        }
                        if ('\ufffe' == c2) {
                            n = URC;
                            break;
                        }
                        if ('\uffff' == c2) {
                            n = URC;
                            break;
                        }
                        char n4 = c2;
                        if (n4 > '\u2400' && n4 < '\u2423' && replaceControlPictures) {
                            n = URC;
                            break;
                        }
                        char x = c2;
                        n = x;
                        break;
                    }
                }
            }
        }
        int code = n;
        return (char)code;
    }

    public boolean remapControlOrLineEndingToVisibleGlyphs$default$2() {
        return false;
    }

    private String byteToCharTable() {
        Object object = this.byteToCharTable$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.byteToCharTable$lzyINIT1();
    }

    private Object byteToCharTable$lzyINIT1() {
        Object object;
        block11: {
            while (true) {
                if ((object = this.byteToCharTable$lzy1) == null) {
                    String res;
                    CharBuffer cb;
                    String string;
                    Object object2;
                    block10: {
                        block9: {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            object2 = null;
                            string = null;
                            try {
                                Charset cs = Charset.forName("windows-1252");
                                CharsetDecoder dec = cs.newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPORT);
                                ByteBuffer bb = ByteBuffer.wrap((byte[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable)i -> Misc$.$anonfun$7(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                                cb = dec.decode(bb);
                                if (cb.position() == 0) break block9;
                                throw Scala3RunTime$.MODULE$.assertFailed();
                            }
                            catch (Throwable throwable) {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.byteToCharTable$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                                throw throwable;
                            }
                        }
                        if (cb.limit() == 256) break block10;
                        throw Scala3RunTime$.MODULE$.assertFailed();
                    }
                    cb.put(129, (char)385);
                    cb.put(141, (char)397);
                    cb.put(143, (char)399);
                    cb.put(144, (char)400);
                    cb.put(157, (char)413);
                    string = res = cb.toString();
                    object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.byteToCharTable$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block11;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public char byteToChar(byte b) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.byteToCharTable()), new UByte(UByte$.MODULE$.apply(b)).toInt());
    }

    public String remapBytesToStringOfVisibleGlyphs(byte[] ba) {
        int len = ba.length;
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(ba.length);
        for (int i = 0; i < ba.length; ++i) {
            sb.append(this.remapControlOrLineEndingToVisibleGlyphs(this.byteToChar(ba[i]), this.remapControlOrLineEndingToVisibleGlyphs$default$2()));
        }
        return sb.toString();
    }

    public char remapOneByteToVisibleGlyph(byte b) {
        return this.remapControlOrLineEndingToVisibleGlyphs(this.byteToChar(b), this.remapControlOrLineEndingToVisibleGlyphs$default$2());
    }

    public boolean isAsciiBased(String csName) {
        return this.isAsciiBased(Charset.forName(csName));
    }

    public boolean isAsciiBased(Charset cs) {
        Set aliases = (Set)CollectionConverters$.MODULE$.SetHasAsScala(cs.aliases()).asScala().map((Function1 & Serializable)_$15 -> _$15.toUpperCase());
        boolean byName = aliases.exists((Function1 & Serializable)s -> !s.contains("7-BIT") && !s.contains("EBCDIC") && (s.startsWith("ASCII") || s.startsWith("US-ASCII") || s.startsWith("ISO-8859") || s.startsWith("UTF")));
        if (byName) {
            return byName;
        }
        CharsetDecoder decoder = cs.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] abcBytes = "abc".getBytes("ascii");
        ByteBuffer bb = ByteBuffer.wrap(abcBytes);
        CharBuffer cb = decoder.decode(bb);
        String abc = cb.toString();
        String string = (String)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(abc);
        return package$TypeEqual$.MODULE$.$eq$colon$eq$extension(string, "abc", package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
    }

    public void writeToFile(String fileName, Function1<Writer, BoxedUnit> body) {
        FileWriter writer = new FileWriter(fileName);
        Using$.MODULE$.resource((Object)writer, (Function1)(JProcedure1 & Serializable)_$16 -> body.apply(_$16), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String determineEncoding(URI uri) {
        EncodingHeuristics$ encH = EncodingHeuristics$.MODULE$;
        InputStream is = uri.toURL().openStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        String enc = encH.readEncodingFromStream((InputStream)bis);
        is.close();
        return enc;
    }

    public String determineEncoding(File file) {
        return this.determineEncoding(file.toURI());
    }

    public String csToString(CharSequence cs) {
        CharSequence charSequence = cs;
        if (charSequence instanceof String) {
            String s = (String)charSequence;
            return s;
        }
        StringBuilder sb = new StringBuilder(cs.length());
        sb.append(cs);
        return sb.mkString();
    }

    public String getAMessage(Throwable th) {
        Object object;
        Throwable c;
        String m = th.getMessage();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)m, (Object)(c = th.getCause()));
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Throwable throwable = (Throwable)tuple2._2();
            if (string == null && throwable == null) {
                object = this.getNameFromClass(th);
            } else if ("".equals(string) && throwable == null) {
                object = this.getNameFromClass(th);
            } else {
                String m2 = string;
                if (throwable == null) {
                    object = m2;
                } else if (string == null) {
                    Throwable c2 = throwable;
                    object = this.getAMessage(c2);
                } else {
                    String m3 = string;
                    Throwable c3 = throwable;
                    String cmsg = this.getAMessage(c3);
                    object = cmsg + " (within " + th.getClass().getSimpleName() + " " + m3 + ")";
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        String res = object;
        if (res == null) {
            throw Assert$.MODULE$.abort("Invariant broken: res.!=(null)");
        }
        return res;
    }

    public Some<String> getSomeMessage(Throwable th) {
        return Some$.MODULE$.apply((Object)this.getAMessage(th));
    }

    public Throwable getACause(Throwable th) {
        Throwable c = th.getCause();
        Throwable throwable = c;
        Throwable res = throwable == null ? th : this.getACause(c);
        return res;
    }

    public Some<Throwable> getSomeCause(Throwable th) {
        return Some$.MODULE$.apply((Object)this.getACause(th));
    }

    public File uriToDiagnosticFile(URI uri) {
        String string = uri.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case -341064690: {
                if (!"resource".equals(string)) break;
                String resourceFilePart = uri.getPath();
                return Paths.get(resourceFilePart, new String[0]).toFile();
            }
            case 104987: {
                if (!"jar".equals(string)) break;
                Tuple2<String, String> tuple2 = this.splitJarUri(uri);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String pathPart = (String)tuple2._2();
                String pathPart2 = pathPart;
                return Paths.get(pathPart2, new String[0]).toFile();
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                return Paths.get(uri).toFile();
            }
        }
        return Paths.get(uri.getPath(), new String[0]).toFile();
    }

    public Field lookupDeclaredField(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = clazz.getDeclaredField(fieldName + "$lzy1");
        }
        return field;
    }

    private static final Option $anonfun$2(String resName$2, Option relativeTo$1) {
        Object[] parts = resName$2.split("/");
        if (parts.length > 1) {
            Object object = Predef$.MODULE$.refArrayOps(parts);
            String filePart = (String)ArrayOps$.MODULE$.last$extension(object);
            Option<URI> secondTry = MODULE$.searchResourceOption(filePart, (Option<URI>)relativeTo$1);
            return secondTry;
        }
        return None$.MODULE$;
    }

    private final int hexCharToValue$1(char c) {
        int n;
        char i = c;
        if (i >= '0' && i <= '9') {
            n = i - 48;
        } else if (i >= 'A' && i <= 'F') {
            n = i - 65 + 10;
        } else if (i >= 'a' && i <= 'f') {
            n = i - 97 + 10;
        } else {
            throw new NumberFormatException("Hex character must be 0-9, a-f, or A-F, but was '" + c + "'");
        }
        int v = n;
        return v;
    }

    private static final /* synthetic */ int $anonfun$3(char ch) {
        return Integer.parseInt(BoxesRunTime.boxToCharacter((char)ch).toString(), 16);
    }

    private static final /* synthetic */ String $anonfun$4(int _$11) {
        return Long.toString(Int$.MODULE$.int2long(_$11), 2);
    }

    private static final /* synthetic */ byte $anonfun$7(int i) {
        return (byte)i;
    }
}

