/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil.core.grammar.primitives

import org.apache.daffodil.core.dsom.ElementBase
import org.apache.daffodil.core.grammar.Terminal
import org.apache.daffodil.runtime1.processors.parsers.ConvertTextBooleanParser
import org.apache.daffodil.unparsers.runtime1.ConvertTextBooleanUnparser

case class ConvertTextBooleanPrim(e: ElementBase) extends Terminal(e, true) {

  override def toString = "to(xs:boolean)"

  override lazy val parser = new ConvertTextBooleanParser(
    e.elementRuntimeData,
    e.textBooleanTrueRepEv,
    e.textBooleanFalseRepEv,
    e.ignoreCaseBool
  )

  override lazy val unparser = new ConvertTextBooleanUnparser(
    e.elementRuntimeData,
    e.textBooleanTrueRepEv,
    e.textBooleanFalseRepEv
  )
}
