/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderMalformedException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000112Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C)5\tI\")\u001b;t\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s+R35G\r'F\u0015\t)a!A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005\u001dA\u0011A\u00039s_\u000e,7o]8sg*\u0011\u0011BC\u0001\u0003S>T!a\u0003\u0007\u0002\u0011\u0011\fgMZ8eS2T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0005\u0013\t)BAA\u0012CSR\u001c8\t[1sg\u0016$H)Z2pI\u0016\u00148I]3bi\u0016\u001c8+\u001e:s_\u001e\fG/Z:\u0002\rqJg.\u001b;?)\u0005A\u0002CA\n\u0001\u0003Q!WmY8eK>sW-\u00168jG>$Wm\u00115beR\u00191$I\u0014\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\t\rC\u0017M\u001d\u0005\u0006E\t\u0001\raI\u0001\u0004I&\u001c\bC\u0001\u0013&\u001b\u0005A\u0011B\u0001\u0014\t\u0005iIe\u000e];u'>,(oY3ECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0015A#\u00011\u0001*\u0003\u00151\u0017N\u001c4p!\t!#&\u0003\u0002,\u0011\tQai\u001c:nCRLeNZ8")
public class BitsCharsetDecoderUTF32LE
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int byte4 = this.getByte(dis, 0);
        int byte3 = this.getByte(dis, 8);
        int byte2 = this.getByte(dis, 16);
        int byte1 = this.getByte(dis, 24);
        int cp = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
        if (cp >= 0 && cp <= 65535) {
            return (char)cp;
        }
        if (cp <= 0x10FFFF) {
            char high = Character.highSurrogate(cp);
            this.setLowSurrogate(Character.lowSurrogate(cp));
            return high;
        }
        throw new BitsCharsetDecoderMalformedException(32);
    }
}

