/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.resource.ActiveSAXSource;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ActiveStreamSource
extends StreamSource
implements ActiveSource {
    public ActiveStreamSource(StreamSource in) {
        this.setInputStream(in.getInputStream());
        this.setReader(in.getReader());
        this.setSystemId(in.getSystemId());
        this.setPublicId(in.getPublicId());
    }

    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        Configuration config = receiver.getPipelineConfiguration().getConfiguration();
        String url = this.getSystemId();
        InputSource is = new InputSource(url);
        is.setCharacterStream(this.getReader());
        is.setByteStream(this.getInputStream());
        boolean reuseParser = false;
        XMLReader parser = options.obtainXMLReader();
        if (parser == null) {
            parser = config.getSourceParser();
            if (options.getEntityResolver() != null) {
                parser.setEntityResolver(options.getEntityResolver());
            }
            reuseParser = true;
        }
        ActiveSAXSource sax = new ActiveSAXSource(parser, is);
        sax.setSystemId(url);
        sax.deliver(receiver, options);
        if (reuseParser) {
            config.reuseSourceParser(parser);
        }
    }
}

