/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataInputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIterator;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.MarkPool;
import org.apache.daffodil.io.MarkState;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.lib.util.Bits$;
import org.apache.daffodil.lib.util.LocalStack;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.MaybeULong$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]w!\u0002\u001d:\u0011\u0003\u0011e!\u0002#:\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003i\u0005\"\u0002(\u0002\t\u0003y\u0005B\u0002(\u0002\t\u0003\u0011\t\r\u0003\u0004O\u0003\u0011\u0005!q\u0019\u0004\u0005\tf\u0012\u0011\u000b\u0003\u0005V\r\t\u0015\r\u0011\"\u0001W\u0011!QfA!A!\u0002\u00139\u0006\"\u0002'\u0007\t\u0013Y\u0006\"B/\u0007\t\u0003r\u0006bB4\u0007\u0005\u0004%)\u0005\u001b\u0005\u0007Y\u001a\u0001\u000bQB5\t\u000f54!\u0019!C\u0001]\"1qO\u0002Q\u0001\n=Dq\u0001\u001f\u0004C\u0002\u0013\u0005\u0011\u0010\u0003\u0004~\r\u0001\u0006IA\u001f\u0005\u0006}\u001a!)e \u0005\b\u0003\u001f1AQIA\t\u0011\u001d\tYB\u0002C\u0001\u0003;Aa!!\n\u0007\t\u0003y\bbBA\u0014\r\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003k1A\u0011IA\u001c\u0011\u001d\tiD\u0002C\u0001\u0003\u007fAq!!\u0012\u0007\t\u0003\t9\u0005C\u0004\u0002F\u0019!\t!!\u001b\t\u000f\u0005Md\u0001\"\u0003\u0002v!9\u0011Q\u0010\u0004\u0005\u0002\u0005}\u0004bBAE\r\u0011\u0005\u00111\u0012\u0005\b\u0003+3A\u0011AAL\u0011%\tyJ\u0002b\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002$\u001a\u0001\u000b\u0011BA%\u0011\u001d\t)K\u0002C\u0001\u0003OCq!!0\u0007\t\u0013\ty\fC\u0004\u0002J\u001a!\t!a3\t\u000f\u0005ug\u0001\"\u0001\u0002`\"9\u0011Q\u001d\u0004\u0005\u0006\u0005\u001d\bbBAw\r\u0011\u0015\u0011q\u001e\u0005\b\u0003c4A\u0011AAz\u0011\u001d\tIP\u0002C\u0001\u0003wDqAa\t\u0007\t\u0013\u0011)\u0003C\u0004\u0003*\u0019!\tAa\u000b\t\u000f\t=b\u0001\"\u0001\u00032!9!Q\u0007\u0004\u0005B\t]\u0002b\u0002B \r\u0011\u0005#\u0011\t\u0005\b\u0005\u000f2A\u0011\u0001B%\u0011\u001d\u0011YE\u0002C\u0003\u0005\u001bB!Ba\u0017\u0007\u0011\u000b\u0007I\u0011\u0001B/\u0011\u001d\u0011YG\u0002C\u0001\u0005[BqAa\u001d\u0007\t\u0003\u0011)\bC\u0005\u0003\f\u001a\u0011\r\u0011\"\u0003\u0003\u000e\"A!Q\u0013\u0004!\u0002\u0013\u0011y\tC\u0004\u0003\u0018\u001a!\tA!'\t\u000f\t\u0005f\u0001\"\u0011\u0003$\"9!\u0011\u0016\u0004\u0005\u0002\t-\u0006b\u0002B\\\r\u0011\u0005!\u0011X\u0001\u001b\u0013:\u0004X\u000f^*pkJ\u001cW\rR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0006\u0003um\n!![8\u000b\u0005qj\u0014\u0001\u00033bM\u001a|G-\u001b7\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0002\u0001!\t\u0019\u0015!D\u0001:\u0005iIe\u000e];u'>,(oY3ECR\f\u0017J\u001c9viN#(/Z1n'\t\ta\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u000bQ!\u00199qYf$2\u0001\u0015B_!\t\u0019eaE\u0002\u0007\rJ\u0003\"aQ*\n\u0005QK$\u0001\u0007#bi\u0006Le\u000e];u'R\u0014X-Y7J[BdW*\u001b=j]\u0006Y\u0011N\u001c9viN{WO]2f+\u00059\u0006CA\"Y\u0013\tI\u0016HA\u0006J]B,HoU8ve\u000e,\u0017\u0001D5oaV$8k\\;sG\u0016\u0004CC\u0001)]\u0011\u0015)\u0016\u00021\u0001X\u0003!!xn\u0015;sS:<G#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\n11\u000b\u001e:j]\u001e\f1aY:u+\u0005I\u0007CA\"k\u0013\tY\u0017HA\u0005NCJ\\7\u000b^1uK\u0006!1m\u001d;!\u0003%i\u0017M]6Ti\u0006\u001c7.F\u0001p!\r\u0001X/[\u0007\u0002c*\u0011!o]\u0001\u0005kRLGN\u0003\u0002uw\u0005\u0019A.\u001b2\n\u0005Y\f(\u0001C'Ti\u0006\u001c7n\u00144\u0002\u00155\f'o[*uC\u000e\\\u0007%\u0001\u0005nCJ\\\u0007k\\8m+\u0005Q\bCA\"|\u0013\ta\u0018H\u0001\u0005NCJ\\\u0007k\\8m\u0003%i\u0017M]6Q_>d\u0007%\u0001\u0005cSR\u0004vn\u001d\u0019c+\t\t\t\u0001E\u0002H\u0003\u0007I1!!\u0002I\u0005\u0011auN\\4)\u0007E\tI\u0001E\u0002H\u0003\u0017I1!!\u0004I\u0005\u0019Ig\u000e\\5oK\u0006Q!-\u001b;MS6LG\u000f\r2\u0016\u0005\u0005M\u0001c\u00019\u0002\u0016%\u0019\u0011qC9\u0003\u00155\u000b\u0017PY3V\u0019>tw\rK\u0002\u0013\u0003\u0013\t1\u0003[1t%\u0016\f7\r[3e\u000b:$wJ\u001a#bi\u0006,\"!a\b\u0011\u0007\u001d\u000b\t#C\u0002\u0002$!\u0013qAQ8pY\u0016\fg.A\nl]><hNQ=uKN\fe/Y5mC\ndW-A\u0006tKR\u0014\u0015\u000e\u001e)pgB\u0012G\u0003BA\u0016\u0003c\u00012aRA\u0017\u0013\r\ty\u0003\u0013\u0002\u0005+:LG\u000fC\u0004\u00024U\u0001\r!!\u0001\u0002\u00179,wOQ5u!>\u001c\bGY\u0001\u000eg\u0016$()\u001b;MS6LG\u000f\r2\u0015\t\u0005}\u0011\u0011\b\u0005\b\u0003w1\u0002\u0019AA\n\u00035qWm\u001e\"ji2KW.\u001b;1E\u0006y!/Z:fi\nKG\u000fT5nSR\u0004$\r\u0006\u0003\u0002,\u0005\u0005\u0003bBA\"/\u0001\u0007\u00111C\u0001\u0010g\u00064X\r\u001a\"ji2KW.\u001b;1E\u0006aq-\u001a;CsR,\u0017I\u001d:bsR1\u0011\u0011JA+\u0003?\u0002RaRA&\u0003\u001fJ1!!\u0014I\u0005\u0015\t%O]1z!\r9\u0015\u0011K\u0005\u0004\u0003'B%\u0001\u0002\"zi\u0016Dq!a\u0016\u0019\u0001\u0004\tI&\u0001\bcSRdUM\\4uQ\u001a\u0013x.\\\u0019\u0011\u0007\u001d\u000bY&C\u0002\u0002^!\u00131!\u00138u\u0011\u001d\t\t\u0007\u0007a\u0001\u0003G\nQAZ5oM>\u00042aQA3\u0013\r\t9'\u000f\u0002\u000b\r>\u0014X.\u0019;J]\u001a|G\u0003CA\u0016\u0003W\ni'a\u001c\t\u000f\u0005]\u0013\u00041\u0001\u0002Z!9\u0011\u0011M\rA\u0002\u0005\r\u0004bBA93\u0001\u0007\u0011\u0011J\u0001\u0006CJ\u0014\u0018-_\u0001\u000eM&dGNQ=uK\u0006\u0013(/Y=\u0015\u0011\u0005-\u0012qOA=\u0003wBq!!\u001d\u001b\u0001\u0004\tI\u0005C\u0004\u0002Xi\u0001\r!!\u0017\t\u000f\u0005\u0005$\u00041\u0001\u0002d\u0005yq-\u001a;CS:\f'/\u001f#pk\ndW\r\u0006\u0003\u0002\u0002\u0006\u001d\u0005cA$\u0002\u0004&\u0019\u0011Q\u0011%\u0003\r\u0011{WO\u00197f\u0011\u001d\t\tg\u0007a\u0001\u0003G\nabZ3u\u0005&t\u0017M]=GY>\fG\u000f\u0006\u0003\u0002\u000e\u0006M\u0005cA$\u0002\u0010&\u0019\u0011\u0011\u0013%\u0003\u000b\u0019cw.\u0019;\t\u000f\u0005\u0005D\u00041\u0001\u0002d\u0005iq-\u001a;TS\u001etW\r\u001a'p]\u001e$b!!\u0001\u0002\u001a\u0006u\u0005bBAN;\u0001\u0007\u0011\u0011L\u0001\u0013E&$H*\u001a8hi\"4%o\\72)>4D\u0007C\u0004\u0002bu\u0001\r!a\u0019\u0002\u00131|gnZ!se\u0006LXCAA%\u0003)awN\\4BeJ\f\u0017\u0010I\u0001\u0010O\u0016$XK\\:jO:,G\rT8oOR1\u0011\u0011VA]\u0003w\u0003B!a+\u000266\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,\u0001\u0005v]NLwM\\3e\u0015\t\t\u0019,A\u0004qCN\u001cXM]1\n\t\u0005]\u0016Q\u0016\u0002\u0006+2{gn\u001a\u0005\b\u00037\u0003\u0003\u0019AA-\u0011\u001d\t\t\u0007\ta\u0001\u0003G\n\u0011%\u00193kkN$()[4J]R\f%O]1z/&$\bN\u0012:bO6,g\u000e\u001e\"zi\u0016$\u0002\"a\u000b\u0002B\u0006\r\u0017q\u0019\u0005\b\u0003c\n\u0003\u0019AA%\u0011\u001d\t)-\ta\u0001\u00033\naB\u001a:bO6,g\u000e\u001e'f]\u001e$\b\u000eC\u0004\u0002b\u0005\u0002\r!a\u0019\u0002\u001f\u001d,GoU5h]\u0016$')[4J]R$b!!4\u0002Z\u0006m\u0007\u0003BAh\u0003+l!!!5\u000b\u0007\u0005M7-\u0001\u0003nCRD\u0017\u0002BAl\u0003#\u0014!BQ5h\u0013:$XmZ3s\u0011\u001d\t9F\ta\u0001\u00033Bq!!\u0019#\u0001\u0004\t\u0019'A\thKR,fn]5h]\u0016$')[4J]R$b!!4\u0002b\u0006\r\bbBA,G\u0001\u0007\u0011\u0011\f\u0005\b\u0003C\u001a\u0003\u0019AA2\u0003II7\u000fR3gS:,GMR8s\u0019\u0016tw\r\u001e5\u0015\t\u0005}\u0011\u0011\u001e\u0005\b\u0003W$\u0003\u0019AA\u0001\u0003\u0015q')\u001b;t\u0003\u001dA\u0017m\u001d#bi\u0006$\"!a\b\u0002\tM\\\u0017\u000e\u001d\u000b\u0007\u0003?\t)0a>\t\u000f\u0005-h\u00051\u0001\u0002\u0002!9\u0011\u0011\r\u0014A\u0002\u0005\r\u0014\u0001B7be.$B!!@\u0003\fA!\u0011q B\u0003\u001d\r\u0019%\u0011A\u0005\u0004\u0005\u0007I\u0014a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7\n\t\t\u001d!\u0011\u0002\u0002\u0005\u001b\u0006\u00148NC\u0002\u0003\u0004eBqA!\u0004(\u0001\u0004\u0011y!A\u0006sKF,Xm\u001d;pe&#\u0005\u0003\u0002B\t\u0005?qAAa\u0005\u0003\u001cA\u0019!Q\u0003%\u000e\u0005\t]!b\u0001B\r\u0003\u00061AH]8pizJ1A!\bI\u0003\u0019\u0001&/\u001a3fM&\u0019aM!\t\u000b\u0007\tu\u0001*\u0001\tsK2,\u0017m]3V]RLG.T1sWR\u0019\u0011Na\n\t\u000f\u0005e\b\u00061\u0001\u0002~\u0006)!/Z:fiR!\u00111\u0006B\u0017\u0011\u001d\tI0\u000ba\u0001\u0003{\fq\u0001Z5tG\u0006\u0014H\r\u0006\u0003\u0002,\tM\u0002bBA}U\u0001\u0007\u0011Q`\u0001\b[\u0006\u00148\u000eU8t+\t\u0011I\u0004\u0005\u0003\u0002\u0000\nm\u0012\u0002\u0002B\u001f\u0005\u0013\u0011q!T1sWB{7/\u0001\u0005sKN,G\u000fU8t)\u0011\tYCa\u0011\t\u000f\t\u0015C\u00061\u0001\u0003:\u0005\tQ.\u0001\rwC2LG-\u0019;f\r&t\u0017\r\\*ue\u0016\fWn\u0015;bi\u0016$\"!a\u000b\u0002\u001b\u001d,GoU8nKN#(/\u001b8h)\u0019\u0011yE!\u0016\u0003ZA)\u0001O!\u0015\u0003\u0010%\u0019!1K9\u0003\u000b5\u000b\u0017PY3\t\u000f\t]c\u00061\u0001\u0002\u0002\u00051an\u00115beNDq!!\u0019/\u0001\u0004\t\u0019'\u0001\btW&\u00048\t[1s\u0005V4g-\u001a:\u0016\u0005\t}\u0003\u0003\u0002B1\u0005Oj!Aa\u0019\u000b\u0007\t\u00154-A\u0002oS>LAA!\u001b\u0003d\tQ1\t[1s\u0005V4g-\u001a:\u0002\u0013M\\\u0017\u000e]\"iCJ\u001cHCBA\u0010\u0005_\u0012\t\bC\u0004\u0003XA\u0002\r!!\u0001\t\u000f\u0005\u0005\u0004\u00071\u0001\u0002d\u0005IAn\\8lS:<\u0017\t\u001e\u000b\u0007\u0003?\u00119H!#\t\u000f\te\u0014\u00071\u0001\u0003|\u00059Q.\u0019;dQ\u0016\u0014\b\u0003\u0002B?\u0005\u000bk!Aa \u000b\t\t\u0005%1Q\u0001\u0006e\u0016<W\r\u001f\u0006\u0003e\u000eLAAa\"\u0003\u0000\t9Q*\u0019;dQ\u0016\u0014\bbBA1c\u0001\u0007\u00111M\u0001\rG\"\f'/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001f\u00032a\u0011BI\u0013\r\u0011\u0019*\u000f\u0002'\u0013:\u0004X\u000f^*pkJ\u001cW\rR1uC&s\u0007/\u001e;TiJ,\u0017-\\\"iCJLE/\u001a:bi>\u0014\u0018!D2iCJLE/\u001a:bi>\u0014\b%\u0001\bbg&#XM]1u_J\u001c\u0005.\u0019:\u0016\u0005\tm\u0005\u0003BA\u0000\u0005;KAAa(\u0003\n\ta1\t[1s\u0013R,'/\u0019;pe\u0006a1/\u001a;EK\n,xmZ5oOR!\u00111\u0006BS\u0011\u001d\u00119+\u000ea\u0001\u0003?\tqa]3ui&tw-\u0001\u0005qCN$H)\u0019;b)\u0011\u0011iKa-\u0011\t\t\u0005$qV\u0005\u0005\u0005c\u0013\u0019G\u0001\u0006CsR,')\u001e4gKJDqA!.7\u0001\u0004\tI&A\bo\u0005f$Xm\u001d*fcV,7\u000f^3e\u0003)1W\u000f^;sK\u0012\u000bG/\u0019\u000b\u0005\u0005[\u0013Y\fC\u0004\u00036^\u0002\r!!\u0017\t\u000f\t}6\u00011\u0001\u0002J\u0005I!-\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u0004!\n\r\u0007b\u0002Bc\t\u0001\u0007!QV\u0001\u000bEf$XMQ;gM\u0016\u0014Hc\u0001)\u0003J\"9!1Z\u0003A\u0002\t5\u0017AA5o!\u0011\u0011yMa5\u000e\u0005\tE'B\u0001\u001ed\u0013\u0011\u0011)N!5\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c")
public final class InputSourceDataInputStream
implements DataInputStreamImplMixin {
    private CharBuffer skipCharBuffer;
    private final InputSource inputSource;
    private final MarkState cst;
    private final MStackOf<MarkState> markStack;
    private final MarkPool markPool;
    private final byte[] longArray;
    private final InputSourceDataInputStreamCharIterator charIterator;
    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer;
    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer;
    private volatile byte bitmap$0;

    public static InputSourceDataInputStream apply(InputStream inputStream) {
        return InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public static InputSourceDataInputStream apply(ByteBuffer byteBuffer) {
        return InputSourceDataInputStream$.MODULE$.apply(byteBuffer);
    }

    public static InputSourceDataInputStream apply(byte[] byArray) {
        return InputSourceDataInputStream$.MODULE$.apply(byArray);
    }

    @Override
    public final boolean isAligned(int bitAlignment1b) {
        return DataInputStreamImplMixin.isAligned$(this, bitAlignment1b);
    }

    @Override
    public final boolean align(int bitAlignment1b, FormatInfo finfo) {
        return DataInputStreamImplMixin.align$(this, bitAlignment1b, finfo);
    }

    @Override
    public final boolean areDebugging() {
        return DataStreamCommonImplMixin.areDebugging$(this);
    }

    @Override
    public final long bitPos1b() {
        return DataInputStream.bitPos1b$(this);
    }

    @Override
    public final long bytePos0b() {
        return DataInputStream.bytePos0b$(this);
    }

    @Override
    public final long bytePos1b() {
        return DataInputStream.bytePos1b$(this);
    }

    @Override
    public final long bitLimit1b() {
        return DataInputStream.bitLimit1b$(this);
    }

    @Override
    public final boolean setBitLimit1b(long bitLimit1b) {
        return DataInputStream.setBitLimit1b$(this, bitLimit1b);
    }

    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.withLocalCharBuffer = LocalBufferMixin.withLocalCharBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.withLocalCharBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.withLocalCharBuffer$lzycompute();
        }
        return this.withLocalCharBuffer;
    }

    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withLocalByteBuffer = LocalBufferMixin.withLocalByteBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withLocalByteBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.withLocalByteBuffer$lzycompute();
        }
        return this.withLocalByteBuffer;
    }

    public InputSource inputSource() {
        return this.inputSource;
    }

    public String toString() {
        long bp0b = this.bitPos0b();
        long bl0b = this.bitLimit0b();
        String bl0b1 = MaybeULong$.MODULE$.isDefined$extension(bl0b) ? Long.toString(MaybeULong$.MODULE$.get$extension(bl0b)) : "none";
        String str = new StringBuilder(35).append("DataInputStream(bitPos=").append(bp0b).append(", bitLimit=").append(bl0b1).append(")").toString();
        return str;
    }

    @Override
    public final MarkState cst() {
        return this.cst;
    }

    public MStackOf<MarkState> markStack() {
        return this.markStack;
    }

    public MarkPool markPool() {
        return this.markPool;
    }

    @Override
    public final long bitPos0b() {
        return this.cst().bitPos0b();
    }

    @Override
    public final long bitLimit0b() {
        return this.cst().bitLimit0b();
    }

    public boolean hasReachedEndOfData() {
        return this.inputSource().hasReachedEndOfData();
    }

    public long knownBytesAvailable() {
        return this.inputSource().knownBytesAvailable();
    }

    public void setBitPos0b(long newBitPos0b) {
        if (newBitPos0b < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitPos0b.>=(0)");
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStream.this.bitLimit0b.isEmpty.||(newBitPos0b.<=(InputSourceDataInputStream.this.bitLimit0b.get))");
        }
        this.inputSource().position(newBitPos0b >> 3);
        this.cst().bitPos0b_$eq(newBitPos0b);
    }

    @Override
    public boolean setBitLimit0b(long newBitLimit0b) {
        if (!MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) && MaybeULong$.MODULE$.get$extension(newBitLimit0b) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitLimit0b.isEmpty.||(newBitLimit0b.get.>=(0))");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) || MaybeULong$.MODULE$.get$extension(newBitLimit0b) <= MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            this.cst().bitLimit0b_$eq(newBitLimit0b);
            return true;
        }
        return false;
    }

    @Override
    public void resetBitLimit0b(long savedBitLimit0b) {
        this.cst().bitLimit0b_$eq(savedBitLimit0b);
    }

    @Override
    public byte[] getByteArray(int bitLengthFrom1, FormatInfo finfo) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int arraySize = (bitLengthFrom1 + 7) / 8;
        byte[] array = new byte[arraySize];
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
        return array;
    }

    @Override
    public void getByteArray(int bitLengthFrom1, FormatInfo finfo, byte[] array) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int bytesNeeded = (bitLengthFrom1 + 7) / 8;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() < bytesNeeded) {
            throw Assert$.MODULE$.usageError("Usage error: scala.Predef.byteArrayOps(array).size.>=(bytesNeeded)");
        }
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
    }

    private void fillByteArray(byte[] array, int bitLengthFrom1, FormatInfo finfo) {
        boolean isUnaligned = !this.isAligned(8);
        int fragmentBits = bitLengthFrom1 % 8;
        int bytesToFill = (bitLengthFrom1 + 7) / 8;
        this.inputSource().get(array, 0, bytesToFill);
        if (isUnaligned) {
            int index;
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null);
            int bitOffset0b = (int)(this.bitPos0b() % 8L);
            int bytesToRead = (bitLengthFrom1 + bitOffset0b + 7) / 8;
            int arrayOverflow = bytesToRead > bytesToFill ? Bits$.MODULE$.asUnsignedByte((long)this.inputSource().get()) : 0;
            int curBitMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(8 - bitOffset0b)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(8 - bitOffset0b));
            int nxtBitMask = ~curBitMask & 0xFF;
            int curShift = bitOffset0b;
            int nxtShift = 8 - bitOffset0b;
            int curByte = Bits$.MODULE$.asUnsignedByte(array[index]);
            int stopIndex = bytesToFill - 1;
            for (index = 0; index < stopIndex; ++index) {
                int nxtByte = Bits$.MODULE$.asUnsignedByte(array[index + 1]);
                array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, nxtByte, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
                curByte = nxtByte;
            }
            array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, arrayOverflow, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
        }
        if (fragmentBits > 0) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            int mask = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(fragmentBits)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(fragmentBits));
            int lastIndex = bytesToFill - 1;
            int lastByte = Bits$.MODULE$.asUnsignedByte(array[lastIndex]);
            array[lastIndex] = Bits$.MODULE$.asSignedByte((long)(lastByte & mask));
        }
        if (bitLengthFrom1 > 8) {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                Bits$.MODULE$.reverseBytes(array, bytesToFill);
                return;
            }
        }
    }

    @Override
    public double getBinaryDouble(FormatInfo finfo) {
        long l = this.getSignedLong(64, finfo);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    @Override
    public float getBinaryFloat(FormatInfo finfo) {
        int i = (int)this.getSignedLong(32, finfo);
        float f = Float.intBitsToFloat(i);
        return f;
    }

    @Override
    public long getSignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.<=(64)");
        }
        long res = this.getUnsignedLong(bitLengthFrom1To64, finfo);
        return Bits$.MODULE$.signExtend(res, bitLengthFrom1To64);
    }

    private byte[] longArray() {
        return this.longArray;
    }

    @Override
    public long getUnsignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        long l;
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.<=(64)");
        }
        if (!this.isDefinedForLength(bitLengthFrom1To64)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1To64);
        }
        int numBytes = (bitLengthFrom1To64 + 7) / 8;
        this.fillByteArray(this.longArray(), bitLengthFrom1To64, finfo);
        int fragmentLength = bitLengthFrom1To64 % 8;
        if (fragmentLength == 0) {
            long l2;
            l = l2 = this.buildLongFromArray$1(numBytes);
        } else {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                long l3;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                    int firstByte = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
                    int shifted = firstByte >>> 8 - fragmentLength;
                    this.longArray()[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                l = l3 = this.buildLongFromArray$1(numBytes);
            } else {
                long l4;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                    int lastIndex = numBytes - 1;
                    byte lastByte = this.longArray()[lastIndex];
                    int shifted = lastByte << 8 - fragmentLength;
                    this.longArray()[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                long unShiftedLong = this.buildLongFromArray$1(numBytes);
                l = l4 = unShiftedLong >>> 8 - fragmentLength;
            }
        }
        long res = l;
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1To64);
        return res;
    }

    private void adjustBigIntArrayWithFragmentByte(byte[] array, int fragmentLength, FormatInfo finfo) {
        ByteOrder byteOrder = finfo.byteOrder();
        ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
        if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                int firstByte = Bits$.MODULE$.asUnsignedByte(array[0]);
                int shifted = firstByte >>> 8 - fragmentLength;
                array[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                return;
            }
            return;
        }
        BitOrder bitOrder = finfo.bitOrder();
        BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
        if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
            int lastIndex = array.length - 1;
            byte lastByte = array[lastIndex];
            int shifted = lastByte << 8 - fragmentLength;
            array[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
        }
        ByteBuffer bb = ByteBuffer.wrap(array);
        Bits$.MODULE$.shiftRight(bb, 8 - fragmentLength);
    }

    @Override
    public BigInteger getSignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1.>=(1)");
        }
        if (bitLengthFrom1 <= 64) {
            return BigInteger.valueOf(this.getSignedLong(bitLengthFrom1, finfo));
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
            int shift = 8 - fragmentLength;
            bytes[0] = (byte)((byte)(bytes[0] << shift) >> shift);
        }
        return new BigInteger(bytes);
    }

    @Override
    public BigInteger getUnsignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1.>=(1)");
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public final boolean isDefinedForLength(long nBits) {
        long newBitPos0b = this.bitPos0b() + nBits;
        if (MaybeULong$.MODULE$.isDefined$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            return false;
        }
        long newEndingBytePos0b = Bits$.MODULE$.roundUpBitToBytePosition(newBitPos0b);
        long moreBytesNeeded = newEndingBytePos0b - this.inputSource().position();
        return this.inputSource().areBytesAvailable(moreBytesNeeded);
    }

    @Override
    public final boolean hasData() {
        return this.isDefinedForLength(1L);
    }

    @Override
    public boolean skip(long nBits, FormatInfo finfo) {
        if (!this.isDefinedForLength(nBits)) {
            return false;
        }
        this.setBitPos0b(this.bitPos0b() + nBits);
        return true;
    }

    @Override
    public DataInputStream.Mark mark(String requestorID) {
        MarkState m = (MarkState)this.markPool().getFromPool(requestorID);
        m.assignFrom(this.cst());
        this.markStack().push((Object)m);
        this.inputSource().lockPosition(m.bytePos0b());
        return m;
    }

    private MarkState releaseUntilMark(DataInputStream.Mark mark) {
        if (this.markStack().isEmpty()) {
            throw Assert$.MODULE$.usageError("Usage error: InputSourceDataInputStream.this.markStack.isEmpty.unary_!");
        }
        if (mark == null) {
            throw Assert$.MODULE$.usageError("Usage error: mark.!=(null)");
        }
        MarkState current = (MarkState)this.markStack().pop();
        while (!this.markStack().isEmpty() && current != mark) {
            this.inputSource().releasePosition(current.bytePos0b());
            this.markPool().returnToPool(current);
            current = (MarkState)this.markStack().pop();
        }
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        return current;
    }

    @Override
    public void reset(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.cst().assignFrom(current);
        this.setBitPos0b(this.cst().bitPos0b());
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public void discard(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public long markPos() {
        return this.bitPos0b();
    }

    @Override
    public void resetPos(long m) {
        this.setBitPos0b(m);
    }

    public void validateFinalStreamState() {
        this.markPool().finalCheck();
    }

    @Override
    public final Object getSomeString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        return ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getSomeString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    private CharBuffer skipCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.skipCharBuffer = CharBuffer.allocate(32);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.skipCharBuffer;
    }

    public CharBuffer skipCharBuffer() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.skipCharBuffer$lzycompute();
        }
        return this.skipCharBuffer;
    }

    @Override
    public boolean skipChars(long nChars, FormatInfo finfo) {
        boolean skippedAllNChars;
        block2: {
            long remainingCharsToSkip;
            int numDecoded;
            long startingBitPos = this.bitPos0b();
            boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
            if (!aligned) {
                return false;
            }
            boolean keepGoing = true;
            for (remainingCharsToSkip = nChars; keepGoing && remainingCharsToSkip > 0L; remainingCharsToSkip -= (long)numDecoded) {
                long charsToSkip = Math.min(remainingCharsToSkip, (long)this.skipCharBuffer().capacity());
                this.skipCharBuffer().position(0);
                this.skipCharBuffer().limit((int)charsToSkip);
                BitsCharsetDecoder qual$1 = finfo.decoder();
                InputSourceDataInputStream x$1 = this;
                FormatInfo x$2 = finfo;
                CharBuffer x$3 = this.skipCharBuffer();
                LongBuffer x$4 = qual$1.decode$default$4();
                numDecoded = qual$1.decode(x$1, x$2, x$3, x$4);
                if (numDecoded != 0) continue;
                keepGoing = false;
            }
            boolean bl = skippedAllNChars = remainingCharsToSkip == 0L;
            if (skippedAllNChars) break block2;
            this.setBitPos0b(startingBitPos);
        }
        return skippedAllNChars;
    }

    @Override
    public boolean lookingAt(Matcher matcher, FormatInfo finfo) {
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            return false;
        }
        int regexMatchBufferLimit = finfo.tunable().initialRegexMatchLimitInCharacters();
        CharBuffer regexMatchBuffer = finfo.regexMatchBuffer();
        LongBuffer regexMatchBitPositionBuffer = finfo.regexMatchBitPositionBuffer();
        regexMatchBuffer.position(0);
        regexMatchBuffer.limit(0);
        regexMatchBitPositionBuffer.position(0);
        regexMatchBitPositionBuffer.limit(0);
        long startingBitPos = this.bitPos0b();
        boolean keepMatching = true;
        boolean isMatch = false;
        while (keepMatching) {
            regexMatchBuffer.position(regexMatchBuffer.limit());
            regexMatchBuffer.limit(regexMatchBufferLimit);
            regexMatchBitPositionBuffer.position(regexMatchBitPositionBuffer.limit());
            regexMatchBitPositionBuffer.limit(regexMatchBufferLimit);
            int numDecoded = finfo.decoder().decode(this, finfo, regexMatchBuffer, regexMatchBitPositionBuffer);
            boolean potentiallyMoreData = regexMatchBuffer.position() == regexMatchBuffer.limit();
            regexMatchBuffer.flip();
            regexMatchBitPositionBuffer.flip();
            if (numDecoded > 0) {
                matcher.reset(regexMatchBuffer);
                isMatch = matcher.lookingAt();
                boolean hitEnd = matcher.hitEnd();
                boolean requireEnd = matcher.requireEnd();
                if (potentiallyMoreData && (hitEnd || isMatch && requireEnd)) {
                    if (regexMatchBufferLimit == regexMatchBuffer.capacity()) {
                        keepMatching = false;
                        continue;
                    }
                    regexMatchBufferLimit = Math.min(regexMatchBufferLimit * 2, regexMatchBuffer.capacity());
                    continue;
                }
                keepMatching = false;
                continue;
            }
            keepMatching = false;
        }
        if (isMatch && matcher.end() != 0) {
            long endingBitPos = regexMatchBitPositionBuffer.get(matcher.end() - 1);
            this.setBitPos0b(endingBitPos);
        } else {
            this.setBitPos0b(startingBitPos);
        }
        return isMatch;
    }

    private InputSourceDataInputStreamCharIterator charIterator() {
        return this.charIterator;
    }

    @Override
    public DataInputStream.CharIterator asIteratorChar() {
        InputSourceDataInputStreamCharIterator ci = this.charIterator();
        ci.reset();
        return ci;
    }

    @Override
    public void setDebugging(boolean setting) {
        DataInputStreamImplMixin.setDebugging$(this, setting);
        this.inputSource().setDebugging(setting);
    }

    @Override
    public ByteBuffer pastData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        int bytesToRead = (int)Math.min(savedBytePosition, (long)nBytesRequested);
        long newBytePosition = savedBytePosition - (long)bytesToRead;
        this.inputSource().position(newBytePosition);
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer futureData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        boolean available = this.inputSource().areBytesAvailable(nBytesRequested);
        int bytesToRead = available ? nBytesRequested : (int)this.inputSource().knownBytesAvailable();
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    private static final byte calcNewByte$1(long curByte, long nxtByte, int curBitMask$1, int nxtBitMask$1, boolean isMSBF$1, int curShift$1, int nxtShift$1) {
        long curBits = curByte & (long)curBitMask$1;
        long nxtBits = nxtByte & (long)nxtBitMask$1;
        long newByte = isMSBF$1 ? curBits << curShift$1 | nxtBits >> nxtShift$1 : curBits >> curShift$1 | nxtBits << nxtShift$1;
        return Bits$.MODULE$.asSignedByte(newByte);
    }

    private final long buildLongFromArray$1(int numBytes$1) {
        long l = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
        for (int i = 1; i < numBytes$1; ++i) {
            l = l << 8 | (long)Bits$.MODULE$.asUnsignedByte(this.longArray()[i]);
        }
        return l;
    }

    public static final /* synthetic */ Object $anonfun$getSomeString$1(InputSourceDataInputStream $this, long nChars$1, FormatInfo finfo$1, long startingBitPos$1, LocalBufferMixin.LocalCharBuffer lcb) {
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$1);
        BitsCharsetDecoder qual$1 = finfo$1.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$1, x$3 = cb, x$4 = qual$1.decode$default$4());
        if (numDecoded > 0) {
            return Maybe$.MODULE$.apply((Object)cb.flip().toString());
        }
        $this.setBitPos0b(startingBitPos$1);
        return Maybe$.MODULE$.Nope();
    }

    public InputSourceDataInputStream(InputSource inputSource) {
        this.inputSource = inputSource;
        DataInputStream.$init$(this);
        DataStreamCommonImplMixin.$init$(this);
        LocalBufferMixin.$init$(this);
        DataInputStreamImplMixin.$init$(this);
        this.cst = new MarkState();
        this.markStack = new MStackOf();
        this.markPool = new MarkPool();
        this.longArray = new byte[8];
        this.charIterator = new InputSourceDataInputStreamCharIterator(this);
    }
}

