/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.grammar.primitives;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.daffodil.lib.api.WarnID;
import org.apache.daffodil.lib.exceptions.SavesErrorsAndWarnings;
import org.apache.daffodil.lib.util.Misc$;
import scala.Predef$;
import scala.collection.Seq;

public final class PatternChecker$ {
    public static PatternChecker$ MODULE$;

    static {
        new PatternChecker$();
    }

    public void checkPattern(String pattern, SavesErrorsAndWarnings context) {
        try {
            Pattern pat = Pattern.compile(pattern);
            Matcher m1 = pat.matcher("");
            Matcher m2 = pat.matcher("\ufffe");
            if (m1.matches() && m2.lookingAt() && m2.group().length() == 0) {
                String needCDATA = pattern.startsWith("(?x)") && !pattern.contains("\n") && pattern.contains("#") ? "\nMissing <![CDATA[...]]> around the regular expression.\nThis is required for free-form regular expression syntax with comments." : "";
                context.SDW((WarnID)WarnID.RegexPatternZeroLength$.MODULE$, "Regular expression pattern '%s'.\nThis pattern will match with zero length, so it can always match.%s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, needCDATA}));
            }
        }
        catch (PatternSyntaxException e) {
            throw context.SDE("Invalid regular expression pattern '%s'.\nReason: %s.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, Misc$.MODULE$.getSomeMessage((Throwable)e).get()}));
        }
    }

    private PatternChecker$() {
        MODULE$ = this;
    }
}

