/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.values;

import com.siemens.ct.exi.core.Constants;
import com.siemens.ct.exi.core.values.AbstractValue;
import com.siemens.ct.exi.core.values.IntegerValue;
import com.siemens.ct.exi.core.values.ValueType;

public class FloatValue
extends AbstractValue {
    protected final IntegerValue mantissa;
    protected final IntegerValue exponent;
    protected int slenMantissa = -1;
    public static IntegerValue FLOAT_SPECIAL_VALUES = IntegerValue.valueOf(-16384);
    public static IntegerValue FLOAT_NEGATIVE_INFINITY = IntegerValue.valueOf(-1);
    public static IntegerValue FLOAT_POSITIVE_INFINITY = IntegerValue.valueOf(1);
    public static IntegerValue FLOAT_NaN = IntegerValue.ZERO;
    protected Double f;

    public FloatValue(IntegerValue mantissa, IntegerValue exponent) {
        super(ValueType.FLOAT);
        if (IntegerValue.ZERO.equals(mantissa)) {
            if (!FLOAT_SPECIAL_VALUES.equals(exponent)) {
                exponent = IntegerValue.ZERO;
            }
        } else {
            long lm = mantissa.longValue();
            long le = exponent.longValue();
            boolean modified = false;
            while (lm % 10L == 0L) {
                lm /= 10L;
                ++le;
                modified = true;
            }
            if (modified) {
                mantissa = IntegerValue.valueOf(lm);
                exponent = IntegerValue.valueOf(le);
            }
        }
        if (FLOAT_SPECIAL_VALUES.equals(exponent) && !FLOAT_NEGATIVE_INFINITY.equals(mantissa) && !FLOAT_POSITIVE_INFINITY.equals(mantissa)) {
            mantissa = FLOAT_NaN;
        }
        this.mantissa = mantissa;
        this.exponent = exponent;
    }

    public FloatValue(long mantissa, long exponent) {
        this(IntegerValue.valueOf(mantissa), IntegerValue.valueOf(exponent));
    }

    public IntegerValue getMantissa() {
        return this.mantissa;
    }

    public IntegerValue getExponent() {
        return this.exponent;
    }

    public static FloatValue parse(String value) {
        try {
            long sExponent;
            long sMantissa;
            value = value.trim();
            if (value.length() == 0) {
                return null;
            }
            if (value.equals("INF")) {
                sMantissa = 1L;
                sExponent = -16384L;
            } else if (value.equals("-INF")) {
                sMantissa = -1L;
                sExponent = -16384L;
            } else if (value.equals("NaN")) {
                sMantissa = 0L;
                sExponent = -16384L;
            } else {
                char[] chars;
                char c;
                int indexE = value.indexOf(69);
                if (indexE == -1) {
                    indexE = value.indexOf(101);
                }
                boolean negative = (c = (chars = value.toCharArray())[0]) == '-';
                int lenMantissa = indexE == -1 ? chars.length : indexE;
                int startMantissa = negative || c == '+' ? 1 : 0;
                boolean decPoint = false;
                int decimalDigits = 0;
                sMantissa = 0L;
                sExponent = 0L;
                if (lenMantissa == 0) {
                    return null;
                }
                block12: for (int i = startMantissa; i < lenMantissa; ++i) {
                    c = chars[i];
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            sMantissa = 10L * sMantissa + (long)(c - 48);
                            if (!decPoint) continue block12;
                            ++decimalDigits;
                            continue block12;
                        }
                        case '.': {
                            if (decPoint) {
                                return null;
                            }
                            decPoint = true;
                            continue block12;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                if (sMantissa < 0L) {
                    if (negative) {
                        if (sMantissa != Long.MIN_VALUE) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if (negative) {
                    sMantissa = -1L * sMantissa;
                }
                boolean negativeExp = false;
                if (indexE != -1) {
                    block13: for (int i = indexE + 1; i < chars.length; ++i) {
                        c = chars[i];
                        switch (c) {
                            case '0': {
                                sExponent = 10L * sExponent;
                                continue block13;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                sExponent = 10L * sExponent + (long)(c - 48);
                                continue block13;
                            }
                            case '-': {
                                if (negativeExp) {
                                    return null;
                                }
                                negativeExp = true;
                                continue block13;
                            }
                            case '+': {
                                continue block13;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                }
                sExponent = negativeExp ? -1L * sExponent : sExponent;
                if (sMantissa < Long.MIN_VALUE || sMantissa > Long.MAX_VALUE || (sExponent -= (long)decimalDigits) < -16383L || sExponent > 16383L) {
                    return null;
                }
            }
            return new FloatValue(sMantissa, sExponent);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FloatValue parse(float f) {
        int sExponent;
        int sMantissa;
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            sMantissa = Float.isNaN(f) ? 0 : (f < 0.0f ? -1 : 1);
            sExponent = -16384;
        } else {
            sExponent = 0;
            while (f - (float)((int)f) != 0.0f) {
                f *= 10.0f;
                --sExponent;
            }
            sMantissa = (int)f;
        }
        return new FloatValue(sMantissa, sExponent);
    }

    public static FloatValue parse(double d) {
        long sExponent;
        long sMantissa;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            sMantissa = Double.isNaN(d) ? 0L : (d < 0.0 ? -1L : 1L);
            sExponent = -16384L;
        } else {
            sExponent = 0L;
            while (d - (double)((long)d) != 0.0) {
                d *= 10.0;
                --sExponent;
            }
            sMantissa = (long)d;
        }
        return new FloatValue(sMantissa, sExponent);
    }

    public Float toFloat() {
        if (this.f == null) {
            this.toDouble();
        }
        return Float.valueOf(this.f.floatValue());
    }

    public Double toDouble() {
        if (this.f == null) {
            if (this.exponent.equals(FLOAT_SPECIAL_VALUES)) {
                this.f = this.mantissa.equals(FLOAT_NEGATIVE_INFINITY) ? Double.valueOf(Double.NEGATIVE_INFINITY) : (this.mantissa.equals(FLOAT_POSITIVE_INFINITY) ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(Double.NaN));
            } else {
                long lMantissa = this.mantissa.longValue();
                long lExponent = this.exponent.longValue();
                this.f = (double)lMantissa * Math.pow(10.0, lExponent);
            }
        }
        return this.f;
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            if (this.exponent.equals(FLOAT_SPECIAL_VALUES)) {
                if (this.mantissa.equals(FLOAT_NEGATIVE_INFINITY)) {
                    this.slen = Constants.FLOAT_MINUS_INFINITY_CHARARRAY.length;
                } else if (this.mantissa.equals(FLOAT_POSITIVE_INFINITY)) {
                    this.slen = Constants.FLOAT_INFINITY_CHARARRAY.length;
                } else {
                    assert (this.mantissa.equals(FLOAT_NaN));
                    this.slen = Constants.FLOAT_NOT_A_NUMBER_CHARARRAY.length;
                }
            } else {
                this.slenMantissa = this.mantissa.getCharactersLength();
                this.slen = this.slenMantissa + 1 + this.exponent.getCharactersLength();
            }
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        if (this.exponent.equals(FLOAT_SPECIAL_VALUES)) {
            char[] a2copy;
            if (this.mantissa.equals(FLOAT_NEGATIVE_INFINITY)) {
                a2copy = Constants.FLOAT_MINUS_INFINITY_CHARARRAY;
            } else if (this.mantissa.equals(FLOAT_POSITIVE_INFINITY)) {
                a2copy = Constants.FLOAT_INFINITY_CHARARRAY;
            } else {
                assert (this.mantissa.equals(FLOAT_NaN));
                a2copy = Constants.FLOAT_NOT_A_NUMBER_CHARARRAY;
            }
            System.arraycopy(a2copy, 0, cbuffer, offset, a2copy.length);
        } else {
            this.mantissa.getCharacters(cbuffer, offset);
            offset += this.slenMantissa;
            cbuffer[offset++] = 69;
            this.exponent.getCharacters(cbuffer, offset);
        }
    }

    public String toString() {
        if (this.exponent.equals(FLOAT_SPECIAL_VALUES)) {
            if (this.mantissa.equals(FLOAT_NEGATIVE_INFINITY)) {
                return "-INF";
            }
            if (this.mantissa.equals(FLOAT_POSITIVE_INFINITY)) {
                return "INF";
            }
            assert (this.mantissa.equals(FLOAT_NaN));
            return "NaN";
        }
        char[] cbuffer = new char[this.getCharactersLength()];
        this.getCharacters(cbuffer, 0);
        return new String(cbuffer);
    }

    public String toString(char[] cbuffer, int offset) {
        if (this.exponent.equals(FLOAT_SPECIAL_VALUES)) {
            if (this.mantissa.equals(FLOAT_NEGATIVE_INFINITY)) {
                return "-INF";
            }
            if (this.mantissa.equals(FLOAT_POSITIVE_INFINITY)) {
                return "INF";
            }
            assert (this.mantissa.equals(FLOAT_NaN));
            return "NaN";
        }
        return super.toString(cbuffer, offset);
    }

    static long multiply(long a, long b) throws ArithmeticException {
        long result = a * b;
        if (a != 0L && result / a != b) {
            throw new ArithmeticException("Overflow");
        }
        return result;
    }

    protected final boolean _equals(FloatValue o) {
        if (this.mantissa == o.mantissa && this.exponent == o.exponent) {
            return true;
        }
        if (this.mantissa.equals(o.mantissa) && this.exponent.equals(o.exponent)) {
            return true;
        }
        long tExponent = this.exponent.longValue();
        long oExponent = o.exponent.longValue();
        long tMantissa = this.mantissa.longValue();
        long oMantissa = o.mantissa.longValue();
        try {
            if (tExponent > oExponent) {
                long diff = tExponent - oExponent;
                int i = 0;
                while ((long)i < diff) {
                    tMantissa = FloatValue.multiply(tMantissa, 10L);
                    ++i;
                }
            } else {
                long diff = oExponent - tExponent;
                int i = 0;
                while ((long)i < diff) {
                    oMantissa = FloatValue.multiply(oMantissa, 10L);
                    ++i;
                }
            }
            return tMantissa == oMantissa;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof FloatValue) {
            return this._equals((FloatValue)o);
        }
        FloatValue fv = FloatValue.parse(o.toString());
        return fv == null ? false : this._equals(fv);
    }

    public int hashCode() {
        return this.mantissa.hashCode() ^ this.exponent.hashCode();
    }
}

