/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSize;
import org.apache.daffodil.io.processors.charset.DecoderInfo;
import org.apache.daffodil.io.processors.charset.EncoderInfo;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MaybeInt;
import org.apache.daffodil.lib.util.MaybeInt$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4qa\u0003\u0007\u0011\u0002\u0007\u0005\u0011\u0004C\u0003%\u0001\u0011\u0005Q\u0005\u0003\u0005*\u0001!\u0015\r\u0011\"\u0003+\u0011!Q\u0004\u0001#b\u0001\n\u0013Y\u0004\"\u0002!\u0001\t\u0013\t\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002,\u0001\t\u00039\u0006\"B-\u0001\t\u0003Q\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00022\u0001\t\u000b\u0019\u0007\"\u0002<\u0001\t\u000b9(aE#oG>$WM\u001d#fG>$WM]'jq&t'BA\u0007\u000f\u0003\u001d\u0019\u0007.\u0019:tKRT!a\u0004\t\u0002\u0015A\u0014xnY3tg>\u00148O\u0003\u0002\u0012%\u0005\u0011\u0011n\u001c\u0006\u0003'Q\t\u0001\u0002Z1gM>$\u0017\u000e\u001c\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\tj\u0011\u0001E\u0005\u0003GA\u0011\u0001\u0003T8dC2\u0014UO\u001a4fe6K\u00070\u001b8\u0002\r\u0011Jg.\u001b;%)\u00051\u0003CA\u000e(\u0013\tACD\u0001\u0003V]&$\u0018\u0001\u00043fG>$WM]\"bG\",W#A\u0016\u0011\t1\n4gN\u0007\u0002[)\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#a\u0002%bg\"l\u0015\r\u001d\t\u0003iUj\u0011\u0001D\u0005\u0003m1\u00111BQ5ug\u000eC\u0017M]:fiB\u0011A\u0007O\u0005\u0003s1\u00111\u0002R3d_\u0012,'/\u00138g_\u0006aQM\\2pI\u0016\u00148)Y2iKV\tA\b\u0005\u0003-cMj\u0004C\u0001\u001b?\u0013\tyDBA\u0006F]\u000e|G-\u001a:J]\u001a|\u0017a\u00033fe&4\u0018\r^5p]N$\"AQ(\u0011\tm\u0019U\tS\u0005\u0003\tr\u0011a\u0001V;qY\u0016\u0014\u0004CA\u000eG\u0013\t9EDA\u0002J]R\u0004\"!S'\u000e\u0003)S!AL&\u000b\u00051\u0013\u0012a\u00017jE&\u0011aJ\u0013\u0002\t\u001b\u0006L(-Z%oi\")Q\u0002\u0002a\u0001g\u0005Qq-\u001a;EK\u000e|G-\u001a:\u0015\u0005I+\u0006C\u0001\u001bT\u0013\t!FB\u0001\nCSR\u001c8\t[1sg\u0016$H)Z2pI\u0016\u0014\b\"B\u0007\u0006\u0001\u0004\u0019\u0014AD4fi\u0012+7m\u001c3fe&sgm\u001c\u000b\u0003oaCQ!\u0004\u0004A\u0002M\n!bZ3u\u000b:\u001cw\u000eZ3s)\tYf\f\u0005\u000259&\u0011Q\f\u0004\u0002\u0013\u0005&$8o\u00115beN,G/\u00128d_\u0012,'\u000fC\u0003\u000e\u000f\u0001\u00071'\u0001\bhKR,enY8eKJLeNZ8\u0015\u0005u\n\u0007\"B\u0007\t\u0001\u0004\u0019\u0014\u0001\u00047f]\u001e$\b.\u00138CSR\u001cHc\u00013hiB\u00111$Z\u0005\u0003Mr\u0011A\u0001T8oO\")\u0001.\u0003a\u0001S\u0006\u00191\u000f\u001e:\u0011\u0005)\fhBA6p!\taG$D\u0001n\u0015\tq\u0007$\u0001\u0004=e>|GOP\u0005\u0003ar\ta\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000f\b\u0005\u0006k&\u0001\raM\u0001\fE&$8o\u00115beN,G/\u0001\bueVt7-\u0019;f)>\u0014\u0015\u000e^:\u0015\t%D\u0018P\u001f\u0005\u0006Q*\u0001\r!\u001b\u0005\u0006k*\u0001\ra\r\u0005\u0006w*\u0001\r\u0001Z\u0001\u0006]\nKGo\u001d")
public interface EncoderDecoderMixin
extends LocalBufferMixin {
    public static /* synthetic */ HashMap org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache$(EncoderDecoderMixin $this) {
        return $this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache();
    }

    default public HashMap<BitsCharset, DecoderInfo> org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache() {
        return new HashMap<BitsCharset, DecoderInfo>();
    }

    public static /* synthetic */ HashMap org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache$(EncoderDecoderMixin $this) {
        return $this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache();
    }

    default public HashMap<BitsCharset, EncoderInfo> org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache() {
        return new HashMap<BitsCharset, EncoderInfo>();
    }

    private Tuple2<Object, MaybeInt> derivations(BitsCharset charset) {
        Tuple2 tuple2;
        BitsCharset bitsCharset = charset;
        if (bitsCharset instanceof BitsCharsetNonByteSize) {
            BitsCharsetNonByteSize bitsCharsetNonByteSize = (BitsCharsetNonByteSize)bitsCharset;
            int encodingMandatoryAlignmentInBits = 1;
            long maybeCharWidthInBits = MaybeInt$.MODULE$.apply(bitsCharsetNonByteSize.bitWidthOfACodeUnit());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
        } else {
            int encodingMandatoryAlignmentInBits = 8;
            BitsCharsetEncoder encoder = charset.newEncoder();
            float maxBytes = encoder.maxBytesPerChar();
            if (maxBytes == encoder.averageBytesPerChar()) {
                long maybeCharWidthInBits = MaybeInt$.MODULE$.apply((int)(maxBytes * (float)8));
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            } else {
                long maybeCharWidthInBits = MaybeInt$.MODULE$.Nope();
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            }
        }
        Tuple2 tuple = tuple2;
        return tuple;
    }

    public static /* synthetic */ BitsCharsetDecoder getDecoder$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getDecoder(charset);
    }

    default public BitsCharsetDecoder getDecoder(BitsCharset charset) {
        return this.getDecoderInfo(charset).coder();
    }

    public static /* synthetic */ DecoderInfo getDecoderInfo$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getDecoderInfo(charset);
    }

    default public DecoderInfo getDecoderInfo(BitsCharset charset) {
        Object object;
        DecoderInfo entry = this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache().get(charset);
        if (entry == null) {
            BitsCharsetDecoder coder = charset.newDecoder();
            Tuple2<Object, MaybeInt> tuple2 = this.derivations(charset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int encodingMandatoryAlignmentInBits = tuple2._1$mcI$sp();
            long maybeCharWidthInBits = ((MaybeInt)tuple2._2()).__v();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            int encodingMandatoryAlignmentInBits2 = tuple22._1$mcI$sp();
            long maybeCharWidthInBits2 = ((MaybeInt)tuple22._2()).__v();
            entry = new DecoderInfo(coder, encodingMandatoryAlignmentInBits2, maybeCharWidthInBits2);
            object = this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache().put(charset, entry);
        } else {
            object = BoxedUnit.UNIT;
        }
        return entry;
    }

    public static /* synthetic */ BitsCharsetEncoder getEncoder$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getEncoder(charset);
    }

    default public BitsCharsetEncoder getEncoder(BitsCharset charset) {
        return this.getEncoderInfo(charset).coder();
    }

    public static /* synthetic */ EncoderInfo getEncoderInfo$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getEncoderInfo(charset);
    }

    default public EncoderInfo getEncoderInfo(BitsCharset charset) {
        Object object;
        EncoderInfo entry = this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache().get(charset);
        if (entry == null) {
            BitsCharsetEncoder coder = charset.newEncoder();
            BitsCharsetEncoder replacingCoder = charset.newEncoder();
            BitsCharsetEncoder reportingCoder = charset.newEncoder();
            replacingCoder.onMalformedInput(CodingErrorAction.REPLACE);
            replacingCoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            reportingCoder.onMalformedInput(CodingErrorAction.REPORT);
            reportingCoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            Tuple2<Object, MaybeInt> tuple2 = this.derivations(charset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int encodingMandatoryAlignmentInBits = tuple2._1$mcI$sp();
            long maybeCharWidthInBits = ((MaybeInt)tuple2._2()).__v();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            int encodingMandatoryAlignmentInBits2 = tuple22._1$mcI$sp();
            long maybeCharWidthInBits2 = ((MaybeInt)tuple22._2()).__v();
            entry = new EncoderInfo(coder, replacingCoder, reportingCoder, encodingMandatoryAlignmentInBits2, maybeCharWidthInBits2);
            object = this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache().put(charset, entry);
        } else {
            object = BoxedUnit.UNIT;
        }
        return entry;
    }

    public static /* synthetic */ long lengthInBits$(EncoderDecoderMixin $this, String str, BitsCharset bitsCharset) {
        return $this.lengthInBits(str, bitsCharset);
    }

    default public long lengthInBits(String str, BitsCharset bitsCharset) {
        if (str.length() == 0) {
            return 0L;
        }
        long mew = bitsCharset.maybeFixedWidth();
        if (MaybeInt$.MODULE$.isDefined$extension(mew)) {
            int w = MaybeInt$.MODULE$.get$extension(mew);
            return w * str.length();
        }
        return BoxesRunTime.unboxToLong((Object)this.withLocalByteBuffer().apply((Function1 & Serializable & scala.Serializable)lbb -> BoxesRunTime.boxToLong((long)EncoderDecoderMixin.$anonfun$lengthInBits$1(this, str, bitsCharset, lbb))));
    }

    public static /* synthetic */ String truncateToBits$(EncoderDecoderMixin $this, String str, BitsCharset bitsCharset, long nBits) {
        return $this.truncateToBits(str, bitsCharset, nBits);
    }

    default public String truncateToBits(String str, BitsCharset bitsCharset, long nBits) {
        if (nBits < 0L) {
            throw Assert$.MODULE$.abort("Usage error: nBits.>=(0)");
        }
        if (str.length() == 0) {
            return str;
        }
        if (nBits == 0L) {
            return "";
        }
        long mew = bitsCharset.maybeFixedWidth();
        if (MaybeInt$.MODULE$.isDefined$extension(mew)) {
            int w = MaybeInt$.MODULE$.get$extension(mew);
            long nChars = nBits / (long)w;
            if (nChars > (long)str.length()) {
                return str;
            }
            return str.substring(0, (int)nChars);
        }
        return (String)this.withLocalByteBuffer().apply((Function1 & Serializable & scala.Serializable)lbb -> {
            long nBytes = nBits / 8L;
            ByteBuffer bb = (ByteBuffer)lbb.getBuf(nBytes);
            return (String)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)cbb -> {
                String string;
                CoderResult cr;
                CharBuffer cb = (CharBuffer)cbb.getBuf(str.length());
                cb.append(str);
                cb.flip();
                BitsCharsetEncoder encoder = this.getEncoder(bitsCharset);
                encoder.reset();
                CoderResult coderResult = cr = encoder.encode(cb, bb, true);
                CoderResult coderResult2 = CoderResult.UNDERFLOW;
                CoderResult coderResult3 = coderResult;
                if (!(coderResult2 != null ? !coderResult2.equals(coderResult3) : coderResult3 != null)) {
                    string = str;
                } else {
                    CoderResult coderResult4 = CoderResult.OVERFLOW;
                    CoderResult coderResult5 = coderResult;
                    if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                        String truncString;
                        cb.flip();
                        string = truncString = cb.toString();
                    } else {
                        if (cr.isMalformed() || cr.isUnmappable()) {
                            cr.throwException();
                            throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                        }
                        throw new MatchError((Object)coderResult);
                    }
                }
                String truncString = string;
                return truncString;
            });
        });
    }

    public static /* synthetic */ long $anonfun$lengthInBits$2(EncoderDecoderMixin $this, String str$1, BitsCharset bitsCharset$1, LocalBufferMixin.LocalByteBuffer lbb$1, LocalBufferMixin.LocalCharBuffer cbb) {
        CoderResult cr;
        CharBuffer cb = (CharBuffer)cbb.getBuf(str$1.length());
        cb.append(str$1);
        cb.flip();
        BitsCharsetEncoder encoder = $this.getEncoder(bitsCharset$1);
        encoder.reset();
        long nBytes = (long)package$.MODULE$.ceil((double)((float)str$1.length() * encoder.maxBytesPerChar()));
        ByteBuffer bb = (ByteBuffer)lbb$1.getBuf(nBytes);
        CoderResult coderResult = cr = encoder.encode(cb, bb, true);
        CoderResult coderResult2 = CoderResult.UNDERFLOW;
        CoderResult coderResult3 = coderResult;
        if (!(coderResult2 != null ? !coderResult2.equals(coderResult3) : coderResult3 != null)) {
        } else {
            CoderResult coderResult4 = CoderResult.OVERFLOW;
            CoderResult coderResult5 = coderResult;
            if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                throw Assert$.MODULE$.invariantFailed("byte buffer wasn't big enough to accomodate the string");
            }
            if (cr.isMalformed()) {
                cr.throwException();
            } else if (cr.isUnmappable()) {
                cr.throwException();
            } else {
                throw new MatchError((Object)coderResult);
            }
        }
        bb.flip();
        int lengthInBytes = bb.remaining();
        return lengthInBytes * 8;
    }

    public static /* synthetic */ long $anonfun$lengthInBits$1(EncoderDecoderMixin $this, String str$1, BitsCharset bitsCharset$1, LocalBufferMixin.LocalByteBuffer lbb) {
        return BoxesRunTime.unboxToLong((Object)$this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)cbb -> BoxesRunTime.boxToLong((long)EncoderDecoderMixin.$anonfun$lengthInBits$2($this, str$1, bitsCharset$1, lbb, cbb))));
    }

    public static void $init$(EncoderDecoderMixin $this) {
    }
}

