/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.daffodil.io.ByteArrayOutputStreamWithGetBuf;
import org.apache.daffodil.io.FileIOException;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!B\u000e\u001d\u0001q!\u0003\u0002\u0004\u0017\u0001\t\u0003\u0005)Q!A!\u0002\u0013q\u0003\u0002\u0004\u001b\u0001\t\u0003\u0005)Q!A!\u0002\u0013)\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b%\u0003A\u0011\u0001&\t\u000fI\u0003\u0001\u0019!C\u0001'\"9q\u000b\u0001a\u0001\n\u0003A\u0006B\u00020\u0001A\u0003&A\u000bC\u0004`\u0001\u0001\u0007I\u0011\u00011\t\u000f\t\u0004\u0001\u0019!C\u0001G\"1Q\r\u0001Q!\n\u0005D\u0001B\u001a\u0001\t\u0006\u0004%\ta\u0015\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0011\u001dI\u0007\u00011A\u0005\u0002)Da\u0001\u001c\u0001!B\u0013q\u0003bB7\u0001\u0001\u0004%\tA\u001c\u0005\b_\u0002\u0001\r\u0011\"\u0001q\u0011\u0019\u0011\b\u0001)Q\u0005K!)1\u000f\u0001C\u0005i\")1\u0010\u0001C!y\"11\u0010\u0001C!\u0003\u0017Aaa\u001f\u0001\u0005B\u0005u\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002H\u0001!\t%!\u0013\u00037\tKH/Z!se\u0006LxJ\u001d$jY\u0016|U\u000f\u001e9viN#(/Z1n\u0015\tib$\u0001\u0002j_*\u0011q\u0004I\u0001\tI\u00064gm\u001c3jY*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h'\t\u0001Q\u0005\u0005\u0002'U5\tqE\u0003\u0002\u001eQ)\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016(\u00051yU\u000f\u001e9viN#(/Z1n\u0003!{'o\u001a\u0013ba\u0006\u001c\u0007.\u001a\u0013eC\u001a4w\u000eZ5mI%|GEQ=uK\u0006\u0013(/Y=Pe\u001aKG.Z(viB,Ho\u0015;sK\u0006lG\u0005J7bq\n+hMZ3s'&TX-\u00138CsR,7o\u0001\u0001\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\t1{gnZ\u0001@_J<G%\u00199bG\",G\u0005Z1gM>$\u0017\u000e\u001c\u0013j_\u0012\u0012\u0015\u0010^3BeJ\f\u0017p\u0014:GS2,w*\u001e;qkR\u001cFO]3b[\u0012\"C/Z7q\t&\u0014\b+\u0019;i!\t1c'\u0003\u00028O\t!a)\u001b7f\u0003Ei\u0017-\u001f2f\u000bbL7\u000f^5oO\u001aKG.\u001a\t\u0004u}\nU\"A\u001e\u000b\u0005qj\u0014\u0001B;uS2T!A\u0010\u0010\u0002\u00071L'-\u0003\u0002Aw\t)Q*Y=cKB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005M&dWM\u0003\u0002GQ\u0005\u0019a.[8\n\u0005!\u001b%\u0001\u0002)bi\"\fa\u0001P5oSRtD\u0003B&N\u001fF\u0003\"\u0001\u0014\u0001\u000e\u0003qAQA\u0014\u0003A\u00029\nA#\\1y\u0005V4g-\u001a:TSj,\u0017J\u001c\"zi\u0016\u001c\b\"\u0002)\u0005\u0001\u0004)\u0014a\u0003;f[B$\u0015N\u001d)bi\"DQ\u0001\u000f\u0003A\u0002e\na![:GS2,W#\u0001+\u0011\u0005=*\u0016B\u0001,1\u0005\u001d\u0011un\u001c7fC:\f!\"[:GS2,w\fJ3r)\tIF\f\u0005\u000205&\u00111\f\r\u0002\u0005+:LG\u000fC\u0004^\r\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0013'A\u0004jg\u001aKG.\u001a\u0011\u0002\u00135\f\u0017PY3GS2,W#A1\u0011\u0007izT'A\u0007nCf\u0014WMR5mK~#S-\u001d\u000b\u00033\u0012Dq!X\u0005\u0002\u0002\u0003\u0007\u0011-\u0001\u0006nCf\u0014WMR5mK\u0002\n!\"[:UK6\u0004h)\u001b7f\u0003\u0019q')\u001f;fgV\ta&\u0001\u0006o\u0005f$Xm]0%KF$\"!W6\t\u000fuk\u0011\u0011!a\u0001]\u00059aNQ=uKN\u0004\u0013AB:ue\u0016\fW.F\u0001&\u0003)\u0019HO]3b[~#S-\u001d\u000b\u00033FDq!\u0018\t\u0002\u0002\u0003\u0007Q%A\u0004tiJ,\u0017-\u001c\u0011\u0002\u0017\rDWmY6Ck\u001a4WM\u001d\u000b\u00033VDQA\u001e\nA\u00029\nQ\u0002\\3oORD\u0017J\u001c\"zi\u0016\u001c\bF\u0001\ny!\ty\u00130\u0003\u0002{a\t1\u0011N\u001c7j]\u0016\fQa\u001e:ji\u0016$\"!W?\t\u000by\u001c\u0002\u0019A@\u0002\u0003\t\u0004RaLA\u0001\u0003\u000bI1!a\u00011\u0005\u0015\t%O]1z!\ry\u0013qA\u0005\u0004\u0003\u0013\u0001$\u0001\u0002\"zi\u0016$r!WA\u0007\u0003\u001f\tI\u0002C\u0003\u007f)\u0001\u0007q\u0010C\u0004\u0002\u0012Q\u0001\r!a\u0005\u0002\u0007=4g\rE\u00020\u0003+I1!a\u00061\u0005\rIe\u000e\u001e\u0005\b\u00037!\u0002\u0019AA\n\u0003\raWM\u001c\u000b\u00043\u0006}\u0001B\u0002@\u0016\u0001\u0004\t\u0019\"A\u0003dY>\u001cX\rF\u0001Z\u0003\u00199W\r\u001e\"vMR\tq0A\u0004hKR4\u0015\u000e\\3\u0016\u0003U\nq\u0001[3y\tVl\u0007/\u0006\u0002\u00022A!\u00111GA!\u001d\u0011\t)$!\u0010\u0011\u0007\u0005]\u0002'\u0004\u0002\u0002:)\u0019\u00111H\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u0004M\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0013Q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}\u0002'\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0004")
public class ByteArrayOrFileOutputStream
extends OutputStream {
    private boolean isTempFile;
    public final long org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes;
    public final File org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath;
    private Object maybeExistingFile;
    private boolean isFile;
    private Object maybeFile;
    private long nBytes;
    private OutputStream stream;
    private volatile boolean bitmap$0;

    public boolean isFile() {
        return this.isFile;
    }

    public void isFile_$eq(boolean x$1) {
        this.isFile = x$1;
    }

    public Object maybeFile() {
        return this.maybeFile;
    }

    public void maybeFile_$eq(Object x$1) {
        this.maybeFile = x$1;
    }

    private boolean isTempFile$lzycompute() {
        ByteArrayOrFileOutputStream byteArrayOrFileOutputStream = this;
        synchronized (byteArrayOrFileOutputStream) {
            if (!this.bitmap$0) {
                this.isTempFile = !Maybe$.MODULE$.isDefined$extension(this.maybeExistingFile) && this.isFile();
                this.bitmap$0 = true;
            }
        }
        this.maybeExistingFile = null;
        return this.isTempFile;
    }

    public boolean isTempFile() {
        if (!this.bitmap$0) {
            return this.isTempFile$lzycompute();
        }
        return this.isTempFile;
    }

    public long nBytes() {
        return this.nBytes;
    }

    public void nBytes_$eq(long x$1) {
        this.nBytes = x$1;
    }

    public OutputStream stream() {
        return this.stream;
    }

    public void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    private void checkBuffer(long lengthInBytes) {
        if (!this.isFile() && this.nBytes() + lengthInBytes > this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes) {
            BoxedUnit boxedUnit;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("Switching to file based output stream. If this is performance critical, you may want to consider re-organizing your schema to avoid this if possible.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.maybeFile_$eq(this.liftedTree1$1());
            FileOutputStream newStream = new FileOutputStream((File)Maybe$.MODULE$.get$extension(this.maybeFile()));
            this.stream().flush();
            ((ByteArrayOutputStreamWithGetBuf)this.stream()).writeTo(newStream);
            this.stream_$eq(newStream);
            this.isFile_$eq(true);
            return;
        }
        this.nBytes_$eq(this.nBytes() + lengthInBytes);
    }

    @Override
    public void write(byte[] b) {
        this.checkBuffer(b.length);
        this.stream().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkBuffer(len);
        this.stream().write(b, off, len);
    }

    @Override
    public void write(int b) {
        this.checkBuffer(1L);
        this.stream().write(b);
    }

    @Override
    public void close() {
        this.stream().close();
    }

    public byte[] getBuf() {
        if (this.isFile()) {
            throw Assert$.MODULE$.abort2("Usage error: Attempted to call getBuf on FileOutputStream", "ByteArrayOrFileOutputStream.this.isFile.unary_!");
        }
        return ((ByteArrayOutputStreamWithGetBuf)this.stream()).getBuf();
    }

    public File getFile() {
        return (File)Maybe$.MODULE$.get$extension(this.maybeFile());
    }

    public String hexDump() {
        if (this.isFile()) {
            return ((File)Maybe$.MODULE$.get$extension(this.maybeFile())).toString();
        }
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (int)this.nBytes() - 1).map((Function1 & Serializable & scala.Serializable)i -> ByteArrayOrFileOutputStream.$anonfun$hexDump$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public String toString() {
        return this.hexDump();
    }

    private final /* synthetic */ Object liftedTree1$1() {
        Object object;
        try {
            File file = File.createTempFile("daffodil-", ".tmp", this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath);
            file.deleteOnExit();
            object = Maybe$.MODULE$.apply((Object)file);
        }
        catch (Exception e) {
            throw new FileIOException(new StringOps(Predef$.MODULE$.augmentString("Unable to create temporary file in %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath.getPath(), e.getMessage()})));
        }
        return object;
    }

    public static final /* synthetic */ String $anonfun$hexDump$1(ByteArrayOrFileOutputStream $this, int i) {
        return new StringOps(Predef$.MODULE$.augmentString("%2x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)($this.getBuf()[i] & 0xFF))}));
    }

    public ByteArrayOrFileOutputStream(long maxBufferSizeInBytes, File tempDirPath, Object maybeExistingFile) {
        this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes = maxBufferSizeInBytes;
        this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath = tempDirPath;
        this.maybeExistingFile = maybeExistingFile;
        this.isFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile);
        this.maybeFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile) ? Maybe$.MODULE$.apply((Object)((Path)Maybe$.MODULE$.get$extension(maybeExistingFile)).toFile()) : Maybe$.MODULE$.Nope();
        this.nBytes = 0L;
        this.stream = new ByteArrayOutputStreamWithGetBuf();
    }
}

