/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors;

import com.ibm.icu.util.ULocale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.cookers.Converter;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.ThrowsSDE;
import scala.Predef$;
import scala.collection.Seq;

public final class LocaleConverter$
implements Converter<String, ULocale> {
    public static LocaleConverter$ MODULE$;
    private final String regex;
    private final Pattern localePattern;

    static {
        new LocaleConverter$();
    }

    public Object convertRuntime(Object b, ThrowsSDE context, boolean forUnparse) {
        return Converter.convertRuntime$((Converter)this, (Object)b, (ThrowsSDE)context, (boolean)forUnparse);
    }

    public Object convertConstant(Object b, ThrowsSDE context, boolean forUnparse) {
        return Converter.convertConstant$((Converter)this, (Object)b, (ThrowsSDE)context, (boolean)forUnparse);
    }

    public String regex() {
        return this.regex;
    }

    public Pattern localePattern() {
        return this.localePattern;
    }

    public ULocale convert(String b, ThrowsSDE context, boolean forUnparse) {
        Matcher m = this.localePattern().matcher(b);
        if (m.matches()) {
            String canonicalCalLang = ULocale.canonicalize((String)b);
            if (canonicalCalLang == null) {
                throw Assert$.MODULE$.abort("Invariant broken: canonicalCalLang.ne(null)");
            }
            ULocale l = new ULocale(canonicalCalLang);
            return l;
        }
        throw context.schemaDefinitionError("dfdl:calendarLanguage property syntax error. Must match '%s' (ex: 'en_us' or 'de_1996'), but was '%s'.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.regex(), b}));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LocaleConverter$() {
        MODULE$ = this;
        Converter.$init$((Converter)this);
        this.regex = "([A-Za-z]{1,8}([-_][A-Za-z0-9]{1,8})*)";
        this.localePattern = Pattern.compile(this.regex());
    }
}

