/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.RegexLimitingStream$;
import org.apache.daffodil.io.StreamIterator;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0012$\u00011B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A1\t\u0001B\u0001B\u0003%a\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B)\u0001\t\u0003\u0011\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u00079\u0002\u0001\u000b\u0011B\u0017\t\u000fu\u0003!\u0019!C\u0005=\"1A\r\u0001Q\u0001\n}Cq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004h\u0001\u0001\u0006I!\u0014\u0005\bQ\u0002\u0011\r\u0011\"\u0003g\u0011\u0019I\u0007\u0001)A\u0005\u001b\"9!\u000e\u0001b\u0001\n\u0013q\u0006BB6\u0001A\u0003%q\fC\u0004m\u0001\t\u0007I\u0011B7\t\rU\u0004\u0001\u0015!\u0003o\u0011\u001d1\bA1A\u0005\n\u0019Daa\u001e\u0001!\u0002\u0013i\u0005\u0002\u0003=\u0001\u0011\u000b\u0007I\u0011B=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011Q\u0001\u0001\u0005B\u0005\r\u0001bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'A\u0011\"a\u0007\u0001\u0001\u0004%I!!\b\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003+Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002<\u0001!I!!\u0010\b\u0013\u0005=3%!A\t\u0002\u0005Ec\u0001\u0003\u0012$\u0003\u0003E\t!a\u0015\t\rE{B\u0011AA.\u0011%\tifHI\u0001\n\u0003\tyFA\nSK\u001e,\u0007\u0010T5nSRLgnZ*ue\u0016\fWN\u0003\u0002%K\u0005\u0011\u0011n\u001c\u0006\u0003M\u001d\n\u0001\u0002Z1gM>$\u0017\u000e\u001c\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00183\u001b\u0005y#B\u0001\u00131\u0015\u0005\t\u0014\u0001\u00026bm\u0006L!aM\u0018\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\fS:\u0004X\u000f^*ue\u0016\fW.A\tsK\u001e,\u0007PR8s\t\u0016d\u0017.\\5uKJ\u0004\"a\u000e!\u000f\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e,\u0003\u0019a$o\\8u})\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyD(A\u000fnCbLW.^7MK:<G\u000f\u001b#fY&l\u0017\u000e^3s\u000bb\fW\u000e\u001d7f\u0003\u001d\u0019\u0007.\u0019:tKR\u0004\"A\u0012&\u000e\u0003\u001dS!\u0001\u0012%\u000b\u0005%\u0003\u0014a\u00018j_&\u00111j\u0012\u0002\b\u0007\"\f'o]3u\u0003=!\u0018M]4fi\u000eCWO\\6TSj,\u0007C\u0001(P\u001b\u0005a\u0014B\u0001)=\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\rM+fk\u0016-Z!\t!\u0006!D\u0001$\u0011\u0015!d\u00011\u0001.\u0011\u0015)d\u00011\u00017\u0011\u0015\u0019e\u00011\u00017\u0011\u0015!e\u00011\u0001F\u0011\u001dae\u0001%AA\u00025\u000b!!\u001b8\u0016\u00035\n1!\u001b8!\u0003Ii\u0017\r\u001f#fY&l\u0017\u000e^3s\u0013:D\u0004(N\u001d\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0019\u0002\t1\fgnZ\u0005\u0003\u0003\u0006\f1#\\1y\t\u0016d\u0017.\\5uKJLe\u000e\u000f\u001d6s\u0001\n!#\\1y\t\u0016d\u0017.\\5uKJdUM\\4uQV\tQ*A\nnCb$U\r\\5nSR,'\u000fT3oORD\u0007%A\u0005dQVt7nU5{K\u0006Q1\r[;oWNK'0\u001a\u0011\u0002\u000bI,w-\u001a=\u0002\rI,w-\u001a=!\u0003\u001d\u0001\u0018\r\u001e;fe:,\u0012A\u001c\t\u0003_Nl\u0011\u0001\u001d\u0006\u0003UFT!A\u001d\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003iB\u0014q\u0001U1ui\u0016\u0014h.\u0001\u0005qCR$XM\u001d8!\u00031awn\\6BQ\u0016\fG-T1y\u00035awn\\6BQ\u0016\fG-T1yA\u0005I1\r[1sg&#XM]\u000b\u0002uB\u0019Ak_?\n\u0005q\u001c#AD*ue\u0016\fW.\u0013;fe\u0006$xN\u001d\t\u0003\u001dzL!a \u001f\u0003\t\rC\u0017M]\u0001\u0005e\u0016\fG\rF\u0001N\u0003%\tg/Y5mC\ndW-A\u0003dY>\u001cX\r\u0006\u0002\u0002\fA\u0019a*!\u0004\n\u0007\u0005=AH\u0001\u0003V]&$\u0018\u0001\u00048p\u001b>\u0014Xm\u00115v].\u001cXCAA\u000b!\rq\u0015qC\u0005\u0004\u00033a$a\u0002\"p_2,\u0017M\\\u0001\u0011]>luN]3DQVt7n]0%KF$B!a\u0003\u0002 !I\u0011\u0011\u0005\u000e\u0002\u0002\u0003\u0007\u0011QC\u0001\u0004q\u0012\n\u0014!\u00048p\u001b>\u0014Xm\u00115v].\u001c\b%\u0001\u0004dQVt7n]\u000b\u0003\u0003S\u0001R!a\u000b\u00026YrA!!\f\u000229\u0019\u0011(a\f\n\u0003uJ1!a\r=\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000e\u0002:\t11\u000b\u001e:fC6T1!a\r=\u0003%\u0019\u0007.Z2l'\u000e\fg\u000eF\u0003N\u0003\u007f\t\u0019\u0005\u0003\u0004\u0002Bu\u0001\rAN\u0001\f[\u0006$8\r[*ue&tw\rC\u0004\u0002Fu\u0001\r!a\u0012\u0002\u000fM\u001c\u0017M\u001c8feB!\u0011\u0011JA&\u001b\u0005\t\u0018bAA'c\n91kY1o]\u0016\u0014\u0018a\u0005*fO\u0016DH*[7ji&twm\u0015;sK\u0006l\u0007C\u0001+ '\ry\u0012Q\u000b\t\u0004\u001d\u0006]\u0013bAA-y\t1\u0011I\\=SK\u001a$\"!!\u0015\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\tGK\u0002N\u0003GZ#!!\u001a\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_b\u0014AC1o]>$\u0018\r^5p]&!\u00111OA5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RegexLimitingStream
extends InputStream {
    private StreamIterator<Object> charsIter;
    private final InputStream in;
    private final String maxDelimiterIn8859;
    private final int maxDelimiterLength;
    private final int chunkSize;
    private final String regex;
    private final Pattern pattern;
    private final int lookAheadMax;
    private boolean noMoreChunks;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$5() {
        return RegexLimitingStream$.MODULE$.$lessinit$greater$default$5();
    }

    private InputStream in() {
        return this.in;
    }

    private String maxDelimiterIn8859() {
        return this.maxDelimiterIn8859;
    }

    private int maxDelimiterLength() {
        return this.maxDelimiterLength;
    }

    private int chunkSize() {
        return this.chunkSize;
    }

    private String regex() {
        return this.regex;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private int lookAheadMax() {
        return this.lookAheadMax;
    }

    private StreamIterator<Object> charsIter$lzycompute() {
        RegexLimitingStream regexLimitingStream = this;
        synchronized (regexLimitingStream) {
            if (!this.bitmap$0) {
                Stream<String> cks = this.chunks();
                Stream streamChars = cks.flatten((Function1 & Serializable & scala.Serializable)x -> new StringOps(Predef$.MODULE$.augmentString(x)));
                StreamIterator iter = new StreamIterator(streamChars);
                this.charsIter = iter;
                this.bitmap$0 = true;
            }
        }
        return this.charsIter;
    }

    private StreamIterator<Object> charsIter() {
        if (!this.bitmap$0) {
            return this.charsIter$lzycompute();
        }
        return this.charsIter;
    }

    @Override
    public int read() {
        if (!this.charsIter().hasNext()) {
            return -1;
        }
        return BoxesRunTime.unboxToChar((Object)this.charsIter().next());
    }

    @Override
    public int available() {
        if (this.charsIter().hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() {
    }

    private boolean noMoreChunks() {
        return this.noMoreChunks;
    }

    private void noMoreChunks_$eq(boolean x$1) {
        this.noMoreChunks = x$1;
    }

    private Stream<String> chunks() {
        if (this.noMoreChunks()) {
            return scala.package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
        }
        this.in().mark(this.lookAheadMax());
        InputStreamReader rdr = new InputStreamReader(this.in(), StandardCharsets.ISO_8859_1);
        Scanner scanner = new Scanner(rdr);
        String matchString = scanner.findWithinHorizon(this.pattern(), 0);
        int matchLength = this.checkScan(matchString, scanner);
        this.in().reset();
        this.in().skip(matchString.length() + matchLength);
        if (matchLength > 0) {
            this.noMoreChunks_$eq(true);
        }
        if (matchString.isEmpty()) {
            return scala.package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
        }
        String string = matchString;
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.chunks()).$hash$colon$colon((Object)string);
    }

    private int checkScan(String matchString, Scanner scanner) {
        int n;
        boolean isFound;
        if (matchString == null) {
            throw Assert$.MODULE$.abort("Invariant broken: matchString.ne(null)");
        }
        MatchResult matcher = scanner.match();
        int beforeDelimMatch = matcher.end(1);
        int delimMatch = matcher.end(2);
        int noDelimMatch = matcher.end(3);
        boolean bl = isFound = beforeDelimMatch > -1;
        if (isFound) {
            if (delimMatch <= -1) {
                throw Assert$.MODULE$.abort("Invariant broken: delimMatch.>(-1)");
            }
            if (noDelimMatch != -1) {
                throw Assert$.MODULE$.abort("Invariant broken: noDelimMatch.==(-1)");
            }
            n = matcher.end(2) - matcher.start(2);
        } else {
            if (delimMatch != -1) {
                throw Assert$.MODULE$.abort("Invariant broken: delimMatch.==(-1)");
            }
            if (noDelimMatch <= -1) {
                throw Assert$.MODULE$.abort("Invariant broken: noDelimMatch.>(-1)");
            }
            n = 0;
        }
        int delimMatchLength = n;
        return delimMatchLength;
    }

    public RegexLimitingStream(InputStream inputStream, String regexForDelimiter, String maximumLengthDelimiterExample, Charset charset, int targetChunkSize) {
        if (targetChunkSize < 1) {
            throw Assert$.MODULE$.abort("Usage error: RegexLimitingStream.this.targetChunkSize.>=(1)");
        }
        if (maximumLengthDelimiterExample.length() < 1) {
            throw Assert$.MODULE$.abort("Usage error: RegexLimitingStream.this.maximumLengthDelimiterExample.length().>=(1)");
        }
        this.in = inputStream;
        this.maxDelimiterIn8859 = new String(maximumLengthDelimiterExample.getBytes(charset), StandardCharsets.ISO_8859_1);
        this.maxDelimiterLength = (int)package$.MODULE$.ceil((double)((float)this.maxDelimiterIn8859().length() * charset.newEncoder().maxBytesPerChar()));
        this.chunkSize = package$.MODULE$.max(targetChunkSize, this.maxDelimiterLength() + 1);
        this.regex = new StringBuilder(32).append("([\\s\\S]{0,").append(this.chunkSize()).append("}?)(?=(").append(regexForDelimiter).append("))|([\\s\\S]{0,").append(this.chunkSize()).append("})").toString();
        this.pattern = Pattern.compile(this.regex());
        this.lookAheadMax = this.chunkSize() + this.maxDelimiterLength();
        this.noMoreChunks = false;
    }
}

