/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.CodeSource;
import java.util.zip.ZipException;
import org.apache.daffodil.api.DFDL;
import org.apache.daffodil.api.DaffodilSchemaSource;
import org.apache.daffodil.api.DaffodilTunables;
import org.apache.daffodil.api.DaffodilTunables$;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.URISchemaSource;
import org.apache.daffodil.api.URISchemaSource$;
import org.apache.daffodil.api.UnitTestSchemaSource;
import org.apache.daffodil.compiler.Compiler$;
import org.apache.daffodil.compiler.InvalidParserException;
import org.apache.daffodil.compiler.InvalidParserException$;
import org.apache.daffodil.compiler.ProcessorFactory;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.externalvars.Binding;
import org.apache.daffodil.externalvars.Binding$;
import org.apache.daffodil.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.processors.DataProcessor;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.xml.NS$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.xml.Node;

@ScalaSignature(bytes="\u0006\u0001\r}b\u0001B\"E\u00015C\u0001\"\u0018\u0001\u0003\u0002\u0004%\tA\u0018\u0005\tE\u0002\u0011\t\u0019!C\u0001G\"A\u0011\u000e\u0001B\u0001B\u0003&q\f\u0003\u0005k\u0001\t\u0005\r\u0011\"\u0001l\u0011!y\u0007A!a\u0001\n\u0003\u0001\b\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0015\u00027\t\u0011M\u0004!\u00111A\u0005\nQD!\"a\u0002\u0001\u0005\u0003\u0007I\u0011BA\u0005\u0011%\ti\u0001\u0001B\u0001B\u0003&Q\u000fC\u0005\u0002\u0010\u0001\u0011\t\u0019!C\u0005=\"Q\u0011\u0011\u0003\u0001\u0003\u0002\u0004%I!a\u0005\t\u0013\u0005]\u0001A!A!B\u0013y\u0006BCA\r\u0001\t\u0005\r\u0011\"\u0003\u0002\u001c!Q\u0011\u0011\b\u0001\u0003\u0002\u0004%I!a\u000f\t\u0015\u0005}\u0002A!A!B\u0013\ti\u0002\u0003\u0006\u0002B\u0001\u0011\t\u0019!C\u0005\u00037A!\"a\u0011\u0001\u0005\u0003\u0007I\u0011BA#\u0011)\tI\u0005\u0001B\u0001B\u0003&\u0011Q\u0004\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\tY\u0005\u0001C\u0005\u0003?Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0005\u0002t\u0001\t\n\u0011\"\u0003\u0002v!I\u00111\u0012\u0001\u0012\u0002\u0013%\u0011Q\u0012\u0005\n\u0003#\u0003\u0011\u0013!C\u0005\u0003'C\u0011\"a&\u0001#\u0003%I!!\u001e\t\u0013\u0005e\u0005!%A\u0005\n\u0005m\u0005\"CAP\u0001E\u0005I\u0011BAN\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!!0\u0001\t\u0003\ty\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0007bBAu\u0001\u0011%\u00111\u001e\u0005\b\u00033\u0004A\u0011AAz\u0011\u001d\tY\u0010\u0001C\u0001\u0003{DqAa\u0006\u0001\t\u0003\u0011I\u0002C\u0004\u0002|\u0002!\tA!\b\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u0005C\u0002A\u0011\u0001B2\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqA!\u001e\u0001\t\u0003\u00119\bC\u0004\u0003|\u0001!\tA! \t\u000f\tm\u0004\u0001\"\u0001\u0003\n\"9!1\u0010\u0001\u0005\u0002\tu\u0005b\u0002B>\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005w\u0002A\u0011\u0001B^\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013D\u0011B!7\u0001#\u0003%\t!a'\t\u0013\tm\u0007!%A\u0005\u0002\u0005m\u0005b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\n\u0005O\u0004\u0011\u0013!C\u0001\u00037C\u0011B!;\u0001#\u0003%\t!a'\t\u000f\t-\b\u0001\"\u0003\u0003n\"9!\u0011 \u0001\u0005\u0002\tm\b\"CB\u000b\u0001E\u0005I\u0011AB\f\u0011%\u0019Y\u0002AI\u0001\n\u0003\tY\nC\u0005\u0004\u001e\u0001\t\n\u0011\"\u0001\u0002\u001c\u001e91q\u0004#\t\u0002\r\u0005bAB\"E\u0011\u0003\u0019\u0019\u0003C\u0004\u0002Lu\"\ta!\n\t\u000f\r\u001dR\b\"\u0001\u0004*!I1QF\u001f\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\b\u0007_iD\u0011BB\u0019\u0011%\u0019i$PI\u0001\n\u0013\t)H\u0001\u0005D_6\u0004\u0018\u000e\\3s\u0015\t)e)\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\t9\u0005*\u0001\u0005eC\u001a4w\u000eZ5m\u0015\tI%*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0006\u0019qN]4\u0004\u0001M\u0019\u0001A\u0014+\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g!\t)6L\u0004\u0002W36\tqK\u0003\u0002Y\r\u0006\u0019\u0011\r]5\n\u0005i;\u0016\u0001\u0002#G\t2K!a\u0011/\u000b\u0005i;\u0016a\u0005<bY&$\u0017\r^3E\r\u0012c5k\u00195f[\u0006\u001cX#A0\u0011\u0005=\u0003\u0017BA1Q\u0005\u001d\u0011un\u001c7fC:\fqC^1mS\u0012\fG/\u001a#G\t2\u001b6\r[3nCN|F%Z9\u0015\u0005\u0011<\u0007CA(f\u0013\t1\u0007K\u0001\u0003V]&$\bb\u00025\u0003\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0014\u0001\u0006<bY&$\u0017\r^3E\r\u0012c5k\u00195f[\u0006\u001c\b%\u0001\u0005uk:\f'\r\\3t+\u0005a\u0007C\u0001,n\u0013\tqwK\u0001\tEC\u001a4w\u000eZ5m)Vt\u0017M\u00197fg\u0006aA/\u001e8bE2,7o\u0018\u0013fcR\u0011A-\u001d\u0005\bQ\u0016\t\t\u00111\u0001m\u0003%!XO\\1cY\u0016\u001c\b%A\u000bfqR,'O\\1m\t\u001a#EJV1sS\u0006\u0014G.Z:\u0016\u0003U\u00042A^>~\u001b\u00059(B\u0001=z\u0003%IW.\\;uC\ndWM\u0003\u0002{!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q<(!B)vKV,\u0007c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0019\u000bA\"\u001a=uKJt\u0017\r\u001c<beNL1!!\u0002\u0000\u0005\u001d\u0011\u0015N\u001c3j]\u001e\f\u0011$\u001a=uKJt\u0017\r\u001c#G\t23\u0016M]5bE2,7o\u0018\u0013fcR\u0019A-a\u0003\t\u000f!D\u0011\u0011!a\u0001k\u00061R\r\u001f;fe:\fG\u000e\u0012$E\u0019Z\u000b'/[1cY\u0016\u001c\b%\u0001\tdQ\u0016\u001c7.\u00117m)>\u0004H*\u001a<fY\u0006!2\r[3dW\u0006cG\u000eV8q\u0019\u00164X\r\\0%KF$2\u0001ZA\u000b\u0011\u001dA7\"!AA\u0002}\u000b\u0011c\u00195fG.\fE\u000e\u001c+pa2+g/\u001a7!\u0003-y\u0007\u000f\u001e*p_Rt\u0015-\\3\u0016\u0005\u0005u\u0001#B(\u0002 \u0005\r\u0012bAA\u0011!\n1q\n\u001d;j_:\u0004B!!\n\u000249!\u0011qEA\u0018!\r\tI\u0003U\u0007\u0003\u0003WQ1!!\fM\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0007)\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\t\u0004U\u0001\u0010_B$(k\\8u\u001d\u0006lWm\u0018\u0013fcR\u0019A-!\u0010\t\u0011!t\u0011\u0011!a\u0001\u0003;\tAb\u001c9u%>|GOT1nK\u0002\n\u0001c\u001c9u%>|GOT1nKN\u0004\u0018mY3\u0002)=\u0004HOU8pi:\u000bW.Z:qC\u000e,w\fJ3r)\r!\u0017q\t\u0005\tQF\t\t\u00111\u0001\u0002\u001e\u0005\tr\u000e\u001d;S_>$h*Y7fgB\f7-\u001a\u0011\u0002\rqJg.\u001b;?)9\ty%a\u0015\u0002V\u0005]\u0013\u0011LA.\u0003;\u00022!!\u0015\u0001\u001b\u0005!\u0005\"B/\u0014\u0001\u0004y\u0006\"\u00026\u0014\u0001\u0004a\u0007\"B:\u0014\u0001\u0004)\bBBA\b'\u0001\u0007q\fC\u0004\u0002\u001aM\u0001\r!!\b\t\u000f\u0005\u00053\u00031\u0001\u0002\u001eQ!\u0011qJA1\u0011\u001diF\u0003%AA\u0002}\u000bAaY8qsRq\u0011qJA4\u0003S\nY'!\u001c\u0002p\u0005E\u0004bB/\u0016!\u0003\u0005\ra\u0018\u0005\bUV\u0001\n\u00111\u0001m\u0011\u001d\u0019X\u0003%AA\u0002UD\u0001\"a\u0004\u0016!\u0003\u0005\ra\u0018\u0005\n\u00033)\u0002\u0013!a\u0001\u0003;A\u0011\"!\u0011\u0016!\u0003\u0005\r!!\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000f\u0016\u0004?\u0006e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0005+\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0012\u0016\u0004Y\u0006e\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003+S3!^A=\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u001e*\"\u0011QDA=\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\n\u0001d]3u\t&\u001cH/\u001b8hk&\u001c\b.\u001a3S_>$hj\u001c3f)\u0015!\u0017QUAU\u0011\u001d\t9\u000b\ba\u0001\u0003G\tAA\\1nK\"9\u00111\u0016\u000fA\u0002\u0005\r\u0012!\u00038b[\u0016\u001c\b/Y2fQ\u001da\u0012qVA[\u0003s\u00032aTAY\u0013\r\t\u0019\f\u0015\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA\\\u0003A\u0002\u0016m]:!CJ<W/\\3oiN\u0004Co\u001c\u0011d_6\u0004\u0018\u000e\\3T_V\u00148-\u001a\u0017!_J\u00043m\\7qS2,g)\u001b7f]\u0005\u0012\u00111X\u0001\u0006e92d\u0006M\u0001\u001ao&$\b\u000eR5ti&tw-^5tQ\u0016$'k\\8u\u001d>$W\r\u0006\u0004\u0002P\u0005\u0005\u00171\u0019\u0005\b\u0003Ok\u0002\u0019AA\u0012\u0011\u001d\tY+\ba\u0001\u0003G\tac]3u-\u0006d\u0017\u000eZ1uK\u00123E\tT*dQ\u0016l\u0017m\u001d\u000b\u0004I\u0006%\u0007BBAf=\u0001\u0007q,A\u0003wC2,X\rK\u0004\u001f\u0003_\u000by-!/\"\u0005\u0005E\u0017!G+tK\u0002\u001awN\\:ueV\u001cGo\u001c:!CJ<W/\\3oi:\nqc^5uQZ\u000bG.\u001b3bi\u0016$e\t\u0012'TG\",W.Y:\u0015\t\u0005=\u0013q\u001b\u0005\u0007\u0003\u0017|\u0002\u0019A0\u0002/M,G/\u0012=uKJt\u0017\r\u001c#G\t23\u0016M]5bE2,Gc\u00023\u0002^\u0006}\u0017\u0011\u001d\u0005\b\u0003O\u0003\u0003\u0019AA\u0012\u0011\u001d\tY\u000b\ta\u0001\u0003GAq!a3!\u0001\u0004\t\u0019\u0003K\u0004!\u0003_\u000b)/!/\"\u0005\u0005\u001d\u0018\u0001K+tK\u0002\"\u0015\r^1Qe>\u001cWm]:pe::\u0018\u000e\u001e5FqR,'O\\1m-\u0006\u0014\u0018.\u00192mKNt\u0013AC4fi\nKg\u000eZ5oOR9Q0!<\u0002p\u0006E\bbBATC\u0001\u0007\u00111\u0005\u0005\b\u0003W\u000b\u0003\u0019AA\u0012\u0011\u001d\tY-\ta\u0001\u0003G!2\u0001ZA{\u0011\u0019\t9P\ta\u0001{\u0006Aa/\u0019:jC\ndW\rK\u0004#\u0003_\u000b)/!/\u00021M,G/\u0012=uKJt\u0017\r\u001c#G\t23\u0016M]5bE2,7\u000fF\u0002e\u0003\u007fDqA!\u0001$\u0001\u0004\u0011\u0019!A\u0005wCJL\u0017M\u00197fgB)!Q\u0001B\b{:!!q\u0001B\u0006\u001d\u0011\tIC!\u0003\n\u0003EK1A!\u0004Q\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0005\u0003\u0014\t\u00191+Z9\u000b\u0007\t5\u0001\u000bK\u0004$\u0003_\u000b)/!/\u0002;]LG\u000f[#yi\u0016\u0014h.\u00197E\r\u0012ce+\u0019:jC\ndWm]%na2$B!a\u0014\u0003\u001c!9!\u0011\u0001\u0013A\u0002\t\rAc\u00013\u0003 !9!\u0011E\u0013A\u0002\t\r\u0012aC3yiZ\u000b'o\u001d$jY\u0016\u0004BA!\n\u000305\u0011!q\u0005\u0006\u0005\u0005S\u0011Y#\u0001\u0002j_*\u0011!QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00032\t\u001d\"\u0001\u0002$jY\u0016Ds!JAX\u0003K\fI,\u0001\u0006tKR$VO\\1cY\u0016$R\u0001\u001aB\u001d\u0005{AqAa\u000f'\u0001\u0004\t\u0019#A\u0004uk:\f'\r\\3\t\u000f\u0005-g\u00051\u0001\u0002$!:a%a,\u0003B\u0005e\u0016E\u0001B\"\u0003A)6/\u001a\u0011xSRDG+\u001e8bE2,g&A\u0006xSRDG+\u001e8bE2,GCBA(\u0005\u0013\u0012Y\u0005C\u0004\u0003<\u001d\u0002\r!a\t\t\u000f\u0005-w\u00051\u0001\u0002$\u0005Y1/\u001a;Uk:\f'\r\\3t)\r!'\u0011\u000b\u0005\b\u0005'B\u0003\u0019\u0001B+\u0003-!XO\\1cY\u0016\u001c\u0018I]4\u0011\u0011\u0005\u0015\"qKA\u0012\u0003GIAA!\u0017\u00028\t\u0019Q*\u00199)\u000f!\nyK!\u0018\u0002:\u0006\u0012!qL\u0001\u0012+N,\u0007e^5uQR+h.\u00192mKNt\u0013\u0001D<ji\"$VO\\1cY\u0016\u001cH\u0003BA(\u0005KBqAa\u0015*\u0001\u0004\u0011)&A\ntKR\u001c\u0005.Z2l\u00032dGk\u001c9MKZ,G\u000eF\u0002e\u0005WBaA!\u001c+\u0001\u0004y\u0016\u0001\u00024mC\u001eDsAKAX\u0005c\nI,\t\u0002\u0003t\u0005IRk]3!o&$\bn\u00115fG.\fE\u000e\u001c+pa2+g/\u001a7/\u0003Q9\u0018\u000e\u001e5DQ\u0016\u001c7.\u00117m)>\u0004H*\u001a<fYR!\u0011q\nB=\u0011\u0019\u0011ig\u000ba\u0001?\u00061!/\u001a7pC\u0012$BAa \u0003\u0006B\u0019QK!!\n\u0007\t\rELA\u0007ECR\f\u0007K]8dKN\u001cxN\u001d\u0005\b\u0005\u000fc\u0003\u0019\u0001B\u0012\u0003-\u0019\u0018M^3e!\u0006\u00148/\u001a:\u0015\t\t}$1\u0012\u0005\b\u0005\u000fk\u0003\u0019\u0001BG!\u0011\u0011yI!'\u000e\u0005\tE%\u0002\u0002BJ\u0005+\u000b\u0001b\u00195b]:,Gn\u001d\u0006\u0005\u0005/\u0013Y#A\u0002oS>LAAa'\u0003\u0012\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fYR!!q\u0010BP\u0011\u001d\u0011\tK\fa\u0001\u0005G\u000bAb]2iK6\f7k\\;sG\u0016\u00042A\u0016BS\u0013\r\u00119k\u0016\u0002\u0015\t\u00064gm\u001c3jYN\u001b\u0007.Z7b'>,(oY3\u0015\t\t}$1\u0016\u0005\b\u0005[{\u0003\u0019\u0001BX\u0003\r)(/\u001b\t\u0005\u0005c\u00139,\u0004\u0002\u00034*!!Q\u0017B\u0016\u0003\rqW\r^\u0005\u0005\u0005s\u0013\u0019LA\u0002V%&#BAa \u0003>\"9!q\u0018\u0019A\u0002\t\u0005\u0017AA5t!\u0011\u0011)Ca1\n\t\t\u0015'q\u0005\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0006d_6\u0004\u0018\u000e\\3GS2,G\u0003\u0003Bf\u0005#\u0014)Na6\u0011\t\u0005E#QZ\u0005\u0004\u0005\u001f$%\u0001\u0005)s_\u000e,7o]8s\r\u0006\u001cGo\u001c:z\u0011\u001d\u0011\u0019.\ra\u0001\u0005G\tAAZ5mK\"I\u0011\u0011D\u0019\u0011\u0002\u0003\u0007\u0011Q\u0004\u0005\n\u0003\u0003\n\u0004\u0013!a\u0001\u0003;\tQcY8na&dWMR5mK\u0012\"WMZ1vYR$#'A\u000bd_6\u0004\u0018\u000e\\3GS2,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u001b\r|W\u000e]5mKN{WO]2f)!\u0011YM!9\u0003d\n\u0015\bb\u0002BQi\u0001\u0007!1\u0015\u0005\n\u00033!\u0004\u0013!a\u0001\u0003;A\u0011\"!\u00115!\u0003\u0005\r!!\b\u0002/\r|W\u000e]5mKN{WO]2fI\u0011,g-Y;mi\u0012\u0012\u0014aF2p[BLG.Z*pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134\u0003U\u0019w.\u001c9jY\u0016\u001cv.\u001e:dK&sG/\u001a:oC2$\u0002Ba3\u0003p\nE(Q\u001f\u0005\b\u0005C;\u0004\u0019\u0001BR\u0011\u001d\u0011\u0019p\u000ea\u0001\u0003;\tab\u001c9u%>|GOT1nK\u0006\u0013x\rC\u0004\u0003x^\u0002\r!!\b\u0002'=\u0004HOU8pi:\u000bW.Z:qC\u000e,\u0017I]4\u0002\u0017\r|W\u000e]5mK:{G-\u001a\u000b\u000b\u0005\u0017\u0014ipa\u0003\u0004\u0012\rM\u0001b\u0002B\u0000q\u0001\u00071\u0011A\u0001\u0004q6d\u0007\u0003BB\u0002\u0007\u000fi!a!\u0002\u000b\u0007\t}\b+\u0003\u0003\u0004\n\r\u0015!\u0001\u0002(pI\u0016D\u0011b!\u00049!\u0003\u0005\raa\u0004\u0002\u0013=\u0004H\u000fV7q\t&\u0014\b#B(\u0002 \t\r\u0002\"CA\rqA\u0005\t\u0019AA\u000f\u0011%\t\t\u0005\u000fI\u0001\u0002\u0004\ti\"A\u000bd_6\u0004\u0018\u000e\\3O_\u0012,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\re!\u0006BB\b\u0003s\nQcY8na&dWMT8eK\u0012\"WMZ1vYR$3'A\u000bd_6\u0004\u0018\u000e\\3O_\u0012,G\u0005Z3gCVdG\u000f\n\u001b\u0002\u0011\r{W\u000e]5mKJ\u00042!!\u0015>'\tid\n\u0006\u0002\u0004\"\u0005)\u0011\r\u001d9msR!\u0011qJB\u0016\u0011\u001div\b%AA\u0002}\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u0001\u001aG>l\u0007/\u001b7f'>,(oY3Ts:\u001c\u0007N]8oSj,'\u000f\u0006\u0006\u0003L\u000eM2qGB\u001d\u0007wAqa!\u000eB\u0001\u0004\ty%A\u0001d\u0011\u001d\u0011\t+\u0011a\u0001\u0005GCq!!\u0007B\u0001\u0004\ti\u0002C\u0004\u0002B\u0005\u0003\r!!\b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0001")
public class Compiler
implements DFDL.Compiler {
    private boolean validateDFDLSchemas;
    private DaffodilTunables tunables;
    private Queue<Binding> externalDFDLVariables;
    private boolean checkAllTopLevel;
    private Option<String> optRootName;
    private Option<String> optRootNamespace;

    public static boolean apply$default$1() {
        return Compiler$.MODULE$.apply$default$1();
    }

    public static Compiler apply(boolean bl) {
        return Compiler$.MODULE$.apply(bl);
    }

    public boolean validateDFDLSchemas() {
        return this.validateDFDLSchemas;
    }

    public void validateDFDLSchemas_$eq(boolean x$1) {
        this.validateDFDLSchemas = x$1;
    }

    public DaffodilTunables tunables() {
        return this.tunables;
    }

    public void tunables_$eq(DaffodilTunables x$1) {
        this.tunables = x$1;
    }

    private Queue<Binding> externalDFDLVariables() {
        return this.externalDFDLVariables;
    }

    private void externalDFDLVariables_$eq(Queue<Binding> x$1) {
        this.externalDFDLVariables = x$1;
    }

    private boolean checkAllTopLevel() {
        return this.checkAllTopLevel;
    }

    private void checkAllTopLevel_$eq(boolean x$1) {
        this.checkAllTopLevel = x$1;
    }

    private Option<String> optRootName() {
        return this.optRootName;
    }

    private void optRootName_$eq(Option<String> x$1) {
        this.optRootName = x$1;
    }

    private Option<String> optRootNamespace() {
        return this.optRootNamespace;
    }

    private void optRootNamespace_$eq(Option<String> x$1) {
        this.optRootNamespace = x$1;
    }

    private Compiler copy(boolean validateDFDLSchemas, DaffodilTunables tunables, Queue<Binding> externalDFDLVariables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        return new Compiler(validateDFDLSchemas, tunables, externalDFDLVariables, checkAllTopLevel, optRootName, optRootNamespace);
    }

    private boolean copy$default$1() {
        return this.validateDFDLSchemas();
    }

    private DaffodilTunables copy$default$2() {
        return this.tunables();
    }

    private Queue<Binding> copy$default$3() {
        return this.externalDFDLVariables();
    }

    private boolean copy$default$4() {
        return this.checkAllTopLevel();
    }

    private Option<String> copy$default$5() {
        return this.optRootName();
    }

    private Option<String> copy$default$6() {
        return this.optRootNamespace();
    }

    public void setDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.abort("Usage error: name.ne(null)");
        }
        this.optRootName_$eq((Option<String>)Option$.MODULE$.apply((Object)name));
        this.optRootNamespace_$eq((Option<String>)Option$.MODULE$.apply((Object)namespace));
    }

    public Compiler withDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.abort("Usage error: name.ne(null)");
        }
        Option x$1 = Option$.MODULE$.apply((Object)name);
        Option x$2 = Option$.MODULE$.apply((Object)namespace);
        boolean x$3 = this.copy$default$1();
        DaffodilTunables x$4 = this.copy$default$2();
        Queue<Binding> x$5 = this.copy$default$3();
        boolean x$6 = this.copy$default$4();
        return this.copy(x$3, x$4, x$5, x$6, (Option<String>)x$1, (Option<String>)x$2);
    }

    public void setValidateDFDLSchemas(boolean value) {
        this.validateDFDLSchemas_$eq(value);
    }

    public Compiler withValidateDFDLSchemas(boolean value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public void setExternalDFDLVariable(String name, String namespace, String value) {
        this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)this.getBinding(name, namespace, value)));
    }

    private Binding getBinding(String name, String namespace, String value) {
        String string = namespace;
        None$ ns = string == null ? None$.MODULE$ : new Some((Object)NS$.MODULE$.apply(namespace));
        Binding b = Binding$.MODULE$.apply(name, (Option)ns, value);
        return b;
    }

    public void setExternalDFDLVariable(Binding variable) {
        this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)variable));
    }

    public void setExternalDFDLVariables(Seq<Binding> variables) {
        variables.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)b));
            return BoxedUnit.UNIT;
        });
    }

    public Compiler withExternalDFDLVariablesImpl(Seq<Binding> variables) {
        ObjectRef extVars = ObjectRef.create(this.externalDFDLVariables());
        variables.foreach((Function1 & Serializable & scala.Serializable)b -> {
            extVars.elem = ((Queue)extVars.elem).enqueue((Object)b);
            return BoxedUnit.UNIT;
        });
        Queue x$1 = (Queue)extVars.elem;
        boolean x$2 = this.copy$default$1();
        DaffodilTunables x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, (Queue<Binding>)x$1, x$4, x$5, x$6);
    }

    public void setExternalDFDLVariables(File extVarsFile) {
        Queue extVars = ExternalVariablesLoader$.MODULE$.fileToBindings(extVarsFile);
        extVars.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)b));
            return BoxedUnit.UNIT;
        });
    }

    public void setTunable(String tunable, String value) {
        this.tunables_$eq(this.tunables().setTunable(tunable, value));
    }

    public Compiler withTunable(String tunable, String value) {
        DaffodilTunables x$1 = this.tunables().setTunable(tunable, value);
        boolean x$2 = this.copy$default$1();
        Queue<Binding> x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    public void setTunables(Map<String, String> tunablesArg) {
        this.tunables_$eq(this.tunables().setTunables(tunablesArg));
    }

    public Compiler withTunables(Map<String, String> tunablesArg) {
        DaffodilTunables x$1 = this.tunables().setTunables(tunablesArg);
        boolean x$2 = this.copy$default$1();
        Queue<Binding> x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    public void setCheckAllTopLevel(boolean flag) {
        this.checkAllTopLevel_$eq(flag);
    }

    public Compiler withCheckAllTopLevel(boolean flag) {
        boolean x$1 = flag;
        boolean x$2 = this.copy$default$1();
        DaffodilTunables x$3 = this.copy$default$2();
        Queue<Binding> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6);
    }

    public DFDL.DataProcessor reload(File savedParser) {
        return this.reload(new FileInputStream(savedParser));
    }

    public DFDL.DataProcessor reload(ReadableByteChannel savedParser) {
        return this.reload(Channels.newInputStream(savedParser));
    }

    public DFDL.DataProcessor reload(DaffodilSchemaSource schemaSource) {
        return this.reload(schemaSource.uriForLoading());
    }

    public DFDL.DataProcessor reload(URI uri) {
        return this.reload(uri.toURL().openStream());
    }

    public DFDL.DataProcessor reload(InputStream is) {
        DataProcessor dataProcessor;
        try {
            DataProcessor dp;
            String savedVersion;
            String requiredDataPrefix = "DAFFODIL ";
            new StringOps(Predef$.MODULE$.augmentString(requiredDataPrefix)).foreach((Function1 & Serializable & scala.Serializable)c -> {
                Compiler.$anonfun$reload$1(is, BoxesRunTime.unboxToChar((Object)c));
                return BoxedUnit.UNIT;
            });
            ArrayBuffer ab = new ArrayBuffer();
            int n = -1;
            while ((n = is.read()) > 0) {
                ab.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)n}));
            }
            if (n == -1) {
                throw new InvalidParserException("The saved parser is corrupted", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            String curVersion = Misc$.MODULE$.getDaffodilVersion();
            String string = savedVersion = new String((byte[])ab.toArray(ClassTag$.MODULE$.Byte()), "utf-8");
            String string2 = curVersion;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidParserException(new StringBuilder(71).append("The saved parser is only compatible with Daffodil ").append(savedVersion).append(". Current version is ").append(curVersion).toString(), InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            ObjectInputStream objInput = new ObjectInputStream(null, is){

                public Class<?> resolveClass(ObjectStreamClass desc) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(desc.getName(), false, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        clazz = super.resolveClass(desc);
                    }
                    return clazz;
                }
            };
            Object dpObj = objInput.readObject();
            objInput.close();
            dataProcessor = dp = (DataProcessor)dpObj;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipException) {
                throw new InvalidParserException("The saved parser is corrupted", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            if (throwable2 instanceof StreamCorruptedException) {
                throw new InvalidParserException("The saved parser is corrupted", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            if (throwable2 instanceof InvalidClassException) {
                InvalidClassException invalidClassException = (InvalidClassException)throwable2;
                Class<?> cls = Class.forName(invalidClassException.classname);
                CodeSource src = cls.getProtectionDomain().getCodeSource();
                String dependencyStr = src != null ? new File(src.getLocation().getFile()).getName() : "a dependency";
                throw new InvalidParserException(new StringBuilder(83).append("The saved parser was created with a different version of ").append(dependencyStr).append(" with incompatible class: ").append(invalidClassException.classname).toString(), InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            if (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError) {
                throw new InvalidParserException(new StringBuilder(113).append("The saved parser was created with a different set of dependencies containing a class no longer on the classpath: ").append(throwable2.getMessage()).toString(), InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            throw throwable;
        }
        return dataProcessor;
    }

    public ProcessorFactory compileFile(File file, Option<String> optRootName, Option<String> optRootNamespace) {
        URISchemaSource source = URISchemaSource$.MODULE$.apply(file.toURI());
        return this.compileSource((DaffodilSchemaSource)source, (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<String> compileFile$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileFile$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory compileSource(DaffodilSchemaSource schemaSource, Option<String> optRootName, Option<String> optRootNamespace) {
        return Compiler$.MODULE$.org$apache$daffodil$compiler$Compiler$$compileSourceSynchronizer(this, schemaSource, optRootName, optRootNamespace);
    }

    public Option<String> compileSource$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileSource$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory org$apache$daffodil$compiler$Compiler$$compileSourceInternal(DaffodilSchemaSource schemaSource, Option<String> optRootNameArg, Option<String> optRootNamespaceArg) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Option rootName = optRootNameArg.orElse((Function0 & Serializable & scala.Serializable)() -> this.optRootName());
        Option rootNamespace = optRootNamespaceArg.orElse((Function0 & Serializable & scala.Serializable)() -> this.optRootNamespace());
        ProcessorFactory pf = new ProcessorFactory((Option<String>)rootName, (Option<String>)rootNamespace, this.externalDFDLVariables(), schemaSource, this.validateDFDLSchemas(), this.checkAllTopLevel(), this.tunables());
        boolean err = pf.isError();
        Seq<Diagnostic> diags = pf.getDiagnostics();
        if (err) {
            if (!diags.nonEmpty()) {
                throw Assert$.MODULE$.abort("Invariant broken: diags.nonEmpty");
            }
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(57).append("Compilation (ProcessorFactory) produced ").append(diags.length()).append(" errors/warnings.").toString(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (diags.nonEmpty()) {
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(50).append("Compilation (ProcessorFactory) produced ").append(diags.length()).append(" warnings.").toString(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)"ProcessorFactory completed with no errors.", null);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(21).append("Schema had ").append(pf.elementBaseInstanceCount()).append(" elements.").toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return pf;
    }

    public ProcessorFactory compileNode(Node xml, Option<File> optTmpDir, Option<String> optRootName, Option<String> optRootNamespace) {
        return this.compileSource((DaffodilSchemaSource)new UnitTestSchemaSource(xml, "anon", optTmpDir), (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<File> compileNode$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileNode$default$3() {
        return None$.MODULE$;
    }

    public Option<String> compileNode$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$reload$1(InputStream is$1, char c) {
        if (is$1.read() != c) {
            throw new InvalidParserException("The saved parser is only compatible with an older version of Daffodil", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private Compiler(boolean validateDFDLSchemas, DaffodilTunables tunables, Queue<Binding> externalDFDLVariables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        this.validateDFDLSchemas = validateDFDLSchemas;
        this.tunables = tunables;
        this.externalDFDLVariables = externalDFDLVariables;
        this.checkAllTopLevel = checkAllTopLevel;
        this.optRootName = optRootName;
        this.optRootNamespace = optRootNamespace;
    }

    public Compiler(boolean validateDFDLSchemas) {
        this(validateDFDLSchemas, DaffodilTunables$.MODULE$.apply(), (Queue<Binding>)Queue$.MODULE$.empty(), true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }
}

