/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil;

import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.helpers.DefaultEXIFactory;
import com.siemens.ct.exi.grammars.GrammarFactory;
import com.siemens.ct.exi.main.api.sax.EXIResult;
import com.siemens.ct.exi.main.api.sax.EXISource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.daffodil.CLIConf;
import org.apache.daffodil.CLIConf$parse$;
import org.apache.daffodil.CLIConf$performance$;
import org.apache.daffodil.CLIConf$test$;
import org.apache.daffodil.CLIConf$unparse$;
import org.apache.daffodil.InfosetType$;
import org.apache.daffodil.Main$ExitCode$;
import org.apache.daffodil.api.DFDL;
import org.apache.daffodil.api.DaffodilConfig;
import org.apache.daffodil.api.DaffodilConfig$;
import org.apache.daffodil.api.DaffodilSchemaSource;
import org.apache.daffodil.api.DaffodilTunables$;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.URISchemaSource;
import org.apache.daffodil.api.URISchemaSource$;
import org.apache.daffodil.api.ValidationMode;
import org.apache.daffodil.api.WithDiagnostics;
import org.apache.daffodil.compiler.Compiler;
import org.apache.daffodil.compiler.Compiler$;
import org.apache.daffodil.compiler.InvalidParserException;
import org.apache.daffodil.compiler.ProcessorFactory;
import org.apache.daffodil.debugger.CLIDebuggerRunner;
import org.apache.daffodil.debugger.DebuggerExitException;
import org.apache.daffodil.debugger.InteractiveDebugger;
import org.apache.daffodil.debugger.InteractiveDebuggerRunner;
import org.apache.daffodil.debugger.TraceDebuggerRunner;
import org.apache.daffodil.dsom.ExpressionCompilerClass;
import org.apache.daffodil.dsom.ExpressionCompilers$;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.NotYetImplementedException;
import org.apache.daffodil.exceptions.UnsuppressableException;
import org.apache.daffodil.externalvars.Binding;
import org.apache.daffodil.externalvars.BindingException;
import org.apache.daffodil.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.infoset.InfosetInputter;
import org.apache.daffodil.infoset.InfosetOutputter;
import org.apache.daffodil.infoset.JDOMInfosetInputter;
import org.apache.daffodil.infoset.JDOMInfosetOutputter;
import org.apache.daffodil.infoset.JsonInfosetInputter;
import org.apache.daffodil.infoset.JsonInfosetOutputter;
import org.apache.daffodil.infoset.NullInfosetInputter;
import org.apache.daffodil.infoset.NullInfosetInputter$;
import org.apache.daffodil.infoset.NullInfosetOutputter;
import org.apache.daffodil.infoset.ScalaXMLInfosetInputter;
import org.apache.daffodil.infoset.ScalaXMLInfosetOutputter;
import org.apache.daffodil.infoset.ScalaXMLInfosetOutputter$;
import org.apache.daffodil.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.infoset.XMLTextInfosetInputter;
import org.apache.daffodil.infoset.XMLTextInfosetOutputter;
import org.apache.daffodil.io.DataDumper;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.processors.DaffodilParseOutputStreamContentHandler;
import org.apache.daffodil.processors.DataLoc;
import org.apache.daffodil.processors.DataProcessor;
import org.apache.daffodil.processors.ExternalVariableException;
import org.apache.daffodil.processors.HasSetDebugger;
import org.apache.daffodil.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.tdml.Runner;
import org.apache.daffodil.tdml.Runner$;
import org.apache.daffodil.tdml.TDMLException;
import org.apache.daffodil.tdml.TDMLTestNotCompatibleException;
import org.apache.daffodil.tdml.TestCase;
import org.apache.daffodil.udf.UserDefinedFunctionFatalErrorException;
import org.apache.daffodil.util.Logger$;
import org.apache.daffodil.util.MaybeULong$;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.util.Timer$;
import org.apache.daffodil.xml.DFDLCatalogResolver$;
import org.apache.daffodil.xml.DaffodilSAXParserFactory$;
import org.apache.daffodil.xml.NS;
import org.apache.daffodil.xml.RefQName;
import org.apache.daffodil.xml.XMLUtils$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.rogach.scallop.ScallopConfBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.ControlThrowable;
import scala.util.matching.Regex;
import scala.xml.Node;
import scala.xml.XML$;

public final class Main$ {
    public static Main$ MODULE$;
    private final Seq<String> traceCommands;
    private final Path blobDir;
    private final String blobSuffix;

    static {
        new Main$();
    }

    public Seq<String> traceCommands() {
        return this.traceCommands;
    }

    public String indent(String str, int pad) {
        String[] lines = str.split("\n");
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(pad);
        String[] indented = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(0).append(prefix).append((String)x$1).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indented)).mkString("\n");
    }

    public Seq<Binding> overrideBindings(Seq<Binding> bindings, Seq<Binding> bindingsToOverride) {
        Seq inBoth = (Seq)((SeqLike)bindings.intersect(bindingsToOverride)).distinct();
        Seq bindingsMinusBoth = (Seq)bindings.diff((GenSeq)inBoth);
        Seq bindingsToOverrideMinusBoth = (Seq)bindingsToOverride.diff((GenSeq)inBoth);
        Seq bindingsWithCorrectValues = (Seq)bindings.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)inBoth.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$overrideBindings$2(b, p)))));
        Seq bindingsMinusUpdates = (Seq)bindingsMinusBoth.union((GenSeq)bindingsToOverrideMinusBoth, Seq$.MODULE$.canBuildFrom());
        Seq bindingsWithUpdates = (Seq)bindingsMinusUpdates.union((GenSeq)bindingsWithCorrectValues, Seq$.MODULE$.canBuildFrom());
        return bindingsWithUpdates;
    }

    public void displayDiagnostics(WithDiagnostics pr) {
        pr.getDiagnostics().foreach((Function1 & Serializable & scala.Serializable)d -> {
            Main$.$anonfun$displayDiagnostics$1(d);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Binding> combineExternalVariables(Map<String, String> vars, Option<DaffodilConfig> optDafConfig) {
        Seq configFileVars = (Seq)optDafConfig.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.externalVariableBindings()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Queue individualVars = ExternalVariablesLoader$.MODULE$.mapToBindings(vars);
        Seq<Binding> bindings = this.overrideBindings((Seq<Binding>)individualVars, (Seq<Binding>)configFileVars);
        return bindings;
    }

    public Option<DFDL.DataProcessor> createProcessorFromParser(File savedParser, Option<String> path, ValidationMode.Type mode) {
        None$ none$;
        block5: {
            try {
                Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
                DFDL.DataProcessor processor = (DFDL.DataProcessor)Timer$.MODULE$.getResult("reloading", (Function0 & Serializable & scala.Serializable)() -> compiler.reload(savedParser));
                if (!processor.isError()) {
                    none$ = new Some((Object)processor.withValidationMode(mode));
                    break block5;
                }
                none$ = None$.MODULE$;
            }
            catch (InvalidParserException e) {
                BoxedUnit boxedUnit;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)e.getMessage(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public void setupDebugOrTrace(HasSetDebugger proc, CLIConf conf) {
        if (BoxesRunTime.unboxToBoolean((Object)conf.trace().apply()) || conf.debug().isDefined()) {
            Object object;
            if (BoxesRunTime.unboxToBoolean((Object)conf.trace().apply())) {
                object = new TraceDebuggerRunner();
            } else {
                BoxedUnit boxedUnit;
                if (System.console() == null) {
                    if (Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                        org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)"Using --debug on a non-interactive console may result in display issues", null);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option option = (Option)conf.debug().apply();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String f = (String)some.value();
                    object = new CLIDebuggerRunner(new File(f));
                } else if (None$.MODULE$.equals(option)) {
                    object = new CLIDebuggerRunner();
                } else {
                    throw new MatchError((Object)option);
                }
            }
            TraceDebuggerRunner runner = object;
            InteractiveDebugger id = new InteractiveDebugger((InteractiveDebuggerRunner)runner, (ExpressionCompilerClass)ExpressionCompilers$.MODULE$);
            proc.setDebugging(true);
            proc.setDebugger((Object)id);
            return;
        }
    }

    public Option<DFDL.DataProcessor> createProcessorFromSchema(URI schema, Option<RefQName> rootNS, Option<String> path, Map<String, String> tunablesMap, ValidationMode.Type mode) {
        Some some;
        RefQName refQName;
        Compiler compiler;
        Compiler c = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunables(tunablesMap);
        Option<RefQName> option = rootNS;
        if (None$.MODULE$.equals(option)) {
            compiler = c;
        } else if (option instanceof Some && (refQName = (RefQName)(some = (Some)option).value()) != null) {
            String root = refQName.local();
            NS ns = refQName.namespace();
            compiler = c.withDistinguishedRootNode(root, ns.toStringOrNullIfNoNS());
        } else {
            throw new MatchError(option);
        }
        Compiler compiler2 = compiler;
        URISchemaSource schemaSource = URISchemaSource$.MODULE$.apply(schema);
        Option res = (Option)Timer$.MODULE$.getResult("compiling", (Function0 & Serializable & scala.Serializable)() -> {
            ProcessorFactory processorFactory = compiler2.compileSource((DaffodilSchemaSource)schemaSource, compiler2.compileSource$default$2(), compiler2.compileSource$default$3());
            if (!processorFactory.isError()) {
                DFDL.DataProcessor processor = processorFactory.onPath((String)path.getOrElse((Function0 & Serializable & scala.Serializable)() -> "/")).withValidationMode(mode);
                MODULE$.displayDiagnostics((WithDiagnostics)processor);
                if (processor.isError()) {
                    return None$.MODULE$;
                }
                return new Some((Object)processor);
            }
            MODULE$.displayDiagnostics((WithDiagnostics)processorFactory);
            return None$.MODULE$;
        });
        return res;
    }

    public Option<DFDL.CodeGenerator> createGeneratorFromSchema(URI schema, Option<RefQName> rootNS, Map<String, String> tunables, String language) {
        Some some;
        RefQName refQName;
        Compiler compiler;
        Compiler c = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunables(tunables);
        Option<RefQName> option = rootNS;
        if (None$.MODULE$.equals(option)) {
            compiler = c;
        } else if (option instanceof Some && (refQName = (RefQName)(some = (Some)option).value()) != null) {
            String root = refQName.local();
            NS ns = refQName.namespace();
            compiler = c.withDistinguishedRootNode(root, ns.toStringOrNullIfNoNS());
        } else {
            throw new MatchError(option);
        }
        Compiler compiler2 = compiler;
        URISchemaSource schemaSource = URISchemaSource$.MODULE$.apply(schema);
        Option cg = (Option)Timer$.MODULE$.getResult("compiling", (Function0 & Serializable & scala.Serializable)() -> {
            ProcessorFactory processorFactory = compiler2.compileSource((DaffodilSchemaSource)schemaSource, compiler2.compileSource$default$2(), compiler2.compileSource$default$3());
            if (!processorFactory.isError()) {
                DFDL.CodeGenerator generator = processorFactory.forLanguage(language);
                MODULE$.displayDiagnostics((WithDiagnostics)generator);
                return new Some((Object)generator);
            }
            MODULE$.displayDiagnostics((WithDiagnostics)processorFactory);
            return None$.MODULE$;
        });
        return cg;
    }

    public Path blobDir() {
        return this.blobDir;
    }

    public String blobSuffix() {
        return this.blobSuffix;
    }

    public Option<EXIFactory> getExiFactoryOpt(Enumeration.Value infosetType, Option<URI> schemaUriOpt) {
        block6: {
            block5: {
                Enumeration.Value value = infosetType;
                Enumeration.Value value2 = InfosetType$.MODULE$.EXI();
                if (!(value == null ? value2 != null : !value.equals(value2))) break block5;
                Enumeration.Value value3 = infosetType;
                Enumeration.Value value4 = InfosetType$.MODULE$.EXISA();
                if (value3 != null ? !value3.equals(value4) : value4 != null) break block6;
            }
            EXIFactory ef = DefaultEXIFactory.newInstance();
            if (schemaUriOpt.isDefined()) {
                Enumeration.Value value = infosetType;
                Enumeration.Value value5 = InfosetType$.MODULE$.EXISA();
                if (!(value != null ? !value.equals(value5) : value5 != null)) {
                    GrammarFactory gf = GrammarFactory.newInstance();
                    Grammars grammar = gf.createGrammars(((URI)schemaUriOpt.get()).toString(), (XMLEntityResolver)DFDLCatalogResolver$.MODULE$.get());
                    ef.setGrammars(grammar);
                }
            }
            return new Some((Object)ef);
        }
        return None$.MODULE$;
    }

    public Either<InfosetOutputter, ContentHandler> getInfosetOutputter(Enumeration.Value infosetType, OutputStream os, Option<EXIFactory> exiFactoryOpt) {
        Left left;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.XML();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            left = scala.package$.MODULE$.Left().apply((Object)new XMLTextInfosetOutputter(os, true));
        } else {
            Enumeration.Value value4 = InfosetType$.MODULE$.SCALA_XML();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                left = scala.package$.MODULE$.Left().apply((Object)new ScalaXMLInfosetOutputter(ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$1(), ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$2()));
            } else {
                Enumeration.Value value6 = InfosetType$.MODULE$.JSON();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    left = scala.package$.MODULE$.Left().apply((Object)new JsonInfosetOutputter(os, true));
                } else {
                    Enumeration.Value value8 = InfosetType$.MODULE$.JDOM();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        left = scala.package$.MODULE$.Left().apply((Object)new JDOMInfosetOutputter());
                    } else {
                        Enumeration.Value value10 = InfosetType$.MODULE$.W3CDOM();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            left = scala.package$.MODULE$.Left().apply((Object)new W3CDOMInfosetOutputter());
                        } else {
                            Enumeration.Value value12 = InfosetType$.MODULE$.SAX();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                left = scala.package$.MODULE$.Right().apply((Object)new DaffodilParseOutputStreamContentHandler(os, true));
                            } else {
                                boolean bl;
                                Enumeration.Value value14 = InfosetType$.MODULE$.EXI();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    bl = true;
                                } else {
                                    Enumeration.Value value16 = InfosetType$.MODULE$.EXISA();
                                    Enumeration.Value value17 = value;
                                    bl = !(value16 != null ? !value16.equals(value17) : value17 != null);
                                }
                                if (bl) {
                                    if (!exiFactoryOpt.isDefined()) {
                                        throw Assert$.MODULE$.abort("Invariant broken: exiFactoryOpt.isDefined");
                                    }
                                    EXIResult exiResult = new EXIResult((EXIFactory)exiFactoryOpt.get());
                                    exiResult.setOutputStream(os);
                                    left = scala.package$.MODULE$.Right().apply((Object)exiResult.getHandler());
                                } else {
                                    Enumeration.Value value18 = InfosetType$.MODULE$.NULL();
                                    Enumeration.Value value19 = value;
                                    if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                        left = scala.package$.MODULE$.Left().apply((Object)new NullInfosetOutputter());
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Left outputter = left;
        Object object = outputter.isLeft() ? outputter.left().map((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.setBlobAttributes(Main$.MODULE$.blobDir(), null, Main$.MODULE$.blobSuffix());
            return BoxedUnit.UNIT;
        }) : BoxedUnit.UNIT;
        return outputter;
    }

    public Object infosetDataToInputterData(Enumeration.Value infosetType, Either<byte[], InputStream> data) {
        boolean bl;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.XML();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = InfosetType$.MODULE$.JSON();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = InfosetType$.MODULE$.SAX();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value8 = InfosetType$.MODULE$.EXI();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value10 = InfosetType$.MODULE$.EXISA();
                        Enumeration.Value value11 = value;
                        bl = !(value10 != null ? !value10.equals(value11) : value11 != null);
                    }
                }
            }
        }
        if (bl) {
            Either<byte[], InputStream> either = data;
            if (either instanceof Left) {
                Left left = (Left)either;
                byte[] bytes = (byte[])left.value();
                return bytes;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                InputStream is = (InputStream)right.value();
                return is;
            }
            throw new MatchError(either);
        }
        Enumeration.Value value12 = InfosetType$.MODULE$.SCALA_XML();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            SAXParser p;
            InputStream inputStream;
            Either<byte[], InputStream> either = data;
            if (either instanceof Left) {
                Left left = (Left)either;
                byte[] bytes = (byte[])left.value();
                inputStream = new ByteArrayInputStream(bytes);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                InputStream is = (InputStream)right.value();
                inputStream = is;
            } else {
                throw new MatchError(either);
            }
            InputStream is = inputStream;
            SAXParserFactory f = DaffodilSAXParserFactory$.MODULE$.apply();
            f.setNamespaceAware(false);
            SAXParser parser = p = f.newSAXParser();
            return XML$.MODULE$.withSAXParser(parser).load(is);
        }
        Enumeration.Value value14 = InfosetType$.MODULE$.JDOM();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            InputStream inputStream;
            Either<byte[], InputStream> either = data;
            if (either instanceof Left) {
                Left left = (Left)either;
                byte[] bytes = (byte[])left.value();
                inputStream = new ByteArrayInputStream(bytes);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                InputStream is = (InputStream)right.value();
                inputStream = is;
            } else {
                throw new MatchError(either);
            }
            InputStream is = inputStream;
            SAXBuilder builder = new SAXBuilder(){

                public XMLReader createParser() {
                    XMLReader rdr = super.createParser();
                    XMLUtils$.MODULE$.setSecureDefaults(rdr);
                    return rdr;
                }
            };
            return builder.build(is);
        }
        Enumeration.Value value16 = InfosetType$.MODULE$.W3CDOM();
        Enumeration.Value value17 = value;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            byte[] byArray;
            Either<byte[], InputStream> either = data;
            if (either instanceof Left) {
                byte[] bytes;
                Left left = (Left)either;
                byArray = bytes = (byte[])left.value();
            } else if (either instanceof Right) {
                Right right = (Right)either;
                InputStream is = (InputStream)right.value();
                byArray = IOUtils.toByteArray((InputStream)is);
            } else {
                throw new MatchError(either);
            }
            byte[] byteArr = byArray;
            return new ThreadLocal<org.w3c.dom.Document>(byteArr){
                private final byte[] byteArr$1;

                public org.w3c.dom.Document initialValue() {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setFeature(XMLUtils$.MODULE$.XML_DISALLOW_DOCTYPE_FEATURE(), true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    return db.parse(new ByteArrayInputStream(this.byteArr$1));
                }
                {
                    this.byteArr$1 = byteArr$1;
                }
            };
        }
        Enumeration.Value value18 = InfosetType$.MODULE$.NULL();
        Enumeration.Value value19 = value;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            InputStream inputStream;
            Either<byte[], InputStream> either = data;
            if (either instanceof Left) {
                Left left = (Left)either;
                byte[] bytes = (byte[])left.value();
                inputStream = new ByteArrayInputStream(bytes);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                InputStream is = (InputStream)right.value();
                inputStream = is;
            } else {
                throw new MatchError(either);
            }
            InputStream is = inputStream;
            NullInfosetInputter.Event[] events = NullInfosetInputter$.MODULE$.toEvents(is);
            return events;
        }
        throw new MatchError((Object)value);
    }

    public Either<InfosetInputter, DFDL.DaffodilUnparseContentHandler> getInfosetInputter(Enumeration.Value infosetType, Object anyRef, DFDL.DataProcessor processor, WritableByteChannel outChannel) {
        boolean bl;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.XML();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            InputStream inputStream;
            Object object = anyRef;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                inputStream = new ByteArrayInputStream(byArray);
            } else if (object instanceof InputStream) {
                InputStream inputStream2 = (InputStream)object;
                inputStream = inputStream2;
            } else {
                throw new MatchError(object);
            }
            InputStream is = inputStream;
            return scala.package$.MODULE$.Left().apply((Object)new XMLTextInfosetInputter(is));
        }
        Enumeration.Value value4 = InfosetType$.MODULE$.JSON();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            InputStream inputStream;
            Object object = anyRef;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                inputStream = new ByteArrayInputStream(byArray);
            } else if (object instanceof InputStream) {
                InputStream inputStream3 = (InputStream)object;
                inputStream = inputStream3;
            } else {
                throw new MatchError(object);
            }
            InputStream is = inputStream;
            return scala.package$.MODULE$.Left().apply((Object)new JsonInfosetInputter(is));
        }
        Enumeration.Value value6 = InfosetType$.MODULE$.SCALA_XML();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return scala.package$.MODULE$.Left().apply((Object)new ScalaXMLInfosetInputter((Node)anyRef));
        }
        Enumeration.Value value8 = InfosetType$.MODULE$.JDOM();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return scala.package$.MODULE$.Left().apply((Object)new JDOMInfosetInputter((Document)anyRef));
        }
        Enumeration.Value value10 = InfosetType$.MODULE$.W3CDOM();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            ThreadLocal tl = (ThreadLocal)anyRef;
            return scala.package$.MODULE$.Left().apply((Object)new W3CDOMInfosetInputter((org.w3c.dom.Document)tl.get()));
        }
        Enumeration.Value value12 = InfosetType$.MODULE$.EXI();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            bl = true;
        } else {
            Enumeration.Value value14 = InfosetType$.MODULE$.EXISA();
            Enumeration.Value value15 = value;
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                bl = true;
            } else {
                Enumeration.Value value16 = InfosetType$.MODULE$.SAX();
                Enumeration.Value value17 = value;
                bl = !(value16 != null ? !value16.equals(value17) : value17 != null);
            }
        }
        if (bl) {
            DFDL.DataProcessor dp = processor;
            return scala.package$.MODULE$.Right().apply((Object)dp.newContentHandlerInstance(outChannel));
        }
        Enumeration.Value value18 = InfosetType$.MODULE$.NULL();
        Enumeration.Value value19 = value;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            NullInfosetInputter.Event[] events = (NullInfosetInputter.Event[])anyRef;
            return scala.package$.MODULE$.Left().apply((Object)new NullInfosetInputter(events));
        }
        throw new MatchError((Object)value);
    }

    public void setLogLevel(int verbose) {
        Level level;
        int n = verbose;
        switch (n) {
            case 0: {
                level = Level.WARN;
                break;
            }
            case 1: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.DEBUG;
                break;
            }
            default: {
                level = Level.TRACE;
                break;
            }
        }
        Level verboseLevel = level;
        Configurator.setLevel((String)"org.apache.daffodil", (Level)verboseLevel);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Enumeration.Value run(String[] arguments) {
        block98: {
            block102: {
                block101: {
                    block100: {
                        block99: {
                            block94: {
                                block96: {
                                    block97: {
                                        block95: {
                                            conf = new CLIConf(arguments);
                                            this.setLogLevel(BoxesRunTime.unboxToInt((Object)conf.verbose().apply()));
                                            var27_3 = false;
                                            var28_4 = null;
                                            var29_5 = conf.subcommand();
                                            if (!(var29_5 instanceof Some)) break block94;
                                            var27_3 = true;
                                            var28_4 = (Some)var29_5;
                                            var30_6 = (ScallopConfBase)var28_4.value();
                                            if (!conf.parse().equals(var30_6)) break block94;
                                            parseOpts = conf.parse();
                                            validate = (ValidationMode.Type)parseOpts.validate().toOption().get();
                                            optDafConfig = parseOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$1(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                                            if (parseOpts.parser().isDefined()) {
                                                v0 = this.createProcessorFromParser((File)parseOpts.parser().apply(), (Option<String>)parseOpts.path().toOption(), validate);
                                            } else {
                                                tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(parseOpts.tunables(), optDafConfig);
                                                v0 = this.createProcessorFromSchema((URI)parseOpts.schema().apply(), (Option<RefQName>)parseOpts.rootNS().toOption(), (Option<String>)parseOpts.path().toOption(), (Map<String, String>)tunables, validate);
                                            }
                                            var37_12 = processor = v0.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$2(org.apache.daffodil.CLIConf$parse$ scala.Option org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((CLIConf$parse$)parseOpts, (Option)optDafConfig));
                                            if (!None$.MODULE$.equals(var37_12)) break block95;
                                            v1 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                                            break block96;
                                        }
                                        if (!(var37_12 instanceof Some)) break block97;
                                        var38_13 = (Some)var37_12;
                                        proc = (DFDL.DataProcessor)var38_13.value();
                                        if (proc.isError()) {
                                            throw Assert$.MODULE$.abort("Invariant broken: proc.isError.unary_!");
                                        }
                                        processor = ObjectRef.create((Object)proc);
                                        var42_16 = parseOpts.infile().toOption();
                                        if (var42_16 instanceof Some != false && "-".equals(var44_18 = (String)(var43_17 = (Some)var42_16).value()) != false ? true : None$.MODULE$.equals(var42_16) != false) {
                                            v2 = System.in;
                                        } else if (var42_16 instanceof Some) {
                                            var45_19 = (Some)var42_16;
                                            file = (String)var45_19.value();
                                            f = new File(file);
                                            v2 = new FileInputStream(f);
                                        } else {
                                            throw new MatchError((Object)var42_16);
                                        }
                                        input = v2;
                                        inStream = InputSourceDataInputStream$.MODULE$.apply(input);
                                        processor.elem = ((DFDL.DataProcessor)processor.elem).withValidationMode(validate);
                                        this.setupDebugOrTrace((HasSetDebugger)((DataProcessor)((DFDL.DataProcessor)processor.elem)), conf);
                                        var50_24 = parseOpts.output().toOption();
                                        if (var50_24 instanceof Some != false && "-".equals(var52_26 = (String)(var51_25 = (Some)var50_24).value()) != false ? true : None$.MODULE$.equals(var50_24) != false) {
                                            v3 /* !! */  = System.out;
                                        } else if (var50_24 instanceof Some) {
                                            var53_27 = (Some)var50_24;
                                            file = (String)var53_27.value();
                                            v3 /* !! */  = new FileOutputStream(file);
                                        } else {
                                            throw new MatchError((Object)var50_24);
                                        }
                                        output = v3 /* !! */ ;
                                        infosetType = (Enumeration.Value)parseOpts.infosetType().toOption().get();
                                        exiFactoryOpt = this.getExiFactoryOpt(infosetType, (Option<URI>)parseOpts.schema().toOption());
                                        eitherOutputterOrHandler = this.getInfosetOutputter(infosetType, output, exiFactoryOpt);
                                        lastParseBitPosition = 0L;
                                        keepParsing = true;
                                        exitCode = Main$ExitCode$.MODULE$.Success();
                                        while (keepParsing) {
                                            var63_37 = eitherOutputterOrHandler;
                                            if (var63_37 instanceof Right) {
                                                var64_38 = (Right)var63_37;
                                                saxContentHandler = (ContentHandler)var64_38.value();
                                                v4 = (DFDL.ParseResult)Timer$.MODULE$.getResult("parsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$3(scala.runtime.ObjectRef org.apache.daffodil.io.InputSourceDataInputStream org.xml.sax.ContentHandler ), ()Lorg/apache/daffodil/api/DFDL$ParseResult;)((ObjectRef)processor, (InputSourceDataInputStream)inStream, (ContentHandler)saxContentHandler));
                                            } else if (var63_37 instanceof Left) {
                                                var66_40 = (Left)var63_37;
                                                outputter = (InfosetOutputter)var66_40.value();
                                                outputter.reset();
                                                v4 = (DFDL.ParseResult)Timer$.MODULE$.getResult("parsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$4(scala.runtime.ObjectRef org.apache.daffodil.io.InputSourceDataInputStream org.apache.daffodil.infoset.InfosetOutputter ), ()Lorg/apache/daffodil/api/DFDL$ParseResult;)((ObjectRef)processor, (InputSourceDataInputStream)inStream, (InfosetOutputter)outputter));
                                            } else {
                                                throw new MatchError(var63_37);
                                            }
                                            parseResult = v4;
                                            finfo = (FormatInfo)parseResult.resultState();
                                            loc = (DataLoc)parseResult.resultState().currentLocation();
                                            this.displayDiagnostics((WithDiagnostics)parseResult);
                                            if (((DFDL.Result)parseResult).isProcessingError() || ((DFDL.Result)parseResult).isValidationError()) {
                                                keepParsing = false;
                                                exitCode = Main$ExitCode$.MODULE$.ParseError();
                                                continue;
                                            }
                                            var70_44 = false;
                                            var71_45 = null;
                                            var72_46 = eitherOutputterOrHandler;
                                            if (!(var72_46 instanceof Left)) ** GOTO lbl-1000
                                            var70_44 = true;
                                            var71_45 = (Left)var72_46;
                                            sxml = (InfosetOutputter)var71_45.value();
                                            if (sxml instanceof ScalaXMLInfosetOutputter) {
                                                var74_48 = (ScalaXMLInfosetOutputter)sxml;
                                                writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);
                                                XML$.MODULE$.write((Writer)writer, var74_48.getResult(), "UTF-8", true, null, XML$.MODULE$.write$default$6());
                                                writer.flush();
                                            } else if (var70_44 && (jdom = (InfosetOutputter)var71_45.value()) instanceof JDOMInfosetOutputter) {
                                                var77_51 = (JDOMInfosetOutputter)jdom;
                                                new XMLOutputter().output(var77_51.getResult(), (OutputStream)output);
                                            } else if (var70_44 && (w3cdom = (InfosetOutputter)var71_45.value()) instanceof W3CDOMInfosetOutputter) {
                                                var79_53 = (W3CDOMInfosetOutputter)w3cdom;
                                                tf = TransformerFactory.newInstance();
                                                transformer = tf.newTransformer();
                                                result = new StreamResult(output);
                                                source = new DOMSource(var79_53.getResult());
                                                transformer.transform(source, result);
                                            }
                                            output.flush();
                                            if (!inStream.hasData()) {
                                                keepParsing = false;
                                                continue;
                                            }
                                            if (BoxesRunTime.unboxToBoolean((Object)parseOpts.stream().toOption().get())) {
                                                if (lastParseBitPosition == (long)loc.bitPos0b()) {
                                                    v5 = remainingBits = MaybeULong$.MODULE$.isDefined$extension(loc.bitLimit0b()) != false ? Long.toString(MaybeULong$.MODULE$.get$extension(loc.bitLimit0b()) - (long)loc.bitPos0b()) : new StringBuilder(9).append("at least ").append(inStream.inputSource().bytesAvailable() * 8L).toString();
                                                    if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                                                        org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)new StringBuilder(110).append("Left over data after consuming 0 bits while streaming. Stopped after consuming ").append(loc.bitPos0b()).append(" bit(s) with ").append(remainingBits).append(" bit(s) remaining.").toString(), null);
                                                        v6 = BoxedUnit.UNIT;
                                                    } else {
                                                        v6 = BoxedUnit.UNIT;
                                                    }
                                                    keepParsing = false;
                                                    exitCode = Main$ExitCode$.MODULE$.LeftOverData();
                                                    continue;
                                                }
                                                lastParseBitPosition = loc.bitPos0b();
                                                keepParsing = true;
                                                output.write(0);
                                                continue;
                                            }
                                            Dump = new DataDumper();
                                            bitsAlreadyConsumed = loc.bitPos0b() % 8;
                                            if (bitsAlreadyConsumed != 0) {
                                                bitsToDisplay = 8 - bitsAlreadyConsumed;
                                                pbp = inStream.inputSource().position() + 1L;
                                                firstByteBitArray = inStream.getByteArray(bitsToDisplay, finfo);
                                                fbs = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper((int)firstByteBitArray[0])))).takeRight(8))).reverse())).padTo(8, (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom()))).reverse();
                                                v7 = finfo.bitOrder();
                                                var94_67 = BitOrder.MostSignificantBitFirst$.MODULE$;
                                                bits = !(v7 != null ? v7.equals(var94_67) == false : var94_67 != null) ? new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("x")).$times(bitsAlreadyConsumed)).append(new StringOps(Predef$.MODULE$.augmentString(fbs)).dropRight(bitsAlreadyConsumed)).toString() : new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(fbs)).takeRight(bitsToDisplay)).append(new StringOps(Predef$.MODULE$.augmentString("x")).$times(bitsAlreadyConsumed)).toString();
                                                arg$macro$1 = BoxesRunTime.boxToLong((long)pbp);
                                                arg$macro$2 = bits;
                                                v8 = dumpString = new StringOps("\nLeft over data starts with partial byte. Left over data (Binary) at byte %s is: (0b%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
                                            } else {
                                                v8 = "";
                                            }
                                            firstByteString = v8;
                                            curBytePosition1b = inStream.inputSource().position() + 1L;
                                            bytesAvailable = inStream.inputSource().bytesAvailable();
                                            bytesLimit = (int)package$.MODULE$.min(8L, bytesAvailable);
                                            destArray = new byte[bytesLimit];
                                            destArrayFilled = inStream.inputSource().get(destArray, 0, bytesLimit);
                                            if (destArrayFilled) {
                                                x$1 = new DataDumper.TextOnly(Dump, (Option)new Some((Object)"utf-8"));
                                                x$2 = 0L;
                                                x$3 = destArray.length * 8;
                                                x$4 = ByteBuffer.wrap(destArray);
                                                x$5 = false;
                                                x$6 = Dump.dump$default$5();
                                                x$7 = Dump.dump$default$7();
                                                v9 = Dump.dump((DataDumper.Kind)x$1, x$2, x$3, x$4, x$6, x$5, x$7).mkString("\n");
                                            } else {
                                                v9 = "";
                                            }
                                            dumpString = v9;
                                            dataText = destArrayFilled != false ? new StringBuilder(51).append("\nLeft over data (UTF-8) starting at byte ").append(curBytePosition1b).append(" is: (").append(dumpString).append("...)").toString() : "";
                                            dataHex = destArrayFilled != false ? new StringBuilder(51).append("\nLeft over data (Hex) starting at byte ").append(curBytePosition1b).append(" is: (0x").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(destArray)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$5$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString()).append("...)").toString() : "";
                                            remainingBits = MaybeULong$.MODULE$.isDefined$extension(loc.bitLimit0b()) != false ? Long.toString(MaybeULong$.MODULE$.get$extension(loc.bitLimit0b()) - (long)loc.bitPos0b()) : new StringBuilder(9).append("at least ").append(bytesAvailable * 8L).toString();
                                            leftOverDataMessage = new StringBuilder(56).append("Left over data. Consumed ").append(loc.bitPos0b()).append(" bit(s) with ").append(remainingBits).append(" bit(s) remaining.").append(firstByteString).append(dataHex).append(dataText).toString();
                                            if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                                                org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)leftOverDataMessage, null);
                                                v10 = BoxedUnit.UNIT;
                                            } else {
                                                v10 = BoxedUnit.UNIT;
                                            }
                                            keepParsing = false;
                                            exitCode = Main$ExitCode$.MODULE$.LeftOverData();
                                        }
                                        v1 = exitCode;
                                        break block96;
                                    }
                                    throw new MatchError((Object)var37_12);
                                }
                                v11 = rc = v1;
                                break block98;
                            }
                            if (!var27_3) break block99;
                            var118_89 = (ScallopConfBase)var28_4.value();
                            if (!conf.performance().equals(var118_89)) break block99;
                            performanceOpts = conf.performance();
                            validate = (ValidationMode.Type)performanceOpts.validate().toOption().get();
                            optDafConfig = performanceOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$6(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                            if (performanceOpts.parser().isDefined()) {
                                v12 = this.createProcessorFromParser((File)performanceOpts.parser().apply(), (Option<String>)performanceOpts.path().toOption(), validate);
                            } else {
                                tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(performanceOpts.tunables(), optDafConfig);
                                v12 = this.createProcessorFromSchema((URI)performanceOpts.schema().apply(), (Option<RefQName>)performanceOpts.rootNS().toOption(), (Option<String>)performanceOpts.path().toOption(), (Map<String, String>)tunables, validate);
                            }
                            var125_95 = processor = v12.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$7(org.apache.daffodil.CLIConf$performance$ scala.Option org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((CLIConf$performance$)performanceOpts, (Option)optDafConfig)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$8(org.apache.daffodil.api.ValidationMode$Type org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((ValidationMode.Type)validate));
                            if (None$.MODULE$.equals(var125_95)) {
                                v13 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                            } else if (var125_95 instanceof Some) {
                                var126_96 = (Some)var125_95;
                                processor = (DFDL.DataProcessor)var126_96.value();
                                infile = new File((String)performanceOpts.infile().apply());
                                files = infile.isDirectory() != false ? (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])infile.listFiles())).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$9$adapted(java.io.File ), (Ljava/io/File;)Ljava/lang/Object;)()) : (File[])((Object[])new File[]{infile});
                                infosetType = (Enumeration.Value)performanceOpts.infosetType().toOption().get();
                                exiFactoryOpt = this.getExiFactoryOpt(infosetType, (Option<URI>)performanceOpts.schema().toOption());
                                dataSeq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$10(org.apache.daffodil.CLIConf$performance$ scala.Enumeration$Value java.io.File ), (Ljava/io/File;)Lscala/util/Either;)((CLIConf$performance$)performanceOpts, (Enumeration.Value)infosetType), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                                inputs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)performanceOpts.number().apply())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$11$adapted(scala.collection.Seq java.lang.Object ), (Ljava/lang/Object;)Lscala/util/Either;)((Seq)dataSeq), IndexedSeq$.MODULE$.canBuildFrom());
                                inputsWithIndex = (IndexedSeq)inputs.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom());
                                executionContext = new ExecutionContext(performanceOpts){
                                    private final ExecutorService threadPool;

                                    public ExecutionContext prepare() {
                                        return ExecutionContext.prepare$((ExecutionContext)this);
                                    }

                                    public ExecutorService threadPool() {
                                        return this.threadPool;
                                    }

                                    public void execute(Runnable runnable) {
                                        this.threadPool().submit(runnable);
                                    }

                                    public void reportFailure(Throwable t) {
                                    }
                                    {
                                        ExecutionContext.$init$((ExecutionContext)this);
                                        this.threadPool = Executors.newFixedThreadPool(BoxesRunTime.unboxToInt((Object)performanceOpts$1.threads().apply()));
                                    }
                                };
                                nullChannelForUnparse = Channels.newChannel((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                                nullOutputStreamForParse = NullOutputStream.NULL_OUTPUT_STREAM;
                                NSConvert = 1.0E9;
                                var141_109 = Timer$.MODULE$.getTimeResult((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$12(scala.collection.immutable.IndexedSeq scala.Enumeration$Value org.apache.daffodil.api.DFDL$DataProcessor java.nio.channels.WritableByteChannel scala.Option org.apache.commons.io.output.NullOutputStream scala.concurrent.ExecutionContext ), ()Lscala/collection/immutable/IndexedSeq;)((IndexedSeq)inputsWithIndex, (Enumeration.Value)infosetType, (DFDL.DataProcessor)processor, (WritableByteChannel)nullChannelForUnparse, exiFactoryOpt, (NullOutputStream)nullOutputStreamForParse, (ExecutionContext)executionContext));
                                if (var141_109 == null) {
                                    throw new MatchError((Object)var141_109);
                                }
                                totalTime = var141_109._1$mcJ$sp();
                                results = (IndexedSeq)var141_109._2();
                                var140_112 = new Tuple2((Object)BoxesRunTime.boxToLong((long)totalTime), (Object)results);
                                totalTime = var140_112._1$mcJ$sp();
                                results = (IndexedSeq)var140_112._2();
                                rates = (IndexedSeq)results.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$18$adapted(double scala.Tuple3 ), (Lscala/Tuple3;)Ljava/lang/Object;)((double)NSConvert), IndexedSeq$.MODULE$.canBuildFrom());
                                numFailures = ((SeqLike)((TraversableLike)results.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$19$adapted(scala.Tuple3 ), (Lscala/Tuple3;)Ljava/lang/Object;)(), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$20$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)())).length();
                                if (numFailures > 0) {
                                    if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                                        org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)new StringBuilder(16).append(numFailures).append(" failures found\n").toString(), null);
                                        v14 = BoxedUnit.UNIT;
                                    } else {
                                        v14 = BoxedUnit.UNIT;
                                    }
                                } else {
                                    v14 = BoxedUnit.UNIT;
                                }
                                sec = (double)totalTime / NSConvert;
                                var153_118 = BoxesRunTime.unboxToBoolean((Object)performanceOpts.unparse().apply());
                                if (var153_118) {
                                    v15 = "unparse";
                                } else if (!var153_118) {
                                    v15 = "parse";
                                } else {
                                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)var153_118));
                                }
                                action = v15;
                                Predef$.MODULE$.printf("total %s time (sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, BoxesRunTime.boxToDouble((double)sec)}));
                                Predef$.MODULE$.printf("min rate (files/sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rates.min((Ordering)Ordering.Double$.MODULE$)}));
                                Predef$.MODULE$.printf("max rate (files/sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rates.max((Ordering)Ordering.Double$.MODULE$)}));
                                Predef$.MODULE$.printf("avg rate (files/sec): %f\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)BoxesRunTime.unboxToInt((Object)performanceOpts.number().apply()) / sec))}));
                                v13 = numFailures == 0 ? Main$ExitCode$.MODULE$.Success() : Main$ExitCode$.MODULE$.PerformanceTestError();
                            } else {
                                throw new MatchError((Object)var125_95);
                            }
                            v11 = rc = v13;
                            break block98;
                        }
                        if (!var27_3) break block100;
                        var154_121 = (ScallopConfBase)var28_4.value();
                        if (!conf.unparse().equals(var154_121)) break block100;
                        unparseOpts = conf.unparse();
                        validate = (ValidationMode.Type)unparseOpts.validate().toOption().get();
                        optDafConfig = unparseOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$21(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                        if (unparseOpts.parser().isDefined()) {
                            v16 = this.createProcessorFromParser((File)unparseOpts.parser().apply(), (Option<String>)unparseOpts.path().toOption(), validate);
                        } else {
                            tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(unparseOpts.tunables(), optDafConfig);
                            v16 = this.createProcessorFromSchema((URI)unparseOpts.schema().apply(), (Option<RefQName>)unparseOpts.rootNS().toOption(), (Option<String>)unparseOpts.path().toOption(), (Map<String, String>)tunables, validate);
                        }
                        processor = v16.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$22(org.apache.daffodil.CLIConf$unparse$ scala.Option org.apache.daffodil.api.DFDL$DataProcessor ), (Lorg/apache/daffodil/api/DFDL$DataProcessor;)Lorg/apache/daffodil/api/DFDL$DataProcessor;)((CLIConf$unparse$)unparseOpts, (Option)optDafConfig));
                        var161_127 = unparseOpts.output().toOption();
                        if (var161_127 instanceof Some != false && "-".equals(var163_129 = (String)(var162_128 = (Some)var161_127).value()) != false ? true : None$.MODULE$.equals(var161_127) != false) {
                            v17 /* !! */  = System.out;
                        } else if (var161_127 instanceof Some) {
                            var164_130 = (Some)var161_127;
                            file = (String)var164_130.value();
                            v17 /* !! */  = new FileOutputStream(file);
                        } else {
                            throw new MatchError((Object)var161_127);
                        }
                        output = v17 /* !! */ ;
                        outChannel = Channels.newChannel(output);
                        var168_134 = unparseOpts.infile().toOption();
                        if (var168_134 instanceof Some != false && "-".equals(var170_136 = (String)(var169_135 = (Some)var168_134).value()) != false ? true : None$.MODULE$.equals(var168_134) != false) {
                            v18 = System.in;
                        } else if (var168_134 instanceof Some) {
                            var171_137 = (Some)var168_134;
                            fileName = (String)var171_137.value();
                            v18 = new FileInputStream(fileName);
                        } else {
                            throw new MatchError((Object)var168_134);
                        }
                        is = v18;
                        var174_140 = processor;
                        if (None$.MODULE$.equals(var174_140)) {
                            v19 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                        } else if (var174_140 instanceof Some) {
                            var175_141 = (Some)var174_140;
                            processor = (DFDL.DataProcessor)var175_141.value();
                            if (processor.isError()) {
                                throw Assert$.MODULE$.abort("Invariant broken: processor.isError.==(false)");
                            }
                            this.setupDebugOrTrace((HasSetDebugger)((DataProcessor)processor), conf);
                            if (BoxesRunTime.unboxToBoolean((Object)unparseOpts.stream().toOption().get())) {
                                scnr = new Scanner(is);
                                scnr.useDelimiter("\u0000");
                                v20 = new Some((Object)scnr);
                            } else {
                                v20 = None$.MODULE$;
                            }
                            maybeScanner = v20;
                            keepUnparsing = maybeScanner.isEmpty() != false || ((Scanner)maybeScanner.get()).hasNext() != false;
                            exitCode = Main$ExitCode$.MODULE$.Success();
                            while (keepUnparsing) {
                                eitherBytesOrStream = maybeScanner.isDefined() != false ? scala.package$.MODULE$.Left().apply((Object)((Scanner)maybeScanner.get()).next().getBytes()) : scala.package$.MODULE$.Right().apply((Object)is);
                                infosetType = (Enumeration.Value)unparseOpts.infosetType().toOption().get();
                                exiFactoryOpt = this.getExiFactoryOpt(infosetType, (Option<URI>)unparseOpts.schema().toOption());
                                inputterData = this.infosetDataToInputterData(infosetType, (Either<byte[], InputStream>)eitherBytesOrStream);
                                inputterOrContentHandler = this.getInfosetInputter(infosetType, inputterData, processor, outChannel);
                                var187_153 = inputterOrContentHandler;
                                if (var187_153 instanceof Left) {
                                    var188_154 = (Left)var187_153;
                                    inputter = (InfosetInputter)var188_154.value();
                                    v21 = (DFDL.UnparseResult)Timer$.MODULE$.getResult("unparsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$23(org.apache.daffodil.api.DFDL$DataProcessor org.apache.daffodil.infoset.InfosetInputter java.nio.channels.WritableByteChannel ), ()Lorg/apache/daffodil/api/DFDL$UnparseResult;)((DFDL.DataProcessor)processor, (InfosetInputter)inputter, (WritableByteChannel)outChannel));
                                } else if (var187_153 instanceof Right) {
                                    var190_156 = (Right)var187_153;
                                    contentHandler = (DFDL.DaffodilUnparseContentHandler)var190_156.value();
                                    var193_159 = inputterData;
                                    if (var193_159 instanceof byte[]) {
                                        var194_160 = (byte[])var193_159;
                                        v22 /* !! */  = new ByteArrayInputStream(var194_160);
                                    } else if (var193_159 instanceof InputStream) {
                                        var195_161 = (InputStream)var193_159;
                                        v22 /* !! */  = var195_161;
                                    } else {
                                        throw new MatchError(var193_159);
                                    }
                                    is /* !! */  = v22 /* !! */ ;
                                    v21 = (DFDL.UnparseResult)Timer$.MODULE$.getResult("unparsing", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$24(java.io.InputStream org.apache.daffodil.api.DFDL$DaffodilUnparseContentHandler scala.Enumeration$Value scala.Option ), ()Lorg/apache/daffodil/api/DFDL$UnparseResult;)((InputStream)is /* !! */ , (DFDL.DaffodilUnparseContentHandler)contentHandler, (Enumeration.Value)infosetType, exiFactoryOpt));
                                } else {
                                    throw new MatchError(var187_153);
                                }
                                unparseResult = v21;
                                this.displayDiagnostics((WithDiagnostics)unparseResult);
                                if (((DFDL.Result)unparseResult).isError()) {
                                    keepUnparsing = false;
                                    exitCode = Main$ExitCode$.MODULE$.UnparseError();
                                    continue;
                                }
                                keepUnparsing = maybeScanner.isDefined() != false && ((Scanner)maybeScanner.get()).hasNext() != false;
                            }
                            v19 = exitCode;
                        } else {
                            throw new MatchError((Object)var174_140);
                        }
                        rc = v19;
                        is.close();
                        outChannel.close();
                        v11 = rc;
                        break block98;
                    }
                    if (!var27_3) break block101;
                    var196_163 = (ScallopConfBase)var28_4.value();
                    if (!conf.save().equals(var196_163)) break block101;
                    saveOpts = conf.save();
                    validate = ValidationMode.Off$.MODULE$;
                    optDafConfig = saveOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$25(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                    tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(saveOpts.tunables(), optDafConfig);
                    tunablesObj = DaffodilTunables$.MODULE$.apply(tunables);
                    processor = this.createProcessorFromSchema((URI)saveOpts.schema().apply(), (Option<RefQName>)saveOpts.rootNS().toOption(), (Option<String>)saveOpts.path().toOption(), (Map<String, String>)tunables, (ValidationMode.Type)validate);
                    var204_170 = saveOpts.outfile().toOption();
                    if (var204_170 instanceof Some != false && "-".equals(var206_172 = (String)(var205_171 = (Some)var204_170).value()) != false ? true : None$.MODULE$.equals(var204_170) != false) {
                        v23 = Channels.newChannel(System.out);
                    } else if (var204_170 instanceof Some) {
                        var207_173 = (Some)var204_170;
                        file = (String)var207_173.value();
                        v23 = new FileOutputStream(file).getChannel();
                    } else {
                        throw new MatchError((Object)var204_170);
                    }
                    output = v23;
                    var210_176 = processor;
                    if (var210_176 instanceof Some) {
                        var211_177 = (Some)var210_176;
                        processor = (DFDL.DataProcessor)var211_177.value();
                        if (processor.isError()) {
                            throw Assert$.MODULE$.abort("Invariant broken: processor.isError.==(false)");
                        }
                        Timer$.MODULE$.getResult("saving", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$run$26(org.apache.daffodil.api.DFDL$DataProcessor java.nio.channels.WritableByteChannel ), ()V)((DFDL.DataProcessor)processor, (WritableByteChannel)output));
                        v24 = Main$ExitCode$.MODULE$.Success();
                    } else if (None$.MODULE$.equals(var210_176)) {
                        v24 = Main$ExitCode$.MODULE$.UnableToCreateProcessor();
                    } else {
                        throw new MatchError(var210_176);
                    }
                    v11 = rc = v24;
                    break block98;
                }
                if (!var27_3) break block102;
                var213_180 = (ScallopConfBase)var28_4.value();
                if (!conf.test().equals(var213_180)) break block102;
                testOpts = conf.test();
                tdmlFile = (String)testOpts.tdmlfile().apply();
                optTDMLImplementation = testOpts.implementation().toOption();
                tdmlRunner = Runner$.MODULE$.apply(tdmlFile, optTDMLImplementation);
                tests = (Seq)((SeqLike)((SeqLike)(testOpts.testnames().isDefined() != false ? ((List)testOpts.testnames().apply()).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$27(org.apache.daffodil.CLIConf$test$ org.apache.daffodil.tdml.Runner java.lang.String ), (Ljava/lang/String;)Lscala/collection/Seq;)((CLIConf$test$)testOpts, (Runner)tdmlRunner), List$.MODULE$.canBuildFrom()) : tdmlRunner.testCases().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$31(org.apache.daffodil.tdml.TestCase ), (Lorg/apache/daffodil/tdml/TestCase;)Lscala/Tuple2;)(), Seq$.MODULE$.canBuildFrom()))).distinct()).sortBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$32(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/String;)(), (Ordering)Ordering.String$.MODULE$);
                tdmlRunner.reset();
                if (BoxesRunTime.unboxToBoolean((Object)testOpts.list().apply())) {
                    if (BoxesRunTime.unboxToInt((Object)testOpts.info().apply()) > 0) {
                        headers = new .colon.colon((Object)"Name", (List)new .colon.colon((Object)"Model", (List)new .colon.colon((Object)"Root", (List)new .colon.colon((Object)"Description", (List)Nil$.MODULE$))));
                        maxCols = (List)tests.foldLeft(headers.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$33$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)(), List$.MODULE$.canBuildFrom()), (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$34(scala.collection.immutable.List scala.Tuple2 ), (Lscala/collection/immutable/List;Lscala/Tuple2;)Lscala/collection/immutable/List;)());
                        formatStr = ((TraversableOnce)maxCols.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$35$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString("  ");
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(formatStr)).format((Seq)headers));
                        tests.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$36$adapted(java.lang.String scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((String)formatStr));
                    } else {
                        tests.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$37$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)());
                    }
                    v11 = Main$ExitCode$.MODULE$.Success();
                } else {
                    pass = IntRef.create((int)0);
                    fail = IntRef.create((int)0);
                    notfound = IntRef.create((int)0);
                    tests.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$38$adapted(scala.runtime.IntRef scala.runtime.IntRef org.apache.daffodil.CLIConf$test$ scala.runtime.IntRef scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((IntRef)pass, (IntRef)fail, (CLIConf$test$)testOpts, (IntRef)notfound));
                    Predef$.MODULE$.println((Object)"");
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Total: %d, Pass: %d, Fail: %d, Not Found: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(pass.elem + fail.elem + notfound.elem)), BoxesRunTime.boxToInteger((int)pass.elem), BoxesRunTime.boxToInteger((int)fail.elem), BoxesRunTime.boxToInteger((int)notfound.elem)})));
                    v11 = fail.elem == 0 ? Main$ExitCode$.MODULE$.Success() : Main$ExitCode$.MODULE$.TestError();
                }
                break block98;
            }
            if (!var27_3) ** GOTO lbl447
            var225_192 = (ScallopConfBase)var28_4.value();
            if (!conf.generate().equals(var225_192)) ** GOTO lbl447
            var226_193 = conf.subcommands();
            var227_194 = List$.MODULE$.unapplySeq((Seq)var226_193);
            if (var227_194.isEmpty() || var227_194.get() == null || ((LinearSeqOptimized)var227_194.get()).lengthCompare(2) != 0) ** GOTO lbl-1000
            var228_195 = (ScallopConfBase)((LinearSeqOptimized)var227_194.get()).apply(0);
            var229_196 = (ScallopConfBase)((LinearSeqOptimized)var227_194.get()).apply(1);
            if (conf.generate().equals(var228_195) && conf.generate().c().equals(var229_196)) {
                generateOpts = conf.generate().c();
                optDafConfig = generateOpts.config().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$41(java.io.File ), (Ljava/io/File;)Lorg/apache/daffodil/api/DaffodilConfig;)());
                tunables = DaffodilTunables$.MODULE$.configPlusMoreTunablesMap(generateOpts.tunables(), optDafConfig);
                generator = this.createGeneratorFromSchema((URI)generateOpts.schema().apply(), (Option<RefQName>)generateOpts.rootNS().toOption(), (Map<String, String>)tunables, generateOpts.language());
                outputDir = (String)generateOpts.outdir().toOption().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$42(), ()Ljava/lang/String;)());
                var236_202 = generator;
                if (var236_202 instanceof Some) {
                    var237_203 = (Some)var236_202;
                    generator = (DFDL.CodeGenerator)var237_203.value();
                    Timer$.MODULE$.getResult("generating", (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$43(org.apache.daffodil.api.DFDL$CodeGenerator java.lang.String ), ()Los/Path;)((DFDL.CodeGenerator)generator, (String)outputDir));
                    this.displayDiagnostics((WithDiagnostics)generator);
                    v25 = generator.isError() ? Main$ExitCode$.MODULE$.GenerateCodeError() : Main$ExitCode$.MODULE$.Success();
                } else if (None$.MODULE$.equals(var236_202)) {
                    v25 = Main$ExitCode$.MODULE$.GenerateCodeError();
                } else {
                    throw new MatchError(var236_202);
                }
                v11 = rc = v25;
            } else lbl-1000:
            // 2 sources

            {
                throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
lbl447:
                // 2 sources

                throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
            }
        }
        ret = v11;
        return ret;
    }

    private DFDL.UnparseResult unparseWithSAX(InputStream is, DFDL.DaffodilUnparseContentHandler contentHandler, Enumeration.Value infosetType, Option<EXIFactory> exiFactoryOpt) {
        XMLReader xMLReader;
        boolean bl;
        Enumeration.Value value = infosetType;
        Enumeration.Value value2 = InfosetType$.MODULE$.EXI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = InfosetType$.MODULE$.EXISA();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            if (!exiFactoryOpt.isDefined()) {
                throw Assert$.MODULE$.abort("Invariant broken: exiFactoryOpt.isDefined");
            }
            EXISource exiSource = new EXISource((EXIFactory)exiFactoryOpt.get());
            xMLReader = exiSource.getXMLReader();
        } else {
            xMLReader = DaffodilSAXParserFactory$.MODULE$.apply().newSAXParser().getXMLReader();
        }
        XMLReader xmlReader = xMLReader;
        xmlReader.setContentHandler((ContentHandler)contentHandler);
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE(), true);
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
        try {
            xmlReader.parse(new InputSource(is));
        }
        catch (DFDL.DaffodilUnparseErrorSAXException daffodilUnparseErrorSAXException) {}
        DFDL.UnparseResult ur = contentHandler.getUnparseResult();
        return ur;
    }

    private DFDL.ParseResult parseWithSAX(DFDL.DataProcessor processor, InputSourceDataInputStream data, ContentHandler saxContentHandler) {
        DFDL.DaffodilParseXMLReader saxXmlRdr = processor.newXMLReaderInstance();
        saxXmlRdr.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
        saxXmlRdr.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBDIRECTORY(), (Object)this.blobDir());
        saxXmlRdr.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBSUFFIX(), (Object)this.blobSuffix());
        saxXmlRdr.setContentHandler(saxContentHandler);
        saxXmlRdr.parse(data);
        DFDL.ParseResult pr = (DFDL.ParseResult)saxXmlRdr.getProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_PARSERESULT());
        return pr;
    }

    public int bugFound(Exception e) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("|\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |!!   An unexpected exception occurred. This is a bug!   !!\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |\n                          | Please report this bug and help us fix it:\n                          |\n                          |  https://daffodil.apache.org/community/#issue-tracker\n                          |\n                          | Please include the following exception, the command you\n                          | ran, and any input, schema, or tdml files used that led\n                          | to this bug.\n                          |\n                          |")).stripMargin());
        e.printStackTrace();
        return 1;
    }

    public int nyiFound(NotYetImplementedException e) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("|\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |!!                 Not Yet Implemented                  !!\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |\n                          | You are using a feature that is not yet implemented:\n                          |\n                          | %s\n                          |\n                          | You can create a bug and track the progress of this\n                          | feature at:\n                          |\n                          |  https://issues.apache.org/jira/projects/DAFFODIL\n                          |\n                          |")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getSomeMessage((Throwable)e)})))).stripMargin());
        return 1;
    }

    public int oomError(OutOfMemoryError e) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("|\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |!!             Daffodil ran out of memory!              !!\n                          |!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n                          |\n                          | Try increasing the amount of memory by changing or\n                          | setting the DAFFODIL_JAVA_OPTS environment variable.\n                          | \"DAFFODIL_JAVA_OPTS=-Xmx5G\" for 5GB.\n                          |\n                          |")).stripMargin());
        return 1;
    }

    public void main(String[] arguments) {
        Enumeration.Value value;
        try {
            value = this.run(arguments);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 instanceof FileNotFoundException) {
                BoxedUnit boxedUnit;
                FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)fileNotFoundException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value = Main$ExitCode$.MODULE$.FileNotFound();
            }
            if (throwable2 instanceof ExternalVariableException) {
                BoxedUnit boxedUnit;
                ExternalVariableException externalVariableException = (ExternalVariableException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)externalVariableException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value = Main$ExitCode$.MODULE$.BadExternalVariable();
            }
            if (throwable2 instanceof BindingException) {
                BoxedUnit boxedUnit;
                BindingException bindingException = (BindingException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)bindingException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value = Main$ExitCode$.MODULE$.BadExternalVariable();
            }
            if (throwable2 instanceof NotYetImplementedException) {
                NotYetImplementedException notYetImplementedException = (NotYetImplementedException)throwable2;
                this.nyiFound(notYetImplementedException);
                value = Main$ExitCode$.MODULE$.NotYetImplemented();
            }
            if (throwable2 instanceof TDMLException) {
                BoxedUnit boxedUnit;
                Throwable throwable3 = throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage(throwable3).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                value = Main$ExitCode$.MODULE$.TestError();
            }
            if (throwable2 instanceof OutOfMemoryError) {
                OutOfMemoryError outOfMemoryError = (OutOfMemoryError)throwable2;
                this.oomError(outOfMemoryError);
                value = Main$ExitCode$.MODULE$.OutOfMemory();
            }
            if (throwable2 instanceof UserDefinedFunctionFatalErrorException) {
                BoxedUnit boxedUnit;
                UserDefinedFunctionFatalErrorException userDefinedFunctionFatalErrorException = (UserDefinedFunctionFatalErrorException)throwable2;
                if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                    org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)Misc$.MODULE$.getSomeMessage((Throwable)userDefinedFunctionFatalErrorException).get(), null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userDefinedFunctionFatalErrorException.cause().getStackTrace())).take(10))).foreach((Function1 & Serializable & scala.Serializable)ste -> {
                    Main$.$anonfun$main$1(ste);
                    return BoxedUnit.UNIT;
                });
                value = Main$ExitCode$.MODULE$.UserDefinedFunctionError();
            }
            if (throwable2 instanceof DebuggerExitException) {
                value = Main$ExitCode$.MODULE$.Failure();
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                this.bugFound(exception);
                value = Main$ExitCode$.MODULE$.BugFound();
            }
            throw throwable;
        }
        Enumeration.Value ret = value;
        System.exit(ret.id());
    }

    public static final /* synthetic */ boolean $anonfun$overrideBindings$2(Binding b$1, Binding p) {
        return b$1.hashCode() == p.hashCode();
    }

    public static final /* synthetic */ void $anonfun$displayDiagnostics$1(Diagnostic d) {
        BoxedUnit boxedUnit;
        if (d.isError()) {
            BoxedUnit boxedUnit2;
            if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
                org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)d.getMessage(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        if (Logger$.MODULE$.log().isEnabled(Level.WARN)) {
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)d.getMessage(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$1(File x$4) {
        return DaffodilConfig$.MODULE$.fromFile(x$4);
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$2(CLIConf$parse$ parseOpts$1, Option optDafConfig$1, DFDL.DataProcessor x$5) {
        return x$5.withExternalVariables(MODULE$.combineExternalVariables((Map<String, String>)parseOpts$1.vars(), (Option<DaffodilConfig>)optDafConfig$1));
    }

    public static final /* synthetic */ DFDL.ParseResult $anonfun$run$3(ObjectRef processor$1, InputSourceDataInputStream inStream$1, ContentHandler saxContentHandler$1) {
        return MODULE$.parseWithSAX((DFDL.DataProcessor)processor$1.elem, inStream$1, saxContentHandler$1);
    }

    public static final /* synthetic */ DFDL.ParseResult $anonfun$run$4(ObjectRef processor$1, InputSourceDataInputStream inStream$1, InfosetOutputter outputter$1) {
        return ((DFDL.DataProcessor)processor$1.elem).parse(inStream$1, outputter$1);
    }

    public static final /* synthetic */ String $anonfun$run$5(byte a) {
        byte arg$macro$3 = a;
        return new StringOps("%02x").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)arg$macro$3)}));
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$6(File x$6) {
        return DaffodilConfig$.MODULE$.fromFile(x$6);
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$7(CLIConf$performance$ performanceOpts$1, Option optDafConfig$2, DFDL.DataProcessor x$7) {
        return x$7.withExternalVariables(MODULE$.combineExternalVariables((Map<String, String>)performanceOpts$1.vars(), (Option<DaffodilConfig>)optDafConfig$2));
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$8(ValidationMode.Type validate$1, DFDL.DataProcessor x$8) {
        return x$8.withValidationMode(validate$1);
    }

    public static final /* synthetic */ boolean $anonfun$run$9(File x$9) {
        return !x$9.isDirectory();
    }

    public static final /* synthetic */ Either $anonfun$run$10(CLIConf$performance$ performanceOpts$1, Enumeration.Value infosetType$1, File filePath) {
        Right right;
        FileInputStream input = new FileInputStream(filePath);
        long dataSize = filePath.length();
        byte[] bytes = new byte[(int)dataSize];
        input.read(bytes);
        boolean bl = BoxesRunTime.unboxToBoolean((Object)performanceOpts$1.unparse().apply());
        if (bl) {
            right = scala.package$.MODULE$.Left().apply(MODULE$.infosetDataToInputterData(infosetType$1, (Either<byte[], InputStream>)scala.package$.MODULE$.Left().apply((Object)bytes)));
        } else if (!bl) {
            right = scala.package$.MODULE$.Right().apply((Object)bytes);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Right data = right;
        return data;
    }

    public static final /* synthetic */ Either $anonfun$run$11(Seq dataSeq$1, int n) {
        int index = n % dataSeq$1.length();
        return (Either)dataSeq$1.apply(index);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$run$12(IndexedSeq inputsWithIndex$1, Enumeration.Value infosetType$1, DFDL.DataProcessor processor$2, WritableByteChannel nullChannelForUnparse$1, Option exiFactoryOpt$1, NullOutputStream nullOutputStreamForParse$1, ExecutionContext executionContext$1) {
        IndexedSeq tasks = (IndexedSeq)inputsWithIndex$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Either inData = (Either)tuple2._1();
                int n = tuple2._2$mcI$sp();
                Future task = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Tuple2 tuple2;
                    Either either = inData;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Object anyRef = left.value();
                        tuple2 = Timer$.MODULE$.getTimeResult((Function0 & Serializable & scala.Serializable)() -> {
                            Either<InfosetInputter, DFDL.DaffodilUnparseContentHandler> inputterForUnparse = MODULE$.getInfosetInputter(infosetType$1, anyRef, processor$2, nullChannelForUnparse$1);
                            Either<InfosetInputter, DFDL.DaffodilUnparseContentHandler> either = inputterForUnparse;
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                InfosetInputter inputter = (InfosetInputter)left.value();
                                return processor$2.unparse(inputter, nullChannelForUnparse$1);
                            }
                            if (either instanceof Right) {
                                InputStream inputStream;
                                Right right = (Right)either;
                                DFDL.DaffodilUnparseContentHandler contentHandler = (DFDL.DaffodilUnparseContentHandler)right.value();
                                Object object = anyRef;
                                if (object instanceof byte[]) {
                                    byte[] byArray = (byte[])object;
                                    inputStream = new ByteArrayInputStream(byArray);
                                } else if (object instanceof InputStream) {
                                    InputStream inputStream2 = (InputStream)object;
                                    inputStream = inputStream2;
                                } else {
                                    throw new MatchError(object);
                                }
                                InputStream is = inputStream;
                                return MODULE$.unparseWithSAX(is, contentHandler, infosetType$1, (Option<EXIFactory>)exiFactoryOpt$1);
                            }
                            throw new MatchError(either);
                        });
                    } else if (either instanceof Right) {
                        Right right = (Right)either;
                        byte[] data = (byte[])right.value();
                        tuple2 = Timer$.MODULE$.getTimeResult((Function0 & Serializable & scala.Serializable)() -> {
                            InputSourceDataInputStream input = InputSourceDataInputStream$.MODULE$.apply(data);
                            Either<InfosetOutputter, ContentHandler> eitherOutputterOrHandlerForParse = MODULE$.getInfosetOutputter(infosetType$1, (OutputStream)nullOutputStreamForParse$1, (Option<EXIFactory>)exiFactoryOpt$1);
                            Either<InfosetOutputter, ContentHandler> either = eitherOutputterOrHandlerForParse;
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                InfosetOutputter outputter = (InfosetOutputter)left.value();
                                return processor$2.parse(input, outputter);
                            }
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                ContentHandler saxContentHandler = (ContentHandler)right.value();
                                DFDL.ParseResult parseResult = MODULE$.parseWithSAX(processor$2, input, saxContentHandler);
                                return parseResult;
                            }
                            throw new MatchError(either);
                        });
                    } else {
                        throw new MatchError((Object)either);
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    long time = tuple22._1$mcJ$sp();
                    DFDL.Result result = (DFDL.Result)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)result);
                    long time2 = tuple23._1$mcJ$sp();
                    DFDL.Result result2 = (DFDL.Result)tuple23._2();
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToLong((long)time2), (Object)BoxesRunTime.boxToBoolean((boolean)result2.isError()));
                }, executionContext$1);
                return task;
            }
            throw new MatchError((Object)tuple2);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq results = (IndexedSeq)tasks.map((Function1 & Serializable & scala.Serializable)x$11 -> (Tuple3)Await$.MODULE$.result((Awaitable)x$11, (Duration)Duration$.MODULE$.Inf()), IndexedSeq$.MODULE$.canBuildFrom());
        return results;
    }

    public static final /* synthetic */ double $anonfun$run$18(double NSConvert$1, Tuple3 results) {
        BoxedUnit boxedUnit;
        String status;
        Tuple3 tuple3 = results;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int runNum = BoxesRunTime.unboxToInt((Object)tuple3._1());
        long nsTime = BoxesRunTime.unboxToLong((Object)tuple3._2());
        boolean error = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        int n = runNum;
        long l = nsTime;
        boolean bl = error;
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToBoolean((boolean)bl));
        int runNum2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        long nsTime2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
        boolean error2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
        double rate = 1.0 / ((double)nsTime2 / NSConvert$1);
        String string = status = error2 ? "fail" : "pass";
        if (Logger$.MODULE$.log().isEnabled(Level.INFO)) {
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.INFO, null, (CharSequence)new StringBuilder(34).append("run: ").append(runNum2).append(", seconds: ").append((double)nsTime2 / NSConvert$1).append(", rate: ").append(rate).append(", status: ").append(status).toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return rate;
    }

    public static final /* synthetic */ boolean $anonfun$run$19(Tuple3 x$14) {
        return BoxesRunTime.unboxToBoolean((Object)x$14._3());
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$21(File x$15) {
        return DaffodilConfig$.MODULE$.fromFile(x$15);
    }

    public static final /* synthetic */ DFDL.DataProcessor $anonfun$run$22(CLIConf$unparse$ unparseOpts$1, Option optDafConfig$3, DFDL.DataProcessor x$16) {
        return x$16.withExternalVariables(MODULE$.combineExternalVariables((Map<String, String>)unparseOpts$1.vars(), (Option<DaffodilConfig>)optDafConfig$3));
    }

    public static final /* synthetic */ DFDL.UnparseResult $anonfun$run$23(DFDL.DataProcessor processor$3, InfosetInputter inputter$1, WritableByteChannel outChannel$1) {
        return processor$3.unparse(inputter$1, outChannel$1);
    }

    public static final /* synthetic */ DFDL.UnparseResult $anonfun$run$24(InputStream is$1, DFDL.DaffodilUnparseContentHandler contentHandler$1, Enumeration.Value infosetType$2, Option exiFactoryOpt$2) {
        return MODULE$.unparseWithSAX(is$1, contentHandler$1, infosetType$2, (Option<EXIFactory>)exiFactoryOpt$2);
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$25(File x$17) {
        return DaffodilConfig$.MODULE$.fromFile(x$17);
    }

    public static final /* synthetic */ void $anonfun$run$26(DFDL.DataProcessor processor$4, WritableByteChannel output$1) {
        processor$4.save(output$1);
    }

    public static final /* synthetic */ boolean $anonfun$run$28(Regex regex$1, TestCase testCase) {
        return regex$1.pattern().matcher(testCase.tcName()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$run$30(String testName$1, TestCase x$18) {
        String string = x$18.tcName();
        String string2 = testName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$run$27(CLIConf$test$ testOpts$1, Runner tdmlRunner$1, String testName) {
        if (BoxesRunTime.unboxToBoolean((Object)testOpts$1.regex().apply())) {
            Regex regex = new StringOps(Predef$.MODULE$.augmentString(testName)).r();
            Seq matches = (Seq)tdmlRunner$1.testCases().filter((Function1 & Serializable & scala.Serializable)testCase -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$28(regex, testCase)));
            return (Seq)matches.map((Function1 & Serializable & scala.Serializable)testCase -> new Tuple2((Object)testCase.tcName(), (Object)new Some(testCase)), Seq$.MODULE$.canBuildFrom());
        }
        return new .colon.colon((Object)new Tuple2((Object)testName, (Object)tdmlRunner$1.testCases().find((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$30(testName, x$18)))), (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ Tuple2 $anonfun$run$31(TestCase test) {
        return new Tuple2((Object)test.tcName(), (Object)new Some((Object)test));
    }

    public static final /* synthetic */ String $anonfun$run$32(Tuple2 x$19) {
        return (String)x$19._1();
    }

    public static final /* synthetic */ List $anonfun$run$34(List maxVals, Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(0))), name.length()), BoxesRunTime.unboxToInt((Object)maxVals.apply(1)), BoxesRunTime.unboxToInt((Object)maxVals.apply(2)), BoxesRunTime.unboxToInt((Object)maxVals.apply(3))}));
            }
        }
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                TestCase test = (TestCase)some.value();
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(0))), name.length()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(1))), test.model().length()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(2))), test.rootName().length()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxVals.apply(3))), test.description().length())}));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$run$35(int max) {
        return new StringBuilder(2).append("%").append(-max).append("s").toString();
    }

    public static final /* synthetic */ void $anonfun$run$36(String formatStr$1, Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                TestCase test = (TestCase)some.value();
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(formatStr$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, test.model(), test.rootName(), test.description()})));
                return;
            }
        }
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(formatStr$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, "[Not Found]", "", ""})));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$run$37(Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Predef$.MODULE$.println((Object)name);
                return;
            }
        }
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s  [Not Found]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$run$38(IntRef pass$1, IntRef fail$1, CLIConf$test$ testOpts$1, IntRef notfound$1, Tuple2 testPair) {
        Tuple2 tuple2 = testPair;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                TestCase test = (TestCase)some.value();
                try {
                    test.run();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Pass] %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                    ++pass$1.elem;
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof ControlThrowable) {
                        ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                        throw (Throwable)controlThrowable;
                    }
                    if (throwable2 instanceof UnsuppressableException) {
                        UnsuppressableException unsuppressableException = (UnsuppressableException)throwable2;
                        throw unsuppressableException;
                    }
                    if (throwable2 instanceof TDMLTestNotCompatibleException) {
                        TDMLTestNotCompatibleException tDMLTestNotCompatibleException = (TDMLTestNotCompatibleException)throwable2;
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Skipped] %s (not compatible with implementation %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, tDMLTestNotCompatibleException.implementation().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<none>")})));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Fail] %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        ++fail$1.elem;
                        if (BoxesRunTime.unboxToInt((Object)testOpts$1.info().apply()) > 0) {
                            Predef$.MODULE$.println((Object)"  Failure Information:");
                            Predef$.MODULE$.println((Object)MODULE$.indent(throwable3.getMessage(), 4));
                        }
                        if (BoxesRunTime.unboxToInt((Object)testOpts$1.info().apply()) > 1) {
                            Predef$.MODULE$.println((Object)"  Backtrace:");
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throwable3.getStackTrace())).foreach((Function1 & Serializable & scala.Serializable)st -> {
                                Predef$.MODULE$.println((Object)Main$.MODULE$.indent(st.toString(), 4));
                                return BoxedUnit.UNIT;
                            });
                        }
                    } else {
                        throw throwable;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("[Not Found] %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                ++notfound$1.elem;
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ DaffodilConfig $anonfun$run$41(File x$21) {
        return DaffodilConfig$.MODULE$.fromFile(x$21);
    }

    public static final /* synthetic */ String $anonfun$run$42() {
        return ".";
    }

    public static final /* synthetic */ os.Path $anonfun$run$43(DFDL.CodeGenerator generator$1, String outputDir$1) {
        return generator$1.generateCode(outputDir$1);
    }

    public static final /* synthetic */ void $anonfun$main$1(StackTraceElement ste) {
        BoxedUnit boxedUnit;
        if (Logger$.MODULE$.log().isEnabled(Level.ERROR)) {
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.ERROR, null, (CharSequence)new StringBuilder(7).append("    at ").append(ste).toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Main$() {
        MODULE$ = this;
        this.traceCommands = (Seq)new .colon.colon((Object)"display info parser", (List)new .colon.colon((Object)"display info data", (List)new .colon.colon((Object)"display info infoset", (List)new .colon.colon((Object)"display info diff", (List)new .colon.colon((Object)"trace", (List)Nil$.MODULE$)))));
        this.blobDir = Paths.get(System.getProperty("user.dir"), "daffodil-blobs");
        this.blobSuffix = ".bin";
    }

    public static final /* synthetic */ String $anonfun$run$5$adapted(Object a) {
        return Main$.$anonfun$run$5(BoxesRunTime.unboxToByte((Object)a));
    }

    public static final /* synthetic */ Object $anonfun$run$9$adapted(File x$9) {
        return BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$9(x$9));
    }

    public static final /* synthetic */ Either $anonfun$run$11$adapted(Seq dataSeq$1, Object n) {
        return Main$.$anonfun$run$11(dataSeq$1, BoxesRunTime.unboxToInt((Object)n));
    }

    public static final /* synthetic */ Object $anonfun$run$18$adapted(double NSConvert$1, Tuple3 results) {
        return BoxesRunTime.boxToDouble((double)Main$.$anonfun$run$18(NSConvert$1, results));
    }

    public static final /* synthetic */ Object $anonfun$run$19$adapted(Tuple3 x$14) {
        return BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$run$19(x$14));
    }

    public static final /* synthetic */ Object $anonfun$run$20$adapted(Object e) {
        return BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)e));
    }

    public static final /* synthetic */ Object $anonfun$run$33$adapted(String x$20) {
        return BoxesRunTime.boxToInteger((int)x$20.length());
    }

    public static final /* synthetic */ String $anonfun$run$35$adapted(Object max) {
        return Main$.$anonfun$run$35(BoxesRunTime.unboxToInt((Object)max));
    }

    public static final /* synthetic */ Object $anonfun$run$36$adapted(String formatStr$1, Tuple2 testPair) {
        Main$.$anonfun$run$36(formatStr$1, testPair);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$run$37$adapted(Tuple2 testPair) {
        Main$.$anonfun$run$37(testPair);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$run$38$adapted(IntRef pass$1, IntRef fail$1, CLIConf$test$ testOpts$1, IntRef notfound$1, Tuple2 testPair) {
        Main$.$anonfun$run$38(pass$1, fail$1, testOpts$1, notfound$1, testPair);
        return BoxedUnit.UNIT;
    }
}

