/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.types;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.core.datatype.charset.XSDBase64CharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDHexBinaryCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDStringCharacterSet;
import com.siemens.ct.exi.core.datatype.strings.StringEncoder;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.io.channel.EncoderChannel;
import com.siemens.ct.exi.core.types.AbstractTypeEncoder;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalTypeEncoder
extends AbstractTypeEncoder {
    protected RestrictedCharacterSetDatatype rcsBase64Binary = new RestrictedCharacterSetDatatype(new XSDBase64CharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsHexBinary = new RestrictedCharacterSetDatatype(new XSDHexBinaryCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsBoolean = new RestrictedCharacterSetDatatype(new XSDBooleanCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDateTime = new RestrictedCharacterSetDatatype(new XSDDateTimeCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDecimal = new RestrictedCharacterSetDatatype(new XSDDecimalCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDouble = new RestrictedCharacterSetDatatype(new XSDDoubleCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsInteger = new RestrictedCharacterSetDatatype(new XSDIntegerCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsString = new RestrictedCharacterSetDatatype(new XSDStringCharacterSet(), null);
    protected Value lastValue;
    public Datatype lastDatatype;

    public LexicalTypeEncoder() throws EXIException {
        this(null, null, null);
    }

    public LexicalTypeEncoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
    }

    @Override
    public boolean isValid(Datatype datatype, Value value) {
        this.lastDatatype = this.dtrMapInUse ? this.getDtrDatatype(datatype) : datatype;
        this.lastValue = value;
        return true;
    }

    @Override
    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        String lastValueString = this.lastValue.toString();
        switch (this.lastDatatype.getDatatypeID()) {
            case exi_base64Binary: {
                this.isValid(this.rcsBase64Binary, this.lastValue);
                this.writeRCSValue(this.rcsBase64Binary, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_hexBinary: {
                this.isValid(this.rcsHexBinary, this.lastValue);
                this.writeRCSValue(this.rcsHexBinary, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_boolean: {
                this.isValid(this.rcsBoolean, this.lastValue);
                this.writeRCSValue(this.rcsBoolean, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_dateTime: 
            case exi_time: 
            case exi_date: 
            case exi_gYearMonth: 
            case exi_gYear: 
            case exi_gMonthDay: 
            case exi_gDay: 
            case exi_gMonth: {
                this.isValid(this.rcsDateTime, this.lastValue);
                this.writeRCSValue(this.rcsDateTime, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_decimal: {
                this.isValid(this.rcsDecimal, this.lastValue);
                this.writeRCSValue(this.rcsDecimal, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_double: {
                this.isValid(this.rcsDouble, this.lastValue);
                this.writeRCSValue(this.rcsDouble, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_integer: {
                this.isValid(this.rcsInteger, this.lastValue);
                this.writeRCSValue(this.rcsInteger, qnContext, valueChannel, stringEncoder, lastValueString);
                break;
            }
            case exi_string: {
                stringEncoder.writeValue(qnContext, valueChannel, this.lastValue.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

