/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.types;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.core.datatype.charset.XSDBase64CharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDHexBinaryCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.core.datatype.charset.XSDStringCharacterSet;
import com.siemens.ct.exi.core.datatype.strings.StringDecoder;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.io.channel.DecoderChannel;
import com.siemens.ct.exi.core.types.AbstractTypeDecoder;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalTypeDecoder
extends AbstractTypeDecoder {
    protected RestrictedCharacterSetDatatype rcsBase64Binary = new RestrictedCharacterSetDatatype(new XSDBase64CharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsHexBinary = new RestrictedCharacterSetDatatype(new XSDHexBinaryCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsBoolean = new RestrictedCharacterSetDatatype(new XSDBooleanCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDateTime = new RestrictedCharacterSetDatatype(new XSDDateTimeCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDecimal = new RestrictedCharacterSetDatatype(new XSDDecimalCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDouble = new RestrictedCharacterSetDatatype(new XSDDoubleCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsInteger = new RestrictedCharacterSetDatatype(new XSDIntegerCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsString = new RestrictedCharacterSetDatatype(new XSDStringCharacterSet(), null);

    public LexicalTypeDecoder() throws EXIException {
        this(null, null, null);
    }

    public LexicalTypeDecoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
    }

    @Override
    public Value readValue(Datatype datatype, QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        if (this.dtrMapInUse) {
            datatype = this.getDtrDatatype(datatype);
        }
        switch (datatype.getDatatypeID()) {
            case exi_base64Binary: {
                return this.readRCSValue(this.rcsBase64Binary, qnContext, valueChannel, stringDecoder);
            }
            case exi_hexBinary: {
                return this.readRCSValue(this.rcsHexBinary, qnContext, valueChannel, stringDecoder);
            }
            case exi_boolean: {
                return this.readRCSValue(this.rcsBoolean, qnContext, valueChannel, stringDecoder);
            }
            case exi_dateTime: 
            case exi_time: 
            case exi_date: 
            case exi_gYearMonth: 
            case exi_gYear: 
            case exi_gMonthDay: 
            case exi_gDay: 
            case exi_gMonth: {
                return this.readRCSValue(this.rcsDateTime, qnContext, valueChannel, stringDecoder);
            }
            case exi_decimal: {
                return this.readRCSValue(this.rcsDecimal, qnContext, valueChannel, stringDecoder);
            }
            case exi_double: {
                return this.readRCSValue(this.rcsDouble, qnContext, valueChannel, stringDecoder);
            }
            case exi_integer: {
                return this.readRCSValue(this.rcsInteger, qnContext, valueChannel, stringDecoder);
            }
            case exi_string: {
                return stringDecoder.readValue(qnContext, valueChannel);
            }
        }
        throw new UnsupportedOperationException();
    }
}

