/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.types;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.BinaryBase64Datatype;
import com.siemens.ct.exi.core.datatype.BinaryHexDatatype;
import com.siemens.ct.exi.core.datatype.BooleanDatatype;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.DatatypeID;
import com.siemens.ct.exi.core.datatype.DatetimeDatatype;
import com.siemens.ct.exi.core.datatype.DecimalDatatype;
import com.siemens.ct.exi.core.datatype.ExtendedStringDatatype;
import com.siemens.ct.exi.core.datatype.FloatDatatype;
import com.siemens.ct.exi.core.datatype.IntegerDatatype;
import com.siemens.ct.exi.core.datatype.ListDatatype;
import com.siemens.ct.exi.core.datatype.StringDatatype;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.types.BuiltIn;
import com.siemens.ct.exi.core.types.BuiltInType;
import com.siemens.ct.exi.core.types.DateTimeType;
import com.siemens.ct.exi.core.types.TypeCoder;
import com.siemens.ct.exi.core.util.xml.QNameUtilities;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeCoder
implements TypeCoder {
    protected final QName[] dtrMapTypes;
    protected final QName[] dtrMapRepresentations;
    protected final Map<QName, Datatype> dtrMapRepresentationsDatatype;
    protected Map<QName, Datatype> dtrMap;
    protected final boolean dtrMapInUse;

    public AbstractTypeCoder() throws EXIException {
        this(null, null, null);
    }

    public AbstractTypeCoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        this.dtrMapTypes = dtrMapTypes;
        this.dtrMapRepresentations = dtrMapRepresentations;
        this.dtrMapRepresentationsDatatype = dtrMapRepresentationsDatatype;
        if (dtrMapTypes == null) {
            this.dtrMapInUse = false;
        } else {
            this.dtrMapInUse = true;
            this.dtrMap = new HashMap<QName, Datatype>();
            assert (dtrMapTypes.length == dtrMapRepresentations.length);
            this.initDtrMaps();
        }
    }

    private void initDtrMaps() throws EXIException {
        assert (this.dtrMapInUse);
        this.dtrMap.put(BuiltIn.XSD_BASE64BINARY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "base64Binary"));
        this.dtrMap.put(BuiltIn.XSD_HEXBINARY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "hexBinary"));
        this.dtrMap.put(BuiltIn.XSD_BOOLEAN, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "boolean"));
        this.dtrMap.put(BuiltIn.XSD_DATETIME, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "dateTime"));
        this.dtrMap.put(BuiltIn.XSD_TIME, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "time"));
        this.dtrMap.put(BuiltIn.XSD_DATE, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "date"));
        this.dtrMap.put(BuiltIn.XSD_GYEARMONTH, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gYearMonth"));
        this.dtrMap.put(BuiltIn.XSD_GYEAR, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gYear"));
        this.dtrMap.put(BuiltIn.XSD_GMONTHDAY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gMonthDay"));
        this.dtrMap.put(BuiltIn.XSD_GDAY, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gDay"));
        this.dtrMap.put(BuiltIn.XSD_GMONTH, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "gMonth"));
        this.dtrMap.put(BuiltIn.XSD_DECIMAL, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "decimal"));
        this.dtrMap.put(BuiltIn.XSD_FLOAT, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "double"));
        this.dtrMap.put(BuiltIn.XSD_DOUBLE, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "double"));
        this.dtrMap.put(BuiltIn.XSD_INTEGER, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "integer"));
        this.dtrMap.put(BuiltIn.XSD_STRING, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "string"));
        this.dtrMap.put(BuiltIn.XSD_ANY_SIMPLE_TYPE, this.getDatatypeRepresentation("http://www.w3.org/2009/exi", "string"));
        for (int i = 0; i < this.dtrMapTypes.length; ++i) {
            QName dtrMapRepr = this.dtrMapRepresentations[i];
            Datatype representation = this.getDatatypeRepresentation(dtrMapRepr.getNamespaceURI(), dtrMapRepr.getLocalPart());
            QName type = this.dtrMapTypes[i];
            this.dtrMap.put(type, representation);
        }
    }

    protected Datatype getDtrDatatype(Datatype datatype) {
        assert (this.dtrMapInUse);
        Datatype dtrDatatype = null;
        if (datatype.equals(BuiltIn.getDefaultDatatype())) {
            dtrDatatype = datatype;
        } else {
            QName schemBaseType;
            Datatype baseDatatype;
            QName schemaType = datatype.getSchemaType().getQName();
            if (dtrDatatype == null && datatype.getBuiltInType() == BuiltInType.STRING && ((StringDatatype)datatype).isDerivedByUnion()) {
                if (this.dtrMap.containsKey(schemaType)) {
                    dtrDatatype = this.dtrMap.get(schemaType);
                } else {
                    baseDatatype = datatype.getBaseDatatype();
                    schemBaseType = baseDatatype.getSchemaType().getQName();
                    dtrDatatype = baseDatatype.getBuiltInType() == BuiltInType.STRING && ((StringDatatype)baseDatatype).isDerivedByUnion() && this.dtrMap.containsKey(schemBaseType) ? this.dtrMap.get(schemBaseType) : datatype;
                }
            }
            if (dtrDatatype == null && datatype.getBuiltInType() == BuiltInType.LIST) {
                ListDatatype ldt = (ListDatatype)datatype;
                if (this.dtrMap.containsKey(schemaType)) {
                    dtrDatatype = this.dtrMap.get(schemaType);
                } else if (this.dtrMap.containsKey(ldt.getListDatatype().getSchemaType().getQName())) {
                    Datatype dt = this.dtrMap.get(ldt.getListDatatype().getSchemaType().getQName());
                    dtrDatatype = new ListDatatype(dt, datatype.getSchemaType());
                } else {
                    Datatype baseDatatype2 = datatype.getBaseDatatype();
                    QName schemBaseType2 = baseDatatype2.getSchemaType().getQName();
                    dtrDatatype = baseDatatype2.getBuiltInType() == BuiltInType.LIST && this.dtrMap.containsKey(schemBaseType2) ? this.dtrMap.get(schemBaseType2) : datatype;
                }
            }
            if (dtrDatatype == null && datatype.getBuiltInType() == BuiltInType.ENUMERATION) {
                if (this.dtrMap.containsKey(schemaType)) {
                    dtrDatatype = this.dtrMap.get(schemaType);
                } else {
                    baseDatatype = datatype.getBaseDatatype();
                    schemBaseType = baseDatatype.getSchemaType().getQName();
                    dtrDatatype = baseDatatype.getBuiltInType() == BuiltInType.ENUMERATION && this.dtrMap.containsKey(schemBaseType) ? this.dtrMap.get(schemBaseType) : datatype;
                }
            }
            if (dtrDatatype == null) {
                dtrDatatype = this.dtrMap.get(schemaType);
                if (dtrDatatype == null) {
                    dtrDatatype = this.updateDtrDatatype(datatype);
                }
                if (dtrDatatype.getDatatypeID() == DatatypeID.exi_estring && datatype.getGrammarEnumeration() != null) {
                    ExtendedStringDatatype esdt = (ExtendedStringDatatype)dtrDatatype;
                    esdt.setGrammarStrings(datatype.getGrammarEnumeration());
                }
            }
        }
        return dtrDatatype;
    }

    protected Datatype updateDtrDatatype(Datatype datatype) {
        assert (this.dtrMapInUse);
        Datatype baseDatatype = datatype.getBaseDatatype();
        QNameContext simpleBaseType = baseDatatype.getSchemaType();
        Datatype dtrDatatype = this.dtrMap.get(simpleBaseType.getQName());
        if (dtrDatatype == null) {
            dtrDatatype = this.updateDtrDatatype(baseDatatype);
        }
        if (!(dtrDatatype.getBuiltInType() != BuiltInType.INTEGER && dtrDatatype.getBuiltInType() != BuiltInType.UNSIGNED_INTEGER || datatype.getBuiltInType() != BuiltInType.NBIT_UNSIGNED_INTEGER && datatype.getBuiltInType() != BuiltInType.UNSIGNED_INTEGER)) {
            dtrDatatype = datatype;
        }
        this.dtrMap.put(datatype.getSchemaType().getQName(), dtrDatatype);
        return dtrDatatype;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Datatype getDatatypeRepresentation(String reprUri, String reprLocalPart) throws EXIException {
        assert (this.dtrMapInUse);
        try {
            void var3_23;
            Object var3_3 = null;
            if ("http://www.w3.org/2009/exi".equals(reprUri)) {
                if ("base64Binary".equals(reprLocalPart)) {
                    BinaryBase64Datatype binaryBase64Datatype = new BinaryBase64Datatype(null);
                    return var3_23;
                } else if ("hexBinary".equals(reprLocalPart)) {
                    BinaryHexDatatype binaryHexDatatype = new BinaryHexDatatype(null);
                    return var3_23;
                } else if ("boolean".equals(reprLocalPart)) {
                    BooleanDatatype booleanDatatype = new BooleanDatatype(null);
                    return var3_23;
                } else if ("dateTime".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.dateTime, null);
                    return var3_23;
                } else if ("time".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.time, null);
                    return var3_23;
                } else if ("date".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.date, null);
                    return var3_23;
                } else if ("gYearMonth".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gYearMonth, null);
                    return var3_23;
                } else if ("gYear".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gYear, null);
                    return var3_23;
                } else if ("gMonthDay".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonthDay, null);
                    return var3_23;
                } else if ("gDay".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gDay, null);
                    return var3_23;
                } else if ("gMonth".equals(reprLocalPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonth, null);
                    return var3_23;
                } else if ("decimal".equals(reprLocalPart)) {
                    DecimalDatatype decimalDatatype = new DecimalDatatype(null);
                    return var3_23;
                } else if ("double".equals(reprLocalPart)) {
                    FloatDatatype floatDatatype = new FloatDatatype(null);
                    return var3_23;
                } else if ("integer".equals(reprLocalPart)) {
                    IntegerDatatype integerDatatype = new IntegerDatatype(null);
                    return var3_23;
                } else if ("string".equals(reprLocalPart)) {
                    StringDatatype stringDatatype = new StringDatatype(null);
                    return var3_23;
                } else {
                    if (!"estring".equals(reprLocalPart)) throw new EXIException("[EXI] Unsupported datatype representation: {" + reprUri + "}" + reprLocalPart);
                    ExtendedStringDatatype extendedStringDatatype = new ExtendedStringDatatype(null);
                }
                return var3_23;
            } else {
                void var3_21;
                QName qn = new QName(reprUri, reprLocalPart);
                if (this.dtrMapRepresentationsDatatype != null) {
                    Datatype datatype = this.dtrMapRepresentationsDatatype.get(qn);
                }
                if (var3_21 != null) return var3_23;
                String className = QNameUtilities.getClassName(qn);
                Class<?> c = Class.forName(className);
                Object o = c.newInstance();
                if (!(o instanceof Datatype)) throw new Exception("[EXI] no Datatype instance");
                Datatype datatype = (Datatype)o;
            }
            return var3_23;
        }
        catch (Exception exception) {
            throw new EXIException(exception);
        }
    }
}

